#!/bin/php
<?php

/*
 * rino-SNMP-agent - SNMP agent for RINOTel (http://www.rinotel.com) gateway hardware
 *
 * Copyright (C) 2013 Volnikov Ivan
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 220 Lenin Avenue 82, Obninsk, Kaluga region, Russia.
 *
 * Report bugs to:  ivan@rinotel.com
 */
/// error_reporting(E_ALL);
///ini_set('display_errors', '1');
 
ini_set('max_execution_time', 0);
 
define('LISERVERFILE','/usr/local/sbin/server');
define('AGENT_DEBUG_MODE',0);
define('SAVED_POSTFIX', '_save');
define('COMPLETED_POSTFIX', '_cmp');

$types['INTEGER:'] = 'integer';
$types['Gauge:'] = 'gauge';
$types['Gauge32:'] = 'gauge';
$types['Gauge64:'] = 'gauge';
$types['Counter:'] = 'counter';
$types['Counter32:'] = 'counter';
$types['Counter64:'] = 'counter';
$types['Timeticks:'] = 'timeticks';
$types['IpAddress:'] = 'ipaddress';
$types['OID:'] = 'objectid';
$types['STRING:'] = 'string';

$oid = '';
$value = "";
$buffer = "";

$fd = null;
if (AGENT_DEBUG_MODE==1)
{
   $fd = fopen('/var/log/rino-snmp-agent', 'a');
}

$fh = fopen('php://stdin', 'r');
$fo = fopen('php://stdout', 'w');

$baseGateWayOID = ".1.3.6.1.4.1.249020.7";
$baseGateWayOID_len = strlen($baseGateWayOID);
$lastRINOoid = ".1.3.6.1.4.1.249020.2013";
$hdlcDRV = "/proc/driver/hdlc/peb22554/";
$monitoringDir = "/var/monitoring";
$monitoringSRVpwr = $monitoringDir."/powerstatus";
$monitoringSRVdip = $monitoringDir."/dip";
$monitoringSRVextBoards = $monitoringDir."/board";
$monitoringSRVemPhones = $monitoringDir."/emphone";
$monitoringSRVctrl = $monitoringDir."/controller/self/status";

$termCountersDir = "/var/monitoring/term_cnts";
$routerTermCounter = $termCountersDir."/router";
$controllerTermCounter = $termCountersDir."/controller";
$serverTermCounter = $termCountersDir."/server";
$extBoardTermCounter = $termCountersDir."/board";
/*
$gw_tree_of_snmp = array(
						array('node'=>".1", 'name'=>"gatewayCommon", 'value'=>array(),
							  'tree'=>array(
								array('node'=>".1.1.0", 'name'=>"DriverBuild", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
								array('node'=>".1.2.0", 'name'=>"SoftwareBuild", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
								array('node'=>".1.3.0", 'name'=>"powerStatus", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
								array('node'=>".1.4.0", 'name'=>"controllerStatus", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array())
								)
							),
						array('node'=>".2", 'name'=>"gatewayE1", 'value'=>array(),
							  'tree'=>array(
								array('node'=>".2.1", 'name'=>"E1Table", 'value'=>array(), 
									  'tree'=>array(
										array('node'=>".2.1.1", 'name'=>"E1TableEntry", 'value'=>array(),
											'tree'=>array(
													array('node'=>".2.1.1.1", 'name'=>"tbE1Index", 'value'=>array(), 
														  'tree'=>array(
																	array('node'=>".2.1.1.1.1", 'name'=>"E1.1", 'value'=>array('value'=>'1','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.1.2", 'name'=>"E1.2", 'value'=>array('value'=>"2",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.1.3", 'name'=>"E1.3", 'value'=>array('value'=>"3",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.1.4", 'name'=>"E1.4", 'value'=>array('value'=>"4",'type'=>'integer'), 'tree'=>array())
																)
														),
													array('node'=>".2.1.1.2", 'name'=>"tbE1Connected", 'value'=>array(), 
														  'tree'=>array(
																	array('node'=>".2.1.1.2.1", 'name'=>"E1.1.connected", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.2.2", 'name'=>"E1.2.connected", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.2.3", 'name'=>"E1.3.connected", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.2.4", 'name'=>"E1.4.connected", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array())
																)
														),
													array('node'=>".2.1.1.3", 'name'=>"tbE1StatusDsc", 'value'=>array(), 
														  'tree'=>array(
																	array('node'=>".2.1.1.3.1", 'name'=>"E1.1.status", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".2.1.1.3.2", 'name'=>"E1.2.status", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".2.1.1.3.3", 'name'=>"E1.3.status", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".2.1.1.3.4", 'name'=>"E1.4.status", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array())
																)
														),
													array('node'=>".2.1.1.4", 'name'=>"tbE1SignalLoss", 'value'=>array(), 
														  'tree'=>array(
																	array('node'=>".2.1.1.4.1", 'name'=>"E1.1.s_lost", 'value'=>array('value'=>'1','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.4.2", 'name'=>"E1.2.s_lost", 'value'=>array('value'=>'1','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.4.3", 'name'=>"E1.3.s_lost", 'value'=>array('value'=>'1','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.4.4", 'name'=>"E1.4.s_lost", 'value'=>array('value'=>'1','type'=>'integer'), 'tree'=>array())
																)
														),
													array('node'=>".2.1.1.5", 'name'=>"tbE1FrameAlignLoss", 'value'=>array(), 
														  'tree'=>array(
																	array('node'=>".2.1.1.5.1", 'name'=>"E1.1.f_lost", 'value'=>array('value'=>'1','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.5.2", 'name'=>"E1.2.f_lost", 'value'=>array('value'=>'1','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.5.3", 'name'=>"E1.3.f_lost", 'value'=>array('value'=>'1','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.5.4", 'name'=>"E1.4.f_lost", 'value'=>array('value'=>'1','type'=>'integer'), 'tree'=>array())
																)
														),
													array('node'=>".2.1.1.6", 'name'=>"tbE1NegSleepCount", 'value'=>array(), 
														  'tree'=>array(
																	array('node'=>".2.1.1.6.1", 'name'=>"E1.1.neg_sleeps", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.6.2", 'name'=>"E1.2.neg_sleeps", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.6.3", 'name'=>"E1.3.neg_sleeps", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.6.4", 'name'=>"E1.4.neg_sleeps", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array())
																)
														),
													array('node'=>".2.1.1.7", 'name'=>"tbE1NegSleepCount", 'value'=>array(), 
														  'tree'=>array(
																	array('node'=>".2.1.1.7.1", 'name'=>"E1.1.pos_sleeps", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.7.2", 'name'=>"E1.2.pos_sleeps", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.7.3", 'name'=>"E1.3.pos_sleeps", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".2.1.1.7.4", 'name'=>"E1.4.pos_sleeps", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array())
																)
														)
												)
											)
										)
									)
								)
							),
						array('node'=>".4", 'name'=>"gatewayExtantions", 'value'=>array(),
							  'tree'=>array(
								array('node'=>".4.1", 'name'=>"extBoardTable", 'value'=>array(), 
									  'tree'=>array(
										array('node'=>".4.1.1", 'name'=>"extBoardTableEntry", 'value'=>array(),
											'tree'=>array(
													array('node'=>".4.1.1.1", 'name'=>"tbExtBoardIndex", 'value'=>array(), 
														  'tree'=>array(
																	array('node'=>".4.1.1.1.1", 'name'=>"LI.1", 'value'=>array('value'=>'1','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.2", 'name'=>"LI.2", 'value'=>array('value'=>"2",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.3", 'name'=>"LI.3", 'value'=>array('value'=>"3",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.4", 'name'=>"LI.4", 'value'=>array('value'=>"4",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.5", 'name'=>"LI.5", 'value'=>array('value'=>"5",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.6", 'name'=>"LI.6", 'value'=>array('value'=>"6",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.7", 'name'=>"LI.7", 'value'=>array('value'=>"7",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.8", 'name'=>"LI.8", 'value'=>array('value'=>"8",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.9", 'name'=>"LI.9", 'value'=>array('value'=>"9",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.10", 'name'=>"LI.10", 'value'=>array('value'=>"10",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.11", 'name'=>"LI.11", 'value'=>array('value'=>"11",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.12", 'name'=>"LI.12", 'value'=>array('value'=>"12",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.13", 'name'=>"LI.13", 'value'=>array('value'=>"13",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.14", 'name'=>"LI.14", 'value'=>array('value'=>"14",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.15", 'name'=>"LI.15", 'value'=>array('value'=>"15",'type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.1.16", 'name'=>"LI.16", 'value'=>array('value'=>"16",'type'=>'integer'), 'tree'=>array())
																)
														),
													array('node'=>".4.1.1.2", 'name'=>"tbExtBoardStatus", 'value'=>array(), 
														  'tree'=>array(
																	array('node'=>".4.1.1.2.1", 'name'=>"LI.1.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.2", 'name'=>"LI.2.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.3", 'name'=>"LI.3.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.4", 'name'=>"LI.4.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.5", 'name'=>"LI.5.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.6", 'name'=>"LI.6.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.7", 'name'=>"LI.7.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.8", 'name'=>"LI.8.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.9", 'name'=>"LI.9.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.10", 'name'=>"LI.10.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.11", 'name'=>"LI.11.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.12", 'name'=>"LI.12.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.13", 'name'=>"LI.13.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.14", 'name'=>"LI.14.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.15", 'name'=>"LI.15.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.2.16", 'name'=>"LI.16.Status", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array())
																)
														),
													array('node'=>".4.1.1.3", 'name'=>"tbExtBoardSoftVer", 'value'=>array(), 
														  'tree'=>array(
																	array('node'=>".4.1.1.3.1", 'name'=>"LI.1.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.2", 'name'=>"LI.2.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.3", 'name'=>"LI.3.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.4", 'name'=>"E1.4.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.5", 'name'=>"LI.5.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.6", 'name'=>"LI.6.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.7", 'name'=>"LI.7.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.8", 'name'=>"E1.8.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.9", 'name'=>"LI.9.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.10", 'name'=>"LI.10.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.11", 'name'=>"LI.11.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.12", 'name'=>"E1.12.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.13", 'name'=>"LI.13.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.14", 'name'=>"LI.14.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.15", 'name'=>"LI.15.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array()),
																	array('node'=>".4.1.1.3.16", 'name'=>"E1.16.Soft", 'value'=>array('value'=>'none','type'=>'string'), 'tree'=>array())
																)
														),
													array('node'=>".4.1.1.4", 'name'=>"tbExtBoardType", 'value'=>array(), 
														  'tree'=>array(
																	array('node'=>".4.1.1.4.1", 'name'=>"LI.1.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.2", 'name'=>"LI.2.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.3", 'name'=>"LI.3.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.4", 'name'=>"LI.4.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.5", 'name'=>"LI.5.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.6", 'name'=>"LI.6.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.7", 'name'=>"LI.7.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.8", 'name'=>"LI.8.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.9", 'name'=>"LI.9.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.10", 'name'=>"LI.10.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.11", 'name'=>"LI.11.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.12", 'name'=>"LI.12.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.13", 'name'=>"LI.13.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.14", 'name'=>"LI.14.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.15", 'name'=>"LI.15.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array()),
																	array('node'=>".4.1.1.4.16", 'name'=>"LI.16.Type", 'value'=>array('value'=>'0','type'=>'integer'), 'tree'=>array())
																)
														)
												)
											)
										)
									),
								array('node'=>".4.2", 'name'=>"emPhoneTable", 'value'=>array(), 
									  'tree'=>array(
										array('node'=>".4.2.1", 'name'=>"emPhoneTableEntry", 'value'=>array(),
											'tree'=>array(
													array('node'=>".4.2.1.1", 'name'=>"tbEmPhoneIndex", 'value'=>array(), 
														  'tree'=>array()
														),
													array('node'=>".4.2.1.2", 'name'=>"tbEmPhonePanelSoftVer", 'value'=>array(), 
														  'tree'=>array()
														),
													array('node'=>".4.2.1.3", 'name'=>"tbEmPhoneCtrlSoftVer", 'value'=>array(), 
														  'tree'=>array()
														),
													array('node'=>".4.2.1.4", 'name'=>"tbEmPhoneFpgaSoftVer", 'value'=>array(), 
														  'tree'=>array()
														),
													array('node'=>".4.2.1.5", 'name'=>"tbEmPhoneStatus", 'value'=>array(), 
														  'tree'=>array()
														),
													array('node'=>".4.2.1.6", 'name'=>"tbEmPhonePowerStatus", 'value'=>array(), 
														  'tree'=>array()
														),
													array('node'=>".4.2.1.7", 'name'=>"tbEmPhoneMode", 'value'=>array(), 
														  'tree'=>array()
														),
													array('node'=>".4.2.1.8", 'name'=>"tbEmPhoneHookStatus", 'value'=>array(), 
														  'tree'=>array()
														),
													array('node'=>".4.2.1.9", 'name'=>"tbEmPhoneBaseStatus", 'value'=>array(), 
														  'tree'=>array()
														)
												)
											)
										)
									)
								)
							)
					  );	
*/					  
	
$gw_flat_tree = array(
	'.1.1.0' => array('name'=>"DriverBuild", 'value'=>array('value'=>'none','type'=>'string'), 'update'=>false),
	'.1.2.0' => array('name'=>"SoftwareBuild", 'value'=>array('value'=>'none','type'=>'string'), 'update'=>false),
	'.1.3.0' => array('name'=>"powerStatus", 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updatePowerStatus'),
	'.1.4.0' => array('name'=>"controllerStatus", 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateControllerStatus'),
	'.1.5.0' => array('name'=>"gatewayDip", 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateGatewayDip'),
	'.6.1.1.0' => array('name'=>"routerTermCounter", 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>false),
	'.6.1.2.0' => array('name'=>"controllerTermCounter", 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>false),
	'.6.1.3.0' => array('name'=>"serverTermCounter", 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateServerTermCnt')
);

function updateFramerStatus($framer)
{
	global $hdlcDRV;
	global $gw_flat_tree;
	
	$framer_postfix = strval($framer);
	
	if (($framer >= 1) && ($framer <= 4)) {
		$eLVL = error_reporting();
		error_reporting($eLVL ^ E_WARNING);
		$frh = fopen($hdlcDRV.($framer-1), 'r');
		error_reporting($eLVL);
		if ($frh!==false)
		{
			//Current status (string)
			$buffer = fgets($frh, 4096);
			list($tmp,$value) = explode(':',$buffer);
			$gw_flat_tree['.2.1.1.2.'.$framer_postfix]['value']['value'] = trim($value)==='No Carrier' ? '0' : '1';
			$gw_flat_tree['.2.1.1.3.'.$framer_postfix]['value']['value'] = trim($value);
			
			//delimiter
			$buffer = fgets($frh, 4096);
			//Loss of Signal
			$buffer = fgets($frh, 4096);
			list($tmp,$value) = explode(':',$buffer);
			$gw_flat_tree['.2.1.1.4.'.$framer_postfix]['value']['value'] = trim($value)==='yes' ? '1' : '0';
			
			//Loss of Frame Aligment
			$buffer = fgets($frh, 4096);
			list($tmp,$value) = explode(':',$buffer);
			$gw_flat_tree['.2.1.1.5.'.$framer_postfix]['value']['value'] = trim($value)==='yes' ? '1' : '0';
			
			//Receive Slip Negative
			$buffer = fgets($frh, 4096);
			list($tmp,$value) = explode(':',$buffer);
			$gw_flat_tree['.2.1.1.6.'.$framer_postfix]['value']['value'] = trim($value);
			
			//Receive Slip Positive
			$buffer = fgets($frh, 4096);
			list($tmp,$value) = explode(':',$buffer);
			$gw_flat_tree['.2.1.1.7.'.$framer_postfix]['value']['value'] = trim($value);
			
			fclose($frh);
		} else {
		//Driver is not loaded!!!
			$gw_flat_tree['.2.1.1.2.'.$framer_postfix]['value']['value'] = '0';
			$gw_flat_tree['.2.1.1.3.'.$framer_postfix]['value']['value'] = 'No Driver';
			$gw_flat_tree['.2.1.1.4.'.$framer_postfix]['value']['value'] = '1';
			$gw_flat_tree['.2.1.1.5.'.$framer_postfix]['value']['value'] = '1';
			$gw_flat_tree['.2.1.1.6.'.$framer_postfix]['value']['value'] = '0';
			$gw_flat_tree['.2.1.1.7.'.$framer_postfix]['value']['value'] = '0';
		}
	}
}

function updateBoardStatus($board)
{
	global $monitoringSRVextBoards;
	
	global $gw_flat_tree;
	
	$board_postfix = strval($board);
	
	if (($board >= 0) && ($board <= 16)) {
		$isAbsent = true;
		$fileName = $monitoringSRVextBoards.$board;
		$cmpName = $fileName.COMPLETED_POSTFIX;
		$savedName = $fileName.SAVED_POSTFIX;
		
		$eLVL = error_reporting();
		error_reporting($eLVL ^ E_WARNING);
		
		if (file_exists($savedName))
			$isAbsent = false;
		unlink($fileName);
		
		if (rename($cmpName, $fileName)) {
			$frh = fopen($fileName, 'r');
			
			if ($frh!==false)
			{
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.4.1.1.2.'.$board_postfix]['value']['value'] = trim($buffer);
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.4.1.1.3.'.$board_postfix]['value']['value'] = trim($buffer);
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.4.1.1.4.'.$board_postfix]['value']['value'] = trim($buffer);
				
				fclose($frh);
			}
			
			unlink($savedName);
			rename($fileName, $savedName);
			
			$isAbsent = false;
		}	
		
		if ($isAbsent) {
			//No monitoring info
			$gw_flat_tree['.4.1.1.2.'.$board_postfix]['value']['value'] = '0';
			$gw_flat_tree['.4.1.1.3.'.$board_postfix]['value']['value'] = 'absent';
			$gw_flat_tree['.4.1.1.4.'.$board_postfix]['value']['value'] = '0';
		}
		
		error_reporting($eLVL);
	}
}

function updatePowerStatus($id)
{
	global $monitoringSRVpwr;
	
	global $gw_flat_tree;
	
	$isAbsent = true;
	$fileName = $monitoringSRVpwr;
	$cmpName = $fileName.COMPLETED_POSTFIX;
	$savedName = $fileName.SAVED_POSTFIX;
	
	$eLVL = error_reporting();
	error_reporting($eLVL ^ E_WARNING);
	
		if (file_exists($savedName))
			$isAbsent = false;
		
		unlink($fileName);
		
		if (rename($cmpName, $fileName)) {
			$frh = fopen($fileName, 'r');
			if ($frh!==false)
			{
				//Current status (integer)
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.1.3.0']['value']['value'] = $buffer;
				
				fclose($frh);
			}
			
			unlink($savedName);
			rename($fileName, $savedName);
			
			$isAbsent = false;
		}
		
		if ($isAbsent) {
			//server is not loaded or hardware is not support this
			//Current status (integer)
			$gw_flat_tree['.1.3.0']['value']['value'] = '0';
		}	

	error_reporting($eLVL);
}

function updateControllerStatus($id)
{
	global $monitoringSRVctrl;
	
	global $gw_flat_tree;
	
	$isAbsent = true;
	$fileName = $monitoringSRVctrl;
	$cmpName = $fileName.COMPLETED_POSTFIX;
	$savedName = $fileName.SAVED_POSTFIX;
	
	$eLVL = error_reporting();
	error_reporting($eLVL ^ E_WARNING);
	if (file_exists($savedName))
		$isAbsent = false;
	
	unlink($fileName);
	
	if (rename($cmpName, $fileName)) {
		$frh = fopen($fileName, 'r');

		if ($frh!==false)
		{
			//Current status (integer)
			$buffer = fgets($frh, 4096);
			$gw_flat_tree['.1.4.0']['value']['value'] = $buffer;
			
			fclose($frh);
		}
		
		unlink($savedName);
		rename($fileName, $savedName);
		
		$isAbsent = false;
	}
	
	if ($isAbsent) {
		//server is not loaded or hardware is not support this
		//Current status (integer)
		$gw_flat_tree['.1.4.0']['value']['value'] = '0';
	}
	
	error_reporting($eLVL);
}

function updateGatewayDip($id)
{
	global $monitoringSRVdip;
	
	global $gw_flat_tree;
	
	$isAbsent = true;
	$fileName = $monitoringSRVdip;
	$cmpName = $fileName.COMPLETED_POSTFIX;
	$savedName = $fileName.SAVED_POSTFIX;
	
	$eLVL = error_reporting();
	error_reporting($eLVL ^ E_WARNING);
	
		if (file_exists($savedName))
			$isAbsent = false;
		
		unlink($fileName);
		
		if (rename($cmpName, $fileName)) {
			$frh = fopen($fileName, 'r');
			if ($frh!==false)
			{
				//Current status (integer)
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.1.5.0']['value']['value'] = $buffer;
				
				fclose($frh);
			}
			
			unlink($savedName);
			rename($fileName, $savedName);
			
			$isAbsent = false;
		}
		
		if ($isAbsent) {
			//server is not loaded or hardware is not support this
			//Current status (integer)
			$gw_flat_tree['.1.5.0']['value']['value'] = '0';
		}	

	error_reporting($eLVL);
}

function updateEmPhoneStatus($phone)
{
	global $monitoringSRVemPhones;
	
	global $gw_flat_tree;
	
	$phone_postfix = strval($phone);
	
	if (($phone >= 0) && ($phone <= 16)) {
		$phoneId = $phone-1;
		$isAbsent = true;
		$fileName = $monitoringSRVemPhones.$phoneId;
		$cmpName = $fileName.COMPLETED_POSTFIX;
		$savedName = $fileName.SAVED_POSTFIX;
		
		$eLVL = error_reporting();
		error_reporting($eLVL ^ E_WARNING);
		
		if (file_exists($savedName))
			$isAbsent = false;
		
		unlink($fileName);
		
		if (rename($cmpName, $fileName)) {
			$frh = fopen($fileName, 'r');
			if ($frh!==false)
			{
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.4.2.1.2.'.$phone_postfix]['value']['value'] = trim($buffer);
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.4.2.1.3.'.$phone_postfix]['value']['value'] = trim($buffer);
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.4.2.1.4.'.$phone_postfix]['value']['value'] = trim($buffer);
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.4.2.1.5.'.$phone_postfix]['value']['value'] = trim($buffer);
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.4.2.1.6.'.$phone_postfix]['value']['value'] = trim($buffer);
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.4.2.1.7.'.$phone_postfix]['value']['value'] = trim($buffer);
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.4.2.1.8.'.$phone_postfix]['value']['value'] = trim($buffer);
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.4.2.1.9.'.$phone_postfix]['value']['value'] = trim($buffer);
				
				fclose($frh);
			}
			
			unlink($savedName);
			rename($fileName, $savedName);
			
			$isAbsent = false;
		}
		
		if ($isAbsent) {
			$gw_flat_tree['.4.2.1.2.'.$phone_postfix]['value']['value'] = 'absent';
			$gw_flat_tree['.4.2.1.3.'.$phone_postfix]['value']['value'] = 'absent';
			$gw_flat_tree['.4.2.1.4.'.$phone_postfix]['value']['value'] = 'absent';
			$gw_flat_tree['.4.2.1.5.'.$phone_postfix]['value']['value'] = '0';
			$gw_flat_tree['.4.2.1.6.'.$phone_postfix]['value']['value'] = '0';
			$gw_flat_tree['.4.2.1.7.'.$phone_postfix]['value']['value'] = '0';
			$gw_flat_tree['.4.2.1.8.'.$phone_postfix]['value']['value'] = '0';
			$gw_flat_tree['.4.2.1.9.'.$phone_postfix]['value']['value'] = '0';
		}
		
		error_reporting($eLVL);
	}
}

function updateServerTermCnt($id)
{
	global $serverTermCounter;
	
	global $gw_flat_tree;
	
	$isAbsent = true;
	$fileName = $serverTermCounter;
	$cmpName = $fileName.COMPLETED_POSTFIX;
	$savedName = $fileName.SAVED_POSTFIX;
	
	$eLVL = error_reporting();
	error_reporting($eLVL ^ E_WARNING);
	
		if (file_exists($savedName))
			$isAbsent = false;
		
		unlink($fileName);
		
		if (rename($cmpName, $fileName)) {
			$frh = fopen($fileName, 'r');
			if ($frh!==false)
			{
				//Current termination counter (integer)
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.6.1.3.0']['value']['value'] = $buffer;
				
				fclose($frh);
			}
			
			unlink($savedName);
			rename($fileName, $savedName);
			
			$isAbsent = false;
		}
		
		if ($isAbsent) {
			//server is not loaded or hardware is not support this
			//Current status (integer)
			$gw_flat_tree['.6.1.3.0']['value']['value'] = '0';
		}	

	error_reporting($eLVL);
}

function updateBoardTermCnt($board)
{
	global $extBoardTermCounter;
	
	global $gw_flat_tree;
	
	$board_postfix = strval($board);
	
	if (($board >= 0) && ($board <= 16)) {
		$isAbsent = true;
		$fileName = $extBoardTermCounter.$board;
		$cmpName = $fileName.COMPLETED_POSTFIX;
		$savedName = $fileName.SAVED_POSTFIX;
		
		$eLVL = error_reporting();
		error_reporting($eLVL ^ E_WARNING);
		
		if (file_exists($savedName))
			$isAbsent = false;
		unlink($fileName);
		
		if (rename($cmpName, $fileName)) {
			$frh = fopen($fileName, 'r');
			
			if ($frh!==false)
			{
				$buffer = fgets($frh, 4096);
				$gw_flat_tree['.6.1.4.1.2.'.$board_postfix]['value']['value'] = trim($buffer);
				
				fclose($frh);
			}
			
			unlink($savedName);
			rename($fileName, $savedName);
			
			$isAbsent = false;
		}	
		
		if ($isAbsent) {
			//No monitoring info
			$gw_flat_tree['.6.1.4.1.2.'.$board_postfix]['value']['value'] = '0';
		}
		
		error_reporting($eLVL);
	}
}

function logDUMP($MSG)
{
    global $fd;
    if (isset($fd)) fwrite($fd,$MSG);
}

function doAnswer($MSG)
{
    global $fo;
    fwrite($fo,$MSG."\n");
}

function getNext(&$a_oid)
{
	$res['type']='string';
	$res['value']='last RINO gateway value';
	
	return $res;
}

function checkBaseOID($baseOID, $oid)
{
	$baseOID_len = strlen($baseOID);
	
	if (strlen($oid) < strlen($baseOID))
		return false;
	
	if (substr_compare($oid, $baseOID, 0, $baseOID_len) != 0)
		return false;
	return true;
}

function get($oid)
{
	global $baseGateWayOID;
	global $baseGateWayOID_len;
	
	global $gw_flat_tree;
	
	$res = false;
	
	if (!checkBaseOID($baseGateWayOID, $oid)) {
		return $res;
	}
	
	$oid = substr($oid, $baseGateWayOID_len);
	
	$node = & $gw_flat_tree[$oid];
	
	if (isset($node)) {		
		$dot_pos = strrpos($oid, '.');
		$id = intval(substr($oid, $dot_pos + 1));
		
		if ($node['update'] != false) {
			$node['update']($id);
		}
		$res = $node['value'];
	}	
	
	return $res;
}


function getSoftVersion()
{
	$ver = shell_exec(LISERVERFILE." --version");
	list($tmp,$ver)=explode(": ",$ver,2);
	return trim($ver);
}

function getDriversVersion()
{
	$eLVL = error_reporting();
	error_reporting($eLVL ^ E_WARNING);
	$fvh = fopen("/proc/voice/version", 'r');
	error_reporting($eLVL);
	$ver="unknown";
	if (isset($fvh))
	{
		$sTMP = fgets($fvh);
		if ($sTMP)
		{
			list($sTMP,$sVersion,$sValue,$sRTP) = explode(" ", $sTMP, 4);
			if (isset($sRTP))
			{
				$ver = sprintf("%s [%s %s]",trim($sVersion), trim($sValue), trim($sRTP));
			}else
			{
				$ver = sprintf("%s [%s]",trim($sVersion), trim($sValue));
			}
		}
		fclose($fvh);
	}
	return $ver;
}

function fillVersions()
{
	global $gw_flat_tree;
	
	$gw_flat_tree['.1.1.0']['value']['value'] = getDriversVersion();
	$gw_flat_tree['.1.2.0']['value']['value'] = getSoftVersion();
}

if (isset($fh)) {
    logDUMP("Stdin is open!\n");
}else
{
    logDUMP("Can not open stdin!"."\n");
    exit(1);
}

function addE1ToTree()
{
	global $gw_flat_tree;
	for ($e1 = 1; $e1 <= 4; $e1 += 1) {
		$e1_str = strval($e1);
		
		$gw_flat_tree['.2.1.1.1.'.$e1_str] = array('name'=>'E1.'.$e1_str, 'value'=>array('value'=>$e1_str,'type'=>'integer'), 'update'=>false);
		$gw_flat_tree['.2.1.1.2.'.$e1_str] = array('name'=>'E1.'.$e1_str.'.connected', 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateFramerStatus');
		$gw_flat_tree['.2.1.1.3.'.$e1_str] = array('name'=>'E1.'.$e1_str.'.status', 'value'=>array('value'=>'none','type'=>'string'), 'update'=>'updateFramerStatus');
		$gw_flat_tree['.2.1.1.4.'.$e1_str] = array('name'=>'E1.'.$e1_str.'.s_lost', 'value'=>array('value'=>'1','type'=>'integer'), 'update'=>'updateFramerStatus');
		$gw_flat_tree['.2.1.1.5.'.$e1_str] = array('name'=>'E1.'.$e1_str.'.f_lost', 'value'=>array('value'=>'1','type'=>'integer'), 'update'=>'updateFramerStatus');
		$gw_flat_tree['.2.1.1.6.'.$e1_str] = array('name'=>'E1.'.$e1_str.'.neg_sleeps', 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateFramerStatus');
		$gw_flat_tree['.2.1.1.7.'.$e1_str] = array('name'=>'E1.'.$e1_str.'.pos_sleeps', 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateFramerStatus');
		
		updateFramerStatus($e1);	
	}
}

function addLIsToTree()
{
	global $gw_flat_tree;
	for ($board = 1; $board <= 16; $board += 1) {
		$board_str = strval($board);
		
		$gw_flat_tree['.4.1.1.1.'.$board_str] = array('name'=>'LI.'.$board_str, 'value'=>array('value'=>$board_str,'type'=>'integer'), 'update'=>false);
		$gw_flat_tree['.4.1.1.2.'.$board_str] = array('name'=>'LI.'.$board_str.'.Status', 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateBoardStatus');
		$gw_flat_tree['.4.1.1.3.'.$board_str] = array('name'=>'LI.'.$board_str.'.Soft', 'value'=>array('value'=>'none','type'=>'string'), 'update'=>'updateBoardStatus');
		$gw_flat_tree['.4.1.1.4.'.$board_str] = array('name'=>'LI.'.$board_str.'.Type', 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateBoardStatus');
		
		$gw_flat_tree['.6.1.4.1.1.'.$board_str] = array('name'=>'LI.'.$board_str, 'value'=>array('value'=>$board_str,'type'=>'integer'), 'update'=>false);
		$gw_flat_tree['.6.1.4.1.2.'.$board_str] = array('name'=>'LI.'.$board_str.'.termCnt', 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateBoardTermCnt');
		
		updateBoardStatus($board);	
		updateBoardTermCnt($board);
	}
}

function addEmPhonesToTree()
{
	global $gw_flat_tree;
	
	for ($phone=1; $phone <= 4; $phone += 1) {
		$phoneId = $phone-1;
		$phone_str = strval($phone);
		
		$gw_flat_tree['.4.2.1.1.'.$phone_str] = array('name'=>'EmPhone.'.$phone_str, 'value'=>array('value'=>strval($phoneId),'type'=>'integer'), 'update'=>false);
		$gw_flat_tree['.4.2.1.2.'.$phone_str] = array('name'=>'EmPhone.'.$phone_str.'.PanelSV', 'value'=>array('value'=>'none','type'=>'string'), 'update'=>'updateEmPhoneStatus');
		$gw_flat_tree['.4.2.1.3.'.$phone_str] = array('name'=>'EmPhone.'.$phone_str.'.CtrlSV', 'value'=>array('value'=>'none','type'=>'string'), 'update'=>'updateEmPhoneStatus');
		$gw_flat_tree['.4.2.1.4.'.$phone_str] = array('name'=>'EmPhone.'.$phone_str.'.FpgaSV', 'value'=>array('value'=>'none','type'=>'string'), 'update'=>'updateEmPhoneStatus');
		$gw_flat_tree['.4.2.1.5.'.$phone_str] = array('name'=>'EmPhone.'.$phone_str.'.Status', 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateEmPhoneStatus');
		$gw_flat_tree['.4.2.1.6.'.$phone_str] = array('name'=>'EmPhone.'.$phone_str.'.PowerStatus', 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateEmPhoneStatus');
		$gw_flat_tree['.4.2.1.7.'.$phone_str] = array('name'=>'EmPhone.'.$phone_str.'.Mode', 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateEmPhoneStatus');
		$gw_flat_tree['.4.2.1.8.'.$phone_str] = array('name'=>'EmPhone.'.$phone_str.'.HookStatus', 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateEmPhoneStatus');
		$gw_flat_tree['.4.2.1.9.'.$phone_str] = array('name'=>'EmPhone.'.$phone_str.'.BaseStatus', 'value'=>array('value'=>'0','type'=>'integer'), 'update'=>'updateEmPhoneStatus');
	
		updateEmPhoneStatus($phone);	
	}
}	

//one upon a time
fillVersions();
addE1ToTree();
addLIsToTree();
addEmPhonesToTree();


$test_commands = array(
	0 => "get",
	1 => ".1.3.6.1.4.1.249020.7.1.3.0",
	2 => "get",
	3 => ".1.3.6.1.4.1.249020.7.1.4.0",
	4 => "get",
	5 => ".1.3.6.1.4.1.249020.7.4.1.1.1.7",
	6 => "get",
	7 => ".1.3.6.1.4.1.249020.7.4.1.1.1.8",
	8 => "get",
	9 => ".1.3.6.1.4.1.249020.7.4.1.1.3.7",
	10 => "get",
	11 => ".1.3.6.1.4.1.249020.7.4.1.1.4.7",
	12 => "get",
	13 => ".1.3.6.1.4.1.249020.7.4.1.1.1.8",
	14 => "get",
	15 => ".1.3.6.1.4.1.249020.7.4.1.1.2.8",
	16 => "get",
	17 => ".1.3.6.1.4.1.249020.7.4.1.1.3.8",
	18 => "get",
	19 => ".1.3.6.1.4.1.249020.7.4.1.1.4.8",
	20 => "get",
	21 => ".1.3.6.1.4.1.249020.7.4.2.1.1.1",
	22 => "get",
	23 => ".1.3.6.1.4.1.249020.7.4.2.1.2.1",
	24 => "get",
	25 => ".1.3.6.1.4.1.249020.7.4.2.1.3.1",
	26 => "get",
	27 => ".1.3.6.1.4.1.249020.7.4.2.1.4.1",
	28 => "get",
	29 => ".1.3.6.1.4.1.249020.7.4.2.1.5.1",
	30 => "get",
	31 => ".1.3.6.1.4.1.249020.7.4.2.1.6.1",
	32 => "get",
	33 => ".1.3.6.1.4.1.249020.7.4.2.1.7.1",
	34 => "get",
	35 => ".1.3.6.1.4.1.249020.7.4.2.1.8.1",
	36 => "get",
	37 => ".1.3.6.1.4.1.249020.7.4.2.1.9.1",
	38 => "get",
	39 => ".1.3.6.1.4.1.249020.7.4.2.1.1.2",
	40 => "get",
	41 => ".1.3.6.1.4.1.249020.7.4.2.1.2.2",
	42 => "get",
	43 => ".1.3.6.1.4.1.249020.7.4.2.1.3.2",
	44 => "get",
	45 => ".1.3.6.1.4.1.249020.7.4.2.1.4.2",
	46 => "get",
	47 => ".1.3.6.1.4.1.249020.7.4.2.1.5.2",
	48 => "get",
	49 => ".1.3.6.1.4.1.249020.7.4.2.1.6.2",
	50 => "get",
	51 => ".1.3.6.1.4.1.249020.7.4.2.1.7.2",
	52 => "get",
	53 => ".1.3.6.1.4.1.249020.7.4.2.1.8.2",
	54 => "get",
	55 => ".1.3.6.1.4.1.249020.7.4.2.1.9.2",
	56 => "get",
	57 => ".1.3.6.1.4.1.249020.7.1.5.0",
);
$test_pos = 0;


$mode = "command";
$command = "run";
$start_time = microtime(true);
$stop_time = $start_time;
do {
	logDUMP("Try read data from stdin..."."\n");

	$buffer = rtrim(fgets($fh, 4096));
/*	
	$buffer = $test_commands[$test_pos];
	$test_pos += 1;
	if ($test_pos >= sizeof($test_commands)) {
		$test_pos = 0;
		$stop_time = microtime(true);
		$exec_time = $stop_time - $start_time;
		
		echo "Execution time: $exec_time\n\n\n\n\n";
		sleep(1);
		$start_time = microtime(true);
	}
*/	
	logDUMP("Data from stdin received [".$buffer."]\n");
	switch ($mode) {
		case "command":
			switch ($buffer) {
				case "PING":
				case "ping":
					// this is for startup handshake
					doAnswer("PONG");
					break;
				case "QUIT":
				case "quit":
					// this is for telnet-tests ;-)
					$command = "QUIT";
					//echo "Terminating.\n";
					break;
				case "getnext":
				case "GETNEXT":
					$mode = "getnext";
					break;
				case "get":
				case "GET":
					$mode = "get";
					
					break;
				case "set":
				case "SET":
					$mode = "set";
					break;
				default:
					echo "NONE\n";
					break;
			}
			logDUMP("Receive <".$buffer."> command [mode=".$mode."]\n");
			break;
		case "getnext":
		case "get":
			$oid=$buffer;
			logDUMP("Process <".$mode."> command [oid=".$oid."]\n");
			if ($mode == "getnext")
			{
				//if ($E1TableFisrtElementIndexOID===$oid)
				//{					
				//	renewE1Status();
				//}
				$res = getNext(&$oid);
				//logDUMP("Result <".$mode."> command [oid=".$oid.", valtype=".$res['type'].", value=".$res['value']."]\n");
				doAnswer($oid);
				doAnswer($res['type']);
				doAnswer($res['value']);
			}else
			{	
				$res = get($oid);
				if ($res===false)
				{
					doAnswer("NONE");
				}else
				{
					doAnswer($oid);
					doAnswer($res['type']);
					doAnswer($res['value']);
				}
			}
			$mode = "command";

			break;
		case "set":
			$mode = "set2";
			break;
		case "set2":
			$mode = "set3";
			break;
		case "set3":
			$mode = "command";
			doAnswer("not-writable");
			break;
		default:
			$mode = "command";
			doAnswer("NONE");
			break;
	}
	
} while ( $command != "QUIT" );

logDUMP("Leave rino snmp agent"."\n");

if (isset($fd)) fclose($fd);

?>
