<?php /*?>#!/bin/php<?php */?>
<html>
<head>
<?php require_once(dirname(__FILE__).'/common_htmlhead.inc'); ?>
<script language="JavaScript" type="text/JavaScript" src="/router.js"></script>
<title>RINO Hardware :: Router configuration</title>
</head>
<body>
<?php require_once(dirname(__FILE__).'/common_header.inc'); ?>
<!--<b class="pagetitle">Router configuration</b>
<div id="nullt">&nbsp;</div><div style="clear: both"></div>-->
<form autocomplete="off" name="routerconf" action="/cgi-bin/doapplyrouter.cgi" method="post">
<?php
	require_once(dirname(__FILE__).'/router_controls.inc');
	$router_conf = new RouterConfFile(ROUTERCONFFILE);
	
//var_dump($router_conf->patterns);	
?>

<input name="hidChangeEvent" id="hidChangeEvent" type="hidden" value="0">

<!------------------------------------------------------------------------------------>
<!--								Main settings:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
	<table class="nb" cellpadding="0" cellspacing="0" width="90%">
		<caption onClick="doSectionSwitch('RMainContainerHeader','RMainContainer');">
			<div class="sec" style="display:inline;float:left">Main settings</div>
			<div style="width:100%;text-align:right;">
			<img id="RMainContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('RMainContainerHeader','RMainContainer')" src="/images/arrow_up.png">
			</div>
		</caption>
		<tr valign="top">
			<td id="RMainContainer">
				<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
					<tr>
						<td colspan="2" class="infoTableHeader" width="200px">&nbsp;Controller connection</td>
					</tr>
					<tr>
						<td class="editLineParam">Address</td>
						<td class="editLineValue">
							<input name="edCtrlHost" type="text" value="<?php
							print($router_conf->ctrl->host)
							?>" maxlength="250" size="250" class="selectw170">
						</td>
					</tr>
				</table>

				<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
					<tr>
						<td colspan="2" class="infoTableHeader" width="200px">&nbsp;CDR (Call Detail Record)</td>
					</tr>
					<tr>
						<td class="editLineParam">Remote CDR receivers</td>
						<td class="editLineValue">
							<input name="edCtrl_CDR_hosts" type="text" value="<?php
							print($router_conf->ctrl->cdr_hosts)
							?>" maxlength="250" size="250" class="selectw170" title="Multiple addresses can be entered, space separated: 192.168.1.1:35500 192.168.1.2:35500"></td>
					</tr>
				</table>

				<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
					<tr>
						<td colspan="2" class="infoTableHeader" width="200px">&nbsp;Call session parameters</td>
					</tr>
					<tr>
						<td class="editLineParam">Session timeout, seconds</td>
						<td class="editLineValue">
							<input name="edCtrl_Session_timeout" type="text" value="<?php
							print($router_conf->ctrl->session_timeout)
							?>" maxlength="10" size="10" class="selectw" title="How many seconds should Router wait for a digit to find the right route">
						</td>
					</tr>
				</table>

				<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
					<tr>
						<td colspan="2" class="infoTableHeader" width="200px">&nbsp;Use redirect patterns</td>
					</tr>
					<tr>
						<td class="editLineParam">
							<a class="imglink" onClick="ToggleCheckBox('cbUse_Redirect_Patterns')">Use redirect patterns</a>
						</td>
						<td class="editLineValue">
							<input name="cbUse_Redirect_Patterns" id="cbUse_Redirect_Patterns" type="checkbox" 
							<?php if($router_conf->ctrl->use_redirect_patterns == "true") print("checked value='1'"); else print(" value='0'"); ?>
							class="selectw" title=""
							onchange="if(this.checked) this.value='1'; else this.value='0';">
						</td>
				</table>

				<!-- table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
					<tr>
						<td colspan="2" class="infoTableHeader" width="200px">&nbsp;Require DTMF</td>
					</tr>
					<tr>
						<td class="editLineParam">require incoming dtmf</td>
						<td class="editLineValue">
							<select name="edCtrl_incoming_DTMF" class="selectw">
								<*?php
									$require_dtmf = array(
										'yes' => 'true',
										'no' => 'false');
									foreach($require_dtmf as $require_name => $reqid) {
										printf("<option value=\"$reqid\"");
										if ($router_conf->ctrl->require_incoming_dtmf == $reqid)
											printf(" selected");
										printf(">$require_name</option>");
									}
								?>
							</select>
						</td>
					</tr>
					<tr>
						<td class="editLineParam">require outgoing dtmf</td>
						<td class="editLineValue">
							<select name="edCtrl_outgoing_DTMF" class="selectw">
								<*?php
									$require_dtmf = array(
										'yes' => 'true',
										'no' => 'false');
									foreach($require_dtmf as $require_name => $reqid) {
										printf("<option value=\"$reqid\"");
										if ($router_conf->ctrl->require_outgoing_dtmf == $reqid)
											printf(" selected");
										printf(">$require_name</option>");
									}
								?>
							</select>
						</td>
					</tr>
				</table -->


			</td>
		</tr>
	</table>
</div>

<!------------------------------------------------------------------------------------>
<!--								Recorders:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('RecorderContainerHeader','RecorderContainer')">
	<div class="sec" style="display:inline;float:left">Recorders&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddRecorder();  doChangeEvent(); doSectionShow('RecorderContainerHeader','RecorderContainer');" title="Add Recorder" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="RecorderContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('RecorderContainerHeader','RecorderContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="RecorderContainer">
		<input name="hidRecorderCount" id="hidRecorderCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php
	reset($router_conf->recorder->arrRecorders);
	$obj = current($router_conf->recorder->arrRecorders);
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddRecorder(%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\");\n",
							-1,
							$obj->name,
							$obj->type,
							$obj->signalling,
							$obj->media,
							$obj->addr,
							$obj->port,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj = next($router_conf->recorder->arrRecorders);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>


<!------------------------------------------------------------------------------------>
<!--								Signalling targets:								-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('SignallingTargetsContainerHeader','SignallingTargetsContainer')">
	<div class="sec" style="display:inline;float:left">Signalling targets&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddTargetSignalling(-1,'','','','','','','','','','','','','','','','','','',0,'',''); 
	Signaling_List(); doChangeEvent();
	doSectionShow('SignallingTargetsContainerHeader','SignallingTargetsContainer');" title="Add Signalling target" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="SignallingTargetsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('SignallingTargetsContainerHeader','SignallingTargetsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="SignallingTargetsContainer">
		<input name="hidSignallingTargetCount" id="hidSignallingTargetCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php
	reset($router_conf->targets_signalling->arrSignallingTargets);
	$obj = current($router_conf->targets_signalling->arrSignallingTargets);
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddTargetSignalling(%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",%d,  \"%s\",\"%s\",\"%s\",  \"%s\",\"%s\");\n",
							-1,
							$obj->name,
							addslashes(htmlspecialchars($obj->called)),
							addslashes(htmlspecialchars($obj->caller)),
							$obj->codec_set,
							$obj->sigtype,
							$obj->sig_ss7_cg_category,
							$obj->sig_ss7_cg_nature,
							$obj->sig_ss7_cg_inetwork,
							$obj->sig_ss7_cg_plan,
							$obj->sig_ss7_cd_nature,
							$obj->sig_ss7_cd_plan,
							$obj->sig_isdn_cg_typeofnumber,
							$obj->sig_isdn_cg_plan,
							$obj->sig_isdn_cg_screeningind,
							$obj->sig_isdn_cd_typeofnumber,
							$obj->sig_isdn_cd_plan,
							$obj->sig_isdn_cd_screeningind,
							$obj->group,
							1,
							$obj->sig_ss7_subject,
							$obj->sig_ss7_priority,
							$obj->sig_ss7_media_service,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj = next($router_conf->targets_signalling->arrSignallingTargets);
	};
	if ($script != "") {
		$script .= sprintf("OnAddSignalling_Plus();");
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>


<!------------------------------------------------------------------------------------>
<!--									AK targets:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('AKTargetsContainerHeader','AKTargetsContainer')">
	<div class="sec" style="display:inline;float:left">AK targets&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddTargetAK(-1,'',null,null,'','',0,'',''); 
	TargetAK_List(); doChangeEvent();
	doSectionShow('AKTargetsContainerHeader','AKTargetsContainer');" title="Add AK target" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="AKTargetsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('AKTargetsContainerHeader','AKTargetsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="AKTargetsContainer">
		<input name="hidAKTargetCount" id="hidAKTargetCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php
	reset($router_conf->targets_ak->arrAKTargets);
	$obj = current($router_conf->targets_ak->arrAKTargets);

	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddTargetAK(%d,\"%s\",%d,%d,\"%s\",\"%s\",'%s',\"%s\",\"%s\");\n",
							-1,
							$obj->name,
							$obj->slot,
							$obj->channel,
							addslashes(htmlspecialchars($obj->income_caller_id)),
							addslashes(htmlspecialchars($obj->outcome_caller_id)),
							addslashes(htmlspecialchars($obj->called)),
							1,
							//$obj->recorders,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj = next($router_conf->targets_ak->arrAKTargets);
	};
	if ($script != "") {
		$script .= sprintf("OnAddTargetAK_Plus();");
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>

<!-- table><tbody><tr><td>
<img  class="imglink" style="display:inline;float:left;margin-top:2px; width:100px;height:100px;" onClick="OnAddTargetAK();TargetAK_List();" title="Add AK target" src="/images/add_block.gif" >
</td></tr></tbody></table -->


<!------------------------------------------------------------------------------------>
<!--								Modem targets:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('ModemTargetsContainerHeader','ModemTargetsContainer')">
	<div class="sec" style="display:inline;float:left">Modem targets&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddTargetModem();doSectionShow('ModemTargetsContainerHeader','ModemTargetsContainer');" title="Add Modem target" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="ModemTargetsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('ModemTargetsContainerHeader','ModemTargetsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="ModemTargetsContainer">
		<input name="hidModemTargetCount" id="hidModemTargetCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php
	reset($router_conf->targets_modem->arrModemTargets);
	$obj = current($router_conf->targets_modem->arrModemTargets);
	$script = "";
//var_dump($obj);	
	while ($obj) {
		$script .= sprintf("OnAddTargetModem(%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\");\n",
							-1,
							$obj->name,
							$obj->originate,
							$obj->fax,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj = next($router_conf->targets_modem->arrModemTargets);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>


<!------------------------------------------------------------------------------------>
<!--								Connections:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('ConnectionContainerHeader','ConnectionContainer')">
	<div class="sec" style="display:inline;float:left">Connections&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddConnection();doSectionShow('ConnectionContainerHeader','ConnectionContainer');" title="Add Connection" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="ConnectionContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('ConnectionContainerHeader','ConnectionContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="ConnectionContainer">
		<input name="hidConnectionCount" id="hidConnectionCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php
	reset($router_conf->connection->arrConnections);
	$obj = current($router_conf->connection->arrConnections);
//var_dump($obj);	
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddConnection(%d,\"%s\" ,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\");\n",
							-1,
							$obj->name,
							$obj->type,
							$obj->radio_rx_addr,
							$obj->radio_rx_port,
							$obj->radio_tx_addr,
							$obj->radio_tx_port,
							$obj->radio_freq_no,
							$obj->radio_freq_chan,
							$obj->cas_trunk_no,
							$obj->cas_trunk_timeslot,

							$obj->radio_bss_enable,
							$obj->radio_rx_delay_msec,
							$obj->radio_tx_delay_msec,

							$obj->vad_voice_th_msec,
							$obj->vad_silence_th_msec,
							$obj->vad_e_th_dB,

							$obj->radio_ng_enable,

							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj = next($router_conf->connection->arrConnections);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>


<!------------------------------------------------------------------------------------>
<!--										Recorder Patterns:						-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('RecorderPatternContainerHeader','RecorderPatternContainer')">
	<div class="sec" style="display:inline;float:left">Recorder Patterns&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddRecorderPattern();doSectionShow('RecorderPatternContainerHeader','RecorderPatternContainer');" title="Add Recorder Pattern" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="RecorderPatternContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('RecorderPatternContainerHeader','RecorderPatternContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="RecorderPatternContainer">
		<input name="hidRecorderPatternSetCount" id="hidRecorderPatternSetCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>

<?php

	reset($router_conf->ILRecorderPatterns->arrILRecorderPatterns);
	$obj=current($router_conf->ILRecorderPatterns->arrILRecorderPatterns);
	//var_dump($router_conf->ILRecorderPatterns);
	//var_dump($obj);	return;
	$script = "";
	
	while ($obj) {
		//var_dump($obj); echo("<br><br>");
		$script .= sprintf("OnAddRecorderPattern(%d,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s');\n",
							-1,
							$obj->recorder_pattern_id,
							$obj->sign_type,
							$obj->slot,
							$obj->channel,
							$obj->trunk,
							$obj->timeslot,
							addslashes(htmlspecialchars($obj->caller)),
							addslashes(htmlspecialchars($obj->called)),
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);

		reset($obj->recorder);
		$obj_int = current($obj->recorder);
		while ($obj_int) {
		//var_dump($obj_int);	echo "<br><br><br>";
			$script .= sprintf("OnAddPatternRec(%d,%d,'%s','%s','%s','%s');\n",
								-1,
								$obj_int->recorder_pattern_id,
								$obj_int->server,
								addslashes(htmlspecialchars($obj_int->user)),
								base64_encode($obj_int->GetCommentLines()),
								base64_encode($obj_int->GetUnknownLines())
								);
			$obj_int = next($obj->recorder);
		}
		
		$obj=next($router_conf->ILRecorderPatterns->arrILRecorderPatterns);
	};
	//var_dump($script);
	if ($script != "") {
		//$script .= sprintf("UpdateBoardControls_AKconfig();\n");
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	
?>


<!------------------------------------------------------------------------------------>
<!--									Patterns:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption  onclick="doSectionSwitch('PatternsContainerHeader','PatternsContainer')">
	<div class="sec" style="display:inline;float:left">Patterns&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddPattern(-1,'','','',null,null,0,'','');Pattern_List(); doSectionShow('PatternsContainerHeader','PatternsContainer'); doChangeEvent();" title="Add pattern" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="PatternsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('PatternsContainerHeader','PatternsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="PatternsContainer">
		<input name="hidPatternCount" id="hidPatternCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php
	reset($router_conf->patterns->arrPatterns);
	$obj = current($router_conf->patterns->arrPatterns);
//var_dump($obj);	
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddPattern(%d,\"%s\",\"%s\",\"%s\",'%s',\"%s\",%d,\"%s\",\"%s\");\n",
							-1,
							$obj->name,
							addslashes(htmlspecialchars($obj->called)),
							addslashes(htmlspecialchars($obj->caller)),
							addslashes(htmlspecialchars($obj->group)),
							$obj->target,
							1,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);

							//addslashes(htmlspecialchars($obj->name)),

		//$script .= sprintf("addPatterntargetRow(%d);\n",-1);
							

		$obj = next($router_conf->patterns->arrPatterns);
	};
	

	if ($script != "") {
		$script .= sprintf("OnAddPattern_Plus();");
		$script .= "UpdatePatternControls();\n";
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	
	//echo var_dump($router_conf->patterns);
?>


<!------------------------------------------------------------------------------------>
<!--									Redirect Patterns:							-->
<!------------------------------------------------------------------------------------>
<!-- div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption>
	<div class="sec" style="display:inline;float:left">Redirect Patterns&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="OnAddRedirectPattern(-1,'','','',null,null,0,'','');RedirectPattern_List(); doSectionShow('RedirectPatternsContainerHeader','RedirectPatternsContainer'); doChangeEvent();" title="Add redirect pattern" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="RedirectPatternsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doSectionSwitch('RedirectPatternsContainerHeader','RedirectPatternsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="RedirectPatternsContainer">
		<input name="hidRedirectPatternCount" id="hidRedirectPatternCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div -->
<?php/*
	reset($router_conf->redirect->arrRedirectPatterns);
	$obj = current($router_conf->redirect->arrRedirectPatterns);
	//var_dump($router_conf->redirect);	
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddRedirectPattern(%d,\"%s\",\"%s\",\"%s\",'%s',\"%s\",%d,\"%s\",\"%s\");\n",
							-1,
							addslashes(htmlspecialchars($obj->name)),
							addslashes(htmlspecialchars($obj->called)),
							addslashes(htmlspecialchars($obj->caller)),
							addslashes(htmlspecialchars($obj->group)),
							$obj->target,
							1,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);

		//$script .= sprintf("addPatterntargetRow(%d);\n",-1);
							

		$obj = next($router_conf->redirect->arrRedirectPatterns);
	};
	

	if ($script != "") {
		$script .= sprintf("OnAddRedirectPattern_Plus();");
		$script .= "UpdateRedirectPatternControls();\n";
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	
	//echo var_dump($router_conf->redirect);*/
?>


<!------------------------------------------------------------------------------------>
<!--								Check patterns:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('CheckPatternsHeader','CheckPatterns')">
	<div class="sec" style="display:inline;float:left">Check patterns&nbsp;</div>
	<div style="width:100%;text-align:right;">
	<img id="CheckPatternsHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('CheckPatternsHeader','CheckPatterns')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top" id="CheckPatterns">
	<td id="CheckPatternsContainer" style="width:170px;">
	</td>
	<td id="CheckPatternsResultContainer">
	</td>
</tr>
</table>
</div>
<?php
	
	$script = sprintf("OnAddCheckPatterns('".$_GET['pcalled']."','".$_GET['pcaller']."','".$_GET['pgroup']."');\n");
	$script .= sprintf("OnAddCheckPatternsResult();\n");
	$script .= sprintf("OnAddCheckPatternsMessage();\n");

	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>


<div id="nullt">&nbsp;</div><div style="clear: both"></div>

<!--table class="nb">
<tr>

<td colspan="2" style="vertical-align:bottom">
<input type="submit" class="inputbt" name="drvApply" value=" Save changes " onclick=" var errmsg=onCheckBeforeSave(); if(errmsg!='') {alert(errmsg);return false;} ">
</td>
<td><span name="errmsg"></span><td>

</tr>
</table -->
<br><br><br><br>
<div class="block-fixed">
<div class="block-fixed-footer">
<input type="submit" class="inputbt" name="drvApply" value=" Save changes " onclick=" var errmsg=onCheckBeforeSave(); if(errmsg!='') {alert(errmsg);return false;} ">
</div>
</div>




<script type="text/javascript">
doSectionCountCheck('SignallingTargetsContainerHeader','SignallingTargetsContainer','Signalling',0);
doSectionCountCheck('AKTargetsContainerHeader','AKTargetsContainer','AKTarget',0);
doSectionCountCheck('ModemTargetsContainerHeader','ModemTargetsContainer','ModemTarget',0);
doSectionCountCheck('ConnectionContainerHeader','ConnectionContainer','Connection',0);
doSectionCountCheck('RecorderContainerHeader','RecorderContainer','Recorder',0);
doSectionCountCheck('PatternsContainerHeader','PatternsContainer','Pattern',0);
doSectionCountCheck('RecorderPatternContainerHeader','RecorderPatternContainer','RecorderPattern',0);
//doSectionCountCheck('RedirectPatternsContainerHeader','RedirectPatternsContainer','RedirectPattern',0);
TargetAK_List();
Pattern_List();
//RedirectPattern_List();
Signaling_List();
if(getCookie('RMainContainerHeader')!=1) doSectionHide('RMainContainerHeader','RMainContainer');
if(getCookie('SignallingTargetsContainerHeader')!=1) doSectionHide('SignallingTargetsContainerHeader','SignallingTargetsContainer');
if(getCookie('AKTargetsContainerHeader')!=1) doSectionHide('AKTargetsContainerHeader','AKTargetsContainer');
if(getCookie('ModemTargetsContainerHeader')!=1) doSectionHide('ModemTargetsContainerHeader','ModemTargetsContainer');
if(getCookie('ConnectionContainerHeader')!=1) doSectionHide('ConnectionContainerHeader','ConnectionContainer');
if(getCookie('RecorderContainerHeader')!=1) doSectionHide('RecorderContainerHeader','RecorderContainer');
if(getCookie('PatternsContainerHeader')!=1) doSectionHide('PatternsContainerHeader','PatternsContainer');
if(getCookie('CheckPatternsHeader')!=1) doSectionHide('CheckPatternsHeader','CheckPatterns');
if(getCookie('RecorderPatternContainerHeader')!=1) doSectionHide('RecorderPatternContainerHeader','RecorderPatternContainer');
//if(getCookie('RedirectPatternsContainerHeader')!=1) doSectionHide('RedirectPatternsContainerHeader','RedirectPatternsContainer');
//alert( document.cookie );
</script>



</form>

<?php require_once(dirname(__FILE__).'/common_footer.inc'); ?>
</body>
</html>
