<?php
function CheckAccess(&$errCode) {
	require_once(dirname(__FILE__).'/ssn_controls.inc');
	$sIP = $_SERVER['REMOTE_ADDR'];
	$sSID = $_COOKIE['IL_SID'];
	$aSSNFile = new CustomSSNFile();
	$aSSNFile->CheckAllSessions();
	$sSTATE = $aSSNFile->GetSessionState($sSID, $sIP);
	if ($sSTATE === 100) {
		$aSSNFile->SetSessionState($sSID, $sIP, $sSTATE);
		return true;
	} else {
		$errCode = 0;
		return false;
	};
};

function DoLogout() {
	require_once(dirname(__FILE__).'/ssn_controls.inc');
	$sIP = $_SERVER['REMOTE_ADDR'];
	$sSID = $_COOKIE['IL_SID'];
	$aSSNFile = new CustomSSNFile("/var/boa_sessions");
	return $aSSNFile->DeleteSession($sSID, $sIP);
};

function CheckRootPassword($user_password) {
	$passwordFileName = '/etc/shadow';
	$md5HASH = '';
	$userName = 'root';
	// find HASH
	$fPassword = fopen($passwordFileName, 'r');
	if ($fPassword) {
		while (!feof($fPassword)) {
			$sLN = fgets($fPassword);
			$arrDiv = explode(':', $sLN);
			if (trim($arrDiv[0]) === $userName) {
				$md5HASH = $arrDiv[1];
				break;
			};
		};
		fclose($fPassword);
	} else {
		// imposible!!!
		return false;
	};
	return (bool)($md5HASH === crypt($user_password, $md5HASH));
};

function DoLogin($sUSR, $sPSWD) {
	// $res values:
	//  1 - successfully logging
	//  0 - access deny
	// -1 - expired time to logging
	// -2 - expired count to logging
	// -3 - system error while logging
	require_once(dirname(__FILE__).'/ssn_controls.inc');
	$logLIMIT = 3;
	$sIP = $_SERVER['REMOTE_ADDR'];
	$sSID = $_COOKIE['IL_SID'];
	$aSSNFile = new CustomSSNFile("/var/boa_sessions");
	$sSTATE = $aSSNFile->GetSessionState($sSID, $sIP);
	$res = -1;
	if ($sSTATE > -1) {
		if ($sSTATE < $logLIMIT) {
			$res = (int)CheckRootPassword($sPSWD);
			if ($res)
				$sSTATE = 100;
			else
				$sSTATE++;
			if (!$aSSNFile->SetSessionState($sSID, $sIP, $sSTATE)) {
				$res = -3;
			};
		} else {
			$res = -2;
		};
	};
	// print_r($_COOKIE);
	return $res;
};

function printMainPage($PagesScript, $WorkScript) {
	print "<html>\n";
	print "<head>\n";
	print "<meta http-equiv='pragma' content='no-cache'>\n";
	print "<meta http-equiv='Cache-Control' content='no-cache'>\n";
	print "<meta http-equiv='expires' content='-1'>\n";
	print "<title>Hardware v5.0 control interface</title>\n";
	print "<script language='JavaScript' type='text/JavaScript' src='/il.js'></script>\n";
	print "<link rel='stylesheet' type='text/css' href='/il.css' media='screen'>\n";
	print "<style type='text/css' media='screen'>\n";
	print "  <!-- @import '/il.css'; -->\n";
	print "</style>\n";
	print "</head>\n";
	print "<frameset rows='40,*' cols='*' framespacing='0' frameborder='no' border='0'>\n";
	print " <frame src='" . $PagesScript;
	print "' name='topFrame' scrolling='no' noresize >\n";
	print " <frame src='" . $WorkScript;
	print "' name='mainFrame'>\n";
	print "</frameset>\n";
	print "<noframes>\n";
	print "<body>\n";
	print "</body>\n";
	print "</noframes>\n";
	print "</html>\n";
};

function printAccessDenied($reason) {
	// TODO: not supported atm - full access!!!
	switch ($reason) {
		case -1:
			header("Location: /denied.html");
			break;
		case 0:
			header("Location: /denied.html");
			break;
		default:
			print "Login error ($reason)<br>\n";
			break;
	}
};

?>
