<?php
define("CONTROLLERCONFFILE", "/usr/local/etc/controller.conf");
include_once "conf_types.inc";

class ILsipObj extends CustomSection {
	public $group = "";
	public $local_contact = '';
	public $log_level = "";
	public $PJ_trace_level = "";
	public $ioqueue_trace_level = "";
	public $local_addr = "";
	public $udp_port = "";
	public $default_URI_scheme = "";
	public $dtmf_INFO_signal_coding = "";
	public $proxy = "";
	public $proxy_user_agent = "";
	public $proxy_username = "";
	public $proxy_password = "";
	public $proxy_realm = "";
	public $proxy_registration_expires = "";
	public $default_gateway = "";
	public $codecs_set = "G.711-Alaw G.729 G.729A G.729B G.729AB G.723.1";


	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "group=" . $this->group . "\n"

				. "local contact=" . $this->local_contact . "\n"
				. "log level=" . $this->log_level . "\n"
				. "PJ SIP log level=" . $this->PJ_trace_level . "\n"
				. "ioqueue trace level=" . $this->ioqueue_trace_level . "\n"
				. "local addr=" . $this->local_addr . "\n"
				. "udp port=" . $this->udp_port . "\n"
				. "default URI scheme=" . $this->default_URI_scheme . "\n"
				. "dtmf INFO signal coding=" . $this->dtmf_INFO_signal_coding . "\n"
				. "proxy=" . $this->proxy . "\n"
				. "proxy user agent=" . $this->proxy_user_agent . "\n"
				. "proxy username=" . $this->proxy_username . "\n"
				. "proxy password=" . $this->proxy_password . "\n"
				. "proxy realm=" . $this->proxy_realm . "\n"
				. "proxy registration expires=" . $this->proxy_registration_expires . "\n"
				. "default gateway=" . $this->default_gateway . "\n"
				. "codecs set=" . $this->codecs_set . "\n"


				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) { $iFormat = 0;  $sName = "";  $sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "group") $this->group = $sValue;
				elseif ($sName === "local contact") $this->local_contact = $sValue;
				elseif ($sName === "log level") $this->log_level = $sValue;
				elseif ($sName === "PJ SIP log level") $this->PJ_trace_level = $sValue;
				elseif ($sName === "ioqueue trace level") $this->ioqueue_trace_level = $sValue;
				elseif ($sName === "local addr") $this->local_addr = $sValue;
				elseif ($sName === "udp port") $this->udp_port = $sValue;
				elseif ($sName === "default URI scheme") $this->default_URI_scheme = $sValue;
				elseif ($sName === "dtmf INFO signal coding") $this->dtmf_INFO_signal_coding = $sValue;
				elseif ($sName === "proxy") $this->proxy = $sValue;
				elseif ($sName === "proxy user agent") $this->proxy_user_agent = $sValue;
				elseif ($sName === "proxy username") $this->proxy_username = $sValue;
				elseif ($sName === "proxy password") $this->proxy_password = $sValue;
				elseif ($sName === "proxy realm") $this->proxy_realm = $sValue;
				elseif ($sName === "proxy registration expires") $this->proxy_registration_expires = $sValue;
				elseif ($sName === "default gateway") $this->default_gateway = $sValue;
				elseif ($sName === "codecs set") $this->codecs_set = $sValue;
				else parent::AddUnknownLine($sParamLine); break;
			case 2: parent::AddCommentLine($sParamLine); break;
		};
	}
};

class ILsipsObj {
	public $arrILsips = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILsip = new ILsipObj();
		$this->arrILsips[] = $objILsip;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILsip->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while (($objValue = $this->arrILsips[$i++])) {
			$sRes = $sRes . "[SIP/PJ]\n" . $objValue->GetAsFullCfgString();
			if ($i < count($this->arrILsips)) {
				$sRes = $sRes . "\n";
			};
		};
		return $sRes;
	}

};

//--------------------------------------------------------------------------------------------------

class ILrtspObj extends CustomSection {
	public $group = "";
	public $log_level = "";
	public $rtsp_log_level = "";
	public $ioqueue_trace_level = "";
	public $local_addr = "";
	public $tcp_port = "";
	public $default_uri_scheme = "";
	public $rtsp_codecs = "G.711-Alaw G.729 G.729A G.729B G.729AB G.723.1";

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "group=" . $this->group . "\n"
				. "log level=" . $this->log_level . "\n"
				. "PJ RTSP log level=" . $this->rtsp_log_level . "\n"
				. "ioqueue trace level=" . $this->ioqueue_trace_level . "\n"
				. "local addr=" . $this->local_addr . "\n"
				. "tcp port=" . $this->tcp_port . "\n"
				. "default URI scheme=" . $this->default_uri_scheme . "\n"
				. "codecs set=" . $this->rtsp_codecs . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
							
	public function PutParam($sParamLine) { $iFormat = 0;  $sName = "";  $sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "group") $this->group = $sValue;
				elseif ($sName === "log level") $this->log_level = $sValue;
				elseif ($sName === "PJ RTSP log level") $this->rtsp_log_level = $sValue;
				elseif ($sName === "ioqueue trace level") $this->ioqueue_trace_level = $sValue;
				elseif ($sName === "local addr") $this->local_addr = $sValue;
				elseif ($sName === "tcp port") $this->tcp_port = $sValue;
				elseif ($sName === "default URI scheme") $this->default_uri_scheme = $sValue;
				elseif ($sName === "codecs set") $this->rtsp_codecs = $sValue;
				else parent::AddUnknownLine($sParamLine); break;
			case 2: parent::AddCommentLine($sParamLine); break;
		};
	}
};

class ILrtspsObj {
	public $arrILrtsps = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILrtsp = new ILrtspObj();
		$this->arrILrtsps[] = $objILrtsp;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILrtsp->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while (($objValue = $this->arrILrtsps[$i++])) {
			$sRes = $sRes . "[RTSP/PJ]\n" . $objValue->GetAsFullCfgString();
			if ($i < count($this->arrILrtsps)) {
				$sRes = $sRes . "\n";
			};
		};
		return $sRes;
	}

};

//--------------------------------------------------------------------------------------------------




class ILboardObj extends CustomSection {
	public $SlotName = "slot1";
	public $HostIP = "127.0.0.1";

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "name=" . $this->SlotName . "\n"
				. "host=" . $this->HostIP . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "name") {
					$this->SlotName = $sValue;
				} else {
					if ($sName === "host") {
						$this->HostIP = $sValue;
					} else {
						parent::AddUnknownLine($sParamLine);
					};
				};
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ILboardsObj {
	public $arrILboards = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILboard = new ILboardObj();
		$this->arrILboards[] = $objILboard;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILboard->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}

	public function GetByIndex($iIndex) {
		return $this->arrILboards[(int)$iIndex];
	}

	public function GetByName($bName) {
		$i = 0;
		do {
			$objBoard = $this->GetByIndex($i++);
			if ($objBoard != null) {
				if ($objBoard->SlotName === $bName) {
					break;
				};
			};
		} while ($objBoard != null);
		return $objBoard;
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while (($objValue = $this->arrILboards[$i++])) {
			$sRes = $sRes . "[board]\n" . $objValue->GetAsFullCfgString();
			if ($i < count($this->arrILboards)) {
				$sRes = $sRes . "\n";
			};
		};
		return $sRes;
	}
};

class ILctrl extends CustomSection {
	public $Port = "20000";
	public $disable_bus = "";

	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			switch ($iFormat) {
				case 1:
					if ($sName === "port") {
						$this->Port = $sValue;
					} elseif ($sName === "disable bus") {
						$this->disable_bus = $sValue;
					} else {
						parent::AddUnknownLine($sTMP);
					};
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsSections() {
		$sRes = "[ctrl]\n"
				. parent::GetCommentLines()
				. "port=" . $this->Port . "\n"
				. "disable bus=" . $this->disable_bus . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
};

class ILsignallingpoint extends CustomSection {
	public $opc = "1";
	public $network = "regional";
	public $trace = "";

	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			switch ($iFormat) {
				case 1:
					if (array_key_exists($sName, get_object_vars($this)))
						$this->$sName = $sValue;
					else
						parent::AddUnknownLine($sTMP);
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsSections() {
		$sRes = "[signalling point]\n"
				. parent::GetCommentLines()
				. "opc=" . $this->opc . "\n"
				. "network=" . $this->network . "\n"
				. "trace=" . $this->trace . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
};

class ILsyncronizer extends CustomSection {
	public $Sources = "";

	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			// printf("Param='%s', Format=%d, Name='%s', Value='%s'<br>",$sTMP,$iFormat,$sName,$sValue);
			switch ($iFormat) {
				case 1:
					if ($sName === "sources") {
						$this->Sources = $sValue;
					} else {
						parent::AddUnknownLine($sTMP);
					};
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsSections() {
		$sRes = "[synchronizer]\n"
				. parent::GetCommentLines()
				. "sources=" . $this->Sources . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
};

class ILtraces extends CustomSection {
	public $ccp = "";
	public $snmptraps = "";

	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			// printf("Param='%s', Format=%d, Name='%s', Value='%s'<br>",$sTMP,$iFormat,$sName,$sValue);
			switch ($iFormat) {
				case 1:
					if ($sName === "ccp") {
						$this->ccp = $sValue;
					} elseif ($sName === "snmp.traps") {
						$this->snmptraps = $sValue;
					} else {
						parent::AddUnknownLine($sTMP);
					};
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsSections() {
		$sRes = "[traces]\n"
				. parent::GetCommentLines()
				. "ccp=" . $this->ccp . "\n"
				. "snmp.traps=" . $this->snmptraps . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
};

class ILH323group extends CustomSection {
	public $group = "";
	public $terminal_type = "40";
	public $compatibility = "v4";
	public $enable_H245_tunneling = "yes";
	public $enable_fast_start = "yes";
	public $codecs_set = "G.711-Alaw G.729 G.729A G.729B G.729AB G.723.1";
	public $alias = "";
	public $gatekeeper = "";
	public $disablet38 = "no";
	public $text_comments = "";
	public $text_unknowns = "";

	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			// printf("Param='%s', Format=%d, Name='%s', Value='%s'<br>",$sTMP,$iFormat,$sName,$sValue);
			switch ($iFormat) {
				case 1:
					if ($sName === "group")
						$this->group = $sValue;
					elseif ($sName === "terminal type")
						$this->terminal_type = $sValue;
					elseif ($sName === "compatibility")
						$this->compatibility = $sValue;
					elseif ($sName === "enable H245 tunneling")
						$this->enable_H245_tunneling = $sValue;
					elseif ($sName === "enable fast start")
						$this->enable_fast_start = $sValue;
					elseif ($sName === "codecs set")
						$this->codecs_set = $sValue;
					elseif ($sName === "gatekeeper")
						$this->gatekeeper = $sValue;
					elseif ($sName === "alias")
						$this->alias = $sValue;
					elseif ($sName === "disable T.38")
						$this->disablet38 = $sValue;
					else {
						parent::AddUnknownLine($sTMP);
						$this->text_comments = $this->text_comments . $sTMP . "\n";
					};
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					$this->text_unknowns = $this->text_unknowns . $sTMP . "\n";
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsSections() {
		$sRes = "[H323]\n" . parent::GetCommentLines()
				. "group=" . $this->group . "\n"
				. "terminal type=" . $this->terminal_type . "\n"
				. "compatibility=" . $this->compatibility . "\n"
				. "enable H245 tunneling=" . $this->enable_H245_tunneling . "\n"
				. "enable fast start=" . $this->enable_fast_start . "\n"
				. "codecs set=" . $this->codecs_set . "\n"
				. "alias=" . $this->alias . "\n"
				. "disable T.38=" . $this->disablet38 . "\n";
		if ($this->gatekeeper) {
			$sRes = $sRes . "gatekeeper=" . $this->gatekeeper . "\n";
		};
		$sRes = $sRes . parent::GetUnknownLines();
		return $sRes;
	}
};

class ILH323groupsObj {
	public $arrILH323groups = array();

	public function AddAsSection($sSection) {
		$objILH323group = new ILH323group();
		$this->arrILH323groups[] = $objILH323group;
		$objILH323group->AddAsSection($sSection);
	}

	public function GetByIndex($iIndex) {
		return $this->arrILH323groups[$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while (($objValue = $this->arrILH323groups[$i++])) {
			$sRes = $sRes . $objValue->GetAsSections();
			if ($i < count($this->arrILH323groups)) {
				$sRes = $sRes . "\n";
			};
		};
		return $sRes;
	}
};

class ILH323terminal extends CustomSection {
	public $Group = "";
	public $HostIP = "";
	public $codecs_set = "";
	public $disablet38 = "no";

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "group=" . $this->Group . "\n"
				. "host=" . $this->HostIP . "\n"
				. "codecs set=" . $this->codecs_set . "\n"
				. "disable T.38=" . $this->disablet38 . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "group")
					$this->Group = $sValue;
				elseif ($sName === "host")
					$this->HostIP = $sValue;
				elseif ($sName === "codecs set")
					$this->codecs_set = $sValue;
				elseif ($sName === "disable T.38")
					$this->disablet38 = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ILH323terminalsObj {
	public $arrILH323terminals = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILH323terminal = new ILH323terminal();
		$this->arrILH323terminals[] = $objILH323terminal;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILH323terminal->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}

	public function GetByIndex($iIndex) {
		return $this->arrILH323terminals[$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while (($objValue = $this->arrILH323terminals[$i++])) {
			$sRes = $sRes . "[H323 terminal]\n" . $objValue->GetAsFullCfgString();
			if ($i < count($this->arrILH323terminals)) {
				$sRes = $sRes . "\n";
			};
		};
		return $sRes;
	}
};

class ILisdnObj extends CustomSection {
	public $IDTrunk = "1";
	public $GroupID = "1";
	public $NetSide = "user";
	public $Tslots = "0";

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		//logmsg(print_r($tmpARR, true));
		$sTMP = current($tmpARR);
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$this->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "trunk=" . $this->IDTrunk . "\n"
				. "group=" . $this->GroupID . "\n"
				. "side=" . $this->NetSide . "\n"
				. "timeslots=" . $this->Tslots . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "trunk")
					$this->IDTrunk = $sValue;
				elseif ($sName === "group")
					$this->GroupID = $sValue;
				elseif ($sName === "side")
					$this->NetSide = $sValue;
				elseif ($sName === "timeslots")
					$this->Tslots = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ILcasObj extends CustomSection {
	public $IDTrunk = "1";
	public $CasType = "";
	public $Tslots = "0";

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		//logmsg(print_r($tmpARR, true));
		$sTMP = current($tmpARR);
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$this->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "trunk=" . $this->IDTrunk . "\n"
				. "type=" . $this->CasType . "\n"
				. "timeslots=" . $this->Tslots . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "trunk")
					$this->IDTrunk = $sValue;
				elseif ($sName === "type")
					$this->CasType = $sValue;
				elseif ($sName === "timeslots")
					$this->Tslots = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ILhdlcObj extends CustomSection {
	public $IDTrunk = "1";
	public $HdlcType = "alarm_ggs";
	//public $HdlcTimeslot = "31";
	//public $HdlcAddress = "0x1111";

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		//logmsg(print_r($tmpARR, true));
		$sTMP = current($tmpARR);
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$this->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "trunk=" . $this->IDTrunk . "\n"
				. "type=" . $this->HdlcType . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
//				. "hdlc_timeslot=" . $this->HdlcTimeslot . "\n"
//				. "hdlc_address=" . $this->HdlcAddress . "\n"

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "trunk")
					$this->IDTrunk = $sValue;
				elseif ($sName === "type")
					$this->HdlcType = $sValue;
				/*elseif ($sName === "hdlc_timeslot")
					$this->HdlcTimeslot = $sValue;
				elseif ($sName === "hdlc_address")
					$this->HdlcAddress = $sValue;*/
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

// trunk concentrator
class ILtrunkObj extends CustomSection {
	public $IDTrunk = "1";
	public $board = "Slot1";
	public $dig_path = "0";
	
	public $BoardObj;
	public $LogicObj;
	public $LogicName = "none";
	public $ss7links;
	public $ss7isup;

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "id=" . $this->IDTrunk . "\n"
				. "board=" . $this->board . "\n"
				. "digital path=" . $this->dig_path . "\n"
				. "LogicName=" . $this->LogicName . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "id")
					$this->IDTrunk = $sValue;
				elseif ($sName === "board")
					$this->board = $sValue;
				elseif ($sName === "digital path")
					$this->dig_path = $sValue;
				elseif ($sName === "LogicName")
					$this->LogicName = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}

	public function GetLinksKey() {
		$sRes = "";
		if ($this->ss7links)
			foreach ($this->ss7links as $link) {
				if ($sRes == "")
					$sRes = $link->skey;
				else
					$sRes .= ",".$link->skey;
			}
		return $sRes;
	}
};

class ILtrunksObj {
	public $arrILtrunks = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILtrunk = new ILtrunkObj();
		$this->arrILtrunks[] = $objILtrunk;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILtrunk->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}

	public function GetByIndex($iIndex) {
		return $this->arrILtrunks[(int)$iIndex];
	}

	public function GetByTrunkID($TrunkID) {
		$i = 0;
		do {
			$objTrunk = $this->GetByIndex($i++);
			if ($objTrunk != null) {
				if ($objTrunk->IDTrunk === $TrunkID) {
					break;
				};
			};
		} while ($objTrunk != null);
		return $objTrunk;
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while (($objValue = $this->arrILtrunks[$i++])) {
			$sRes = $sRes . "[trunk]\n" . $objValue->GetAsFullCfgString();
			if ($objValue->LogicObj) {
				//$sRes = $sRes . "\n[isdn]\n" . $objValue->LogicObj->GetAsFullCfgString();
				$sRes = $sRes . "\n[".$objValue->LogicObj->LName."]\n" . $objValue->LogicObj->GetAsFullCfgString();
			};
			if ($i < count($this->arrILtrunks)) {
				$sRes = $sRes . "\n";
			};
		};
		return $sRes;
	}
	
	
	
	
};

//*************************************************************************************************************

// isdn trunk
class ILISDNTrunkObj extends CustomSection {
	public $trunk = "1";
	public $group = "";
	public $side = "";
	public $timeslots = "";

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "trunk=" . $this->trunk . "\n"
				. "group=" . $this->group . "\n"
				. "side=" . $this->side . "\n"
				. "timeslots=" . $this->timeslots . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "trunk")
					$this->trunk = $sValue;
				elseif ($sName === "group")
					$this->group = $sValue;
				elseif ($sName === "side")
					$this->side = $sValue;
				elseif ($sName === "timeslots")
					$this->timeslots = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}

	/*public function GetLinksKey() {
		$sRes = "";
		if ($this->ss7links)
			foreach ($this->ss7links as $link) {
				if ($sRes == "")
					$sRes = $link->skey;
				else
					$sRes .= ",".$link->skey;
			}
		return $sRes;
	}*/
};

class ILISDNTrunksObj {
	public $arrISDNTrunks = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILtrunk = new ILISDNTrunkObj();
		$this->arrISDNTrunks[] = $objILtrunk;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILtrunk->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}

	public function GetByIndex($iIndex) {
		return $this->arrISDNTrunks[(int)$iIndex];
	}
/*
	public function GetByTrunkID($TrunkID) {
		$i = 0;
		do {
			$objTrunk = $this->GetByIndex($i++);
			if ($objTrunk != null) {
				if ($objTrunk->IDTrunk === $TrunkID) {
					break;
				};
			};
		} while ($objTrunk != null);
		return $objTrunk;
	}*/

/*
	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while (($objValue = $this->arrISDNTrunks[$i++])) {
			$sRes = $sRes . "[isdn]\n" . $objValue->GetAsFullCfgString();
			if ($objValue->LogicObj) {
				//$sRes = $sRes . "\n[isdn]\n" . $objValue->LogicObj->GetAsFullCfgString();
				$sRes = $sRes . "\n[".$objValue->LogicObj->LName."]\n" . $objValue->LogicObj->GetAsFullCfgString();
			};
			if ($i < count($this->arrISDNTrunks)) {
				$sRes = $sRes . "\n";
			};
		};
		return $sRes;
	}
*/
	
	public function GetAsSections() {
		$sRes = "";
		foreach ($this->arrISDNTrunks as $linkset) {
			$sRes .= "\n[isdn]\n" . $linkset->GetAsFullCfgString();
			/*foreach ($linkset->links as $link)
				$sRes .= "\n[link]\n" . $link->GetAsFullCfgString();
			foreach ($linkset->isups as $isup)
				$sRes .= "\n[isup]\n" . $isup->GetAsFullCfgString();*/
		}
		return $sRes;
	}
	
	
	
};

//**************************************************************************************************************



// cas trunk
class ILCASTrunkObj extends CustomSection {
	public $trunk = "";
	public $type = "";
	public $timeslots = "";
	public $cas_channel = array();

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "trunk=" . $this->trunk . "\n"
				. "type=" . $this->type . "\n"
				. "timeslots=" . $this->timeslots . "\n"
				. parent::GetUnknownLines();
		//var_dump($sRes);return;
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "trunk")
					$this->trunk = $sValue;
				elseif ($sName === "type")
					$this->type = $sValue;
				elseif ($sName === "timeslots")
					$this->timeslots = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
	
};

class ILCASTrunksObj {
	public $arrCASTrunks = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILCASTrunk = new ILCASTrunkObj();
		$this->arrCASTrunks[] = $objILCASTrunk;
		$objILCASTrunkSet->index = count($this->arrCASTrunks);
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILCASTrunk->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}
	
	
	public function GetByIndex($iIndex) {
		return $this->arrCASTrunks[(int)$iIndex];
	}

	//public function GetByID($emphone_id) {
	public function GetByID($trunk) {
		$i = 0;
		do {
			$obj_castrunkset = $this->GetByIndex($i++);
			if ($obj_castrunkset != null) {
				//if ($obj_castrunkset->trunk === $emphone_id) {
				if ($obj_castrunkset->trunk === $trunk) {
					break;
				};
			};
		} while ($obj_castrunkset != null);
		return $obj_castrunkset;
	}	

	public function GetAsSections() {
		$sRes = "";
		foreach ($this->arrCASTrunks as $cas_set) {
			$sRes .= "\n[cas]\n" . $cas_set->GetAsFullCfgString();
			foreach ($cas_set->cas_channel as $cas_channel)
				$sRes .= "\n[cas-channel]\n" . $cas_channel->GetAsFullCfgString();
		}
		//var_dump($sRes);return;
		return $sRes;
	}
	
};



class ILCASTrunksChannelObj extends CustomSection {
	public $trunk;
	public $timeslot;
	public $type;
	
	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			switch ($iFormat) {
				case 1:
					$props = get_object_vars($this);
					$name2 = str_replace(' ', '_', $sName);
					if (array_key_exists($sName, $props))
						$this->$sName = $sValue;
					elseif (array_key_exists($name2, $props))
						$this->$name2 = $sValue;
					else
						parent::AddUnknownLine($sTMP);
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "trunk=" . $this->trunk . "\n"
				. "timeslot=" . $this->timeslot . "\n"
				. "type=" . $this->type . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
	
};




// tone signalling trunk
class ILToneTrunkObj extends CustomSection {
	public $trunk = "1";
	public $type = "";
	public $transport = "";
	public $timeslot = "";
	public $det_lvl_dB = "";
	public $gen_lvl_dB = "";
	public $rx_gain_dB = "";
	public $vad_voice_th_msec = "";
	public $vad_silence_th_msec = "";
	public $vad_e_th_dB = "";
	public $name = "";

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "trunk=" . $this->trunk . "\n"
				. "type=" . $this->type . "\n"
				. "transport=" . $this->transport . "\n"
				. "timeslot=" . $this->timeslot . "\n"
				. "det_lvl_dB=" . $this->det_lvl_dB . "\n"
				. "gen_lvl_dB=" . $this->gen_lvl_dB . "\n"
				. "rx_gain_dB=" . $this->rx_gain_dB . "\n"
				. "vad.voice_th_msec=" . $this->vad_voice_th_msec . "\n"
				. "vad.silence_th_msec=" . $this->vad_silence_th_msec . "\n"
				. "vad.e_th_dB=" . $this->vad_e_th_dB . "\n"
				. "name=" . $this->name . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "trunk")
					$this->trunk = $sValue;
				elseif ($sName === "type")
					$this->type = $sValue;
				elseif ($sName === "transport")
					$this->transport = $sValue;
				elseif ($sName === "timeslot")
					$this->timeslot = $sValue;
				elseif ($sName === "det_lvl_dB")
					$this->det_lvl_dB = $sValue;
				elseif ($sName === "gen_lvl_dB")
					$this->gen_lvl_dB = $sValue;
				elseif ($sName === "rx_gain_dB")
					$this->rx_gain_dB = $sValue;
				elseif ($sName === "vad.voice_th_msec")
					$this->vad_voice_th_msec = $sValue;
				elseif ($sName === "vad.silence_th_msec")
					$this->vad_silence_th_msec = $sValue;
				elseif ($sName === "vad.e_th_dB")
					$this->vad_e_th_dB = $sValue;
				elseif ($sName === "name")
					$this->name = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ILToneTrunksObj {
	public $arrToneTrunks = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILtrunk = new ILToneTrunkObj();
		$this->arrToneTrunks[] = $objILtrunk;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILtrunk->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}

	public function GetByIndex($iIndex) {
		return $this->arrToneTrunks[(int)$iIndex];
	}
	
	public function GetAsSections() {
		$sRes = "";
		foreach ($this->arrToneTrunks as $linkset) {
			$sRes .= "\n[tone-channel]\n" . $linkset->GetAsFullCfgString();
		}
		return $sRes;
	}
	
	
	
};


//**************************************************************************************************************






// SS7 linkset
class ILlinksetObj extends CustomSection {
	public $index;
	public $id = 'ls';
	public $dpc = '0';
	public $links = array();
	public $isups = array();

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "id=" . $this->id . "\n"
				. "dpc=" . $this->dpc . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if (array_key_exists($sName, get_object_vars($this)))
					$this->$sName = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

// SS7 linksets
class ILlinksetsObj {
	public $arrILlinksets = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILlinkset = new ILlinksetObj();
		$this->arrILlinksets[] = $objILlinkset;
		$objILlinkset->index = count($this->arrILlinksets);
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILlinkset->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}

	public function GetByIndex($iIndex) {
		return $this->arrILlinksets[(int)$iIndex];
	}

	public function GetLinksByKey($skey) {
		if ($skey != '0_0') {
			$res = array();
			$keylist = explode(",", $skey);
			foreach ($keylist as $key) {
				$keys = explode("_", $key);
				$res[] = $this->arrILlinksets[(int)($keys[0] - 1)]->links[(int)($keys[1] - 1)];
			}
			return $res;
			//$keys = explode("_", $skey);
			//return $this->arrILlinksets[(int)($keys[0] - 1)]->links[(int)($keys[1] - 1)];
		} else
			return null;
	}

	public function GetIsupByKey($skey) {
		if ($skey != '0_0') {
			$keys = explode("_", $skey);
			return $this->arrILlinksets[(int)($keys[0] - 1)]->isups[(int)($keys[1] - 1)];
		} else
			return null;
	}

	public function GetByID($linksetID) {
		$i = 0;
		do {
			$objlinkset = $this->GetByIndex($i++);
			if ($objlinkset != null) {
				if ($objlinkset->id === $linksetID) {
					break;
				};
			};
		} while ($objlinkset != null);
		return $objlinkset;
	}

	public function GetByDPC($linksetDPC) {
		$i = 0;
		do {
			$objlinkset = $this->GetByIndex($i++);
			if ($objlinkset != null) {
				if ($objlinkset->dpc === $linksetDPC) {
					break;
				};
			};
		} while ($objlinkset != null);
		return $objlinkset;
	}

	public function GetAsSections() {
		// $i=0;
		// while ($objValue=$this->arrILlinksets[$i++])
		// {
		// $sRes .= "[linkset]\n".$objValue->GetAsFullCfgString();
		// //TODO: process all linkset.link and all .isups
		// if ($i<count($this->arrILlinksets))
		// {
		// $sRes .= "\n";
		// };
		// };
		$sRes = "";
		foreach ($this->arrILlinksets as $linkset) {
			$sRes .= "\n[linkset]\n" . $linkset->GetAsFullCfgString();
			foreach ($linkset->links as $link)
				$sRes .= "\n[link]\n" . $link->GetAsFullCfgString();
			foreach ($linkset->isups as $isup)
				$sRes .= "\n[isup]\n" . $isup->GetAsFullCfgString();
		}
		return $sRes;
	}
};

// SS7 link
class ILlinkObj extends CustomSection {
	public $index;
	public $skey;
	public $linkset = '';
	public $trunk = '';
	public $timeslot = '';
	public $slc = '';
	public $trace_id = '';
	public $trunk_obj;

	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			switch ($iFormat) {
				case 1:
					$props = get_object_vars($this);
					$name2 = str_replace(' ', '_', $sName);
					if (array_key_exists($sName, $props))
						$this->$sName = $sValue;
					elseif (array_key_exists($name2, $props))
						$this->$name2 = $sValue;
					else
						parent::AddUnknownLine($sTMP);
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "linkset=" . $this->linkset . "\n"
				. "trunk=" . $this->trunk . "\n"
				. "timeslot=" . $this->timeslot . "\n"
				. "slc=" . $this->slc . "\n"
				. "trace id=" . $this->trace_id . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
};

// SS7 isup
class ILisupObj extends CustomSection {
	public $index;
	public $skey;
	public $linkset = '';
	public $trunk = '';
	public $cic_base = '';
	public $dpc = '';
	public $timeslots = '1..31';
	public $group = '';
	public $trunk_obj;

	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			switch ($iFormat) {
				case 1:
					$props = get_object_vars($this);
					$name2 = str_replace(' ', '_', $sName);
					if (array_key_exists($sName, $props))
						$this->$sName = $sValue;
					elseif (array_key_exists($name2, $props))
						$this->$name2 = $sValue;
					else
						parent::AddUnknownLine($sTMP);
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "trunk=" . $this->trunk . "\n"
				. "cic base=" . $this->cic_base . "\n"
				. "dpc=" . $this->dpc . "\n"
				. "timeslots=" . $this->timeslots . "\n"
				. "group=" . $this->group . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
};
/*
class ILAKObj extends CustomSection {
	public $id = 'ak';
	public $Slot = "1";
	public $Board = "";
	public $Group = "";
	public $EmV5Chs = "";
	public $FourWireChs = "";
	public $channel = array();

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "slot=" . $this->Slot . "\n"
				. "board=" . $this->Board . "\n"
				. "group=" . $this->Group . "\n"
				. "e&m_v5-channels=" . $this->EmV5Chs . "\n"
				. "4wire-channels=" . $this->FourWireChs . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "slot")
					$this->Slot = $sValue;
				elseif ($sName === "board")
					$this->Board = $sValue;
				elseif ($sName === "group")
					$this->Group = $sValue;
				elseif ($sName === "e&m_v5-channels")
					$this->EmV5Chs = $sValue;
				elseif ($sName === "4wire-channels")
					$this->FourWireChs = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};
*/
class ILAKObj extends CustomSection {
	public $ak_id = "";
	public $Slot = "";
	public $Board = "";
	public $Group = "";
	public $EmV5Chs = "";
	public $FourWireChs = "";
	public $r2channels = "";
	public $channel = array();

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "ak_id=" . $this->ak_id . "\n"
				. "slot=" . $this->Slot . "\n"
				. "board=" . $this->Board . "\n"
				. "group=" . $this->Group . "\n"
				. "e&m_v5-channels=" . $this->EmV5Chs . "\n"
				. "4wire-channels=" . $this->FourWireChs . "\n"
				. "r2-channels=" . $this->r2channels . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "ak_id")
					$this->ak_id = $sValue;
				elseif ($sName === "slot")
					$this->Slot = $sValue;
				elseif ($sName === "board")
					$this->Board = $sValue;
				elseif ($sName === "group")
					$this->Group = $sValue;
				elseif ($sName === "e&m_v5-channels")
					$this->EmV5Chs = $sValue;
				elseif ($sName === "4wire-channels")
					$this->FourWireChs = $sValue;
				elseif ($sName === "r2-channels")
					$this->r2channels = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ILAKsObj {
	public $arrILAKs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILAK = new ILAKObj();
		$this->arrILAKs[] = $objILAK;
		$objILAKset->index = count($this->arrILAKs);
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILAK->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}
	
	
	public function GetByIndex($iIndex) {
		return $this->arrILAKs[(int)$iIndex];
	}

	public function GetByID($aksetID) {
		$i = 0;
		do {
			$objakset = $this->GetByIndex($i++);
			if ($objakset != null) {
				if ($objakset->ak_id === $aksetID) {
					break;
				};
			};
		} while ($objakset != null);
		return $objakset;
	}	

	public function GetAsSections() {
		$sRes = "";
		foreach ($this->arrILAKs as $akset) {
			$sRes .= "\n[ak]\n" . $akset->GetAsFullCfgString();
			foreach ($akset->channel as $channel)
				$sRes .= "\n[ak-channel]\n" . $channel->GetAsFullCfgString();
		}
		return $sRes;
	}
	
};


class ILAKChannelObj extends CustomSection {
	public $idx;
	public $ak_id;
	public $name;
	public $slot;
	public $board;
	public $group;
	public $id;
	public $rx_gain_dB;
	public $rx_pregain_dB;
	public $tx_gain_dB;
	public $cid_det_dB;
	//public $cid_aisn;
	public $cid_type;
	public $dtmf_sig_msec;
	public $dtmf_pause_msec;
	public $gen_gain_dB;
	public $line_coeffs_set;
	public $ec_nlp;
	public $ec_lbgn;
	public $vad_lvl_dB;
	public $vad_timeout_sec;
	public $release_by_vad;

	
	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			switch ($iFormat) {
				case 1:
					$props = get_object_vars($this);
					$name2 = str_replace(' ', '_', $sName);
					if (array_key_exists($sName, $props))
						$this->$sName = $sValue;
					elseif (array_key_exists($name2, $props))
						$this->$name2 = $sValue;
					else
						parent::AddUnknownLine($sTMP);
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "ak_id=" . $this->ak_id . "\n"
				. "name=" . $this->name . "\n"
				. "slot=" . $this->slot . "\n"
				. "board=" . $this->board . "\n"
				. "group=" . $this->group . "\n"
				. "id=" . $this->id . "\n"
				. "rx_gain_dB=" . $this->rx_gain_dB . "\n"
				. "rx_pregain_dB=" . $this->rx_pregain_dB . "\n"
				. "tx_gain_dB=" . $this->tx_gain_dB . "\n"
				. "cid_det_dB=" . $this->cid_det_dB . "\n"
				. "cid_type=" . $this->cid_type . "\n"
				. "dtmf_sig_msec=" . $this->dtmf_sig_msec . "\n"
				. "dtmf_pause_msec=" . $this->dtmf_pause_msec . "\n"
				. "gen_gain_dB=" . $this->gen_gain_dB . "\n"
				. "line_coeffs_set=" . $this->line_coeffs_set . "\n"
				. "ec_nlp=" . $this->ec_nlp . "\n"
				. "ec_lbgn=" . $this->ec_lbgn . "\n"
				. "vad_lvl_dB=" . $this->vad_lvl_dB . "\n"
				. "vad_timeout_sec=" . $this->vad_timeout_sec . "\n"
				. "release_by_vad=" . $this->release_by_vad . "\n"
				. parent::GetUnknownLines();

				//. "cid_aisn=" . $this->cid_aisn . "\n"
		return $sRes;
	}
	
};


//   Emergency Phone configuration ------------------------------------------------------------------
class ILEmPhoneObj extends CustomSection {
	public $emphone_id = "";
	public $trunk = "";
	public $callerId = "";
	public $name = "";
	public $missec = "";
	public $emphone_channel = array();
	public $hdlc_timeslot = "31";
	public $hdlc_address = "0x1111";

	public function GetAsFullCfgString() {
		$this->missec = ( $this->missec >=0 ) ? $this->missec : 15;
		$sRes = parent::GetCommentLines()
				. "emphone_id=" . $this->emphone_id . "\n"
				. "trunk=" . $this->trunk . "\n"
				. "callerId=" . $this->callerId . "\n"
				. "name=" . $this->name . "\n"
				. "missedHighlightSecs=" . $this->missec . "\n"
				. "hdlc_timeslot=" . $this->hdlc_timeslot . "\n"
				. "hdlc_address=" . $this->hdlc_address . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "emphone_id")
					$this->emphone_id = $sValue;
				elseif ($sName === "trunk")
					$this->trunk = $sValue;
				elseif ($sName === "callerId")
					$this->callerId = $sValue;
				elseif ($sName === "name")
					$this->name = $sValue;
				elseif ($sName === "missedHighlightSecs")
					$this->missec = $sValue;
				elseif ($sName === "hdlc_timeslot")
					$this->hdlc_timeslot = $sValue;
				elseif ($sName === "hdlc_address")
					$this->hdlc_address = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ILEmPhonesObj {
	public $arrILEmPhones = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILEmPhone = new ILEmPhoneObj();
		$this->arrILEmPhones[] = $objILEmPhone;
		$objILEmPhoneSet->index = count($this->arrILEmPhones);
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILEmPhone->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}
	
	
	public function GetByIndex($iIndex) {
		return $this->arrILEmPhones[(int)$iIndex];
	}

	public function GetByID($emphone_id) {
		$i = 0;
		do {
			$obj_emphoneset = $this->GetByIndex($i++);
			if ($obj_emphoneset != null) {
				if ($obj_emphoneset->emphone_id === $emphone_id) {
					break;
				};
			};
		} while ($obj_emphoneset != null);
		return $obj_emphoneset;
	}	

	public function GetAsSections() {
		$sRes = "";
		foreach ($this->arrILEmPhones as $eph_set) {
			$sRes .= "\n[emphone]\n" . $eph_set->GetAsFullCfgString();
			foreach ($eph_set->emphone_channel as $emphone_channel)
				$sRes .= "\n[emphone-channel]\n" . $emphone_channel->GetAsFullCfgString();
		}
		return $sRes;
	}
	
};

class ILEmPhoneChannelObj extends CustomSection {
	public $emphone_id;
	public $trunk;
	public $timeslot;
	public $called;
	public $called_desc;
	public $subscribe_to;
	public $enable;
	
	
	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			switch ($iFormat) {
				case 1:
					$props = get_object_vars($this);
					$name2 = str_replace(' ', '_', $sName);
					if (array_key_exists($sName, $props))
						$this->$sName = $sValue;
					elseif (array_key_exists($name2, $props))
						$this->$name2 = $sValue;
					else
						parent::AddUnknownLine($sTMP);
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "emphone_id=" . $this->emphone_id . "\n"
				. "trunk=" . $this->trunk . "\n"
				. "timeslot=" . $this->timeslot . "\n"
				. "called=" . $this->called . "\n"
				. "called_desc=" . $this->called_desc . "\n"
				. "subscribe_to=" . $this->subscribe_to . "\n"
				. "enable=" . $this->enable . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
	
};

//***************************************************************************************************

/*
//   CAS Trunk configuration ------------------------------------------------------------------
class ILCASTrunkObj extends CustomSection {
	public $trunk = "";
	public $type = "";
	public $timeslots = "";
	public $castrunk_channel = array();

	public function GetAsFullCfgString() {
		$this->missec = ( $this->missec >=0 ) ? $this->missec : 15;
		$sRes = parent::GetCommentLines()
				. "trunk=" . $this->trunk . "\n"
				. "type=" . $this->type . "\n"
				. "timeslots=" . $this->timeslots . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "trunk")
					$this->trunk = $sValue;
				elseif ($sName === "type")
					$this->type = $sValue;
				elseif ($sName === "timeslots")
					$this->timeslots = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ILCASTrunksObj {
	public $arrILCASTrunks = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILCASTrunk = new ILCASTrunkObj();
		$this->arrILCASTrunks[] = $objILCASTrunk;
		$objILEmPhoneSet->index = count($this->arrILCASTrunks);
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILCASTrunk->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}
	
	
	public function GetByIndex($iIndex) {
		return $this->arrILCASTrunks[(int)$iIndex];
	}

	public function GetByID($emphone_id) {
		$i = 0;
		do {
			$obj_emphoneset = $this->GetByIndex($i++);
			if ($obj_emphoneset != null) {
				if ($obj_emphoneset->emphone_id === $emphone_id) {
					break;
				};
			};
		} while ($obj_emphoneset != null);
		return $obj_emphoneset;
	}	

	public function GetAsSections() {
		$sRes = "";
		foreach ($this->arrILCASTrunks as $eph_set) {
			$sRes .= "\n[cas]\n" . $eph_set->GetAsFullCfgString();
			foreach ($eph_set->emphone_channel as $emphone_channel)
				$sRes .= "\n[cas-channel]\n" . $emphone_channel->GetAsFullCfgString();
		}
		return $sRes;
	}
	
};
*/
/*
class ILEmPhoneChannelObj extends CustomSection {
	public $emphone_id;
	public $trunk;
	public $timeslot;
	public $called;
	public $called_desc;
	public $subscribe_to;
	public $enable;
	
	
	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			switch ($iFormat) {
				case 1:
					$props = get_object_vars($this);
					$name2 = str_replace(' ', '_', $sName);
					if (array_key_exists($sName, $props))
						$this->$sName = $sValue;
					elseif (array_key_exists($name2, $props))
						$this->$name2 = $sValue;
					else
						parent::AddUnknownLine($sTMP);
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "emphone_id=" . $this->emphone_id . "\n"
				. "trunk=" . $this->trunk . "\n"
				. "timeslot=" . $this->timeslot . "\n"
				. "called=" . $this->called . "\n"
				. "called_desc=" . $this->called_desc . "\n"
				. "subscribe_to=" . $this->subscribe_to . "\n"
				. "enable=" . $this->enable . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
	
};
*/




//****************************************************************************************************



// -------------------------------------------------------------------------------------------------------------------





//Redundancy
class ILhspObj extends CustomSection {
	public $service = "";
	public $board = "";
	public $channel = "";
	public $mode = "";
	public $host_id = "";

	public $group = "";
	public $priority = "";
	public $hello_time = "";
	public $hold_time = "";
	public $info_time = "";
	public $transport_type = "";
	public $transport_addr = "";
	public $transport = "";
	public $comment = "";
	
	public function GetAsFullCfgString() {
		
		$sRes = parent::GetCommentLines()
				. "service=" . $this->service . "\n"
				//. "board=" . $this->board . "\n"
				//. "channel=" . $this->channel . "\n"
				. "mode=" . $this->mode . "\n"
				. "host id=" . $this->host_id . "\n"
				. "group=" . $this->group . "\n"
				. "priority=" . $this->priority . "\n"
				. "hello time=" . $this->hello_time . "\n"
				. "hold time=" . $this->hold_time . "\n"
				. "info time=" . $this->info_time . "\n"
				//. "transport type=" . $this->transport_type . "\n"
				//. "transport addr=" . $this->transport_addr . "\n";
				. "comment=" . $this->comment . "\n"
				. "transport=" . $this->transport . "\n";
				//. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) { $iFormat = 0;  $sName = "";  $sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:

				//if ($sName === "service") $this->service = $sValue;
				//elseif ($sName === "board") $this->board = $sValue;
				//elseif ($sName === "channel") $this->channel = $sValue;

				if ($sName === "service") {
					$service_arr = explode(":", $sValue);
					$this->service = $service_arr[0];
					$this->board = $service_arr[1];
					$this->channel = $service_arr[2];
				}
				elseif ($sName === "mode") $this->mode = $sValue;
				elseif ($sName === "host id") $this->host_id = $sValue;
				elseif ($sName === "group") $this->group = $sValue;
				elseif ($sName === "priority") $this->priority = $sValue;
				elseif ($sName === "hello time") $this->hello_time = $sValue;
				elseif ($sName === "hold time") $this->hold_time = $sValue;
				elseif ($sName === "info time") $this->info_time = $sValue;
				elseif ($sName === "comment") $this->comment = $sValue;
				//elseif ($sName === "transport type") $this->transport_type = $sValue;
				//elseif ($sName === "transport addr") $this->transport_addr = $sValue;
				
				/*if ($sName === "transport") {
					$service_arr = explode(":", $sValue);
					$this->transport_type = trim($service_arr[0]);
					$this->transport_addr = trim($service_arr[1]);
					if(!empty($service_arr[2])) $this->transport_addr = $this->transport_addr.':'.trim($service_arr[2]);
				}*/
				if ($sName === "transport") {
					//$this->transport = explode(" ", $sValue);
					$this->transport = $sValue;
				}
				
				
				else parent::AddUnknownLine($sParamLine); 
				break;
			case 2: parent::AddCommentLine($sParamLine); break;
		};
	}
};

class ILhspsObj {
	public $arrILhsps = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILhsp = new ILhspObj();
		$this->arrILhsps[] = $objILhsp;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILhsp->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while (($objValue = $this->arrILhsps[$i++])) {
			$sRes = $sRes . "[hsp]\n" . $objValue->GetAsFullCfgString();
			if ($i < count($this->arrILhsps)) {
				$sRes = $sRes . "\n";
			};
		};
		return $sRes;
	}

};



# ######################################
class ControllerConfFile extends CustomConfFile {
	public $ILboards;
	public $ILsips;
	public $ILrtsps;
	public $ILctrlobj;
	public $ILsignallingpointobj;
	public $ILsyncronizerobj;
	public $ILtracesobj;
	public $ILH323groups;
	public $ILH323terminals;
	public $ILtrunks;
	public $ILlinksets;
	public $ILunknownSettings;
	public $ILTrunkType='E1 ';
	public $ILAKs;
	public $ILhsps;
	public $ILEmPhones;
	public $ILISDNTrunks;
	public $ILCASTrunks;
	public $ILToneTrunks;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->ILboards = new ILboardsObj();
		$this->ILsips = new ILsipsObj();
		$this->ILrtsps = new ILrtspsObj();
		$this->ILctrlobj = new ILctrl();
		$this->ILsignallingpointobj = new ILsignallingpoint();
		$this->ILsyncronizerobj = new ILsyncronizer();
		$this->ILtracesobj = new ILtraces();
		$this->ILH323groups = new ILH323groupsObj();
		$this->ILH323terminals = new ILH323terminalsObj();
		$this->ILtrunks = new ILtrunksObj();
		$this->ILlinksets = new ILlinksetsObj();
		$this->ILunknownSettings = array();
		$this->ILAKs = new ILAKsObj();
		$this->ILEmPhones = new ILEmPhonesObj();
		$this->ILhsps = new ILhspsObj();
		$this->ILISDNTrunks = new ILISDNTrunksObj();
		$this->ILCASTrunks = new ILCASTrunksObj();
		$this->ILToneTrunks = new ILToneTrunksObj();
		$this->DoReadSections();
	}

	function DoReadIsdn($Logics) {
		// print("DoReadIsdn !count!=".count($Logics)." Value[0]=".$Logics[0]."<br>\n");
		reset($Logics);
		$sTMP = current($Logics);
		while ($sTMP) {
			$isdnTMP = new ILisdnObj();
			$isdnTMP->AddAsSection($sTMP);
			$trunkTMP = $this->ILtrunks->GetByTrunkID($isdnTMP->IDTrunk);
			if ($trunkTMP != null) {
				$trunkTMP->LogicObj = $isdnTMP;
				$trunkTMP->LogicName = "isdn";
			};
			$sTMP = next($Logics);
		};
	}

	function DoReadCas($Logics) {
		// print("DoReadCas !count!=".count($Logics)." Value[0]=".$Logics[0]."<br>\n");
		reset($Logics);
		$sTMP = current($Logics);
		while ($sTMP) {
			$casTMP = new ILcasObj();
			$casTMP->AddAsSection($sTMP);
			$trunkTMP = $this->ILtrunks->GetByTrunkID($casTMP->IDTrunk);
			if ($trunkTMP != null) {
				$trunkTMP->LogicObj = $casTMP;
				$trunkTMP->LogicName = "cas";
			};
			$sTMP = next($Logics);
		};
	}
	
	function DoReadHdlc($Logics) {
		// print("DoReadHdlc !count!=".count($Logics)." Value[0]=".$Logics[0]."<br>\n");
		reset($Logics);
		$sTMP = current($Logics);
		while ($sTMP) {
			$hdlcTMP = new ILhdlcObj();
			$hdlcTMP->AddAsSection($sTMP);
			$trunkTMP = $this->ILtrunks->GetByTrunkID($hdlcTMP->IDTrunk);
			if ($trunkTMP != null) {
				$trunkTMP->LogicObj = $hdlcTMP;
				$trunkTMP->LogicName = "hdlc";
			};
			$sTMP = next($Logics);
		};
	}
	
	function DoReadSS7Links($cache) {
		reset($cache);
		$sTMP = current($cache);
		while ($sTMP) {
			$linkTMP = new ILlinkObj();
			$linkTMP->AddAsSection($sTMP);
			$linksetTMP = $this->ILlinksets->GetByID($linkTMP->linkset);
			if ($linksetTMP) {
				$linksetTMP->links[] = $linkTMP;
				$linkTMP->index = count($linksetTMP->links);
				$linkTMP->skey = sprintf("%d_%d", $linksetTMP->index, $linkTMP->index);

				$linkTMP->trunk_obj = $this->ILtrunks->GetByTrunkID($linkTMP->trunk);
				if ($linkTMP->trunk_obj) {
					$linkTMP->trunk_obj->ss7links[] = $linkTMP;
					$linkTMP->trunk_obj->LogicObj = null;
					$linkTMP->trunk_obj->LogicName = "ss7";
				};
			}
			$sTMP = next($cache);
		};
	}

	function DoReadSS7ISUPs($cache) {
		reset($cache);
		$sTMP = current($cache);
		while ($sTMP) {
			$isupTMP = new ILisupObj();
			$isupTMP->AddAsSection($sTMP);
			$linksetTMP = $this->ILlinksets->GetByDPC($isupTMP->dpc);
			if ($linksetTMP) {
				$linksetTMP->isups[] = $isupTMP;
				$isupTMP->index = count($linksetTMP->isups);
				$isupTMP->skey = sprintf("%d_%d", $linksetTMP->index, $isupTMP->index);

				$isupTMP->linkset = $linksetTMP->id;

				$isupTMP->trunk_obj = $this->ILtrunks->GetByTrunkID($isupTMP->trunk);
				if ($isupTMP->trunk_obj) {
					$isupTMP->trunk_obj->ss7isup = $isupTMP;
					$isupTMP->trunk_obj->LogicObj = null;
					$isupTMP->trunk_obj->LogicName = "ss7";
				};
			}
			$sTMP = next($cache);
		};
	}

	function DoReadAKChannels($cache) {
		reset($cache);
		$sTMP = current($cache);
		while ($sTMP) {
			$chTMP = new ILAKChannelObj();
			$chTMP->AddAsSection($sTMP);
			$aksetTMP = $this->ILAKs->GetByID($chTMP->ak_id);
			if ($aksetTMP) {
				$aksetTMP->channel[] = $chTMP;
				$chTMP->idx = count($aksetTMP->channel);
			}
			$sTMP = next($cache);
		};
	}

	
	function DoReadEmPhoneChannels($cache) {
		reset($cache);
		$sTMP = current($cache);
		while ($sTMP) {
			$chTMP = new ILEmPhoneChannelObj();
			$chTMP->AddAsSection($sTMP);
			$emphone_setTMP = $this->ILEmPhones->GetByID($chTMP->emphone_id);
			if ($emphone_setTMP) {
				$emphone_setTMP->emphone_channel[] = $chTMP;
				$chTMP->idx = count($emphone_setTMP->emphone_channel);
			}
			$sTMP = next($cache);
		};
	}

	function DoReadCASTrunkChannels($cache) {
		reset($cache);
		$sTMP = current($cache);
		while ($sTMP) {
			$chTMP = new ILCASTrunksChannelObj();
			$chTMP->AddAsSection($sTMP);
			//$castrunk_setTMP = $this->ILCASTrunks->GetByID($chTMP->emphone_id);
			$castrunk_setTMP = $this->ILCASTrunks->GetByID($chTMP->trunk);
			if ($castrunk_setTMP) {
				$castrunk_setTMP->cas_channel[] = $chTMP;
				$chTMP->idx = count($castrunk_setTMP->cas_channel);
			}
			$sTMP = next($cache);
		};
	}
	
	
	function DoTrunksValidate() {
		$i = 0;
		while (($trunkTMP = $this->ILtrunks->GetByIndex($i++)) != null) {
			$trunkTMP->BoardObj = $this->ILboards->GetByName($trunkTMP->board);
		};
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->ILunknownSettings[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$iPart = 0;
		$iPosAfter = 0;
		$bInSection = false;
		$sSectionValue = "";
		$sSectionValues = "";
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			$iPartBK = $iPart;
			// TODO: endless loop somewhere here if empty section encountered
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				//logmsg('DoReadNextSection: ' . sprintf('%s, %d, %d, posbk=%d', $sSectionValue, $iPart, $iPosAfter, $iPosAfterBK));
				if ($iPart === 0) {
					if (($iPosAfter !== 0) && ($iPartBK !== $iPart)/*empty section*/)
						parent::SetAtPos($iPosAfterBK);
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
					$iPartBK = $iPart;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$isdnLogicCash = array();
		$casLogicCash = array();
		$hdlcLogicCash = array();
		$ss7linkscache = array();
		$ss7isupscache = array();
		$akchannelcache = array();
		$aemphonechannelcache = array();
		$castrunkchannelcache = array();

		$sSectionName = "";
		$sSectionValues = "";
		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "board")
				$this->ILboards->AddAsSection($sSectionValues);
			elseif ($sSectionName === "SIP/PJ")
				$this->ILsips->AddAsSection($sSectionValues);
			elseif ($sSectionName === "RTSP/PJ")
				$this->ILrtsps->AddAsSection($sSectionValues);
			elseif ($sSectionName === "ctrl")
				$this->ILctrlobj->AddAsSection($sSectionValues);
			elseif ($sSectionName === "signalling point")
				$this->ILsignallingpointobj->AddAsSection($sSectionValues);
			elseif ($sSectionName === "synchronizer")
				$this->ILsyncronizerobj->AddAsSection($sSectionValues);
			elseif ($sSectionName === "traces")
				$this->ILtracesobj->AddAsSection($sSectionValues);
			elseif ($sSectionName === "H323")
				$this->ILH323groups->AddAsSection($sSectionValues);
			elseif ($sSectionName === "H323 terminal")
				$this->ILH323terminals->AddAsSection($sSectionValues);
			
			elseif ($sSectionName === "trunk")
				$this->ILtrunks->AddAsSection($sSectionValues);
			// while isdn logic supported only
			elseif ($sSectionName === "isdn"){
				//$isdnLogicCash[] = $sSectionValues;
				$this->ILISDNTrunks->AddAsSection($sSectionValues);
			}
			elseif ($sSectionName === "cas"){
				//$casLogicCash[] = $sSectionValues;
				$this->ILCASTrunks->AddAsSection($sSectionValues);
			}
			elseif ($sSectionName === "cas-channel")
				$castrunkchannelcache[] = $sSectionValues;
			
			elseif ($sSectionName === "hdlc")
				$hdlcLogicCash[] = $sSectionValues;
			// SS7
			elseif ($sSectionName === "linkset")
				$this->ILlinksets->AddAsSection($sSectionValues);
			elseif ($sSectionName === "link")
				$ss7linkscache[] = $sSectionValues;
			elseif ($sSectionName === "isup")
				$ss7isupscache[] = $sSectionValues;
			elseif ($sSectionName === "ak")
				$this->ILAKs->AddAsSection($sSectionValues);
			elseif ($sSectionName === "ak-channel")
				$akchannelcache[] = $sSectionValues;
			elseif ($sSectionName === "hsp")
				$this->ILhsps->AddAsSection($sSectionValues);
			elseif ($sSectionName === "emphone")
				$this->ILEmPhones->AddAsSection($sSectionValues);
			elseif ($sSectionName === "emphone-channel")
				$aemphonechannelcache[] = $sSectionValues;
			elseif ($sSectionName === "tone-channel"){
				$this->ILToneTrunks->AddAsSection($sSectionValues);
			}
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
		# process reading trunk dependences
		$this->DoReadIsdn($isdnLogicCash);
		$this->DoReadCas($casLogicCash);
		$this->DoReadHdlc($hdlcLogicCash);
		$this->DoReadSS7Links($ss7linkscache);
		$this->DoReadSS7ISUPs($ss7isupscache);
		$this->DoTrunksValidate();
		$this->DoReadAKChannels($akchannelcache);
		$this->DoReadEmPhoneChannels($aemphonechannelcache);
		$this->DoReadCASTrunkChannels($castrunkchannelcache);
		
	}
	function FixToFile()
	{
		$this->Clear();
		$this->PutIgnoreLine("Generated by Web Administration Processor for controller.conf\n");

		// Common
		$this->PutLine($this->ILctrlobj->GetAsSections());
		$this->PutLine($this->ILtracesobj->GetAsSections()); 		// Traces
		$this->PutLine($this->ILsignallingpointobj->GetAsSections());
		// Syncronizer
		$this->PutLine($this->ILsyncronizerobj->GetAsSections());
		// boards
		$this->PutLine($this->ILboards->GetAsSections());
		// SIP/PJ
		$this->PutLine($this->ILsips->GetAsSections());
		// RTSP/PJ
		$this->PutLine($this->ILrtsps->GetAsSections());
		// H323
		$this->PutLine($this->ILH323groups->GetAsSections());
		$this->PutLine($this->ILH323terminals->GetAsSections());

		// Trunks
		$this->PutLine($this->ILtrunks->GetAsSections());
		// ISDN Trunks
		$this->PutLine($this->ILISDNTrunks->GetAsSections());
		// CAS Trunks
		$this->PutLine($this->ILCASTrunks->GetAsSections());
		// Tone Trunks
		$this->PutLine($this->ILToneTrunks->GetAsSections());
//var_dump($this->ILISDNTrunks->GetAsSections());
//var_dump($this->ILCASTrunks->GetAsSections());
//var_dump($this->ILToneTrunks->GetAsSections());
//return;

		// Linksets
		$this->PutLine($this->ILlinksets->GetAsSections());
		// AKs
		$this->PutLine($this->ILAKs->GetAsSections());
		// EmPhones
		$this->PutLine($this->ILEmPhones->GetAsSections());
		// Redundancy
		$this->PutLine($this->ILhsps->GetAsSections());
		

		if (count($this->ILunknownSettings) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->ILunknownSettings);$i++) {
				$this->PutLine($this->ILunknownSettings[$i] . "\n");
			};
		};
	}
};
# ######################################
?>