<?php
function logmsg($str) {
	$pfFile = null;
	$sFileName = '/var/boa_debug_log';
	$pfFile = fopen($sFileName, "a");
	if ($pfFile != null) {
		flock($pfFile, LOCK_EX);
		fwrite($pfFile, date("d.m.Y H:i:s ") . $str . "\n");
		fflush($pfFile);
		flock($pfFile, LOCK_UN);
		fclose($pfFile);

		return true;
	}
	return false;
}

function logpost() {
	$pfFile = null;
	$sFileName = '/var/boa_post_log';
	$pfFile = fopen($sFileName, "a");
	if ($pfFile != null) {
		flock($pfFile, LOCK_EX);
		fwrite($pfFile, "\n" . date("d.m.Y H:i:s") . "\n" . var_export($_POST, true) . "\n");
		fflush($pfFile);
		flock($pfFile, LOCK_UN);
		fclose($pfFile);

		return true;
	}
	return false;
}

function bin2asc($binary) {
	$i = 0;
	while (strlen($binary) > 3) {
		$byte[$i] = substr($binary, 0, 8);
		$byte[$i] = base_convert($byte[$i], 2, 10);
		$byte[$i] = chr($byte[$i]);
		$binary = substr($binary, 8);
		$ascii = "$ascii$byte[$i]";
	}
	return $ascii;
}

function asc2bin($ascii) {
	while (strlen($ascii) > 0) {
		$byte = "";
		$i = 0;
		$byte = substr($ascii, 0, 1);
		while ($byte != chr($i)) {
			$i++;
		}
		$byte = base_convert($i, 10, 2);
		$byte = str_repeat("0", (8 - strlen($byte))) . $byte; # This is an endian (architexture) specific line, you may need to alter it.
		$ascii = substr($ascii, 1);
		$binary = "$binary$byte";
	}
	return $binary;
}

class CustomConfFile {
	private $pfFile = null;
	private $bOpen = false;
	private $sFileName = "";
	private $sIgnoreSeparator = "#!!-->";

	public function DoOpen($aFileName) {
		if ($this->bOpen) {
			fflush($this->pfFile);
			fclose($this->pfFile);
			$this->bOpen = false;
		};
		$this->pfFile = fopen($aFileName, "r+");
		if ($this->pfFile != null) {
			$this->sFileName = $aFileName;
			$this->bOpen = true;
		} else {
			printf("Filename='%s' open - FAIL (1)\n", $aFileName);
		};
		return $this->bOpen;
	}

	function DoClose() {
		if ($this->bOpen) {
			$this->bOpen = false;
			fflush($this->pfFile);
			fclose($this->pfFile);
			return true;
		} else {
			return false;
		};
	}

	function Clear() {
		if ($this->bOpen) {
			$this->bOpen = false;
			fflush($this->pfFile);
			fclose($this->pfFile);
			$this->pfFile = fopen($this->sFileName, "w");
			if ($this->pfFile) {
				fflush($this->pfFile);
				fclose($this->pfFile);
				$this->pfFile = fopen($this->sFileName, "r+");
				if ($this->pfFile) {
					$this->bOpen = true;
				};
			};
		}
		return $this->bOpen;
	}

	function PutLine($sLine) {
		if ($this->bOpen) {
			return (fputs($this->pfFile, $sLine . "\n") > 0);
		} else {
			return false;
		};
	}

	function PutIgnoreLine($sLine) {
		return $this->PutLine($this->sIgnoreSeparator . $sLine);
	}

	function PutStr($sStr) {
		if ($this->bOpen) {
			return (fputs($this->pfFile, $sStr) > 0);
		} else {
			return false;
		};
	}

	public function __construct($aFileName) {
		if ($aFileName)
			$this->DoOpen($aFileName);
	}

	public function getNextStr(&$sValue, &$iPart, &$iPosAfter) {
		// $iPart: 0 - section name; 1 - section line; 2 - comment
		if ($this->bOpen) {
			do {
				//logmsg('getNextStr: ' . 'sValue = '.$sValue . ', iPart = '.$iPart . ', iPosAfter = '.$iPosAfter);
				if (feof($this->pfFile)) {
					$sValue = "eof";
					return false;
				} else {
					$sValue = fgets($this->pfFile);
					if ($sValue) {
						$sValue = trim($sValue);
						$iLen = strlen($sValue);
						if (($iLen > 0) && (strpos($sValue, "#") === 0)) {
							$iPart = 2;
							$iPosAfter = ftell($this->pfFile);
							if (strpos($sValue, $this->sIgnoreSeparator) === 0)
								return $this->getNextStr($sValue, $iPart, $iPosAfter);
							else
								return true;
						} elseif (eregi('^[[]'.'(.*)'.'[]]$', $sValue, $regs)) {
								$iPart = 0;
								$sValue = $regs[1];
								$iPosAfter = ftell($this->pfFile);
								return true;
						} else {
							if ($iLen > 0) {
								$iPart = 1;
								$iPosAfter = ftell($this->pfFile);
								return true;
							};
						};
					} else {
						$sValue = "error fail";
						return false;
					};
				};
			} while (true);
		} else {
			$sValue = "no file";
			return false;
		};
		return false;
	}

	function __destruct() {
		if ($this->bOpen) {
			fflush($this->pfFile);
			fclose($this->pfFile);
		};
		$this->bOpen = false;
	}

	function SetAtFirst() {
		if ($this->bOpen) {
			return rewind($this->pfFile);
		} else {
			return false;
		};
	}

	function SetAtPos($iOffset) {
		if ($this->bOpen) {
			return fseek($this->pfFile, $iOffset, SEEK_SET) + 1;
		} else {
			return false;
		};
	}
};

class CustomSection {
	private $Unknowns = array();
	private $Comments = array();

	public function AddUnknownLine($sLine) {
		$this->Unknowns[] = $sLine;
	}

	public function AddCommentLine($sLine) {
		$this->Comments[] = $sLine;
	}

	public function GetUnknownLines() {
		reset($this->Unknowns);
		$sRetValue = "";
		while (list(, $sVal) = each($this->Unknowns)) {
			$sRetValue = $sRetValue . $sVal . "\n";
		};
		return $sRetValue;
	}

	public function SetUnknownLines($sLine) {
		// unset?
		$this->Unknowns = array();

		if ($sLine != "") {
			$tmpARR = explode("\n", trim($sLine));
			reset($tmpARR);
			$sTMP = current($tmpARR);
			$i = 0;
			while ($i++ < count($tmpARR)) {
				$this->AddUnknownLine($sTMP);
				$sTMP = next($tmpARR);
			};
		};
	}

	public function GetCommentLines() {
		reset($this->Comments);
		$sRetValue = "";
		while (list(, $sVal) = each($this->Comments)) {
			$sRetValue = $sRetValue . $sVal . "\n";
		};
		return $sRetValue;
	}

	public function SetCommentLines($sLine) {
		// unset?
		$this->Comments = array();

		if ($sLine != "") {
			$tmpARR = explode("\n", trim($sLine));
			reset($tmpARR);
			$sTMP = current($tmpARR);
			$i = 0;
			while ($i++ < count($tmpARR)) {
				$this->AddCommentLine($sTMP);
				$sTMP = next($tmpARR);
			};
		};
	}

	public function CheckValue($sLine, &$iFormat, &$sName, &$sValue) {
		// $iFormat: 0 - unformated; 1 - formated; 2 - comments
		$iFormat = 0;
		if (strpos($sLine, "#") === 0) {
			$iFormat = 2;
		} else {
			//list($sName, $sValue) = preg_split("[ ]*=[ ]*", $sLine);
			$sLine = ereg_replace("[ ]*=[ ]*", "=", $sLine);
			list($sName, $sValue) = explode("=", $sLine);
			if ($sName)
				$iFormat = 1;
		};
	}
};
?>
