<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("MODEMCONFWEBTEMPLATE", '/cgi-bin/options.webtemplate');

define("MODEM_PARAM_GUI_TYPE_CHECKBOX", 0);
define("MODEM_PARAM_GUI_TYPE_LONGEDIT", 1);
define("MODEM_PARAM_GUI_TYPE_SHORTEDIT", 2);

define("SEPARATOR_ADDITIONAL_OPTIONS", '#!!-->');

$ModemTypes = array(
	'aoptions' => array('description' => 'Analogous, originate (aoptions)',
						'file' => '/usr/local/etc/ppp/aoptions'),
	'coptions' => array('description' => 'Analogous, answer (coptions)',
						'file' => '/usr/local/etc/ppp/coptions'),
	'ioptions' => array('description' => 'Digital (ioptions)',
						'file' => '/usr/local/etc/ppp/ioptions')
);

# ######################################
class ModemOptions {
	private $configFile;
	private $templateFile = 'options.webtemplate';

	public $configItems = array();
	public $templateItems = array();
	public $configItemsAdditionalText = '';

	function __construct($templateFilename, $configFilename) {
		$this->configFile = $configFilename;
		$this->templateFile = $templateFilename;

		$this->parseConfig(true);
		$this->parseTemplate();
		$this->parseConfig(false);

		//logmsg(print_r($this->configItems, true));
		//logmsg(print_r($this->templateItems, true));
	}

	function __get($id) {
		return $this->configItems[$id];
	}

	function parseTemplate() {
		$this -> templateItems = array();
		$cmnt = '';
		$fh = fopen($this->templateFile, 'r');
		while (!feof($fh)) {
			$line = trim(fgets($fh));
			if ((strlen($line) > 0) && (strpos($line, '##') !== 0)) {
				if (strpos($line, '#') === 0) {
					$cmnt .= substr($line, 1);
				} else {
					$regs = explode(" ", $line, 2);
					$option = trim($regs[0]);
					$value = trim($regs[1]);
					$cmnt = str_replace(array("\r\n", "\n", "\r"), " ", trim($cmnt));
					if (eregi('\(default ([0-9]+)\)', $cmnt, $regs))
						$value_def = $regs[1];
					else
						$value_def = '';
					if (strlen($value) === 0)
						$type = MODEM_PARAM_GUI_TYPE_CHECKBOX;
					elseif (strpos($value, "\"") !== false)
						$type = MODEM_PARAM_GUI_TYPE_LONGEDIT;
					else
						$type = MODEM_PARAM_GUI_TYPE_SHORTEDIT;
					$value = ereg_replace("<[a-zA-Z]{1}>", "", $value);
					//$cmnt = str_replace('\\', '\\\\', $cmnt);
					//$value = str_replace('\\', '\\\\', $value);
					//$cmnt = addslashes($cmnt);
					//$value = addslashes($value);
					$active = $this->optionEnabled($option, $value);
					$this->templateItems[] = array("option"=>$option,
													"value"=>$value,
													"value_default"=>$value_def,
													"type"=>$type,
													"info"=>$cmnt,
													"enabled"=>$active);
					$cmnt = '';
				}
			}
		}
		fclose($fh);
	}

	function parseConfig($bKnownOptionsOnly) {
		if ($bKnownOptionsOnly)
			$this -> configItems = array();
		else
			$this -> configItemsAdditionalText = '';

		$bAdditionalsOnly = false;
		if (is_readable($this->configFile) && ($fh = fopen($this->configFile, 'r'))) {
			while (!feof($fh)) {
				$line = trim(fgets($fh));
				if (strlen($line) > 0) {
					if (!$bKnownOptionsOnly && (strpos($line, SEPARATOR_ADDITIONAL_OPTIONS) === 0))
						$bAdditionalsOnly = true;

					if (strpos($line, '#') !== 0) {
						if (!$bKnownOptionsOnly &&
								($bAdditionalsOnly || $this->optionUnknown($line)))
							$this->configItemsAdditionalText .= $line . "\n";
						elseif ($bKnownOptionsOnly) {
							$regs = explode(" ", $line, 2);
							$this->configItems[trim($regs[0])] = trim($regs[1]);
						}
					}
				}
			}
			fclose($fh);
		}
	}

	function saveConfig() {
		$fh = fopen($this->configFile /*. '.test'*/, 'w');
		foreach ($this->configItems as $option => $value)
			fwrite($fh, $option . " " .$value . "\n");
		if (strlen($this->configItemsAdditionalText) > 0) {
			fwrite($fh, "\n" . SEPARATOR_ADDITIONAL_OPTIONS . "additional options" . "\n");
			fwrite($fh, $this->configItemsAdditionalText . "\n");
		}
		fclose($fh);
	}

	function optionEnabled($optionname, &$optionvalue) {
		if ($res = array_key_exists($optionname, $this->configItems))
			$optionvalue = $this->configItems[$optionname];
		return $res;
	}

	function optionUnknown($optionline) {
		$regs = explode(" ", $optionline, 2);
		$option = trim($regs[0]);
		$value = trim($regs[1]);

		foreach ($this->templateItems as $obj)
			if ($obj['option'] == $option) {
				return false;
			}
		return true;
	}
}
# ######################################
?>
