/* DEFAULTS */
var arrAllCodecs = new Array(
	"G.711-Alaw",
	"G.711-Ulaw",
	"G.711-Alaw-mcc",
	"G.711-Ulaw-mcc",
	"G.723.1",
	"G.729",
	"G.729A",
	"G.729B",
	"G.729AB",
	"G.728"
);
/* /DEFAULTS */

/* checkboxes */
//global variables that can be used by ALL the function son this page.
var inputs;
var imgFalse = '/images/check_off.gif';
var imgTrue = '/images/check_on.gif';
var imgFalseD = '/images/check_offd.gif';
var imgTrueD = '/images/check_ond.gif';

function init() {
	replaceChecks();
}

function replaceChecks() {
	inputs = document.getElementsByTagName("input");
	for (var i = 0; i < inputs.length; i++) {
		if (inputs[i].getAttribute("type") == "checkbox") {
			var img = document.createElement("img");
			img.className = "imglink";
			img.style.verticalAlign = "middle";
			img.src = inputs[i].checked ? (inputs[i].disabled ? imgTrueD : imgTrue) : (inputs[i].disabled ? imgFalseD : imgFalse);
			img.id = "checkImage_" + inputs[i].id;
			img.onclick = new Function("checkChange('" + inputs[i].id + "')");
			inputs[i].parentNode.insertBefore(img, inputs[i]);
			inputs[i].style.display = "none";
		}
	}
}

//change the checkbox status and the replacement image
function checkChange(cb) {
	var cbo = document.getElementById(cb);
	var cbi;
	if (cbo && !cbo.disabled) {
		if (cbo.checked) {
			cbo.checked = '';
			cbo.value = 0;
			cbi = document.getElementById('checkImage_' + cb);
			if (cbi)
				cbi.src = imgFalse;
		} else {
			cbo.checked = 'checked';
			cbo.value = 1;
			cbi = document.getElementById('checkImage_' + cb);
			if (cbi)
				cbi.src = imgTrue;
		}
	}
	cbo.onchange();
}

function ToggleCheckBox(cb) {
	checkChange(cb);
	/*var cbo = document.getElementById(cb);
	 if (cbo) {
	 cbo.checked = !cbo.checked;
	 }*/
}
/* /checkboxes */

/* cookie management */
function setCookie(name, value) {
	var today = new Date();
	var expires = new Date();
	expires.setTime(today.getTime() + 1000 * 60 * 60 * 24 * 365);
	document.cookie = name + "=" + escape(value) + "; expires=" + expires.toGMTString();
}

function getCookie(Name) {
	var search = Name + "=";
	if (document.cookie.length > 0) {
		offset = document.cookie.indexOf(search);
		if (offset != -1) {
			offset += search.length;
			end = document.cookie.indexOf(";", offset);
			if (end == -1) end = document.cookie.length;
			return unescape(document.cookie.substring(offset, end));
		}
		else return('');
	}
	else return('');
}
/* /cookie management */

/* tab management */
var arrTabs = new Array(
	new Array("Hardware info", "/cgi-bin/Hrdinfo.cgi"),
	//new Array("Drivers & Startup", "/cgi-bin/Drv_startup.cgi"),
	new Array("System", "/cgi-bin/Drv_startup.cgi"),
	new Array("Configuration", "/cgi-bin/Controller.cgi"),
	new Array("Modems", "/cgi-bin/modems.cgi"),
	new Array("Routing", "/cgi-bin/Router.cgi"),
	new Array("Statistics", "/cgi-bin/stats.cgi"),
	new Array("Syslog", "/cgi-bin/syslog.cgi"),
	new Array("Logout", "/cgi-bin/Logout.cgi"),
	""
);

var activeTab = -1;//getCookie("activetab");
var searchTab = -1;
for (var i = 0; i < arrTabs.length; i++) {
	if (arrTabs[i][1] == document.location.pathname) {
		searchTab = i;
		break;
	}
}
if (searchTab != -1) {
	activeTab = searchTab;
} else {
	if ((activeTab < 0) || (activeTab >= arrTabs.length)) {
		activeTab = 0;
	}
}

function click_tab(tab, showonly) {
	var obj = document.getElementById("navmenu");
	var objs = obj.getElementsByTagName("DIV");
	for (var i = 0; i < objs.length; i++) {
		if (objs[i].id.indexOf("tab") > -1) {
			objs[i].className = "unselected-tab";
		}
	}
	activeTab = tab;
	obj = document.getElementById("tab" + tab);
	obj.className = "selected-tab";
	if (showonly == 0) {
		//setCookie("activetab", activeTab);
		top.location = arrTabs[activeTab][1];
	}
}
/* /tab management */

/* highlight */
var lastBC;
/*function L(TopicID) {
 lastBC = TopicID.style.backgroundColor;
 TopicID.style.backgroundColor = "#ddd";
 }
 function D(TopicID) {
 TopicID.style.backgroundColor = lastBC;
 }*/
function L(TopicID) {
	var obj = document.getElementById(TopicID);
	lastBC = obj.style.backgroundColor;
	obj.style.backgroundColor = "#ddd";
}
function D(TopicID) {
	var obj = document.getElementById(TopicID);
	obj.style.backgroundColor = lastBC;
}
/* /highlight */

/* encoding */
var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" +
	"abcdefghijklmnopqrstuvwxyz" +
	"0123456789+/=";
function encode64(inp) {
	var out = "";
	var chr1, chr2, chr3 = "";
	var enc1, enc2, enc3, enc4 = "";
	var i = 0;

	if (inp)
		do {
			chr1 = inp.charCodeAt(i++);
			chr2 = inp.charCodeAt(i++);
			chr3 = inp.charCodeAt(i++);
			enc1 = chr1 >> 2;
			enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
			enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
			enc4 = chr3 & 63;

			if (isNaN(chr2)) {
				enc3 = enc4 = 64;
			} else if (isNaN(chr3)) {
				enc4 = 64;
			}
			out = out + keyStr.charAt(enc1) + keyStr.charAt(enc2) + keyStr.charAt(enc3) +
				keyStr.charAt(enc4);
			chr1 = chr2 = chr3 = "";
			enc1 = enc2 = enc3 = enc4 = "";

		} while (i < inp.length);
	return out;
}
function decode64(inp) {
	var out = "";
	var chr1, chr2, chr3 = "";
	var enc1, enc2, enc3, enc4 = "";
	var i = 0;
	var base64test = /[^A-Za-z0-9\+\/\=]/g;

//	if (base64test.exec(inp)) {
//		alert("There were invalid base64 characters in the input text.\n" +
//		"Valid base64 characters are A-Z, a-z, 0-9, ?+?, ?/?, and ?=?\n" +
//		"Expect errors in decoding.");
//	}
	inp = inp.replace(/[^A-Za-z0-9\+\/\=]/g, "");

	if (inp)
		do {
			enc1 = keyStr.indexOf(inp.charAt(i++));
			enc2 = keyStr.indexOf(inp.charAt(i++));
			enc3 = keyStr.indexOf(inp.charAt(i++));
			enc4 = keyStr.indexOf(inp.charAt(i++));
			chr1 = (enc1 << 2) | (enc2 >> 4);
			chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
			chr3 = ((enc3 & 3) << 6) | enc4;
			out = out + String.fromCharCode(chr1);

			if (enc3 != 64) {
				out = out + String.fromCharCode(chr2);
			}
			if (enc4 != 64) {
				out = out + String.fromCharCode(chr3);
			}
			chr1 = chr2 = chr3 = "";
			enc1 = enc2 = enc3 = enc4 = "";

		} while (i < inp.length);
	return out;
}

function encode_base64(decStr) {
	decStr = escape(decStr);		//line add for chinese char
	var bits, dual, i = 0, encOut = '';
	while (decStr.length >= i + 3) {
		bits =
			(decStr.charCodeAt(i++) & 0xff) << 16 |
				(decStr.charCodeAt(i++) & 0xff) << 8 |
				decStr.charCodeAt(i++) & 0xff;
		encOut +=
			base64s.charAt((bits & 0x00fc0000) >> 18) +
				base64s.charAt((bits & 0x0003f000) >> 12) +
				base64s.charAt((bits & 0x00000fc0) >> 6) +
				base64s.charAt((bits & 0x0000003f));
	}
	if (decStr.length - i > 0 && decStr.length - i < 3) {
		dual = Boolean(decStr.length - i - 1);
		bits =
			((decStr.charCodeAt(i++) & 0xff) << 16) |
				(dual ? (decStr.charCodeAt(i) & 0xff) << 8 : 0);
		encOut +=
			base64s.charAt((bits & 0x00fc0000) >> 18) +
				base64s.charAt((bits & 0x0003f000) >> 12) +
				(dual ? base64s.charAt((bits & 0x00000fc0) >> 6) : '=') +
				'=';
	}
	return encOut
}

function decode_base64(encStr) {
	var bits, decOut = '', undecOut = '', i = 0;
	for (; i < encStr.length; i += 4) {
		bits =
			(base64s.indexOf(encStr.charAt(i)) & 0xff) << 18 |
				(base64s.indexOf(encStr.charAt(i + 1)) & 0xff) << 12 |
				(base64s.indexOf(encStr.charAt(i + 2)) & 0xff) << 6 |
				base64s.indexOf(encStr.charAt(i + 3)) & 0xff;
		decOut += String.fromCharCode(
			(bits & 0xff0000) >> 16, (bits & 0xff00) >> 8, bits & 0xff);
	}
	if (encStr.charCodeAt(i - 2) == 61)
		undecOut = decOut.substring(0, decOut.length - 2);
	else if (encStr.charCodeAt(i - 1) == 61)
		undecOut = decOut.substring(0, decOut.length - 1);
	else undecOut = decOut;

	return unescape(undecOut);		//line add for chinese char
}
/* /encoding */

/* gui controls */
function RebuildHiddenControls(list) {
	var obj_list = document.getElementById(list);
	var obj_list_sel = document.getElementById("ed" + list);
	if (obj_list && obj_list_sel) {
		var val = "";
		for (var i = 0; i < obj_list.length; i++) {
			if (obj_list.options[i].value != "") {
				if (val == "")
					val = obj_list.options[i].value;
				else
					val = val + " " + obj_list.options[i].value;
			} else {
				break;
			}
		}
		obj_list_sel.value = val;
	} else {
		//alert("DEBUG:"  + list + " not found!");
	}
}

function MoveListItem(side, list) {
	attribute1 = document.getElementById(list);//document.localrc.driver_selected;
	//fill an array with values to Up/Down
	var i;
	var temp1 = [];
	var current1 = 0;
	var tmpText;
	var tmpValue;
	var tmpClass;
	var attribute1;
	var option1;
	var option2;

	if (side == "up") {
		for (i = 0; i < attribute1.length; i++) {
			if (attribute1.options[i].selected) {
				temp1[current1++] = i;
				if (i > 0) {
					option1 = attribute1.options[i - 1];
					option2 = attribute1.options[i];
					tmpText = option1.text;
					tmpValue = option1.value;
					tmpClass = option1.className;
					option1.value = option2.value;
					option1.text = option2.text;
					option1.className = option2.className;
					option2.value = tmpValue;
					option2.text = tmpText;
					option2.className = tmpClass;
					attribute1.options[i].selected = false;
				} else {
					break;
				}
			}
		}
	} else {
		for (i = attribute1.length - 1; i >= 0; i--) {
			if (attribute1.options[i].selected) {
				temp1[current1++] = i;
				if (i < (attribute1.length - 1)) {
					option1 = attribute1.options[i];
					option2 = attribute1.options[i + 1];
					tmpText = option1.text;
					tmpValue = option1.value;
					tmpClass = option1.className;
					option1.value = option2.value;
					option1.text = option2.text;
					option1.className = option2.className;
					option2.value = tmpValue;
					option2.text = tmpText;
					option2.className = tmpClass;
					attribute1.options[i].selected = false;
				} else {
					//wall
					break;
				}
			}
		}
	}
	for (i = 0; i < current1; i++) {
		if (side == "up") {
			if (temp1[i] > 0) {
				attribute1.options[temp1[i] - 1].selected = true;
			} else {
				break;
			}
		} else {
			if (temp1[i] < (attribute1.length - 1)) {
				attribute1.options[temp1[i] + 1].selected = true;
			} else {
				break;
			}
		}
	}
	RebuildHiddenControls(list);
}
function ClearList(OptionList, TitleName) {
	OptionList.length = 0;
}

/*function move(side)
 {   var temp1 = new Array();
 var temp2 = new Array();
 var current1 = 0;
 var current2 = 0;
 var attribute;
 //assign what select attribute treat as attribute1 and attribute2
 if (side == "right")
 {  attribute1 = document.localrc.driver_name;
 attribute2 = document.localrc.driver_selected;
 }
 else
 {  attribute1 = document.localrc.driver_selected;
 attribute2 = document.localrc.driver_name;
 }
 //fill an array with old values
 for (var i = 0; i < attribute2.length; i++)
 {  temp1[current1++] = attribute2.options[i].value;
 }
 //assign new values to arrays
 for (var i = 0; i < attribute1.length; i++)
 {   if ( attribute1.options[i].selected )
 {  temp1[current1++] = attribute1.options[i].value;
 }
 else
 {  temp2[current2++] = attribute1.options[i].value;
 }
 }
 //generating new options
 for (var i = 0; i < temp1.length; i++)
 {
 attribute2.options[i] = new Option();
 attribute2.options[i].value = temp1[i];
 attribute2.options[i].text =  temp1[i];
 }
 //generating new options
 ClearList(attribute1,attribute1);
 if (temp2.length>0)
 {
 for (var i = 0; i < temp2.length; i++)
 {   attribute1.options[i] = new Option();
 attribute1.options[i].value = temp2[i];
 attribute1.options[i].text =  temp2[i];
 }
 }
 RebuildHiddenControls();
 }*/

function disableForm(theform) {
	if (document.all || document.getElementById) {
		for (var i = 0; i < theform.length; i++) {
			var tempobj = theform.elements[i];
			if (tempobj.type.toLowerCase() == "submit") {
				tempobj.focus();
				tempobj.disabled = true;
			}
		}
	}
	return true;
}

function checkform_drivers(theform) {
	var mcc_check = 2 * (theform.ed_mcc_ss7.value - 0) +
		(theform.ed_mcc_num_of_mcc_data.value - 0) +
		(theform.ed_mcc_num_of_mcc_trans.value - 0);
	if (mcc_check > 0 && mcc_check != 4 * 32) {
		alert('Number of channels mismatch!\n\n' + 'Valid condition: 2*mcc.SS7 + mcc.Voice + mcc.HDLC = 128\n');
		return false;
	} else
	if ((theform.ed_g711mcc_channels.value - 0) > 0 &&
		(theform.ed_mcc_num_of_mcc_trans.value - 0) < (theform.ed_g711mcc_channels.value - 0)) {
		alert('Number of channels mismatch!\n\n' + 'Valid condition: mcc.Voice >= g711mcc.Channels\n');
		return false;
	}
	return true;
}

function GetSelectedString(strparam, strval) {
	if (strparam == strval)
		return ' selected ';
	else
		return "";
}

function GetAltColor(num, ex, forceex) {
	var arrColors = new Array(
		"#e4e4e4",
		"#f5f5f5",
		"#cccccc",
		"#c0c0c0"
	);
	if (!ex)
		ex = 0;
	if (!forceex)
		forceex = false;

	if (forceex) {
		return arrColors[ex + 0]
	} else {
		if (num % 2 == 0)
			return arrColors[0 + (ex - 0)];//"#e4e4e4"; //even
		else
			return arrColors[1 + (ex - 0)];//"#f5f5f5"; //odd
	}
}

function AddTableCaption(table_body_obj, caption_content_text) {
	if (!table_body_obj)
		return false;

	var tr = document.createElement("tr");
	var td = document.createElement("td");
	td.colSpan = 2;
	td.className = "editTableHeader";
	td.innerHTML = caption_content_text;
	tr.appendChild(td);
	table_body_obj.appendChild(tr);

	return true;
}

function AddTableRow(table_body_obj, row_label_text, row_content_text, label_align_top) {
	if (!table_body_obj)
		return false;

	var tr = document.createElement("tr");
	var td = document.createElement("td");
	if (label_align_top != true)
		td.className = "editLineParam";
	else
		td.className = "editLineParamTop";
	td.innerHTML = row_label_text;
	tr.appendChild(td);
	td = document.createElement("td");
	td.className = "editLineValue";
	td.innerHTML = row_content_text;
	tr.appendChild(td);
	table_body_obj.appendChild(tr);

	return true;
}

function AddTableRow_Triple(table_body_obj, row_label_text, row_content_text, row_info_text, row_color, extended) {
	if (!table_body_obj)
		return false;

	var tr = document.createElement("tr");
	var td = document.createElement("td");
	//tr.className = "bgsel";
	td.className = "editLineParamTriple";
	td.innerHTML = row_label_text;
	tr.appendChild(td);
	if (!extended) {
		td = document.createElement("td");
		td.className = "editLineValueTriple";
		td.innerHTML = row_content_text;
		tr.appendChild(td);
		td = document.createElement("td");
		td.className = "editLineInfoTriple";
		td.innerHTML = row_info_text;
		tr.appendChild(td);
	} else {
		td = document.createElement("td");
		td.colSpan = 2;
		td.className = "editLineInfoTriple";
		td.innerHTML = row_content_text;
		tr.appendChild(td);
	}
	table_body_obj.appendChild(tr);

	tr.setAttribute("style", "background:" + row_color);
	tr.style.cssText = "background:" + row_color;

	tr.onMouseOver = "this.style.backgroundColor='#D3D3D3'";
	tr.onMouseOut = "this.style.backgroundColor='#F5F5F5'";

	return true;
}

function GetCodecOptionsString(enabled_codecs) {
	var res = "";
	var arrEC = enabled_codecs.split(" ");
	var i = 0;

	//make enabled items
	while (i < arrEC.length) {
		res += "<option value='" + arrEC[i] + "'>" + arrEC[i] + "</option>";
		i++;
	}

	//make 'disabled' separator
	res += "<option value='' class='optsep'>&#151;&#151;&#151;&nbsp;disabled&nbsp;&#151;&#151;&#151;</option>";

	//make disabled items
	i = 0;
	enabled_codecs = " " + enabled_codecs + " ";
	while (i < arrAllCodecs.length) {
		if (enabled_codecs.indexOf(" " + arrAllCodecs[i] + " ") == -1)
			res += "<option value='" + arrAllCodecs[i] + "' class='optsep'>" + arrAllCodecs[i] + "</option>";
		i++;
	}

	return res;
}

/* /gui controls */




/*------------------------------------------------------------------------------------
					Page section management:	(see Configuration, Routing)
--------------------------------------------------------------------------------------*/

// switch section visible mode
function doSectionSwitch(header,section){
	var headerobj = document.getElementById(header);
	if(headerobj.getAttribute('showmode')==1) {
		doSectionHide(header,section);
		setCookie(header, 0);
	} else {
		doSectionShow(header,section);
		setCookie(header, 1);
	}
}
// show section
function doSectionHide(header,section){
	var headerobj = document.getElementById(header);
	var obj = document.getElementById(section);
	headerobj.setAttribute('showmode','0'); 
	headerobj.setAttribute('src','/images/arrow_down.png');
	obj.style.display = 'none';
}
// hide section
function doSectionShow(header,section){
	var headerobj = document.getElementById(header);
	var obj = document.getElementById(section);
	headerobj.setAttribute('showmode','1');
	headerobj.setAttribute('src','/images/arrow_up.png');
	obj.style.display = '';
}
// hide switch button if list is empty (if count of blocks less than "cnt")
//	use: aTable.setAttribute("block_type", "sip");
function doSectionCountCheck(header,section,block_type,cnt){
	var obj = document.getElementById(header);
	var elems = document.querySelectorAll( 'table[block_type="'+block_type+'"]' );
	if(elems.length>cnt) {
		obj.style.display = "";
		doSectionShow(header,section);
	} else {
		obj.style.display = "none";
		doSectionHide(header,section);
	}
}


// stop event (for reload onclick)
function doClearClick(event){
		event = event || window.event; 
		event.stopPropagation ? event.stopPropagation() : (event.cancelBubble=true);
}
