<?php /*?>#!/bin/php<?php */?>
<html>
<head>
<?php include "/cgi-bin/common_htmlhead.inc" ?>
<script language="JavaScript" type="text/JavaScript" src="/controller.js"></script>
<title>Hardware :: Controller configuration</title>
</head>
<body>
<?php include("/cgi-bin/common_header.inc"); ?>
<!--<b class="pagetitle">Controller configuration</b>
<div id="nullt">&nbsp;</div><div style="clear: both"></div>-->
<form name="controllerconf" action="/cgi-bin/doapplycontroller.cgi" method="post" onSubmit="return checkform_controller(this);">
<?php
	include "/cgi-bin/conf_controls.inc";
	$controller_conf = new ControllerConfFile(CONTROLLERCONFFILE);
//var_dump($controller_conf->ILAKs);	
//var_dump($controller_conf->ILConsoles->arrConsoles);

	require_once(dirname(__FILE__).'/router_controls.inc');
	$router_conf = new RouterConfFile(ROUTERCONFFILE);


	// when board configuration first block is slot0 then show IL ip-address
	require_once(dirname(__FILE__).'/sh_controls.inc');
	require_once(dirname(__FILE__).'/hardinfofunc.inc');
	$frclocal2 = new IL_rc_local_ShellScriptFile(NETWORKCONFIGFILE,0);
	$IL_IP = htmlspecialchars("\"".$frclocal2->netparams[IPADDR]."\"");

	include "/cgi-bin/monitor_controls.inc";
	$controller_monitor = new ControllerMonitor();
	//echo "<br><br>";
	//var_dump($controller_monitor->monitor);
?>

<input name="hidChangeEvent" id="hidChangeEvent" type="hidden" value="0">


<?php

	// Trunk and timeslot information about Routing Connection ( from Routing page ) -------------
	reset($router_conf->connection->arrConnections);
	$obj = current($router_conf->connection->arrConnections);
	$trunklist = "";
	$timeslotlist = "";
	$trunklist_arr = array();
	$timeslotlist_arr = array();
	while ($obj) {
		array_push($trunklist_arr,$obj->cas_trunk_no);
		array_push($timeslotlist_arr,$obj->cas_trunk_timeslot);
		$obj = next($router_conf->connection->arrConnections);
	};
	$trunklist = implode(',', $trunklist_arr);
	$timeslotlist = implode(',', $timeslotlist_arr);
	printf("<input id=\"edRoutingConnection_Trunk\" type=\"hidden\" value=".$trunklist.">");
	printf("<input id=\"edRoutingConnection_Timeslot\" type=\"hidden\" value=".$timeslotlist.">");


	// Trunk and timeslot information about Recorder Pattern ( from Routing page ) ---------------
	reset($router_conf->ILRecorderPatterns->arrILRecorderPatterns);
	$obj=current($router_conf->ILRecorderPatterns->arrILRecorderPatterns);
	$trunklist = "";
	$timeslotlist = "";
	$trunklist_arr = array();
	$timeslotlist_arr = array();
	while ($obj) {
		array_push($trunklist_arr,$obj->trunk);
		array_push($timeslotlist_arr,$obj->timeslot);
		$obj=next($router_conf->ILRecorderPatterns->arrILRecorderPatterns);
	};
	$trunklist = implode(',', $trunklist_arr);
	$timeslotlist = implode(',', $timeslotlist_arr);
	printf("<input id=\"edRecorderPattern_Trunk\" type=\"hidden\" value=".$trunklist.">");
	printf("<input id=\"edRecorderPattern_Timeslot\" type=\"hidden\" value=".$timeslotlist.">");

?>

<div id="edSectionTrunkTimeslot"></div>




<!------------------------------------------------------------------------------------>
<!--								Main settings:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
	<table class="nb" cellpadding="0" cellspacing="0" width="90%">
	<caption onclick="doSectionSwitch('MainSettingContainerHeader','MainSettingContainer')">
	<div class="sec" style="display:inline;float:left">Main settings</div>
	<div style="width:100%;text-align:right;">
	<img id="MainSettingContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('MainSettingContainerHeader','MainSettingContainer')" src="/images/arrow_up.png">
	</div>
	</caption>
	<tr valign="top">
		<td id="MainSettingContainer">
			<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
				<tr>
				<td colspan="2" class="infoTableHeader" width="100px">&nbsp;Controls</td>
				</tr>
				<tr>
				<td class="editLineParam">Listening port</td>
				<td class="editLineValue">
				<input name="edControlPort" type="text" value="<?php print($controller_conf->ILctrlobj->Port) ?>" maxlength="5" size="5" class="selectw">
				</td>
				</tr>
				<tr>
				<td class="editLineParam">Disable bus</td>
				<td class="editLineValue">
				<input name="edControlDisableBus" id="edControlDisableBus" type="text" value="<?php print($controller_conf->ILctrlobj->disable_bus) ?>" maxlength="50" size="20" class="selectw170" oninput="checkDisabledBus();">
				</td>
				</tr>
			</table>
			<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
				<tr>
				<td colspan="2" class="infoTableHeader" width="100px">&nbsp;Traces</td>
				</tr>
				<tr>
				<td class="editLineParam">CCP</td>
				<td class="editLineValue">
				<select name="ssCCPLog" class="selectw">
					<?php
						if ($controller_conf->ILtracesobj->ccp==="enable") {
							printf("<option value=\"enable\" selected>enable</option>\n");
							printf("<option value=\"disable\">disable</option>\n");
						} else {
							printf("<option value=\"enable\">enable</option>\n");
							printf("<option value=\"disable\" selected>disable</option>\n");
						};
					?>
				</select>
				</td>

				<tr>
				<td class="editLineParam">SNMP Trap receivers</td>
				<td class="editLineValue">
				<input name="edsnmptraps" type="text" value="<?php print($controller_conf->ILtracesobj->snmptraps) ?>" maxlength="50" size="20" class="selectw170">
				</td>


				</tr>
			</table>
			<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
				<tr>
				<td colspan="2" class="infoTableHeader" width="200px">&nbsp;SS7 signalling point</td>
				</tr>
				<tr>
				<td class="editLineParam">OPC</td>
				<td class="editLineValue">
				<input name="ed_signallingpoint_opc" type="text"
					value="<?php print($controller_conf->ILsignallingpointobj->opc) ?>"
					maxlength="30" size="30" class="selectw300">
				</td>
				</tr>
				<tr>
				<td class="editLineParam">Network</td>
				<td class="editLineValue">
				<select name="ed_signallingpoint_network" class="selectw300">
					<?php
						/*
						 * Q.704
						 * The network indicator codes are allocated as follows:
						 * bits D C
						 * 		0 0 International network
						 * 		0 1 Spare (for international use only)
						 * 		1 0 National network
						 * 		1 1 Reserved for national use
						 */
						/*$signallingpoint_networks = array('international', 'reserved', 'federal', 'regional');
						foreach($signallingpoint_networks as $net) {
							printf("<option value=\"$net\"");
							if ($controller_conf->ILsignallingpointobj->network == $net)
								printf(" selected");
							printf(">$net</option>");
						}*/
						$signallingpoint_networks = array(
							'International network' => 'international',
							'Spare (for international use only)' => 'reserved',
							'National network' => 'federal',
							'Reserved for national use' => 'regional');
						foreach($signallingpoint_networks as $netname => $netid) {
							printf("<option value=\"$netid\"");
							if ($controller_conf->ILsignallingpointobj->network == $netid)
								printf(" selected");
							printf(">$netname</option>");
						}
					?>
				</select>
				</td>
				</tr>
				<tr>
				<td class="editLineParam">Trace</td>
				<td class="editLineValue">
				<input name="ed_signallingpoint_trace"
					type="text"
					value="<?php print($controller_conf->ILsignallingpointobj->trace); ?>"
					maxlength="30" size="30" class="selectw300">
				</td>
				</tr>
			</table>
			
			
			
			
			<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
				<tr>
				<td colspan="2" class="infoTableHeader" width="100px">&nbsp;Consoles</td>
				</tr>

				<tr>
				<td class="editLineParam">PS1</td>
				<td class="editLineValue">
				<input name="edps1" type="text" value="<?php print($controller_conf->ILConsoles->arrConsoles[0]->ps1) ?>" maxlength="50" size="20" class="selectw170">
				</td>
				</tr>

				<tr>
				<td class="editLineParam">Transport</td>
				<td class="editLineValue">
					
				<table class="editLineParam" name="edConsolesTransportTable" id="edConsolesTransportTable" style="padding: 0px;" >
				<tr><td>type</td><td>address</td></tr>
				</table>
				<table class="infoLineParam" style="padding: 0px;">
				<tr><td colspan=3 style="cursor:pointer; font-weight:bold; background:#ddd; padding-left: 10px;" onclick="addConsolesTransportRow();" title="Add new transport">+ Add</td></tr>
				</table>
				
				</td>
				</tr>
			</table>

			
			
			
			
		</td>
	</tr>
</table>
</div>

<?php
	reset($controller_conf->ILConsoles->arrConsoles);
	$obj=current($controller_conf->ILConsoles->arrConsoles);
	$arrtrans = explode(' ',trim($obj->transport));
	$trans = current($arrtrans);
	$script = "";
	while ($trans) {
		$param = explode(':',trim($trans));
		$script .= sprintf("addConsolesTransportRow('%s','%s');\n",
							$param[0],
							$param[1]
							);
		$trans=next($arrtrans);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf($script);
		printf("</script>\n");
	}
?>


<!------------------------------------------------------------------------------------>
<!--										Boards:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('BoardsContainerHeader','BoardsContainer')">
	<div class="sec" style="display:inline;float:left">Boards configuration&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); var hid = document.getElementById('hidBoardCount'); 
	if(hid.value==0) OnAddBoard(-1,null,<?php print($IL_IP) ?>,null,null); else OnAddBoard(-1,null,null,null,null);doSectionShow('BoardsContainerHeader','BoardsContainer');" title="Add board" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="BoardsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('BoardsContainerHeader','BoardsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="BoardsContainer">
		<input name="hidBoardCount" id="hidBoardCount" type="hidden" value="0<?php /*?><?php print(count($controller_conf->ILboards->arrILboards)) ?><?php */?>">
	</td>
</tr>
</table>
</div>
<?php
	reset($controller_conf->ILboards->arrILboards);
	$obj=current($controller_conf->ILboards->arrILboards);
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddBoard(%d,\"%s\",\"%s\",\"%s\",\"%s\");\n",
							-1,
							$obj->SlotName,
							$obj->HostIP,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj=next($controller_conf->ILboards->arrILboards);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>


<!------------------------------------------------------------------------------------>
<!--										SIP/PJ:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('SipsContainerHeader','SipsContainer')">
	<div class="sec" style="display:inline;float:left">SIP/PJ&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddSip();doSectionShow('SipsContainerHeader','SipsContainer');" title="Add SIP/PJ" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="SipsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('SipsContainerHeader','SipsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="SipsContainer">
		<input name="hidSipCount" id="hidSipCount" type="hidden" value="0<?php /*?><?php print(count($controller_conf->ILsips->arrILsips)) ?><?php */?>">
	</td>
</tr>
</table>
</div>
<?php
	reset($controller_conf->ILsips->arrILsips);
	$obj=current($controller_conf->ILsips->arrILsips);
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddSip(%d,'%s','%s','%s','%s','%s','%s','%s','%s','%s',".
		"'%s','%s','%s','%s','%s','%s','%s','%s','%s');\n",
							-1,
							$obj->group,
							addslashes(htmlspecialchars($obj->local_contact)),
							$obj->log_level,
							$obj->PJ_trace_level,
							$obj->ioqueue_trace_level,
							$obj->local_addr,
							$obj->udp_port,
							$obj->default_URI_scheme,
							$obj->dtmf_INFO_signal_coding,
							$obj->proxy,
							$obj->proxy_user_agent,
							$obj->proxy_username,
							$obj->proxy_password,
							$obj->proxy_realm,
							$obj->proxy_registration_expires,
							$obj->default_gateway,
							$obj->codecs_set,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj=next($controller_conf->ILsips->arrILsips);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>

<!------------------------------------------------------------------------------------>
<!--										RTSP/PJ:								-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('RtspsContainerHeader','RtspsContainer')">
	<div class="sec" style="display:inline;float:left">RTSP/PJ&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddRtsp();doSectionShow('RtspsContainerHeader','RtspsContainer');" title="Add RTSP/PJ" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="RtspsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('RtspsContainerHeader','RtspsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="RtspsContainer">
		<input name="hidRtspCount" id="hidRtspCount" type="hidden" value="0<?php /*?><?php print(count($controller_conf->ILsips->arrILsips)) ?><?php */?>">
	</td>
</tr>
</table>
</div>
<?php

	reset($controller_conf->ILrtsps->arrILrtsps);
	$obj=current($controller_conf->ILrtsps->arrILrtsps);
	//var_dump($obj); reset;
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddRtsp(%d,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s');\n",
							-1,
							$obj->group,
							$obj->log_level,
							$obj->rtsp_log_level,
							$obj->ioqueue_trace_level,
							$obj->local_addr,
							$obj->tcp_port,
							$obj->default_uri_scheme,
							$obj->rtsp_codecs,
							
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj=next($controller_conf->ILrtsps->arrILrtsps);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>



<!------------------------------------------------------------------------------------>
<!--										H323:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('H323ContainerHeader','H323Container')">
	<div class="sec" style="display:inline;float:left">H323 configuration&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddH323Group();doSectionShow('H323ContainerHeader','H323Container');" border="0" title="Add H323 group" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="H323ContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event);  doSectionSwitch('H323ContainerHeader','H323Container')" src="/images/arrow_up.png">
	</div>
</caption>
<tr>
	<td id="H323Container">
	<input name="hidH323GroupCount" id="hidH323GroupCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>

<?php
	//create h323 groups
	reset($controller_conf->ILH323groups->arrILH323groups);
	$obj=current($controller_conf->ILH323groups->arrILH323groups);
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddH323Group(%d,%d,%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\");\n",
							-1,
							$obj->group,
							$obj->terminal_type,
							$obj->compatibility,
							$obj->enable_H245_tunneling,
							$obj->enable_fast_start,
							$obj->codecs_set,
							$obj->gatekeeper,
							$obj->alias,
							$obj->disablet38,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj=next($controller_conf->ILH323groups->arrILH323groups);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>
<?php
	//create h323 terminals (each group fills automatically)
	reset($controller_conf->ILH323terminals->arrILH323terminals);
	$obj=current($controller_conf->ILH323terminals->arrILH323terminals);
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddH323Terminal(%d,%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\");\n",
							$obj->Group,
							-1,
							$obj->HostIP,
							$obj->codecs_set,
							$obj->disablet38,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj=next($controller_conf->ILH323terminals->arrILH323terminals);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>


<!------------------------------------------------------------------------------------>
<!--										Trunks:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('TrunkContainerHeader','TrunkContainer')">
	<div class="sec" style="display:inline;float:left"><?php print($controller_conf->ILTrunkType) ?>Trunks configuration&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddTrunk();doSectionShow('TrunkContainerHeader','TrunkContainer');" border="0" title="Add trunk" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="TrunkContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('TrunkContainerHeader','TrunkContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr>
	<td id="TrunkContainer" valign="top">
		<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
		<tr>
			<td colspan="2" class="editTableHeader">
				<div style="display:inline;float:left">&nbsp;Synchronizer&nbsp;</div>
			</td>
		</tr>
		<tr>
			<td class="editLineParam">
			Trunk sequence
			</td>
			<td class="editLineValue">
			<input name="edSynhcro" type="text" value="<?php print($controller_conf->ILsyncronizerobj->Sources) ?>" maxlength="5" class="selectw">
			</td>
		</tr>
		</table>
		<input name="hidTrunkCount" id="hidTrunkCount" type="hidden" value="0<?php /*?><?php print(count($controller_conf->ILtrunks->arrILtrunks)) ?><?php */?>">
	</td>
</tr>
</table>
</div>
<?php
	//create trunks
	reset($controller_conf->ILtrunks->arrILtrunks);
	$obj=current($controller_conf->ILtrunks->arrILtrunks);
	$script = "";
	while ($obj) {
		//var_dump($obj->LogicObj->Tslots);	
		if (($obj->LogicName == "isdn") && ($obj->LogicObj)) {
			$IsdnLogicComments = base64_encode($obj->LogicObj->GetCommentLines());
			$IsdnLogicUnknowns = base64_encode($obj->LogicObj->GetUnknownLines());
		} else {
			$IsdnLogicComments = "";
			$IsdnLogicUnknowns = "";
		};
		/*
		$script .= sprintf("OnAddTrunk(%d,%d,\"%s\",\"%s\",\"%s\",%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\");\n",
							-1,
							$obj->IDTrunk,
							$obj->board,
							$obj->dig_path,
							$obj->LogicName,
							$obj->LogicObj->GroupID,
							$obj->LogicObj->NetSide,
							$obj->GetLinksKey(),//$obj->ss7link->skey,
							$obj->ss7isup->skey,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines()),
							$IsdnLogicComments,
							$IsdnLogicUnknowns,
							$obj->LogicObj->CasType,
							$obj->LogicObj->Tslots,
							$obj->LogicObj->HdlcType,
							$obj->LogicObj->HdlcTimeslot,
							$obj->LogicObj->HdlcAddress
							);
		*/
		$script .= sprintf("OnAddTrunk(%d,%d,\"%s\",\"%s\",\"%s\",%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\");\n",
							-1,
							$obj->IDTrunk,
							$obj->board,
							$obj->dig_path,
							$obj->LogicName,
							$obj->LogicObj->GroupID,
							$obj->LogicObj->NetSide,
							$obj->GetLinksKey(),//$obj->ss7link->skey,
							$obj->ss7isup->skey,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines()),
							$IsdnLogicComments,
							$IsdnLogicUnknowns,
							$obj->LogicObj->CasType,
							$obj->LogicObj->Tslots,
							$obj->LogicObj->HdlcType
							);
		$obj=next($controller_conf->ILtrunks->arrILtrunks);
	};
	if ($script != "") {
		$script .= sprintf("UpdateBoardControls();\n");
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	};
?>


<!------------------------------------------------------------------------------------>
<!--								SS7 Linkset:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('LinksetContainerHeader','LinksetContainer')">
	<div class="sec" style="display:inline;float:left">SS7 configuration&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddLinkset();doSectionShow('LinksetContainerHeader','LinksetContainer');" border="0" title="Add linkset" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="LinksetContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('LinksetContainerHeader','LinksetContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<!-- tr><td></td></tr -->
<tr>
	<td id="LinksetContainer">
	<input name="hidLinksetCount" id="hidLinksetCount" type="hidden" value="0">
	</td>
</tr>
</table>
<!-- input name="hidLinksetCount" id="hidLinksetCount" type="hidden" value="0" -->
</div>

<?php
	//create SS7 Linkset
	reset($controller_conf->ILlinksets->arrILlinksets);
	$obj = current($controller_conf->ILlinksets->arrILlinksets);
	$script = '';
	while ($obj) {
		$script .= sprintf("OnAddLinkset(%d,\"%s\",%d,\"%s\",\"%s\");\n",
							-1,
							$obj->id,
							$obj->dpc,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		//links
		reset($obj->links);
		$obj_int = current($obj->links);
		while ($obj_int) {
			$script .= sprintf("OnAddLink(%d,\"%s\",%d,%d,%d,\"%s\",\"%s\",\"%s\");\n",
								-1,
								$obj_int->linkset,
								$obj_int->trunk,
								$obj_int->timeslot,
								$obj_int->slc,
								$obj_int->trace_id,
								base64_encode($obj_int->GetCommentLines()),
								base64_encode($obj_int->GetUnknownLines())
								);
			$obj_int = next($obj->links);
		}
		//isups
		reset($obj->isups);
		$obj_int = current($obj->isups);
		while ($obj_int) {
			$script .= sprintf("OnAddIsup(%d,\"%s\",%d,%d,\"%s\",%d,\"%s\",\"%s\");\n",
								-1,
								$obj_int->linkset,
								$obj_int->trunk,
								$obj_int->cic_base,
								$obj_int->timeslots,
								$obj_int->group,
								base64_encode($obj_int->GetCommentLines()),
								base64_encode($obj_int->GetUnknownLines())
								);
			$obj_int = next($obj->isups);
		}

		$obj = next($controller_conf->ILlinksets->arrILlinksets);
	};
	
	
	
	
	if ($script != "") {
		$script .= sprintf("UpdateSS7Controls();\n");
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>
<?php
//	print('<pre>');
//	print_r($controller_conf->ILlinksets);
//	print('</pre>');
?>
















<!------------------------------------------------------------------------------------>
<!--							Trunk -> ISDN Configuration:						-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('TrunkISDNContainerHeader','TrunkISDNContainer')">
	<div class="sec" style="display:inline;float:left">ISDN Configuration</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddTrunkISDN();doSectionShow('TrunkISDNContainerHeader','TrunkISDNContainer');" title="Add ISDN Trunk" src="/images/add.gif">
	<img class="imglink" style="display:inline;float:left;margin-top:2px;padding-left:4px;" onClick="doClearClick(event); OnAdd_ISDN_QSIG();doSectionShow('TrunkISDNContainerHeader','TrunkISDNContainer');" title="Add ISDN-QSIG" src="/images/add.gif">
	<img class="imglink" style="display:inline;float:left;margin-top:2px;padding-left:4px;" onClick="doClearClick(event); OnAdd_ISDN_ATS_QSIG();doSectionShow('TrunkISDNContainerHeader','TrunkISDNContainer');" title="Add ISDN-ATS-QSIG" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="TrunkISDNContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('TrunkISDNContainerHeader','TrunkISDNContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="TrunkISDNContainer">
		<table>
		<tr><td><input name="hidTrunkISDNCount" id="hidTrunkISDNCount" type="hidden" value="0"></td></tr>
		<tr><td><input name="hid_ISDN_QSIG_Count" id="hid_ISDN_QSIG_Count" type="hidden" value="0"></td></tr>
		<tr><td><input name="hid_ISDN_ATS_QSIG_Count" id="hid_ISDN_ATS_QSIG_Count" type="hidden" value="0"></td></tr>
		</table>
	</td>
</tr>
</table>
</div>

<?php

	reset($controller_conf->ILISDNTrunks->arrISDNTrunks);
	$obj=current($controller_conf->ILISDNTrunks->arrISDNTrunks);
	//var_dump($controller_conf->ILISDNTrunks->arrISDNTrunks);
	
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddTrunkISDN(%d,%d,'%s','%s','%s','%s','%s');\n",
							-1,
							$obj->trunk,
							$obj->group,
							$obj->side,
							$obj->timeslots,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj=next($controller_conf->ILISDNTrunks->arrISDNTrunks);
	};
	if ($script != "") {
		//$script .= sprintf("UpdateBoardControls_AKconfig();\n");
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}

	reset($controller_conf->IL_ISDN_QSIGs->arr_ISDN_QSIG);
	$obj=current($controller_conf->IL_ISDN_QSIGs->arr_ISDN_QSIG);
	//var_dump($controller_conf->IL_ISDN_QSIGs->arr_ISDN_QSIG);
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAdd_ISDN_QSIG(%d,%d,'%s','%s','%s','%s','%s');\n",
							-1,
							$obj->trunk,
							$obj->group,
							$obj->side,
							$obj->timeslots,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj=next($controller_conf->IL_ISDN_QSIGs->arr_ISDN_QSIG);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}

	reset($controller_conf->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG);
	$obj=current($controller_conf->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG);
	//var_dump($controller_conf->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG);
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAdd_ISDN_ATS_QSIG(%d,'%s','%s','%s',%d,'%s','%s','%s','%s','%s');\n",
							-1,
							$obj->transport,
							$obj->board,
							$obj->channel,
							$obj->trunk,
							$obj->timeslot,
							$obj->group,
							$obj->side,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj=next($controller_conf->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	
?>

<!------------------------------------------------------------------------------------>
<!--						    	Trunk -> CAS Configuration:						-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('TrunkCASContainerHeader','TrunkCASContainer')">
	<div class="sec" style="display:inline;float:left">CAS Configuration</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddTrunkCAS();doSectionShow('TrunkCASContainerHeader','TrunkCASContainer');" title="Add emergency phone" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="TrunkCASContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('TrunkCASContainerHeader','TrunkCASContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="TrunkCASContainer">
		<input name="hidTrunkCASCount" id="hidTrunkCASCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>

<?php

	//reset($controller_conf->ILEmPhones->arrILEmPhones);
	//$obj=current($controller_conf->ILEmPhones->arrILEmPhones);
	reset($controller_conf->ILCASTrunks->arrCASTrunks);
	$obj=current($controller_conf->ILCASTrunks->arrCASTrunks);
	//var_dump($obj);	return;
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddTrunkCAS(%d,%d,'%s','%s','%s','%s');\n",
							-1,
							$obj->trunk,
							$obj->type,
							$obj->timeslots,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		//cas_channel
		$trunk = $obj->trunk;
		reset($obj->cas_channel);
		$obj_int = current($obj->cas_channel);
		//var_dump($obj_int);
		while ($obj_int) {
			$script .= sprintf("OnAddTrunkCASChannel(%d,%d,'%s','%s','%s','%s');\n",
								-1,
								-1,
								$obj_int->trunk,
								$obj_int->timeslot,
								$obj_int->type,
								base64_encode($obj_int->GetCommentLines()),
								base64_encode($obj_int->GetUnknownLines())
								);
			$obj_int = next($obj->cas_channel);
		}
		
		//$script .= sprintf("alert(%d);",$trunk);
		
		$obj=next($controller_conf->ILCASTrunks->arrCASTrunks);
	};
//var_dump($script);
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	
?>

<!------------------------------------------------------------------------------------>
<!--							Trunk ->  Tone Signalling Configuration:			-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('TrunkToneContainerHeader','TrunkToneContainer')">
	<div class="sec" style="display:inline;float:left">Tone Signalling Configuration</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddTrunkTone();doSectionShow('TrunkToneContainerHeader','TrunkToneContainer');" title="Add Tone Trunk" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="TrunkToneContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('TrunkToneContainerHeader','TrunkToneContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="TrunkToneContainer">
		<input name="hidTrunkToneCount" id="hidTrunkToneCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>

<?php

	reset($controller_conf->ILToneTrunks->arrToneTrunks);
	$obj=current($controller_conf->ILToneTrunks->arrToneTrunks);
	
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddTrunkTone(%d,%d,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s');\n",
							-1,
							$obj->trunk,
							$obj->type,
							$obj->transport,
							$obj->timeslot,
							$obj->det_lvl_dB,
							$obj->gen_lvl_dB,
							$obj->rx_gain_dB,

							$obj->vad_voice_th_msec,
							$obj->vad_silence_th_msec,
							$obj->vad_e_th_dB,

							$obj->name,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj=next($controller_conf->ILToneTrunks->arrToneTrunks);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	
?>





























<!------------------------------------------------------------------------------------>
<!--										AK:										-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('AKContainerHeader','AKContainer')">
	<div class="sec" style="display:inline;float:left">AK configuration&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddAK();doSectionShow('AKContainerHeader','AKContainer');" title="Add analog set" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="AKContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('AKContainerHeader','AKContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="AKContainer">
		<input name="hidAKSetCount" id="hidAKSetCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>

<?php

	reset($controller_conf->ILAKs->arrILAKs);
	$obj=current($controller_conf->ILAKs->arrILAKs);
	//var_dump($obj);	return;
	$script = "";
	while ($obj) {
		//var_dump($obj); echo("<br><br>");
		$script .= sprintf("OnAddAK(%d,'%s','%s','%s','%s','%s','%s','%s','%s','%s');\n",
							-1,
							$obj->ak_id,
							$obj->Slot,
							$obj->Board,
							$obj->Group,
							$obj->EmV5Chs,
							$obj->FourWireChs,
							$obj->r2channels,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);

		//ak-channel
		reset($obj->channel);
		$obj_int = current($obj->channel);
		while ($obj_int) {
		//var_dump($obj_int);	echo "<br><br><br>";
			//$script .= sprintf("OnAddAKChannel(%d,'%s','%s',%d,\"%s\",%d,%d,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s');\n",
			//$script .= sprintf("OnAddAKChannel(%d,'%s','%s',%d,\"%s\",%d,%d,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s');\n",
			$script .= sprintf("OnAddAKChannel(%d,%d,'%s','%s','%s',%d,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s');\n",
								-1,
								$obj_int->ak_id,
								$obj_int->name,
								$obj_int->slot,
								$obj_int->board,
								$obj_int->id,
								$obj_int->group,
								addslashes(htmlspecialchars($obj_int->rx_gain_dB)),
								addslashes(htmlspecialchars($obj_int->rx_pregain_dB)),
								addslashes(htmlspecialchars($obj_int->tx_gain_dB)),
								addslashes(htmlspecialchars($obj_int->cid_det_dB)),
								//addslashes(htmlspecialchars($obj_int->cid_aisn)),
								addslashes(htmlspecialchars($obj_int->line_coeffs_set)),
								addslashes(htmlspecialchars($obj_int->cid_type)),
								addslashes(htmlspecialchars($obj_int->dtmf_sig_msec)),
								addslashes(htmlspecialchars($obj_int->dtmf_pause_msec)),
								addslashes(htmlspecialchars($obj_int->gen_gain_dB)),

								addslashes(htmlspecialchars($obj_int->ec_nlp)),
								addslashes(htmlspecialchars($obj_int->ec_lbgn)),

								addslashes(htmlspecialchars($obj_int->vad_lvl_dB)),
								addslashes(htmlspecialchars($obj_int->vad_timeout_sec)),
								addslashes(htmlspecialchars($obj_int->release_by_vad)),
								
								addslashes(htmlspecialchars($obj_int->wink_msec)),
								addslashes(htmlspecialchars($obj_int->default_cid)),

								base64_encode($obj_int->GetCommentLines()),
								base64_encode($obj_int->GetUnknownLines())
								);
			$obj_int = next($obj->channel);
		}
		
		$obj=next($controller_conf->ILAKs->arrILAKs);
	};
//var_dump($script);
	if ($script != "") {
		$script .= sprintf("UpdateBoardControls_AKconfig();\n");
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	
?>

<!------------------------------------------------------------------------------------>
<!--							Emergency Phone configuration:						-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('EmPhoneContainerHeader','EmPhoneContainer')">
	<div class="sec" style="display:inline;float:left">Emergency Phone configuration</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddEmPhone();doSectionShow('EmPhoneContainerHeader','EmPhoneContainer');" title="Add emergency phone" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="EmPhoneContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('EmPhoneContainerHeader','EmPhoneContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="EmPhoneContainer">
		<input name="hidEmPhoneSetCount" id="hidEmPhoneSetCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>

<?php

	reset($controller_conf->ILEmPhones->arrILEmPhones);
	$obj=current($controller_conf->ILEmPhones->arrILEmPhones);
	//var_dump($obj);	//return;
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddEmPhone(%d,%d,'%s','%s','%s','%s','%s','%s','%s','%s');\n",
							-1,
							$obj->emphone_id,
							$obj->trunk,
							$obj->callerId,
							$obj->name,
							$obj->missec,
							$obj->hdlc_timeslot,
							$obj->hdlc_address,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);

		//emphone_channel
		reset($obj->emphone_channel);
		$obj_int = current($obj->emphone_channel);
		while ($obj_int) {
			$script .= sprintf("OnAddEmPhoneChannel(%d,%d,'%s','%s','%s','%s','%s','%s','%s','%s');\n",
								-1,
								$obj_int->emphone_id,
								$obj_int->trunk,
								$obj_int->timeslot,
								$obj_int->called,
								$obj_int->called_desc,
								$obj_int->subscribe_to,
								$obj_int->enable,
								base64_encode($obj_int->GetCommentLines()),
								base64_encode($obj_int->GetUnknownLines())
								);
			$obj_int = next($obj->emphone_channel);
		}

		
		$obj=next($controller_conf->ILEmPhones->arrILEmPhones);
	};
//var_dump($script);
	if ($script != "") {
		$script .= sprintf("UpdateBoardControls_AKconfig();\n");
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	
?>



<!------------------------------------------------------------------------------------>
<!--									Redundancy:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('RedundancyContainerHeader','RedundancyContainer')">
	<div class="sec" style="display:inline;float:left">Redundancy&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddRedundancy();doSectionShow('RedundancyContainerHeader','RedundancyContainer');Redundancy_List();" title="Add Redundancy" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="RedundancyContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('RedundancyContainerHeader','RedundancyContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="RedundancyContainer">
		<input name="hidRedundancyCount" id="hidRedundancyCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php
	reset($controller_conf->ILhsps->arrILhsps);
	$obj=current($controller_conf->ILhsps->arrILhsps);
	//var_dump($obj);	
	$script = "";
	while ($obj) {

		$idx = trim($obj->service).':'.trim($obj->board).':'.trim($obj->channel);
		if( (trim($obj->board)=='') and (trim($obj->channel)=='') ) $idx = trim($obj->service);
		$redundancy = $controller_monitor->getRedundancyState($idx);
		//var_dump($redundancy);

		$script .= sprintf("OnAddRedundancy(%d,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s');\n",
							-1,
							$obj->service,
							$obj->board,
							$obj->channel,
							$obj->mode,
							$obj->host_id,

							$obj->group,
							$obj->priority,
							$obj->hello_time,
							$obj->hold_time,
							$obj->info_time,
							$obj->transport_type,
							$obj->transport_addr,

							$obj->transport,

							$obj->comment,

							$redundancy['shspDynamicPriority'],
							$redundancy['shspStateAsText'],

							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj=next($controller_conf->ILhsps->arrILhsps);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>


<div id="nullt">&nbsp;</div><div style="clear: both"></div>

<br><br><br><br><br><br><br><br><br><br><br><br>
<!-- div class="block-fixed">
<div class="block-fixed-footer">
<table class="nb">
<tr style="vertical-align:middle">
<td><input type="checkbox" name="cbApply" id="cbApply" value="1"></td>
<td><a class="imglink" onClick="ToggleCheckBox('cbApply')">Save changes and try to apply settings without restarting controller</a></td>
</tr>
<tr style="vertical-align:middle">
<td><input type="checkbox" name="cbSaveECcoeffs" id="cbSaveECcoeffs" value="1"></td>
<td><a class="imglink" onClick="ToggleCheckBox('cbSaveECcoeffs')">Save echocanceller coefficients and restart controller</a></td>
</tr>
<tr style="vertical-align:middle">
<td><input type="checkbox" name="cbRebootController" id="cbRebootController" value="1"></td>
<td><a class="imglink" onClick="ToggleCheckBox('cbRebootController')">Save changes and restart controller</a></td>
</tr>
<tr>
<td colspan="2" style="vertical-align:bottom"><input type="submit" class="inputbt" name="drvApply" value=" Save changes " onclick="onSaveClick();"></td>
</tr>
</table>
</div>
</div -->


<div class="block-fixed">
<div class="block-fixed-footer">
<table class="nb">

<tr style="vertical-align:middle">
<td><input type="checkbox" name="cbApply" id="cbApply" value="0" onchange="onCheckClick('cbApply');"></td>
<td><a class="imglink" id="acbApply" onClick="ToggleCheckBox('cbApply');">Save changes and try to apply settings without restarting controller</a></td>
</tr>
<tr style="vertical-align:middle">
<td><input type="checkbox" name="cbSaveECcoeffs" id="cbSaveECcoeffs" value="0" onchange="onCheckClick('cbSaveECcoeffs');"></td>
<td><a class="imglink" id="acbSaveECcoeffs" onClick="ToggleCheckBox('cbSaveECcoeffs');">Save echocanceller coefficients and restart controller</a></td>
</tr>

</table>



<div id="div_infoview"></div>



<!-- div id="OperInfoDiv" class="div_operinfo" style="display:none;">
<table id="OperInfoTab" class="nb, tab_operinfo">
</table>
</div -->

<table class="nb">

<tr style="vertical-align:middle">
<td colspan="2"><!-- input type="hidden" name="cbApply" id="cbApply" value="0" --></td>
</tr>
<tr style="vertical-align:middle">
<td colspan="2"><input type="hidden" name="cbRebootController" id="cbRebootController" value="0"></td>
</tr>

<tr>
<td colspan="1" style="vertical-align:bottom"><input type="submit" class="inputbt" name="drvApply" value=" Save " onclick="onPreSaveSetting(this); onSaveClick();"></td>
<td colspan="1" style="vertical-align:bottom"><input type="submit" class="inputbt" name="drvApplyRestart" value=" Save & Restart " onclick="onPreSaveSetting(this); onSaveClick();"></td>
</tr>

</table>
</div>
</div>









<script type="text/javascript">
doSectionCountCheck('BoardsContainerHeader','BoardsContainer','Board',0);
doSectionCountCheck('SipsContainerHeader','SipsContainer','SIP',0);
doSectionCountCheck('RtspsContainerHeader','RtspsContainer','RTSP',0);
doSectionCountCheck('H323ContainerHeader','H323Container','H323',0);
doSectionCountCheck('LinksetContainerHeader','LinksetContainer','Linkset',0);
doSectionCountCheck('AKContainerHeader','AKContainer','AK',0);
doSectionCountCheck('EmPhoneContainerHeader','EmPhoneContainer','EmPhone',0);
doSectionCountCheck('RedundancyContainerHeader','RedundancyContainer','hsp',0);
doSectionCountCheck('TrunkISDNContainerHeader','TrunkISDNContainer','TrunkISDN',0);
doSectionCountCheck('TrunkCASContainerHeader','TrunkCASContainer','TrunkCAS',0);
doSectionCountCheck('TrunkToneContainerHeader','TrunkToneContainer','TrunkTone',0);
Redundancy_List();

if(getCookie('MainSettingContainerHeader')!=1) doSectionHide('MainSettingContainerHeader','MainSettingContainer');
if(getCookie('BoardsContainerHeader')!=1) doSectionHide('BoardsContainerHeader','BoardsContainer');
if(getCookie('SipsContainerHeader')!=1) doSectionHide('SipsContainerHeader','SipsContainer');
if(getCookie('RtspsContainerHeader')!=1) doSectionHide('RtspsContainerHeader','RtspsContainer');
if(getCookie('H323ContainerHeader')!=1) doSectionHide('H323ContainerHeader','H323Container');
if(getCookie('TrunkContainerHeader')!=1) doSectionHide('TrunkContainerHeader','TrunkContainer');
if(getCookie('LinksetContainerHeader')!=1) doSectionHide('LinksetContainerHeader','LinksetContainer');
if(getCookie('AKContainerHeader')!=1) doSectionHide('AKContainerHeader','AKContainer');
if(getCookie('EmPhoneContainerHeader')!=1) doSectionHide('EmPhoneContainerHeader','EmPhoneContainer');
if(getCookie('RedundancyContainerHeader')!=1) doSectionHide('RedundancyContainerHeader','RedundancyContainer');
if(getCookie('TrunkISDNContainerHeader')!=1) doSectionHide('TrunkISDNContainerHeader','TrunkISDNContainer');
if(getCookie('TrunkCASContainerHeader')!=1) doSectionHide('TrunkCASContainerHeader','TrunkCASContainer');
if(getCookie('TrunkToneContainerHeader')!=1) doSectionHide('TrunkToneContainerHeader','TrunkToneContainer');

setCookie("eccoeffs", "");

</script>



		
</form>

<?php include("/cgi-bin/common_footer.inc"); ?>
</body>
</html>