#!/bin/php
<?php
function DoApplyControllerSettings() {
	include "/cgi-bin/conf_controls.inc";
	$conf_controller = new ControllerConfFile(CONTROLLERCONFFILE);

	// Control port
	if (isset($_POST['edControlPort']))
		$conf_controller->ILctrlobj->Port = $_POST['edControlPort'];
	if (isset($_POST['edControlDisableBus']))
		$conf_controller->ILctrlobj->disable_bus = $_POST['edControlDisableBus'];

	// Logging
	if (isset($_POST['ssCCPLog']))
		$conf_controller->ILtracesobj->ccp = $_POST['ssCCPLog'];
	if (isset($_POST['edsnmptraps']))
		$conf_controller->ILtracesobj->snmptraps = $_POST['edsnmptraps'];

	// ss7 signalling point
	$conf_controller->ILsignallingpointobj->opc = $_POST['ed_signallingpoint_opc'];
	$conf_controller->ILsignallingpointobj->network = $_POST['ed_signallingpoint_network'];
	$conf_controller->ILsignallingpointobj->trace = $_POST['ed_signallingpoint_trace'];

	// logpost();


	$objConsole = new ILConsoleObj();
	$objConsole->ps1 = $_POST['edps1'];
	$objConsole->transport = '';
	$i = 1;
	while( isset($_POST['con_transport_type_'.$i]) ){
		$objConsole->transport .= $_POST['con_transport_type_'.$i] . ':' . $_POST['con_transport_address_'.$i] . ' ';
		$i++;
	}
	$conf_controller->ILConsoles->arrConsoles[0] = $objConsole;


	// SIP/PJ
	$sValue = $_POST['hidSipCount'];
	if ($sValue != null) {
		$iValue = (int)$sValue;
		$conf_controller->ILsips->arrILsips = array();
		for ($i = 0;$i < $iValue;$i++) {
			$sKey = ((string)($i + 1));
			if ($_POST['edSipGroup' . $sKey] != null) {
				$objILsip = new ILsipObj();
				$objILsip->group = $_POST['edSipGroup' . $sKey];
				$objILsip->local_contact = stripslashes($_POST['edSipLocContact' . $sKey]);
				$objILsip->log_level = $_POST['edSipLogLevel' . $sKey];
				$objILsip->PJ_trace_level = $_POST['edSipPJTraceLevel' . $sKey];
				$objILsip->ioqueue_trace_level = $_POST['edSipIOqueueLevel' . $sKey];
				$objILsip->local_addr = $_POST['edSipLocalAddr' . $sKey];
				$objILsip->udp_port = $_POST['edSipUDPport' . $sKey];
				$objILsip->default_URI_scheme = $_POST['edSipDefURIscheme' . $sKey];
				$objILsip->dtmf_INFO_signal_coding = $_POST['ssSipDTMFinfo' . $sKey];
				$objILsip->proxy = $_POST['edProxy' . $sKey];
				$objILsip->proxy_user_agent = $_POST['edSipProxyUserAgent' . $sKey];
				$objILsip->proxy_username = $_POST['edSipProxyUserName' . $sKey];
				$objILsip->proxy_password = $_POST['edSipProxyPassword' . $sKey];
				$objILsip->proxy_realm = $_POST['edSipProxyRealm' . $sKey];
				$objILsip->proxy_registration_expires = $_POST['edSipProxyRegExpires' . $sKey];
				$objILsip->default_gateway = $_POST['edSipDefaultGateway' . $sKey];
				$objILsip->codecs_set = $_POST['edSipCodecs' . $sKey];

				$objILsip->SetCommentLines(base64_decode($_POST['edSipComments' . $sKey]));
				$objILsip->SetUnknownLines(base64_decode($_POST['edSipUnknowns' . $sKey]));

			$conf_controller->ILsips->arrILsips[] = $objILsip;
			}
		};
	};

	// RTSP/PJ
	$sValue = $_POST['hidRtspCount'];
	if ($sValue != null) {
		$iValue = (int)$sValue;
		$conf_controller->ILrtsps->arrILrtsps = array();
		for ($i = 0;$i < $iValue;$i++) {
			$sKey = ((string)($i + 1));
			if ($_POST['edRtspGroup' . $sKey] != null) {
				$objILrtsp = new ILrtspObj();
				$objILrtsp->group = $_POST['edRtspGroup' . $sKey];
				//$objILrtsp->local_uri = stripslashes($_POST['edRtspLocalURI' . $sKey]);
				$objILrtsp->log_level = $_POST['edRtspLogLevel' . $sKey];
				$objILrtsp->rtsp_log_level = $_POST['edRtspRTSPLogLevel' . $sKey];
				$objILrtsp->ioqueue_trace_level = $_POST['edRtspTraceLevel' . $sKey];
				$objILrtsp->local_addr = $_POST['edRtspLocalAddr' . $sKey];
				$objILrtsp->tcp_port = $_POST['edRtspTCPPort' . $sKey];
				$objILrtsp->default_uri_scheme = $_POST['edRtspDefaultURI' . $sKey];
				$objILrtsp->rtsp_codecs = $_POST['edRtspCodecs' . $sKey];

				$objILrtsp->SetCommentLines(base64_decode($_POST['edRtspComments' . $sKey]));
				$objILrtsp->SetUnknownLines(base64_decode($_POST['edRtspUnknowns' . $sKey]));

			$conf_controller->ILrtsps->arrILrtsps[] = $objILrtsp;
			}
		};
	};


	// H323
	$sH323GroupCount = $_POST['hidH323GroupCount'];
	if ($sH323GroupCount != null) {
		$cntH323GroupCount = (int)$sH323GroupCount;

		// H323 groups
		$conf_controller->ILH323groups->arrILH323groups = array();
		for ($idxGroup = 0; $idxGroup < $cntH323GroupCount; $idxGroup++) {
			$sKey = ((string)($idxGroup + 1));
			if ($_POST['edH323GroupID' . $sKey] != null) {
				$objILH323group = new ILH323group();
				$objILH323group->group = $_POST['edH323GroupID' . $sKey];
				$objILH323group->terminal_type = $_POST['edH323TermType' . $sKey];
				$objILH323group->compatibility = $_POST['ssH323Compatibility' . $sKey];
				$objILH323group->enable_H245_tunneling = $_POST['ssH245Tunneling' . $sKey];
				$objILH323group->enable_fast_start = $_POST['ssH323FastStart' . $sKey];
				$objILH323group->codecs_set = $_POST['edH323GroupCodecs' . $sKey];
				$objILH323group->alias = $_POST['edH323GKAlias' . $sKey];
				$objILH323group->gatekeeper = $_POST['edH323Gatekeeper' . $sKey];
				$objILH323group->disablet38 = $_POST['ssH323DisableT38' . $sKey];
				$objILH323group->SetCommentLines(base64_decode($_POST['edH323GroupComments' . $sKey]));
				$objILH323group->SetUnknownLines(base64_decode($_POST['edH323GroupUnknowns' . $sKey]));
				$conf_controller->ILH323groups->arrILH323groups[] = $objILH323group;
			};
		}

		// H323 terminals
		$conf_controller->ILH323terminals->arrILH323terminals = array();
		for ($idxGroup = 0; $idxGroup < $cntH323GroupCount; $idxGroup++) {
			$sH323TerminalCount = $_POST['hidH323TerminalCount' . ((string)($idxGroup + 1))];
			if ($sH323TerminalCount != null) {
				$cntH323TerminalCount = (int)$sH323TerminalCount;
				for ($idxTerm = 0; $idxTerm < $cntH323TerminalCount; $idxTerm++) {
					$sKey = '_' . ((string)($idxGroup + 1)) . '_' . ((string)($idxTerm + 1));
					if ($_POST['edH323TerminalIP' . $sKey] != null) {
						$objILH323terminal = new ILH323terminal();
						$objILH323terminal->HostIP = $_POST['edH323TerminalIP' . $sKey];
						$objILH323terminal->Group = $_POST['edH323GroupID' . ((string)($idxGroup + 1))]; //from groups!
						$objILH323terminal->codecs_set = $_POST['edH323TerminalCodecs' . $sKey];
						$objILH323terminal->disablet38 = $_POST['ssH323TerminalDisableT38' . $sKey];
						$objILH323terminal->SetCommentLines(base64_decode($_POST['edH323TerminalComments' . $sKey]));
						$objILH323terminal->SetUnknownLines(base64_decode($_POST['edH323TerminalUnknowns' . $sKey]));
						$conf_controller->ILH323terminals->arrILH323terminals[] = $objILH323terminal;
					};
				};
			};
		}
	}

	// Synchronizer
	$conf_controller->ILsyncronizerobj->Sources = $_POST['edSynhcro'];

	// Boards
	$sValue = $_POST['hidBoardCount'];
	if ($sValue != null) {
		$iValue = (int)$sValue;
		$conf_controller->ILboards->arrILboards = array();
		for ($i = 0;$i < $iValue;$i++) {
			$sKey = ((string)($i + 1));
			$sValue1 = $_POST['edBoardName' . $sKey];
			$sValue2 = $_POST['edBoardIP' . $sKey];
			if (($sValue1 != null) && ($sValue2 != null)) {
				$objILboard = new ILboardObj();
				$objILboard->SlotName = $sValue1;
				$objILboard->HostIP = $sValue2;
				$objILboard->SetCommentLines(base64_decode($_POST['edBoardComments' . $sKey]));
				$objILboard->SetUnknownLines(base64_decode($_POST['edBoardUnknowns' . $sKey]));
				$conf_controller->ILboards->arrILboards[] = $objILboard;
			};
		};
	};

	// Linksets, links and isups
	// TODO: Big badaboom
	$lscount = $_POST['hidLinksetCount'];
	if ($lscount != null) {
		$conf_controller->ILlinksets->arrILlinksets = array();
		$lscount = (int)$lscount;
		for ($idx_ls = 1; $idx_ls <= $lscount; $idx_ls++) {
			$lsKey = ((string)$idx_ls);
			if ($_POST['edLinksetID' . $lsKey] != null) {
				$linkset = new ILlinksetObj();
				$linkset->id = $_POST['edLinksetID' . $lsKey];
				$linkset->dpc = $_POST['edLinksetDPC' . $lsKey];
				$linkset->SetCommentLines(base64_decode($_POST['edLinksetComments' . $lsKey]));
				$linkset->SetUnknownLines(base64_decode($_POST['edLinksetUnknowns' . $lsKey]));
				$conf_controller->ILlinksets->arrILlinksets[] = $linkset;
				$linkset->index = count($conf_controller->ILlinksets->arrILlinksets);

				// links
				$icount = (int)$_POST['hidLinkCount' . $lsKey];
				for ($idx = 1; $idx <= $icount; $idx++) {
					$lKey = "_" . ((string)$idx_ls) . "_" . ((string)$idx);
					if ($_POST['edLinkTimeslot' . $lKey] != null) {
						$link = new ILlinkObj();
						$link->linkset = $linkset->id;
						$link->trunk = $_POST['edLinkTrunk' . $lKey];
						$link->timeslot = $_POST['edLinkTimeslot' . $lKey];
						$link->slc = $_POST['edLinkSLC' . $lKey];
						$link->trace_id = $_POST['edLinkTraceID' . $lKey];
						$link->SetCommentLines(base64_decode($_POST['edLinkComments' . $lKey]));
						$link->SetUnknownLines($_POST['edLinkUnknowns' . $lKey]);
						$linkset->links[] = $link;
						$link->index = count($linkset->links);
					}
				}
				// logmsg(print_r($linkset->links, true));

				// isups
				$icount = (int)$_POST['hidIsupCount' . $lsKey];
				for ($idx = 1; $idx <= $icount; $idx++) {
					$lKey = "_" . ((string)$idx_ls) . "_" . ((string)$idx);
					if ($_POST['edIsupCICBase' . $lKey] != null) {
						$isup = new ILisupObj();
						$isup->dpc = $linkset->dpc;
						$isup->trunk = $_POST['edIsupTrunk' . $lKey];
						$isup->cic_base = $_POST['edIsupCICBase' . $lKey];
						$isup->timeslots = $_POST['edIsupTimeslots' . $lKey];
						$isup->group = $_POST['edIsupGroup' . $lKey];
						$isup->SetCommentLines(base64_decode($_POST['edIsupComments' . $lKey]));
						$isup->SetUnknownLines($_POST['edIsupUnknowns' . $lKey]);
						$linkset->isups[] = $isup;
						$isup->index = count($linkset->isups);
					}
				}
				// logmsg(print_r($linkset->isups, true));
			};
		}
	}
	//logpost();

	// Trunks
	$iValue = $_POST['hidTrunkCount'];
	if ($iValue != null) {
		$conf_controller->ILtrunks->arrILtrunks = array();
		$iValue = (int)$iValue;
		for ($i = 1; $i <= $iValue; $i++) {
			$sKey = (string)$i;
			$sValue1 = $_POST['edTrunkID' . $sKey];
			$sValue2 = $_POST['edTrunkBoard' . $sKey];
			$sValue3 = $_POST['edTrunkDigitalPath' . $sKey];
			$sValue4 = $_POST['ssTrunkLogic' . $sKey];

			$sValue5 = $_POST['ssTrunkCasType' . $sKey];
			$sValue6 = $_POST['edTrunkTimeslots' . $sKey];
			$sValue7 = $_POST['ssTrunkHdlcType' . $sKey];
			//$sValue8 = $_POST['edTrunkHdlcTimeslot' . $sKey];
			//$sValue9 = $_POST['edTrunkHdlcAddress' . $sKey];
			

			if (($sValue1 != null) && ($sValue2 != null) && ($sValue3 != null) && ($sValue4 != null)) {
				$objILtrunk = new ILtrunkObj();
				$objILtrunk->IDTrunk = $sValue1;
				$objILtrunk->board = $sValue2;
				$objILtrunk->dig_path = $sValue3;
				$objILtrunk->LogicName = $sValue4;
				if ($objILtrunk->LogicName == "isdn") {/*
					$sValue2 = $_POST['edIsdnGroup' . $sKey];
					$sValue3 = $_POST['ssIsdnSide' . $sKey];
					if(empty($sValue6)) $sValue6 = "1..15,17..31";
					if (($sValue2 != null) && ($sValue3 != null)) {
						$objILtrunk->LogicObj = new ILisdnObj();
						$objILtrunk->LogicObj->LName = "isdn";
						$objILtrunk->LogicObj->IDTrunk = $sValue1;
						$objILtrunk->LogicObj->GroupID = $sValue2;
						$objILtrunk->LogicObj->NetSide = $sValue3;
						$objILtrunk->LogicObj->Tslots = $sValue6;
						$objILtrunk->LogicObj->SetCommentLines(base64_decode($_POST['edIsdnLogicComments' . $sKey]));
						$objILtrunk->LogicObj->SetUnknownLines(base64_decode($_POST['edIsdnLogicUnknowns' . $sKey]));
					} else {
						$objILtrunk->LogicName = "none";
					};*/
				} else

				if ($objILtrunk->LogicName == "cas") {/*
					$sValue2 = $_POST['ssTrunkCasType' . $sKey];
					if (($sValue2 != null)) {
						$objILtrunk->LogicObj = new ILcasObj();
						$objILtrunk->LogicObj->LName = "cas";
						$objILtrunk->LogicObj->IDTrunk = $sValue1;
						$objILtrunk->LogicObj->CasType = $sValue2;
						$objILtrunk->LogicObj->Tslots = $sValue6;
						$objILtrunk->LogicObj->SetCommentLines(base64_decode($_POST['edIsdnLogicComments' . $sKey]));
						$objILtrunk->LogicObj->SetUnknownLines(base64_decode($_POST['edIsdnLogicUnknowns' . $sKey]));
					} else {
						$objILtrunk->LogicName = "none";
					};*/
				} else

				if ($objILtrunk->LogicName == "ss7") {
					$objILtrunk->ss7links = $conf_controller->ILlinksets->GetLinksByKey($_POST['ssLinksSelected' . $sKey]);
					$objILtrunk->ss7isup = $conf_controller->ILlinksets->GetIsupByKey($_POST['ssIsup' . $sKey]);
					foreach ($objILtrunk->ss7links as $lnk)
						$lnk->trunk = $objILtrunk->IDTrunk;
					if ($objILtrunk->ss7isup)
						$objILtrunk->ss7isup->trunk = $objILtrunk->IDTrunk;
				} else
				
				if ($objILtrunk->LogicName == "hdlc") {
					if (($sValue7 != null)) {
						$objILtrunk->LogicObj = new ILhdlcObj();
						$objILtrunk->LogicObj->LName = "hdlc";
						$objILtrunk->LogicObj->IDTrunk = $sValue1;
						$objILtrunk->LogicObj->HdlcType = $sValue7;
						$objILtrunk->LogicObj->SetCommentLines(base64_decode($_POST['edIsdnLogicComments' . $sKey]));
						$objILtrunk->LogicObj->SetUnknownLines(base64_decode($_POST['edIsdnLogicUnknowns' . $sKey]));
						//$objILtrunk->LogicObj->HdlcTimeslot = $sValue8;
						//$objILtrunk->LogicObj->HdlcAddress = $sValue9;
					} else {
						$objILtrunk->LogicName = "none";
					};
				}
				
				$objILtrunk->SetCommentLines(base64_decode($_POST['edTrunkComments' . $sKey]));
				$objILtrunk->SetUnknownLines(base64_decode($_POST['edTrunkUnknowns' . $sKey]));
				$conf_controller->ILtrunks->arrILtrunks[] = $objILtrunk;
			};
		};
	};


	// ISDN Trunk
	$sValue = $_POST['hidTrunkISDNCount'];
	if ($sValue != null) {
		$iValue = (int)$sValue;
		$conf_controller->ILISDNTrunks->arrISDNTrunks = array();
		for ($i = 0;$i < $iValue;$i++) {
			$sKey = ((string)($i + 1));
			if ($_POST['edIsdnTrunk' . $sKey] != null) {
				$objILISDNTrunk = new ILISDNTrunkObj();
				$objILISDNTrunk->trunk = $_POST['edIsdnTrunk' . $sKey];
				$objILISDNTrunk->group = $_POST['edIsdnTrunkGroup' . $sKey];
				$objILISDNTrunk->side = $_POST['ssIsdnTrunkSide' . $sKey];
				$objILISDNTrunk->timeslots = $_POST['edIsdnTrunkTimeslots' . $sKey];
				//$objILISDNTrunk->SetCommentLines(base64_decode($_POST['edSipComments' . $sKey]));
				//$objILISDNTrunk->SetUnknownLines(base64_decode($_POST['edSipUnknowns' . $sKey]));
				$conf_controller->ILISDNTrunks->arrISDNTrunks[] = $objILISDNTrunk;
			}
		};
	};
	//($conf_controller->ILISDNTrunks);return;

	// ISDN_QSIG
	$sValue = $_POST['hid_ISDN_QSIG_Count'];
	if ($sValue != null) {
		$iValue = (int)$sValue;
		$conf_controller->IL_ISDN_QSIGs->arr_ISDN_QSIG = array();
		for ($i = 0;$i < $iValue;$i++) {
			$sKey = ((string)($i + 1));
			if ($_POST['ed_ISDN_QSIG' . $sKey] != null) {
				$objIL_ISDN_QSIG = new IL_ISDN_QSIG_Obj();
				$objIL_ISDN_QSIG->trunk = $_POST['ed_ISDN_QSIG' . $sKey];
				$objIL_ISDN_QSIG->group = $_POST['ed_ISDN_QSIG_Group' . $sKey];
				$objIL_ISDN_QSIG->side = $_POST['ss_ISDN_QSIG_Side' . $sKey];
				$objIL_ISDN_QSIG->timeslots = $_POST['ed_ISDN_QSIG_Timeslots' . $sKey];
				//$objIL_ISDN_QSIG->SetCommentLines(base64_decode($_POST['edSipComments' . $sKey]));
				//$objIL_ISDN_QSIG->SetUnknownLines(base64_decode($_POST['edSipUnknowns' . $sKey]));
				$conf_controller->IL_ISDN_QSIGs->arr_ISDN_QSIG[] = $objIL_ISDN_QSIG;
			}
		};
	};
	//var_dump($conf_controller->IL_ISDN_QSIGs);return;

	// ISDN_ATS_QSIG
	$sValue = $_POST['hid_ISDN_ATS_QSIG_Count'];
	//var_dump($sValue);
	if ($sValue != null) {
		$iValue = (int)$sValue;
		$conf_controller->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG = array();
		for ($i = 0;$i < $iValue;$i++) {
			$sKey = ((string)($i + 1));
			//if ($_POST['ed_ISDN_ATS_QSIG' . $sKey] != null) {
				
			if ($_POST['ed_ISDN_ATS_QSIG'.$sKey] != null || $_POST['ed_ISDN_ATS_QSIG_Transport'.$sKey] == 'E0') {
				$objIL_ISDN_ATS_QSIG = new IL_ISDN_ATS_QSIG_Obj();
				$objIL_ISDN_ATS_QSIG->transport = $_POST['ed_ISDN_ATS_QSIG_Transport' . $sKey];
				$objIL_ISDN_ATS_QSIG->board = $_POST['ed_ISDN_ATS_QSIG_Board' . $sKey];
				$objIL_ISDN_ATS_QSIG->channel = $_POST['ed_ISDN_ATS_QSIG_Channel' . $sKey];
				$objIL_ISDN_ATS_QSIG->trunk = $_POST['ed_ISDN_ATS_QSIG' . $sKey];
				$objIL_ISDN_ATS_QSIG->timeslot = $_POST['ed_ISDN_ATS_QSIG_Timeslot' . $sKey];
				$objIL_ISDN_ATS_QSIG->group = $_POST['ed_ISDN_ATS_QSIG_Group' . $sKey];
				$objIL_ISDN_ATS_QSIG->side = $_POST['ss_ISDN_ATS_QSIG_Side' . $sKey];
				//$objIL_ISDN_ATS_QSIG->SetCommentLines(base64_decode($_POST['edSipComments' . $sKey]));
				//$objIL_ISDN_ATS_QSIG->SetUnknownLines(base64_decode($_POST['edSipUnknowns' . $sKey]));
				$conf_controller->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG[] = $objIL_ISDN_ATS_QSIG;
			}
			
		};
	};
	//var_dump($conf_controller->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG);return;
	//var_dump($objIL_ISDN_ATS_QSIG);return;



	// CAS Trunk
	$sValue = $_POST['hidTrunkCASCount'];
	//var_dump($sValue);return;
	if ($sValue != null) {
		$iValue = (int)$sValue;
		$conf_controller->ILCASTrunks->arrCASTrunks = array();
		$emphone_id = 0;
		for ($i = 0;$i < $iValue;$i++) {
			$sKey = ((string)($i + 1));
			$trunk = $_POST['edCasTrunk' . $sKey];
			//var_dump($trunk);return;
			if ($trunk != null) {
				$emphone_id++;
				$objILCASTrunkObj = new ILCASTrunkObj();
				$objILCASTrunkObj->trunk = $_POST['edCasTrunk' . $sKey];
				$objILCASTrunkObj->type = $_POST['ssCASTrunk_type' . $sKey];
				$objILCASTrunkObj->timeslots = $_POST['edCASTrunk_timeslot' . $sKey];
				//var_dump($objILCASTrunkObj);return;
				$conf_controller->ILCASTrunks->arrCASTrunks[] = $objILCASTrunkObj;
				//var_dump($conf_controller->ILCASTrunks->arrCASTrunks);return;
				$objILCASTrunkObj->index = count($conf_controller->ILCASTrunksObj->arrCASTrunks);

				$ch_count = (int)$_POST['hidTrunkCASChannelCount' . $sKey];
				//var_dump($ch_count);return;
				for ($idx = 1; $idx <= $ch_count; $idx++) {
					$lKey = "_" . ((string)($i + 1)) . "_" . ((string)$idx);
					//var_dump($_POST['edTrunkCASChanneltrunk' . $lKey]);return;
					//if ($_POST['edTrunkCASChanneltrunk' . $lKey] != null) {
						$castrunk_channel = new ILCASTrunksChannelObj();
						
						$castrunk_channel->trunk = $_POST['edTrunkCASChanneltrunk' . $lKey];
						//$castrunk_channel->trunk = $_POST['edCasTrunk' . ((string)($i + 1))];
						
						$castrunk_channel->timeslot = $_POST['edTrunkCASChanneltimeslot' . $lKey];
						$castrunk_channel->type = $_POST['ssTrunkCASChanneltype' . $lKey];

						//$castrunk_channel->SetCommentLines(base64_decode($_POST['edEmPhoneChannelComments' . $lKey]));
						//$castrunk_channel->SetUnknownLines($_POST['edEmPhoneChannelUnknowns' . $lKey]);
						$objILCASTrunkObj->cas_channel[] = $castrunk_channel;
					//}
				}

			};
		};
		//var_dump($conf_controller->ILCASTrunks);return;
	};
	
	// Tone Trunk
	$sValue = $_POST['hidTrunkToneCount'];
	if ($sValue != null) {
		$iValue = (int)$sValue;
		$conf_controller->ILToneTrunks->arrToneTrunks = array();
		for ($i = 0;$i < $iValue;$i++) {
			$sKey = ((string)($i + 1));
			if ($_POST['edToneTrunk' . $sKey] != null) {
				$objILToneTrunk = new ILToneTrunkObj();
				$objILToneTrunk->trunk = $_POST['edToneTrunk' . $sKey];
				$objILToneTrunk->type = $_POST['ssToneTrunkType' . $sKey];
				$objILToneTrunk->transport = $_POST['ssToneTrunkTransport' . $sKey];
				$objILToneTrunk->timeslot = $_POST['ssToneTrunkTimeslot' . $sKey];

				$objILToneTrunk->det_lvl_dB = $_POST['ssToneDetectorLevel' . $sKey];
				$objILToneTrunk->gen_lvl_dB = $_POST['ssToneGeneratorLevel' . $sKey];
				$objILToneTrunk->rx_gain_dB = $_POST['ssToneRxGainLevel' . $sKey];

				$objILToneTrunk->vad_voice_th_msec = $_POST['edTone_vad_voice_th_msec' . $sKey];
				$objILToneTrunk->vad_silence_th_msec = $_POST['edTone_vad_silence_th_msec' . $sKey];
				$objILToneTrunk->vad_e_th_dB = $_POST['edTone_vad_e_th_dB' . $sKey];

				$objILToneTrunk->name = $_POST['edToneTrunkName' . $sKey];
				//$objILToneTrunk->SetCommentLines(base64_decode($_POST['edSipComments' . $sKey]));
				//$objILToneTrunk->SetUnknownLines(base64_decode($_POST['edSipUnknowns' . $sKey]));
				$conf_controller->ILToneTrunks->arrToneTrunks[] = $objILToneTrunk;
			}
		};
	};
	

	// AKs
/*	$sValue = $_POST['hidAKCount'];
	if ($sValue != null) {
		$iValue = (int)$sValue;
		$conf_controller->ILAKs->arrILAKs = array();
		for ($i = 0;$i < $iValue;$i++) {
			$sKey = ((string)($i + 1));
			$sSlot = $_POST['edAKSlot' . $sKey];
			if ($sSlot != null) {
				$objILAK = new ILAKObj();
				$objILAK->Slot = $sSlot;
				//$objILAK->Board = $_POST['edAKBoard' . $sKey];
				$objILAK->Board = $_POST['edAK' . $sKey];
				$objILAK->Group = $_POST['edAKGroup' . $sKey];
				$objILAK->EmV5Chs = $_POST['edAKEmV5Chs' . $sKey];
				$objILAK->FourWireChs = $_POST['edAK4WireChs' . $sKey];
				$objILAK->SetCommentLines(base64_decode($_POST['edAKComments' . $sKey]));
				$objILAK->SetUnknownLines(base64_decode($_POST['edAKUnknowns' . $sKey]));
				$conf_controller->ILAKs->arrILAKs[] = $objILAK;
			};
		};
	};*/
	$sValue = $_POST['hidAKSetCount'];
	if ($sValue != null) {
		$iValue = (int)$sValue;
		$conf_controller->ILAKs->arrILAKs = array();
		$ak_id = 0;
		for ($i = 0;$i < $iValue;$i++) {
			$sKey = ((string)($i + 1));
			$sSlot = $_POST['edAKSlot' . $sKey];
			if ($sSlot != null) {
				$ak_id++;
				$objILAK = new ILAKObj();
				//$objILAK->ak_id = $sKey;
				$objILAK->ak_id = $ak_id;
				$objILAK->Slot = $sSlot;
				$objILAK->Board = $_POST['edAK' . $sKey];
				$objILAK->Group = $_POST['edAKGroup' . $sKey];
				$objILAK->EmV5Chs = $_POST['edAKEmV5Chs' . $sKey];
				$objILAK->FourWireChs = $_POST['edAK4WireChs' . $sKey];
				$objILAK->r2channels = $_POST['edAKr2Chs' . $sKey];
				$objILAK->SetCommentLines(base64_decode($_POST['edAKComments' . $sKey]));
				$objILAK->SetUnknownLines(base64_decode($_POST['edAKUnknowns' . $sKey]));
				$conf_controller->ILAKs->arrILAKs[] = $objILAK;
				$objILAK->index = count($conf_controller->ILAKs->arrILAKs);


				$ch_count = (int)$_POST['hidAKChannelCount' . $sKey];
				for ($idx = 1; $idx <= $ch_count; $idx++) {
					$lKey = "_" . ((string)($i + 1)) . "_" . ((string)$idx);
					if ($_POST['edAKChannelslot' . $lKey] != null) {
						$channel = new ILAKChannelObj();
						$channel->ak_id = $objILAK->ak_id;
						$channel->name = $_POST['edAKChannelname' . $lKey];
						$channel->slot = $_POST['edAKChannelslot' . $lKey];
						$channel->board = $_POST['edAKChannelboard' . $lKey];
						$channel->group = $_POST['edAKChannelgroup' . $lKey];
						$channel->id = $_POST['edAKChannelID' . $lKey];
						$channel->rx_gain_dB = $_POST['edAKChannel_rx_gain' . $lKey];
						$channel->rx_pregain_dB = $_POST['edAKChannel_rx_pregain' . $lKey];
						$channel->tx_gain_dB = $_POST['edAKChannel_tx_gain' . $lKey];
						$channel->cid_det_dB = $_POST['edAKChannel_cid_det' . $lKey];
						//$channel->cid_aisn = $_POST['edAKChannel_cid_aisn' . $lKey];
						
						$cid_type_id = "";
						if($_POST['edAKChannel_cid_type' . $lKey]=="none") $cid_type_id = "0";
						if($_POST['edAKChannel_cid_type' . $lKey]=="FskBellcore") $cid_type_id = "1";
						if($_POST['edAKChannel_cid_type' . $lKey]=="DTMF") $cid_type_id = "2";
						//$channel->cid_type = $_POST['edAKChannel_cid_type' . $lKey];
						$channel->cid_type = $cid_type_id;
						
						$channel->dtmf_sig_msec = $_POST['edAKChannel_dtmf_sig_msec' . $lKey];
						if($channel->dtmf_sig_msec < 0) $channel->dtmf_sig_msec = 0;
						if($channel->dtmf_sig_msec > 6000) $channel->dtmf_sig_msec = 6000;
						
						$channel->dtmf_pause_msec = $_POST['edAKChannel_dtmf_pause_msec' . $lKey];
						if($channel->dtmf_pause_msec < 0) $channel->dtmf_pause_msec = 0;
						if($channel->dtmf_pause_msec > 6000) $channel->dtmf_pause_msec = 6000;

						$channel->gen_gain_dB = $_POST['edAKChannel_gen_gain' . $lKey];

						$ec_nlp_id = "";
						if($_POST['edAKChannel_ec_nlp' . $lKey]=="none") $ec_nlp_id = "0";
						if($_POST['edAKChannel_ec_nlp' . $lKey]=="CNG") $ec_nlp_id = "1";
						if($_POST['edAKChannel_ec_nlp' . $lKey]=="CLIP") $ec_nlp_id = "2";
						$channel->ec_nlp = $ec_nlp_id;
						
						$channel->ec_lbgn = $_POST['edAKChannel_ec_lbgn' . $lKey];

						$channel->vad_lvl_dB = $_POST['edAKChannel_rx_vad_lvl_dB' . $lKey];
						$channel->vad_timeout_sec = $_POST['edAKChannel_rx_vad_timeout_sec' . $lKey];
						$channel->release_by_vad = $_POST['edAKChannel_akc_release_by_rx_vad' . $lKey];

						$channel->wink_msec = $_POST['edAKChannel_wink_msec' . $lKey];
						$channel->default_cid = $_POST['edAKChannel_default_cid' . $lKey];

						$channel->line_coeffs_set = $_POST['edAKChannel_line_coeffs_set' . $lKey];
						$channel->SetCommentLines(base64_decode($_POST['edLinkComments' . $lKey]));
						$channel->SetUnknownLines($_POST['edLinkUnknowns' . $lKey]);
						$objILAK->channel[] = $channel;
					}

					$bool_wink_msec = !in_array( $channel->id, explode(",", $objILAK->EmV5Chs));
					if ( $bool_wink_msec ) unset($channel->wink_msec);

				}


			};
		};
	};
	
	// EmPhones
	$sValue = $_POST['hidEmPhoneSetCount'];
	if ($sValue != null) {
		$iValue = (int)$sValue;
		$conf_controller->ILEmPhones->arrILEmPhones = array();
		$emphone_id = 0;
		for ($i = 0;$i < $iValue;$i++) {
			$sKey = ((string)($i + 1));
			$trunk = $_POST['edEmPhone_trunk' . $sKey];
			if ($trunk != null) {
				$emphone_id++;
				$objILEmPhone = new ILEmPhoneObj();
				$objILEmPhone->emphone_id = $emphone_id;
				$objILEmPhone->trunk = $_POST['edEmPhone_trunk' . $sKey];
				$objILEmPhone->callerId = $_POST['edEmPhone_callerId' . $sKey];
				$objILEmPhone->name = $_POST['edEmPhone_name' . $sKey];
				$objILEmPhone->missec = $_POST['edEmPhone_missec' . $sKey];

				$objILEmPhone->hdlc_timeslot = $_POST['edEmHdlcTimeslot' . $sKey];
				$objILEmPhone->hdlc_address = $_POST['edEmHdlcAddress' . $sKey];
				
//var_dump($objILEmPhone->hdlc_timeslot); return;				

				$objILEmPhone->SetCommentLines(base64_decode($_POST['edEmPhoneComments' . $sKey]));
				$objILEmPhone->SetUnknownLines(base64_decode($_POST['edEmPhoneUnknowns' . $sKey]));
				$conf_controller->ILEmPhones->arrILEmPhones[] = $objILEmPhone;
				$objILEmPhone->index = count($conf_controller->ILEmPhones->arrILEmPhones);

				$ch_count = (int)$_POST['hidEmPhoneChannelCount' . $sKey];
				for ($idx = 1; $idx <= $ch_count; $idx++) {
					$lKey = "_" . ((string)($i + 1)) . "_" . ((string)$idx);
					if ($_POST['edEmPhoneChanneltrunk' . $lKey] != null) {
						$emphone_channel = new ILEmPhoneChannelObj();
						$emphone_channel->emphone_id = $objILEmPhone->emphone_id;
						$emphone_channel->trunk = $_POST['edEmPhoneChanneltrunk' . $lKey];
						$emphone_channel->timeslot = $_POST['edEmPhoneChanneltimeslot' . $lKey];
						$emphone_channel->called = $_POST['edEmPhoneChannelcalled' . $lKey];
						$emphone_channel->called_desc = $_POST['edEmPhoneChannelcalled_desc' . $lKey];
						//$emphone_channel->subscribe_to = $_POST['edEmPhoneChannelsubscribe_to' . $lKey];

						$emphone_channel->subscribe_to = '';
						for($subs_row=0; $subs_row<$_POST['hidEmPhoneChannelSubscribeCount'.$lKey]; $subs_row++ ){
							if(isset($_POST['channel_subscribe'.$lKey.'_'.$subs_row])){
								$emphone_channel->subscribe_to .= $_POST['channel_subscribe'.$lKey.'_'.$subs_row] . ' ';
							}
						}

						//$emphone_channel->enable = ( ($_POST['edEmPhoneChannelenable' . $lKey]) == 'true' ) ? 1 : 0;
						$emphone_channel->enable = $_POST['edEmPhoneChannelenable' . $lKey];
						$emphone_channel->SetCommentLines(base64_decode($_POST['edEmPhoneChannelComments' . $lKey]));
						$emphone_channel->SetUnknownLines($_POST['edEmPhoneChannelUnknowns' . $lKey]);
						$objILEmPhone->emphone_channel[] = $emphone_channel;
					}
				}

			};
		};
	};
	
	
	
	// Redundancy
	$sValue = $_POST['hidRedundancyCount'];
	if ($sValue != null) {
		$iValue = (int)$sValue;
		$conf_controller->ILhsps->arrILhsps = array();
		for ($i = 0;$i < $iValue;$i++) {
			$sKey = ((string)($i + 1));
			if ($_POST['ssHspService' . $sKey] != null) {
				$objILhsp = new ILhspObj();

				//$objILhsp->service = $_POST['ssHspService' . $sKey];
				//$objILhsp->board = stripslashes($_POST['edHspBoard' . $sKey]);
				//$objILhsp->channel = $_POST['edHspChannel' . $sKey];
				/*
				if($_POST['ssHspService' . $sKey] == 'controller')
					{$objILhsp->service = $_POST['ssHspService' . $sKey];}
				elseif ($_POST['ssHspService' . $sKey] == 'ak') 
					{$objILhsp->service = $_POST['ssHspService' . $sKey] . ':' . $_POST['edHspBoard' . $sKey] . ':' . $_POST['edHspChannel' . $sKey];}
				*/
				if($_POST['ssHspService' . $sKey] == 'controller')
					{$objILhsp->service = $_POST['ssHspService' . $sKey];}
				elseif ($_POST['ssHspService' . $sKey] == 'ak') 
					{$objILhsp->service = $_POST['ssHspService' . $sKey] . ':' . $_POST['edHspBoard' . $sKey] . ':' . $_POST['edHspChannel' . $sKey];}
				elseif ($_POST['ssHspService' . $sKey] == 'radio') 
					{$objILhsp->service = $_POST['ssHspService' . $sKey] . ':' . $_POST['edHspBoard' . $sKey] . ':' . $_POST['edHspChannel' . $sKey];}

				$objILhsp->mode = $_POST['ssHspMode' . $sKey];
				$objILhsp->host_id = $_POST['edHspHostID' . $sKey];
				$objILhsp->group = $_POST['edHspGroup' . $sKey];
				$objILhsp->priority = $_POST['edHspPriority' . $sKey];
				$objILhsp->hello_time = $_POST['edHspHelloTime' . $sKey];
				$objILhsp->hold_time = $_POST['edHspHoldTime' . $sKey];
				$objILhsp->info_time = $_POST['edHspInfoTime' . $sKey];
				$objILhsp->comment = $_POST['edHspComment' . $sKey];
				
				//$objILhsp->transport_type = $_POST['ssHspTransportType' . $sKey];
				//$objILhsp->transport_addr = $_POST['edHspTransportAddr' . $sKey];
				/*if($_POST['ssHspTransportType' . $sKey] == 'udp')
					{$objILhsp->transport = $_POST['ssHspTransportType' . $sKey] . ':' . $_POST['edHspTransportAddr' . $sKey];}
				elseif ($_POST['ssHspService' . $sKey] != 'udp') 
					{$objILhsp->transport = '';}*/

				$objILhsp->transport = '';
				for($tr_row=2; $tr_row<=$_POST['hidRedundancyTransportCount'.$sKey]+1; $tr_row++ ){
					if(isset($_POST['transport_type_'.$sKey.'_'.$tr_row])){
						//$objILhsp->transport .= $_POST['transport_type_'.$sKey.'_'.$tr_row] . ':' .
						//$_POST['transport_address_'.$sKey.'_'.$tr_row] . ':' .
						//$_POST['transport_port_'.$sKey.'_'.$tr_row].' ';
						$objILhsp->transport .= $_POST['transport_type_'.$sKey.'_'.$tr_row] . ':' .
						$_POST['transport_address_'.$sKey.'_'.$tr_row] . ':' .
						$_POST['transport_port_'.$sKey.'_'.$tr_row] . ':' .
						$_POST['transport_ttl_'.$sKey.'_'.$tr_row].' ';
					}
				}
				//var_dump($objILhsp->transport);					


				//$objILhsp->SetCommentLines(base64_decode($_POST['edHspComments' . $sKey]));
				//$objILhsp->SetUnknownLines(base64_decode($_POST['edHspUnknowns' . $sKey]));
				$conf_controller->ILhsps->arrILhsps[] = $objILhsp;
			}
		};
	};

	//var_dump($conf_controller);return;
	$conf_controller->FixToFile();

	// apply
	include "/cgi-bin/hardinfofunc.inc";
	/*
	if ($_POST['cbApply'])
		RereadControllerParams();
	if ($_POST['cbSaveECcoeffs'])
		SaveECcoeffs();
	if ($_POST['cbRebootController'])
		RestartController();
	Inform_AutoConfig();
	*/
	
	if ($_POST['cbRebootController']){
		if ($_POST['cbSaveECcoeffs']) SaveECcoeffs();
		RestartController();
	} else {
		if($_POST['cbApply']) RereadControllerParams();
		//else RestartController();
	}
	
	Inform_AutoConfig();
	

	header("Location: /cgi-bin/Controller.cgi");
};

//////////////////////////////////////////

include "/cgi-bin/MainPageProcessing.inc";
if (CheckAccess($ErrCode))
	DoApplyControllerSettings();
else
	printAccessDenied($ErrCode);
?>