<?php
define("MONITORCONF_DIR", "/var/monitoring");


// monitoring subject files (LI,lemzgw,channel and etc.)
class MonitorSubject {
	public $param = array(
		"statusHotStandbyProtoTable" => "",
		"statusInterfacesTable" => "",
		"statusInterface1ChannelsTable" => "",
		"statusInterface2ChannelsTable" => "",
		"statusInterface3ChannelsTable" => "",
		"statusInterface4ChannelsTable" => ""
	);

	// check is the variable monitoring subject
	public function isMonitorSubject($var){
		$var = strrev( substr(strrev($var), 0, strpos(strrev($var),'/')) );
		foreach($this->param as $key => $val) if($var == $key) return true;
		return false;
	}
};

// monitoring parameters list
class MonitorParam {
	public $param = array(
		"shspNumber"				=> array("","",""),
		"shspServiceAsText"			=> array("","",""),
		"shspDynamicPriority"		=> array("statusHotStandbyProtoTable","Dynamic Priority",""),
		"shspStateAsText"			=> array("statusHotStandbyProtoTable","State",""),
		
		"siDIChannels"				=> array("statusInterfacesTable","Digital channels capacity",""),
		"siAIChannels"				=> array("statusInterfacesTable","Analog channels capacity",""),
		"siDIFPGAVersion"			=> array("statusInterfacesTable","PLD software version",""),
		"siDIBootVersion"			=> array("statusInterfacesTable","Bootloader version",""),
		"siDIVersion"				=> array("statusInterfacesTable","Digital software version",""),
		"siAIVersion"				=> array("statusInterfacesTable","Analog software version",""),
		"siId"						=> array("statusInterfacesTable","Line Interface ID",""),
		"siActiveChannelsCount"		=> array("statusInterfacesTable","Active Channels Count",""),
		"siStatusInterfaceAsText"	=> array("statusInterfacesTable","Interface status",""),
		"siStatusInterface"			=> array("","",""),
		
		"si1Number"					=> array("","",""),
		"si1StatusCall"				=> array("","",""),
		"si1StatusCallAsText"		=> array("statusInterface1ChannelsTable","Call status",""),
		"si1StatusTransmiterAsText"	=> array("statusInterface1ChannelsTable","Transmiter status",""),
		"si1StatusTransmiter"		=> array("","",""),
		"si1StatusReceiverAsText"	=> array("statusInterface1ChannelsTable","Receiver status",""),
		"si1StatusReceiver"			=> array("","",""),
		"si1StatusChannel"			=> array("","",""),
		"si1StatusChannelAsText"	=> array("statusInterface1ChannelsTable","Channel status",""),

		"si2Number"					=> array("","",""),
		"si2StatusCall"				=> array("","",""),
		"si2StatusCallAsText"		=> array("statusInterface2ChannelsTable","Call status",""),
		"si2StatusTransmiterAsText"	=> array("statusInterface2ChannelsTable","Transmiter status",""),
		"si2StatusTransmiter"		=> array("","",""),
		"si2StatusReceiverAsText"	=> array("statusInterface2ChannelsTable","Receiver status",""),
		"si2StatusReceiver"			=> array("","",""),
		"si2StatusChannel"			=> array("","",""),
		"si2StatusChannelAsText"	=> array("statusInterface2ChannelsTable","Channel status","")
	);
	
	// check is the variable monitoring parameter
	public function isMonitorParam($var){
		$var = strrev( substr(strrev($var), 0, strpos(strrev($var),'/')) );
		foreach($this->param as $key => $val) if($var == $key) return true;
		return false;
	}
};



// main class for variables monitoring
class ControllerMonitor{
	public $structure = array();
	public $monitor = array();
	public $subject;
	public $param;

	function __construct() {
		$this->subject = new MonitorSubject();
		$this->param = new MonitorParam();
		$this->getMonitorStructure(MONITORCONF_DIR,0);
		$this->getMonitorParameter();
	}
	
	// get monitoring file structure and parameter value
	function getMonitorStructure($dir,$level){
		
		// take only subject directories (level = 0 is a root MONITORCONF_DIR, 1 is a subject level, >1 others child dirs)
		if( is_dir($dir) && $this->subject->isMonitorSubject($dir) && $level == 1 ) $list = scandir($dir);
		elseif( is_dir($dir) && $level != 1 ) $list = scandir($dir);
		else { 
			// parameters value
			if( is_file($dir) && $this->param->isMonitorParam($dir) ) 
			//$this->structure[$dir][] = file_get_contents($dir); 
			$this->structure[$dir] = file_get_contents($dir); 
			return; 
		}
		// directory structure
		$list = array_diff($list, array('.', '..'));
		foreach($list as $key => $val){
			$this->structure[$dir][] = $val;
			$path = $dir . '/' . $val;
			$this->getMonitorStructure($path,$level++);
		}
	}
	
	// get monitoring parameters from monitoring structure
	function getMonitorParameter(){
		foreach($this->structure as $key => $val){
			if(!is_array($val)) $this->monitor[$key] = $val;
		}
	}

	// connect monitoring data with redundancy block (by service:board:channel)
	function getRedundancyState($idx){
		$redundancy = array();
		$path = "";
		foreach($this->monitor as $key => $val){
			//var_dump($val);echo "<br><br>";
			if($val == $idx){
				$path = substr($key, 0, strpos($key,'shspServiceAsText'));
				break;
			}
		}
		//var_dump($path);		
		//echo "<br><br>";		
		if( !empty($path) ){
			foreach($this->monitor as $key => $val){
				if( strpos($key,$path)===0 ){
					$key = str_replace ($path,'',$key );
					//$this->redundancy[$key] = $val;
					$redundancy[$key] = $val;
				}
			}
		}
		return $redundancy;
	}

	// connect monitoring data with lemzgw block (by slot number)
	function getLemzgwState($idx){
		$param = array();
		$path = "/var/monitoring/statusInterfacesTable/".trim($idx)."/";
		if( !empty($path) ){
			foreach($this->monitor as $key => $val){
				if( strpos($key,$path)===0 ){
					$key = str_replace ($path,'',$key );
					$param[$key] = $val;
				}
			}
		}
		return $param;
	}

	// connect monitoring data with lemzgw channel block (by slot and channel number)
	function getLemzgwChannelState($slot_idx,$channel_idx){
		$slot_idx++;
		$param = array();
		$path = "/var/monitoring/statusInterface".trim($slot_idx)."ChannelsTable/".trim($channel_idx)."/";
		if( !empty($path) ){
			foreach($this->monitor as $key => $val){
				if( strpos($key,$path)===0 ){
					$key = str_replace ($path,'',$key );
					$key = str_replace ($slot_idx,'',$key );
					$param[$key] = $val;
				}
			}
		}
		return $param;
	}

}


?>