<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("ROUTERCONFFILE", '/usr/local/etc/router.conf');

define("PATTERN_TYPE_BASIC", 0);
define("PATTERN_TYPE_TIMEOUT", 1);
define("PATTERN_TYPE_REDIRECT", 2);

class Router_ctrl extends CustomSection {
	public $session_timeout = "7";
	public $host = "127.0.0.1:20000";
	public $cdr_hosts = "192.168.1.200:35500";
	public $use_redirect_patterns = "false";
	//public $require_incoming_dtmf = "true";
	//public $require_outgoing_dtmf = "true";

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));

		$iFormat = 0;
		$sName = "";
		$sValue = "";

		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			switch ($iFormat) {
				case 1:
					if ($sName === "session timeout") { $this->session_timeout = $sValue;	} else
					if ($sName === "host") { $this->host = $sValue;	} else
					if ($sName === "cdr hosts") { $this->cdr_hosts = $sValue;	} else
					if ($sName === "use redirect patterns") { $this->use_redirect_patterns = $sValue;	} else
					
					//if ($sName === "require incoming dtmf") {
					//	$this->require_incoming_dtmf = $sValue;	} else
					//if ($sName === "require outgoing dtmf") {
					//	$this->require_outgoing_dtmf = $sValue;	} else
					parent::AddUnknownLine($sTMP);
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsSections() {
		$sRes = "[ctrl]\n";
		$sRes = $sRes . parent::GetCommentLines();
		$sRes = $sRes . "session timeout=" . $this->session_timeout . "\n";
		$sRes = $sRes . "host=" . $this->host . "\n";
		$sRes = $sRes . "cdr hosts=" . $this->cdr_hosts . "\n";
		$sRes = $sRes . "use redirect patterns=" . $this->use_redirect_patterns . "\n";
		//$sRes = $sRes . "require incoming dtmf=" . $this->require_incoming_dtmf . "\n";
		//$sRes = $sRes . "require outgoing dtmf=" . $this->require_outgoing_dtmf . "\n";
		$sRes = $sRes . parent::GetUnknownLines();
		return $sRes;
	}
};

class Router_pattern extends CustomSection {
	public $name = "";
	public $called = "";
	public $caller = "";
	public $group = "";
	public $target = "";
	public $type = PATTERN_TYPE_BASIC;
	public $targets = array('1','2');
	
	public function GetAsFullCfgString() {

		foreach ($this->targets as $key => $value) {
			//$target = $target."target=".$value."\n";
			$target = $target.$value." ";
		}
		$target = "target=".$target."\n";

		$name = (empty($this->name))?"":"name=" . $this->name . "\n";
		$caller = (empty($this->caller))?"":"caller=" . $this->caller . "\n";
		$group = (empty($this->group))?"":"group=" . $this->group . "\n";
		
		$sRes = parent::GetCommentLines()
				. $name
				. "called=" . $this->called . "\n"
//				. "caller=" . $this->caller . "\n"
				. $caller
//				. "group=" . $this->group . "\n"
				. $group
				. $target
				. parent::GetUnknownLines();
		return $sRes;
	}
	
	
	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "called")
					$this->called = $sValue;
				elseif ($sName === "caller")
					$this->caller = $sValue;
				elseif ($sName === "group")
					$this->group = $sValue;
				elseif ($sName === "target")
					$this->target = $sValue;
				elseif ($sName === "name")
					$this->name = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Router_patterns {
	public $arrPatterns = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Router_pattern();
		$this->arrPatterns[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function AddAsSectionEx($sSection, $patterntype) {
		$obj = $this->AddAsSection($sSection);
		if ($obj)
			$obj->type = $patterntype;
	}

	public function GetByIndex($iIndex) {
		return $this->arrPatterns[(int)$iIndex];
	}

	public function GetByTarget($bName) {
		$i = 0;
		do {
			$obj = $this->GetByIndex($i++);
			if ($obj != null) {
				if ($obj->target === $bName) {
					break;
				};
			};
		} while ($obj != null);
		return $obj;
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while (($obj = $this->arrPatterns[$i++])) {
			//$sRes = $sRes . "[pattern]\n" . $objValue->GetAsFullCfgString();
			switch ($obj->type) {
				case PATTERN_TYPE_BASIC:
					$sRes = $sRes . "[pattern]\n";
					break;
				case PATTERN_TYPE_TIMEOUT:
					$sRes = $sRes . "[timeout pattern]\n";
					break;
				//case PATTERN_TYPE_REDIRECT:
				//	$sRes = $sRes . "[redirect pattern]\n";
				//	break;
				default:
					break;
			}
			$sRes = $sRes . $obj->GetAsFullCfgString();

			if ($i < count($this->arrPatterns))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};
////////////////////////////////////////////////////////////////////////////////////////////////////


class Router_redirectpattern extends CustomSection {
	public $name = "";
	public $called = "";
	public $caller = "";
	public $group = "";
	public $target = "";
	public $type = PATTERN_TYPE_REDIRECT;
	public $targets = array('1','2');
	
	public function GetAsFullCfgString() {

		foreach ($this->targets as $key => $value) {
			//$target = $target."target=".$value."\n";
			$target = $target.$value." ";
		}
		$target = "target=".$target."\n";

		$name = (empty($this->name))?"":"name=" . $this->name . "\n";
		$caller = (empty($this->caller))?"":"caller=" . $this->caller . "\n";
		$group = (empty($this->group))?"":"group=" . $this->group . "\n";
		
		$sRes = parent::GetCommentLines()
				. $name
				. "called=" . $this->called . "\n"
//				. "caller=" . $this->caller . "\n"
				. $caller
//				. "group=" . $this->group . "\n"
				. $group
				. $target
				. parent::GetUnknownLines();
		return $sRes;
	}
	
	
	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "called")
					$this->called = $sValue;
				elseif ($sName === "caller")
					$this->caller = $sValue;
				elseif ($sName === "group")
					$this->group = $sValue;
				elseif ($sName === "target")
					$this->target = $sValue;
				elseif ($sName === "name")
					$this->name = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Router_redirectpatterns {
	public $arrRedirectPatterns = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Router_redirectpattern();
		$this->arrRedirectPatterns[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function AddAsSectionEx($sSection, $patterntype) {
		$obj = $this->AddAsSection($sSection);
		if ($obj)
			$obj->type = $patterntype;
	}

	public function GetByIndex($iIndex) {
		return $this->arrRedirectPatterns[(int)$iIndex];
	}

	public function GetByTarget($bName) {
		$i = 0;
		do {
			$obj = $this->GetByIndex($i++);
			if ($obj != null) {
				if ($obj->target === $bName) {
					break;
				};
			};
		} while ($obj != null);
		return $obj;
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while (($obj = $this->arrRedirectPatterns[$i++])) {
			//$sRes = $sRes . "[pattern]\n" . $objValue->GetAsFullCfgString();
			switch ($obj->type) {
				case PATTERN_TYPE_BASIC:
					$sRes = $sRes . "[pattern]\n";
					break;
				case PATTERN_TYPE_TIMEOUT:
					$sRes = $sRes . "[timeout pattern]\n";
					break;
				case PATTERN_TYPE_REDIRECT:
					$sRes = $sRes . "[redirect]\n";
					break;
				default:
					break;
			}
			$sRes = $sRes . $obj->GetAsFullCfgString();

			if ($i < count($this->arrRedirectPatterns))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};


///////////////////////////////////////////////////////////////////////////////////////////////////////////

class ILRecorderPatternObj extends CustomSection {
	public $recorder_pattern_id = "";
	public $sign_type = "";
	public $slot = "";
	public $channel = "";
	public $trunk = "";
	public $timeslot = "";
	public $caller = "";
	public $called = "";
	public $recorder = array();
	public $name = "";

	public function GetAsFullCfgString() {
		if($this->sign_type == "ak"){
			$sRes = parent::GetCommentLines()
				. "recorder_pattern_id=" . $this->recorder_pattern_id . "\n"
				. "name=" . $this->name . "\n"
				. "sign_type=" . $this->sign_type . "\n"
				. "slot=" . $this->slot . "\n"
				. "channel=" . $this->channel . "\n"
				. parent::GetUnknownLines();
		}
//		if($this->sign_type == "sip"){
		if($this->sign_type == "digital-phone"){
			$sRes = parent::GetCommentLines()
				. "recorder_pattern_id=" . $this->recorder_pattern_id . "\n"
				. "name=" . $this->name . "\n"
				. "sign_type=" . $this->sign_type . "\n"
				. "caller=" . $this->caller . "\n"
				. "called=" . $this->called . "\n"
				. parent::GetUnknownLines();
		}
		if($this->sign_type == "trunk"){
			$sRes = parent::GetCommentLines()
				. "recorder_pattern_id=" . $this->recorder_pattern_id . "\n"
				. "name=" . $this->name . "\n"
				. "sign_type=" . $this->sign_type . "\n"
				. "trunk=" . $this->trunk . "\n"
				. "timeslot=" . $this->timeslot . "\n"
				. parent::GetUnknownLines();
		}
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "recorder_pattern_id")
					$this->recorder_pattern_id = $sValue;
				elseif ($sName === "sign_type")
					$this->sign_type = $sValue;
				elseif ($sName === "slot")
					$this->slot = $sValue;
				elseif ($sName === "channel")
					$this->channel = $sValue;
				elseif ($sName === "trunk")
					$this->trunk = $sValue;
				elseif ($sName === "timeslot")
					$this->timeslot = $sValue;
				elseif ($sName === "caller")
					$this->caller = $sValue;
				elseif ($sName === "called")
					$this->called = $sValue;
				elseif ($sName === "name")
					$this->name = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ILRecorderPatternsObj {
	public $arrILRecorderPatterns = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILRecorderPattern = new ILRecorderPatternObj();
		$this->arrILRecorderPatterns[] = $objILRecorderPattern;
		$objILRecorderPatternset->index = count($this->arrILRecorderPatterns);
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILRecorderPattern->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}
	
	public function GetByIndex($iIndex) {
		return $this->arrILRecorderPatterns[(int)$iIndex];
	}

	public function GetByID($recorder_pattern_ID) {
		$i = 0;
		do {
			$objakset = $this->GetByIndex($i++);
			if ($objakset != null) {
				if ($objakset->recorder_pattern_id === $recorder_pattern_ID) {
					break;
				};
			};
		} while ($objakset != null);
		return $objakset;
	}	

	public function GetAsSections() {
		$sRes = "";
		foreach ($this->arrILRecorderPatterns as $recorder_pattern_set) {
			$sRes .= "\n[recorder-pattern]\n" . $recorder_pattern_set->GetAsFullCfgString();
			foreach ($recorder_pattern_set->recorder as $recorder)
				$sRes .= "\n[pattern-rec]\n" . $recorder->GetAsFullCfgString();
		}
		return $sRes;
	}
	
};

class ILPatternRecObj extends CustomSection {
	public $idx;
	public $recorder_pattern_id;
	public $server;
	//public $user;
	public $url_path;
	public $sdp_uri;
	
	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			switch ($iFormat) {
				case 1:
					$props = get_object_vars($this);
					$name2 = str_replace(' ', '_', $sName);
					if (array_key_exists($sName, $props))
						$this->$sName = $sValue;
					elseif (array_key_exists($name2, $props))
						$this->$name2 = $sValue;
					elseif ( $sName=='user' )
						$this->url_path = $sValue;
					else
						parent::AddUnknownLine($sTMP);
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "recorder_pattern_id=" . $this->recorder_pattern_id . "\n"
				. "server=" . $this->server . "\n"
				//. "user=" . $this->user . "\n"
				. "url path=" . $this->url_path . "\n"
				. "sdp uri=" . $this->sdp_uri . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
};




///////////////////////////////////////////////////////////////////////////////////////////////////////////

class ILRadioED137PatternObj extends CustomSection {
	public $radio_ed137_pattern_id = "";
	public $sign_type = "";
	public $slot = "";
	public $channel = "";
	public $trunk = "";
	public $timeslot = "";
	
	public $snmp_port = "";
	public $session_max_count = "";
	public $frequency = "";
	public $frequency_spacing = "";
	public $permission_enable = "";
	public $permission_normal = "";
	public $permission_emergency = "";
	public $climax_offset = "";
	public $rf_output_power = "";
	public $carrier_squ_threshold = "";
	public $sn_squ_threshold = "";
	public $squ_function = "";
	public $transmission_depend_on_squ = "";
	public $qos_dscp_for_voice = "";
	public $ptt_collision_handling = "";
	public $coupling_ptt_collision_handling = "";
	public $linked_session_support = "";
	
	public $recorder = array();
	public $name = "";

	public function GetAsFullCfgString() {
		if($this->sign_type == "ak"){
			$sRes = parent::GetCommentLines()
				. "radio_ed137_pattern_id=" . $this->radio_ed137_pattern_id . "\n"
				. "name=" . $this->name . "\n"
				. "sign_type=" . $this->sign_type . "\n"
				. "slot=" . $this->slot . "\n"
				. "channel=" . $this->channel . "\n"

				. "snmp_port=" . $this->snmp_port . "\n"
				. "session_max_count=" . $this->session_max_count . "\n"
				. "frequency=" . $this->frequency . "\n"
				. "frequency_spacing=" . $this->frequency_spacing . "\n"
				. "permission_enable=" . $this->permission_enable . "\n"
				. "permission_normal=" . $this->permission_normal . "\n"
				. "permission_emergency=" . $this->permission_emergency . "\n"
				. "climax_offset=" . $this->climax_offset . "\n"
				. "rf_output_power=" . $this->rf_output_power . "\n"
				. "carrier_squ_threshold=" . $this->carrier_squ_threshold . "\n"
				. "sn_squ_threshold=" . $this->sn_squ_threshold . "\n"
				. "squ_function=" . $this->squ_function . "\n"
				. "transmission_depend_on_squ=" . $this->transmission_depend_on_squ . "\n"
				. "qos_dscp_for_voice=" . $this->qos_dscp_for_voice . "\n"
				. "ptt_collision_handling=" . $this->ptt_collision_handling . "\n"
				. "coupling_ptt_collision_handling=" . $this->coupling_ptt_collision_handling . "\n"
				. "linked_session_support=" . $this->linked_session_support . "\n"

				. parent::GetUnknownLines();
		}
		if($this->sign_type == "trunk"){
			$sRes = parent::GetCommentLines()
				. "radio_ed137_pattern_id=" . $this->radio_ed137_pattern_id . "\n"
				. "name=" . $this->name . "\n"
				. "sign_type=" . $this->sign_type . "\n"
				. "trunk=" . $this->trunk . "\n"
				. "timeslot=" . $this->timeslot . "\n"

				. "snmp_port=" . $this->snmp_port . "\n"
				. "session_max_count=" . $this->session_max_count . "\n"
				. "frequency=" . $this->frequency . "\n"
				. "frequency_spacing=" . $this->frequency_spacing . "\n"
				. "permission_enable=" . $this->permission_enable . "\n"
				. "permission_normal=" . $this->permission_normal . "\n"
				. "permission_emergency=" . $this->permission_emergency . "\n"
				. "climax_offset=" . $this->climax_offset . "\n"
				. "rf_output_power=" . $this->rf_output_power . "\n"
				. "carrier_squ_threshold=" . $this->carrier_squ_threshold . "\n"
				. "sn_squ_threshold=" . $this->sn_squ_threshold . "\n"
				. "squ_function=" . $this->squ_function . "\n"
				. "transmission_depend_on_squ=" . $this->transmission_depend_on_squ . "\n"
				. "qos_dscp_for_voice=" . $this->qos_dscp_for_voice . "\n"
				. "ptt_collision_handling=" . $this->ptt_collision_handling . "\n"
				. "coupling_ptt_collision_handling=" . $this->coupling_ptt_collision_handling . "\n"
				. "linked_session_support=" . $this->linked_session_support . "\n"

				. parent::GetUnknownLines();
		}
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "radio_ed137_pattern_id")
					$this->radio_ed137_pattern_id = $sValue;
				elseif ($sName === "sign_type")
					$this->sign_type = $sValue;
				elseif ($sName === "slot")
					$this->slot = $sValue;
				elseif ($sName === "channel")
					$this->channel = $sValue;
				elseif ($sName === "trunk")
					$this->trunk = $sValue;
				elseif ($sName === "timeslot")
					$this->timeslot = $sValue;

				elseif ($sName === "snmp_port")
					$this->snmp_port = $sValue;
				elseif ($sName === "session_max_count")
					$this->session_max_count = $sValue;
				elseif ($sName === "frequency")
					$this->frequency = $sValue;
				elseif ($sName === "frequency_spacing")
					$this->frequency_spacing = $sValue;
				elseif ($sName === "permission_enable")
					$this->permission_enable = $sValue;
				elseif ($sName === "permission_normal")
					$this->permission_normal = $sValue;
				elseif ($sName === "permission_emergency")
					$this->permission_emergency = $sValue;
				elseif ($sName === "climax_offset")
					$this->climax_offset = $sValue;
				elseif ($sName === "rf_output_power")
					$this->rf_output_power = $sValue;
				elseif ($sName === "carrier_squ_threshold")
					$this->carrier_squ_threshold = $sValue;
				elseif ($sName === "sn_squ_threshold")
					$this->sn_squ_threshold = $sValue;
				elseif ($sName === "squ_function")
					$this->squ_function = $sValue;
				elseif ($sName === "transmission_depend_on_squ")
					$this->transmission_depend_on_squ = $sValue;
				elseif ($sName === "qos_dscp_for_voice")
					$this->qos_dscp_for_voice = $sValue;
				elseif ($sName === "ptt_collision_handling")
					$this->ptt_collision_handling = $sValue;
				elseif ($sName === "coupling_ptt_collision_handling")
					$this->coupling_ptt_collision_handling = $sValue;
				elseif ($sName === "linked_session_support")
					$this->linked_session_support = $sValue;

				elseif ($sName === "name")
					$this->name = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ILRadioED137PatternsObj {
	public $arrILRadioED137Patterns = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$objILRecorderPattern = new ILRadioED137PatternObj();
		$this->arrILRadioED137Patterns[] = $objILRecorderPattern;
		$objILRecorderPatternset->index = count($this->arrILRadioED137Patterns);
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$objILRecorderPattern->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
	}
	
	public function GetByIndex($iIndex) {
		return $this->arrILRadioED137Patterns[(int)$iIndex];
	}

	public function GetByID($radio_ed137_pattern_id) {
		$i = 0;
		do {
			$objakset = $this->GetByIndex($i++);
			if ($objakset != null) {
				if ($objakset->radio_ed137_pattern_id === $radio_ed137_pattern_id) {
					break;
				};
			};
		} while ($objakset != null);
		return $objakset;
	}	

	public function GetAsSections() {
		$sRes = "";
		foreach ($this->arrILRadioED137Patterns as $recorder_pattern_set) {
			$sRes .= "\n[radio-ed137-pattern]\n" . $recorder_pattern_set->GetAsFullCfgString();
		}
		return $sRes;
	}
	
};






///////////////////////////////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////////////////////////
class Router_target_ak extends CustomSection {
	public $name = "";
	public $slot = 0;
	public $channel = 0;
	//public $income_caller_id = "";
	//public $outcome_caller_id = "";
	public $caller = "";
	public $called = "";
	//public $recorders = "";

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "name=" . $this->name . "\n"
				. "slot=" . $this->slot . "\n"
				. "channel=" . $this->channel . "\n"
				//. "incoming caller id=" . $this->income_caller_id . "\n"
				//. "outcoming caller id=" . $this->outcome_caller_id . "\n"
				. "caller=" . $this->caller . "\n"
				. "called=" . $this->called . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "name")
					$this->name = $sValue;
				elseif ($sName === "slot")
					$this->slot = $sValue;
				elseif ($sName === "channel")
					$this->channel = $sValue;
				//elseif ($sName === "incoming caller id")
				//	$this->income_caller_id = $sValue;
				//elseif ($sName === "outcoming caller id")
				//	$this->outcome_caller_id = $sValue;
				elseif ($sName === "caller")
					$this->caller = $sValue;
				elseif ($sName === "called")
					$this->called = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Router_target_aks {
	public $arrAKTargets = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Router_target_ak();
		$this->arrAKTargets[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrAKTargets[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrAKTargets[$i++]) {
			$sRes = $sRes . "[ak]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrAKTargets))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

class Router_target_modem extends CustomSection {
	public $name = "";
	public $originate = "no";
	public $fax = "no";

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "name=" . $this->name . "\n"
				. "originate=" . $this->originate . "\n"
				. "fax=" . $this->fax . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "name")
					$this->name = $sValue;
				elseif ($sName === "originate")
					$this->originate = $sValue;
				elseif ($sName === "fax")
					$this->fax = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Router_target_modems {
	public $arrModemTargets = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Router_target_modem();
		$this->arrModemTargets[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrModemTargets[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrModemTargets[$i++]) {
			$sRes = $sRes . "[modem]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrModemTargets))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};


//----------------------------------------------------------------------------------------------------
//
//----------------------------------------------------------------------------------------------------

class Router_recorder extends CustomSection {
	public $name = "";
	public $type = "";
	public $signalling = "";
	public $media = "";
	public $addr = "";
	public $port = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "name=" . $this->name . "\n"
				. "type=" . $this->type . "\n"
				. "signalling=" . $this->signalling . "\n"
				. "media=" . $this->media . "\n"
				. "addr=" . $this->addr . "\n"
				. "port=" . $this->port . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "type")
					$this->type = $sValue;
				elseif ($sName === "name")
					$this->name = $sValue;
				elseif ($sName === "signalling")
					$this->signalling = $sValue;
				elseif ($sName === "media")
					$this->media = $sValue;
				elseif ($sName === "addr")
					$this->addr = $sValue;
				elseif ($sName === "port")
					$this->port = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Router_recorders {
	public $arrRecorders = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Router_recorder();
		$this->arrRecorders[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrRecorders[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrRecorders[$i++]) {
			$sRes = $sRes . "[recorder]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrRecorders))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

//----------------------------------------------------------------------------------------------------
//
//----------------------------------------------------------------------------------------------------

class Router_connection extends CustomSection {
	public $name = "";
	public $type = "";
	public $radio_rx_addr = "";
	public $radio_rx_port = "";
	public $radio_tx_addr = "";
	public $radio_tx_port = "";
	public $radio_tx_ttl = "";
	public $radio_tx_qos_dscp = "";
	public $radio_freq_no = "";
	public $radio_freq_chan = "";
	public $cas_trunk_no = "";
	public $cas_trunk_timeslot = "";

	public $radio_bss_enable = "";
	public $radio_rx_delay_msec = "";
	public $radio_tx_delay_msec = "";
	public $radio_selcal_delay_msec = "";

	public $vad_voice_th_msec = "";
	public $vad_silence_th_msec = "";
	public $vad_e_th_dB = "";
	public $radio_ng_enable = "";

	//public $recorders = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "name=" . $this->name . "\n"
				. "type=" . $this->type . "\n"
				. "radio.rx.addr=" . $this->radio_rx_addr . "\n"
				. "radio.rx.port=" . $this->radio_rx_port . "\n"
				. "radio.tx.addr=" . $this->radio_tx_addr . "\n"
				. "radio.tx.port=" . $this->radio_tx_port . "\n"
				. "radio.tx.ttl=" . $this->radio_tx_ttl . "\n"
				. "radio.tx.qos_dscp=" . $this->radio_tx_qos_dscp . "\n"
				. "radio.freq.no=" . $this->radio_freq_no . "\n"
				. "radio.freq.chan=" . $this->radio_freq_chan . "\n"
				. "cas.trunk.no=" . $this->cas_trunk_no . "\n"
				. "cas.trunk.timeslot=" . $this->cas_trunk_timeslot . "\n"

				. "radio.bss.enable=" . $this->radio_bss_enable . "\n"
				. "radio.rx.delay.msec=" . $this->radio_rx_delay_msec . "\n"
				. "radio.tx.delay.msec=" . $this->radio_tx_delay_msec . "\n"
				. "radio.selcal.delay.msec=" . $this->radio_selcal_delay_msec . "\n"

				. "vad.voice.th.msec=" . $this->vad_voice_th_msec . "\n"
				. "vad.silence.th.msec=" . $this->vad_silence_th_msec . "\n"
				. "vad.e.th.dB=" . $this->vad_e_th_dB . "\n"
				. "radio.ng.enable=" . $this->radio_ng_enable . "\n"

				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "type")
					$this->type = $sValue;
				elseif ($sName === "name")
					$this->name = $sValue;
				elseif ($sName === "radio.rx.addr")
					$this->radio_rx_addr = $sValue;
				elseif ($sName === "radio.rx.port")
					$this->radio_rx_port = $sValue;
				elseif ($sName === "radio.tx.addr")
					$this->radio_tx_addr = $sValue;
				elseif ($sName === "radio.tx.port")
					$this->radio_tx_port = $sValue;
				elseif ($sName === "radio.tx.ttl")
					$this->radio_tx_ttl = $sValue;
				elseif ($sName === "radio.tx.qos_dscp")
					$this->radio_tx_qos_dscp = $sValue;

				elseif ($sName === "radio.freq.no")
					$this->radio_freq_no = $sValue;
				elseif ($sName === "radio.freq.chan")
					$this->radio_freq_chan = $sValue;
				elseif ($sName === "cas.trunk.no")
					$this->cas_trunk_no = $sValue;
				elseif ($sName === "cas.trunk.timeslot")
					$this->cas_trunk_timeslot = $sValue;

				elseif ($sName === "radio.bss.enable")
					$this->radio_bss_enable = $sValue;
				elseif ($sName === "radio.rx.delay.msec")
					$this->radio_rx_delay_msec = $sValue;
				elseif ($sName === "radio.tx.delay.msec")
					$this->radio_tx_delay_msec = $sValue;
				elseif ($sName === "radio.selcal.delay.msec")
					$this->radio_selcal_delay_msec = $sValue;
					

				elseif ($sName === "vad.voice.th.msec")
					$this->vad_voice_th_msec = $sValue;
				elseif ($sName === "vad.silence.th.msec")
					$this->vad_silence_th_msec = $sValue;
				elseif ($sName === "vad.e.th.dB")
					$this->vad_e_th_dB = $sValue;
				elseif ($sName === "radio.ng.enable")
					$this->radio_ng_enable = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Router_connections {
	public $arrConnections = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Router_connection();
		$this->arrConnections[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrConnections[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrConnections[$i++]) {
			$sRes = $sRes . "[connection]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrConnections))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};


class Router_target_signalling extends CustomSection {
	public $name = "";
	public $called = "";
	public $caller = "";
	public $codec_set = "";
	public $sigtype = "";
	
	public $sig_ss7_cg_category = "";
	public $sig_ss7_cg_nature = "";
	public $sig_ss7_cg_inetwork = "";

	public $sig_ss7_cg_plan = "";
	public $sig_ss7_cd_nature = "";
	public $sig_ss7_cd_plan = "";
	public $sig_isdn_cg_typeofnumber = "";
	public $sig_isdn_cg_plan = "";
	public $sig_isdn_cg_screeningind = "";
	public $sig_isdn_cd_typeofnumber = "";
	public $sig_isdn_cd_plan = "";
	public $sig_isdn_cd_screeningind = "";
	public $group = "";
	public $sig_ss7_subject = "";
	public $sig_ss7_priority = "";
	public $sig_ss7_media_service = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "name=" . $this->name . "\n"
				. "called=" . $this->called . "\n"
				. "caller=" . $this->caller . "\n"
				. "codec set=" . $this->codec_set . "\n"
				. "sigtype=" . $this->sigtype . "\n"

				. "ss7.cg.category=" . $this->sig_ss7_cg_category . "\n"
				. "ss7.cg.nature=" . $this->sig_ss7_cg_nature . "\n"
				. "ss7.cg.inetwork=" . $this->sig_ss7_cg_inetwork . "\n"
				. "ss7.cg.plan=" . $this->sig_ss7_cg_plan . "\n"
				. "ss7.cd.nature=" . $this->sig_ss7_cd_nature . "\n"
				. "ss7.cd.plan=" . $this->sig_ss7_cd_plan . "\n"

				. "isdn.cg.typeofnumber=" . $this->sig_isdn_cg_typeofnumber . "\n"
				. "isdn.cg.plan=" . $this->sig_isdn_cg_plan . "\n"
				. "isdn.cg.screeningind=" . $this->sig_isdn_cg_screeningind . "\n"
				. "isdn.cd.typeofnumber=" . $this->sig_isdn_cd_typeofnumber . "\n"
				. "isdn.cd.plan=" . $this->sig_isdn_cd_plan . "\n"
				. "isdn.cd.screeningind=" . $this->sig_isdn_cd_screeningind . "\n"
				. "group=" . $this->group . "\n"
				. "subject=" . $this->sig_ss7_subject . "\n"
				. "priority=" . $this->sig_ss7_priority . "\n"
				. "media service=" . $this->sig_ss7_media_service . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "name")
					$this->name = $sValue;
				elseif ($sName === "called")
					$this->called = $sValue;
				elseif ($sName === "caller")
					$this->caller = $sValue;
				elseif ($sName === "codec set")
					$this->codec_set = $sValue;
				elseif ($sName === "sigtype")
					$this->sigtype = $sValue;

				elseif ($sName === "ss7.cg.category")
					$this->sig_ss7_cg_category = $sValue;
				elseif ($sName === "ss7.cg.nature")
					$this->sig_ss7_cg_nature = $sValue;
				elseif ($sName === "ss7.cg.inetwork")
					$this->sig_ss7_cg_inetwork = $sValue;

				elseif ($sName === "ss7.cg.plan")
					$this->sig_ss7_cg_plan = $sValue;
				elseif ($sName === "ss7.cd.nature")
					$this->sig_ss7_cd_nature = $sValue;
				elseif ($sName === "ss7.cd.plan")
					$this->sig_ss7_cd_plan = $sValue;
					
					
				elseif ($sName === "isdn.cg.typeofnumber")
					$this->sig_isdn_cg_typeofnumber = $sValue;
				elseif ($sName === "isdn.cg.plan")
					$this->sig_isdn_cg_plan = $sValue;
				elseif ($sName === "isdn.cg.screeningind")
					$this->sig_isdn_cg_screeningind = $sValue;
				elseif ($sName === "isdn.cd.typeofnumber")
					$this->sig_isdn_cd_typeofnumber = $sValue;
				elseif ($sName === "isdn.cd.plan")
					$this->sig_isdn_cd_plan = $sValue;
				elseif ($sName === "isdn.cd.screeningind")
					$this->sig_isdn_cd_screeningind = $sValue;
				elseif ($sName === "group")
					$this->group = $sValue;

				elseif ($sName === "subject")
					$this->sig_ss7_subject = $sValue;
				elseif ($sName === "priority")
					$this->sig_ss7_priority = $sValue;
				elseif ($sName === "media service")
					$this->sig_ss7_media_service = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Router_target_signallings {
	public $arrSignallingTargets = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Router_target_signalling();
		$this->arrSignallingTargets[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrSignallingTargets[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrSignallingTargets[$i++]) {
			$sRes = $sRes . "[signalling]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrSignallingTargets))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

# ######################################
class RouterConfFile extends CustomConfFile {
	public $ctrl;
	public $patterns;
	public $redirect;
	public $targets_ak;
	public $targets_modem;
	public $targets_signalling;
	public $connection;
	public $recorder;
	public $ILRecorderPatterns;
	public $ILRadioED137Patterns;

	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->ctrl = new Router_ctrl();
		$this->patterns = new Router_patterns();
		$this->redirect = new Router_redirectpatterns();
		$this->targets_ak = new Router_target_aks();
		$this->targets_modem = new Router_target_modems();
		$this->connection = new Router_connections();
		$this->recorder = new Router_recorders();
		$this->targets_signalling = new Router_target_signallings();
		$this->ILRecorderPatterns = new ILRecorderPatternsObj();
		$this->ILRadioED137Patterns = new ILRadioED137PatternsObj();
		
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function DoReadPatternRec($cache) {
		if(!empty($cache)){
			reset($cache);
			$sTMP = current($cache);
			while ($sTMP) {
				$chTMP = new ILPatternRecObj();
				$chTMP->AddAsSection($sTMP);
				$aksetTMP = $this->ILRecorderPatterns->GetByID($chTMP->recorder_pattern_id);
				if ($aksetTMP) {
					$aksetTMP->recorder[] = $chTMP;
					$chTMP->idx = count($aksetTMP->recorder);
				}
				$sTMP = next($cache);
			};
		}
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";
		$patternrec_cache = array();

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "ctrl")
				$this->ctrl->AddAsSection($sSectionValues);
			elseif ($sSectionName === "pattern")
				$this->patterns->AddAsSectionEx($sSectionValues, PATTERN_TYPE_BASIC);
			elseif ($sSectionName === "timeout pattern")
				$this->patterns->AddAsSectionEx($sSectionValues, PATTERN_TYPE_TIMEOUT);
			//elseif ($sSectionName === "redirect pattern")
			//	$this->patterns->AddAsSectionEx($sSectionValues, PATTERN_TYPE_REDIRECT);
			elseif ($sSectionName === "redirect")
				$this->redirect->AddAsSectionEx($sSectionValues, PATTERN_TYPE_REDIRECT);
			elseif ($sSectionName === "ak")
				$this->targets_ak->AddAsSection($sSectionValues);
			elseif ($sSectionName === "modem")
				$this->targets_modem->AddAsSection($sSectionValues);
			elseif ($sSectionName === "connection")
				$this->connection->AddAsSection($sSectionValues);
			elseif ($sSectionName === "recorder")
				$this->recorder->AddAsSection($sSectionValues);
			elseif ($sSectionName === "signalling")
				$this->targets_signalling->AddAsSection($sSectionValues);
			elseif ($sSectionName === "recorder-pattern")
				$this->ILRecorderPatterns->AddAsSection($sSectionValues);
			elseif ($sSectionName === "radio-ed137-pattern")
				$this->ILRadioED137Patterns->AddAsSection($sSectionValues);
				
				
			elseif ($sSectionName === "pattern-rec")
				$patternrec_cache[] = $sSectionValues;
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};

		$this->DoReadPatternRec($patternrec_cache);
	}

	function FixToFile() {
		$this->Clear();
		$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		//commons
		$this->PutLine($this->ctrl->GetAsSections());
		//targets
		$this->PutLine($this->targets_signalling->GetAsSections());
		$this->PutLine($this->targets_ak->GetAsSections());
		$this->PutLine($this->targets_modem->GetAsSections());
		$this->PutLine($this->connection->GetAsSections());
		$this->PutLine($this->recorder->GetAsSections());
		//patterns
		$this->PutLine($this->patterns->GetAsSections());
		$this->PutLine($this->redirect->GetAsSections());

		$this->PutLine($this->ILRecorderPatterns->GetAsSections());
		$this->PutLine($this->ILRadioED137Patterns->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}
};
# ######################################
?>
