//--------------------------------------------------------------------------------------------------
// Плагин: Информационная лента сообщений. Представляет собой прокручивающуюся таблицу в div-е.
// html: <div id="div_infoview"></div>
// init: $('div[id=div_infoview]').infoviewer('init');
// use: $('div[id=div_infoview]').infoviewer('putrow',row_id,row_text);
// Если нет записей плагин прячется. Как только добавлется запись - появляется.
//--------------------------------------------------------------------------------------------------

var tab_infoview;
 
// наши публичные методы
var methods = {
    // инициализация плагина
    init:function(params) {

		$(this).addClass('scroll-table');

		tab_infoview = document.createElement("table");
		tab_infoview.id = "tab_infoview";
		$(this).append(tab_infoview);
		
		$('.scroll-table').css({
			'width':'100%',
			'overflow':'auto',
			'position':'relative',
			'background-color':'#ffdcdc'
		});
		$('.scroll-table table').css({
			'width':'100%',
			'display':'inline-block',
			'vertical-align':'top',
			'max-width':'100%',
			'overflow-y':'auto',
			'-webkit-overflow-scrolling':'touch',
			'height':'70px',
			'color':'#335588'
		});


    },

    putrow : function(id,res){
		
			var div_infoview = $(this); 

			// если запись с идентификатором id есть, то меняем ее значение на res
			// но если res имеет пустое значение, то удаляем эту запись
			var row_noexist = true;
			$('tr',tab_infoview).each(function() { 
				var tr_id = $('td:eq(0)',this).text();
				if( tr_id == id ) { 
					if(res!='') $('td:eq(1)',this).html(res); 
					else $(this).remove();
					row_noexist = false;
					return false;
				}
			});

			// если записи с идентификатором id нет, то добавляем новую
			if(row_noexist && res!=''){

				tr = document.createElement("tr");

				td = document.createElement("td");
				td.style.display = "none";
				td.innerHTML = id;
				tr.appendChild(td);

				td = document.createElement("td");
				td.innerHTML = res;
				tr.appendChild(td);

				tab_infoview.appendChild(tr);

				if( $('tr',tab_infoview).length > 0 && $(div_infoview).is(':hidden') ) $(div_infoview).show();
			}
			
			
			if( $('tr',tab_infoview).length == 0 && $(div_infoview).is(':visible') ) $(div_infoview).hide();

    }
	
};


(function($) {

    $.fn.infoviewer = function( method ) {

		// немного магии
		if ( methods[method] ) {
			// если запрашиваемый метод существует, мы его вызываем
			// все параметры, кроме имени метода прийдут в метод
			// this так же перекочует в метод
			return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
		} else if ( typeof method === 'object' || ! method ) {
			// если первым параметром идет объект, либо совсем пусто
			// выполняем метод init
			return methods.init.apply( this, arguments );
		} else {
			// если ничего не получилось
			$.error( 'Метод &quot;' +  method + '&quot; не найден в плагине' );
		}
		
        return this;
    };
	
})(jQuery);

