<?php /*?>#!/bin/php<?php */?>
<html>
<head>
<?php require_once(dirname(__FILE__).'/common_htmlhead.inc'); ?>
<script language="JavaScript" type="text/JavaScript" src="/router.js"></script>
<title>RINO Hardware :: Router configuration</title>
</head>
<body>
<?php require_once(dirname(__FILE__).'/common_header.inc'); ?>
<!--<b class="pagetitle">Router configuration</b>
<div id="nullt">&nbsp;</div><div style="clear: both"></div>-->
<form autocomplete="off" name="routerconf" action="/cgi-bin/doapplyrouter.cgi" method="post">
<?php
	require_once(dirname(__FILE__).'/router_controls.inc');
	$router_conf = new RouterConfFile(ROUTERCONFFILE);
//var_dump($router_conf->phonenumbertables);
//var_dump($router_conf->phonenumbertables->arrPhoneNumberTable);
//var_dump($router_conf->ILRecorderPatterns->arrILRecorderPatterns);


	include "/cgi-bin/conf_controls.inc";
	$controller_conf = new ControllerConfFile(CONTROLLERCONFFILE);
	//var_dump($controller_conf->ILCASTrunks);

?>

<input name="hidChangeEvent" id="hidChangeEvent" type="hidden" value="0">



<!------------------------------------------------------------------------------------>
<!--							Configuration settings:								-->
<!------------------------------------------------------------------------------------>
<?php

	// E1 Trunks configuration --------------------------------------------------------
	reset($controller_conf->ILtrunks->arrILtrunks);
	$obj = current($controller_conf->ILtrunks->arrILtrunks);
	$res = '';
	while ($obj) {
		$res .= $res=='' ? $obj->IDTrunk .','.$obj->name : '|'.$obj->IDTrunk.','.$obj->name;
		$obj = next($controller_conf->ILtrunks->arrILtrunks);
	};
	printf("<input id=\"edController_ILtrunks\" type=\"hidden\" value=".$res.">");

	// Tone Signalling Configuration --------------------------------------------------
	reset($controller_conf->ILToneTrunks->arrToneTrunks);
	$obj = current($controller_conf->ILToneTrunks->arrToneTrunks);
	$res = '';
	while ($obj) {
		if($obj->type != 'ac-radio'){
			$res .= $res=='' ? $obj->trunk .','.$obj->timeslot : '|'.$obj->trunk.','.$obj->timeslot;
		}
		$obj = next($controller_conf->ILToneTrunks->arrToneTrunks);
	};
	printf("<input id=\"edController_ILToneTrunks\" type=\"hidden\" value=".$res.">");


?>

<div id="edSectionTrunkTimeslot"></div>

<!------------------------------------------------------------------------------------>
<!--								Main settings:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
	<table class="nb" cellpadding="0" cellspacing="0" width="90%">
		<caption onClick="doSectionSwitch('RMainContainerHeader','RMainContainer');">
			<div class="sec" style="display:inline;float:left">Main settings</div>
			<div style="width:100%;text-align:right;">
			<img id="RMainContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('RMainContainerHeader','RMainContainer')" src="/images/arrow_up.png">
			</div>
		</caption>
		<tr valign="top">
			<td id="RMainContainer">
				<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
					<tr>
						<td colspan="2" class="infoTableHeader" width="200px">&nbsp;Controller connection</td>
					</tr>
					<tr>
						<td class="editLineParam">Address</td>
						<td class="editLineValue">
							<input name="edCtrlHost" type="text" value="<?php
							print($router_conf->ctrl->host)
							?>" maxlength="250" size="250" class="selectw170">
						</td>
					</tr>
				</table>

				<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
					<tr>
						<td colspan="2" class="infoTableHeader" width="200px">&nbsp;CDR (Call Detail Record)</td>
					</tr>
					<tr>
						<td class="editLineParam">Remote CDR receivers</td>
						<td class="editLineValue">
							<input name="edCtrl_CDR_hosts" type="text" value="<?php
							print($router_conf->ctrl->cdr_hosts)
							?>" maxlength="250" size="250" class="selectw170" title="Multiple addresses can be entered, space separated: 192.168.1.1:35500 192.168.1.2:35500"></td>
					</tr>
				</table>

				<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
					<tr>
						<td colspan="2" class="infoTableHeader" width="200px">&nbsp;Call session parameters</td>
					</tr>
					<tr>
						<td class="editLineParam">Session timeout, seconds</td>
						<td class="editLineValue">
							<input name="edCtrl_Session_timeout" type="text" value="<?php
							print($router_conf->ctrl->session_timeout)
							?>" maxlength="10" size="10" class="selectw" title="How many seconds should Router wait for a digit to find the right route">
						</td>
					</tr>
				</table>

				<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
					<tr>
						<td colspan="2" class="infoTableHeader" width="200px">&nbsp;Use redirect patterns</td>
					</tr>
					<tr>
						<td class="editLineParam">
							<a class="imglink" onClick="ToggleCheckBox('cbUse_Redirect_Patterns')">Use redirect patterns</a>
						</td>
						<td class="editLineValue">
							<input name="cbUse_Redirect_Patterns" id="cbUse_Redirect_Patterns" type="checkbox" 
							<?php if($router_conf->ctrl->use_redirect_patterns == "true") print("checked value='1'"); else print(" value='0'"); ?>
							class="selectw" title=""
							onchange="if(this.checked) this.value='1'; else this.value='0';">
						</td>
				</table>

				<!-- table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
					<tr>
						<td colspan="2" class="infoTableHeader" width="200px">&nbsp;Require DTMF</td>
					</tr>
					<tr>
						<td class="editLineParam">require incoming dtmf</td>
						<td class="editLineValue">
							<select name="edCtrl_incoming_DTMF" class="selectw">
								<*?php
									$require_dtmf = array(
										'yes' => 'true',
										'no' => 'false');
									foreach($require_dtmf as $require_name => $reqid) {
										printf("<option value=\"$reqid\"");
										if ($router_conf->ctrl->require_incoming_dtmf == $reqid)
											printf(" selected");
										printf(">$require_name</option>");
									}
								?>
							</select>
						</td>
					</tr>
					<tr>
						<td class="editLineParam">require outgoing dtmf</td>
						<td class="editLineValue">
							<select name="edCtrl_outgoing_DTMF" class="selectw">
								<*?php
									$require_dtmf = array(
										'yes' => 'true',
										'no' => 'false');
									foreach($require_dtmf as $require_name => $reqid) {
										printf("<option value=\"$reqid\"");
										if ($router_conf->ctrl->require_outgoing_dtmf == $reqid)
											printf(" selected");
										printf(">$require_name</option>");
									}
								?>
							</select>
						</td>
					</tr>
				</table -->

			<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
				<tr>
				<td colspan="2" class="infoTableHeader" width="100px">&nbsp;Consoles</td>
				</tr>

				<tr>
				<td class="editLineParam">PS1</td>
				<td class="editLineValue">
				<input name="edps1" type="text" value="<?php print($router_conf->ILConsoles->arrConsoles[0]->ps1) ?>" maxlength="50" size="20" class="selectw170">
				</td>
				</tr>

				<tr>
				<td class="editLineParam">Transport</td>
				<td class="editLineValue">
					
				<table class="editLineParam" name="edConsolesTransportTable" id="edConsolesTransportTable" style="padding: 0px;" >
				<tr><td>type</td><td>address</td></tr>
				</table>
				<table class="infoLineParam" style="padding: 0px;">
				<tr><td colspan=3 style="cursor:pointer; font-weight:bold; background:#ddd; padding-left: 10px;" onclick="addConsolesTransportRow();" title="Add new transport">+ Add</td></tr>
				</table>
				
				</td>
				</tr>
			</table>

			<?php
				reset($router_conf->ILConsoles->arrConsoles);
				$obj=current($router_conf->ILConsoles->arrConsoles);
				$arrtrans = explode(' ',trim($obj->transport));
				$trans = current($arrtrans);
				$script = "";
				while ($trans) {
					$param = explode(':',trim($trans));
					$script .= sprintf("addConsolesTransportRow('%s','%s');\n",
										$param[0],
										$param[1]
										);
					$trans=next($arrtrans);
				};
				if ($script != "") {
					printf("<script type=\"text/javascript\">\n");
					printf($script);
					printf("</script>\n");
				}
			?>

				<table class="nb" cellpadding="0" cellspacing="0" style="float:left;background:#f5f5f5">
					<tr>
						<td colspan="2" class="infoTableHeader" width="200px">&nbsp;End to End connection</td>
					</tr>
					<tr>
						<td class="editLineParam">YACP port</td>
						<td class="editLineValue">
							<input name="edCtrl_yacp_port" type="text" value="<?php
							print($router_conf->ctrl->yacp_port)
							?>" maxlength="10" size="10" class="selectw" title="">
						</td>
					</tr>
				</table>



			</td>
		</tr>
	</table>
</div>


<!------------------------------------------------------------------------------------>
<!--								Recorders:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('RecorderContainerHeader','RecorderContainer')">
	<div class="sec" style="display:inline;float:left">Recorders&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddRecorder();  doChangeEvent(); doSectionShow('RecorderContainerHeader','RecorderContainer');" title="Add Recorder" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="RecorderContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('RecorderContainerHeader','RecorderContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="RecorderContainer">
		<input name="hidRecorderCount" id="hidRecorderCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php
	reset($router_conf->recorder->arrRecorders);
	$obj = current($router_conf->recorder->arrRecorders);
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddRecorder(%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\");\n",
							-1,
							$obj->name,
							$obj->type,
							$obj->signalling,
							$obj->media,
							$obj->addr,
							$obj->port,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj = next($router_conf->recorder->arrRecorders);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>


<!------------------------------------------------------------------------------------>
<!--								Signalling targets:								-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('SignallingTargetsContainerHeader','SignallingTargetsContainer')">
	<div class="sec" style="display:inline;float:left">Signalling targets&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddTargetSignalling(-1,'','','','','','','','','','','','','','','','','','',0,'',''); 
	Signaling_List(); doChangeEvent();
	doSectionShow('SignallingTargetsContainerHeader','SignallingTargetsContainer');" title="Add Signalling target" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="SignallingTargetsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('SignallingTargetsContainerHeader','SignallingTargetsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="SignallingTargetsContainer">
		<input name="hidSignallingTargetCount" id="hidSignallingTargetCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php
	reset($router_conf->targets_signalling->arrSignallingTargets);
	$obj = current($router_conf->targets_signalling->arrSignallingTargets);
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddTargetSignalling(%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",%d,  \"%s\",\"%s\",\"%s\",  \"%s\",\"%s\");\n",
							-1,
							$obj->name,
							addslashes(htmlspecialchars($obj->called)),
							addslashes(htmlspecialchars($obj->caller)),
							$obj->codec_set,
							$obj->sigtype,
							$obj->sig_ss7_cg_category,
							$obj->sig_ss7_cg_nature,
							$obj->sig_ss7_cg_inetwork,
							$obj->sig_ss7_cg_plan,
							$obj->sig_ss7_cd_nature,
							$obj->sig_ss7_cd_plan,
							$obj->sig_isdn_cg_typeofnumber,
							$obj->sig_isdn_cg_plan,
							$obj->sig_isdn_cg_screeningind,
							$obj->sig_isdn_cd_typeofnumber,
							$obj->sig_isdn_cd_plan,
							$obj->sig_isdn_cd_screeningind,
							$obj->group,
							1,
							$obj->sig_ss7_subject,
							$obj->sig_ss7_priority,
							$obj->sig_ss7_media_service,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj = next($router_conf->targets_signalling->arrSignallingTargets);
	};
	if ($script != "") {
		$script .= sprintf("OnAddSignalling_Plus();");
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>


<!------------------------------------------------------------------------------------>
<!--									AK targets:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('AKTargetsContainerHeader','AKTargetsContainer')">
	<div class="sec" style="display:inline;float:left">AK targets&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddTargetAK(-1,'',null,null,'','',0,'',''); 
	TargetAK_List(); doChangeEvent();
	doSectionShow('AKTargetsContainerHeader','AKTargetsContainer');" title="Add AK target" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="AKTargetsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('AKTargetsContainerHeader','AKTargetsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="AKTargetsContainer">
		<input name="hidAKTargetCount" id="hidAKTargetCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php

	// ------------------------------------------------------------------
	// (0001924) Формирование списка доступных слотов
	// ------------------------------------------------------------------
	$aktarget_cnt = count($controller_conf->ILAKs->arrILAKs);
	$disable_bus = explode(',',$controller_conf->ILctrlobj->disable_bus);
	$slot_list = '';
	// (0001924) Список AK Configuration пуст, Disable bus = 8,...,31, тогда список AK targets - slot = 0,1,2,3,4,5,6,7
	if( $aktarget_cnt === 0 ){
		for ($i = 0; $i <= 31; $i++) {
			if( !in_array($i,$disable_bus) ){
				$slot_list .= $slot_list=='' ? $i : ','.$i; 
			}
		}
	// (0001924) Список AK Configuration - Slot = 0,1,2,3,4,5,6,7, Disable bus = 4,5,6,7, тогда список AK targets - slot = 0,1,2,3		
	} else {
		foreach ($controller_conf->ILAKs->arrILAKs as $key => $value) {
			if( !in_array($value->Slot,$disable_bus) ) $slot_list .= $slot_list=='' ? $value->Slot : ','.$value->Slot; 
		}
	}
	// ------------------------------------------------------------------


	reset($router_conf->targets_ak->arrAKTargets);
	$obj = current($router_conf->targets_ak->arrAKTargets);

	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddTargetAK(%d,\"%s\",%d,%d,\"%s\",\"%s\",'%s',\"%s\",\"%s\");\n",
							-1,
							$obj->name,
							$obj->slot,
							$obj->channel,
							//addslashes(htmlspecialchars($obj->income_caller_id)),
							//addslashes(htmlspecialchars($obj->outcome_caller_id)),
							addslashes(htmlspecialchars($obj->caller)),
							addslashes(htmlspecialchars($obj->called)),
							1,
							$slot_list,
							//$obj->recorders,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj = next($router_conf->targets_ak->arrAKTargets);
	};
	if ($script != "") {
		$script .= sprintf("OnAddTargetAK_Plus();");
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	printf("<input id=\"edAKTargets_slot_list\" type=\"hidden\" value=".$slot_list.">");
?>

<!-- table><tbody><tr><td>
<img  class="imglink" style="display:inline;float:left;margin-top:2px; width:100px;height:100px;" onClick="OnAddTargetAK();TargetAK_List();" title="Add AK target" src="/images/add_block.gif" >
</td></tr></tbody></table -->


<!------------------------------------------------------------------------------------>
<!--								Modem targets:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('ModemTargetsContainerHeader','ModemTargetsContainer')">
	<div class="sec" style="display:inline;float:left">Modem targets&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddTargetModem();doSectionShow('ModemTargetsContainerHeader','ModemTargetsContainer');" title="Add Modem target" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="ModemTargetsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('ModemTargetsContainerHeader','ModemTargetsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="ModemTargetsContainer">
		<input name="hidModemTargetCount" id="hidModemTargetCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php
	reset($router_conf->targets_modem->arrModemTargets);
	$obj = current($router_conf->targets_modem->arrModemTargets);
	$script = "";
//var_dump($obj);	
	while ($obj) {
		$script .= sprintf("OnAddTargetModem(%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\");\n",
							-1,
							$obj->name,
							$obj->originate,
							$obj->fax,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj = next($router_conf->targets_modem->arrModemTargets);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>


<!------------------------------------------------------------------------------------>
<!--								Connections:									-->
<!------------------------------------------------------------------------------------>
<?php
	$trunklist = " ";
	foreach($controller_conf->ILCASTrunks->arrCASTrunks AS $key => $elem){
		$trunklist .= ','.$elem->trunk;
	}
?>

<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('ConnectionContainerHeader','ConnectionContainer')">
	<div class="sec" style="display:inline;float:left">Connections&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddConnection(-1,'<?php echo $trunklist; ?>');doSectionShow('ConnectionContainerHeader','ConnectionContainer');" title="Add Connection" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="ConnectionContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('ConnectionContainerHeader','ConnectionContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="ConnectionContainer">
		<input name="hidConnectionCount" id="hidConnectionCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php

	// прверка вхождения транка и таймслота в формируемый список
	function ts_check_exist($tslist,$ts){
		$res = false;
		foreach ($tslist as $key => $val) {
			if( $val[0] == $ts[0] && $val[1] == $ts[1] ){
				$res = true;
				break;
			}
		}
		return $res;
	}


	reset($router_conf->connection->arrConnections);
	$obj = current($router_conf->connection->arrConnections);
//var_dump($obj);	
	$script = "";
	//$trunklist = "";
	while ($obj) {
		
		//emphone list (0001924)
		reset($controller_conf->ILEmPhones->arrILEmPhones);
		$emphonetrunk_obj=current($controller_conf->ILEmPhones->arrILEmPhones);
		$emphonetrunk = array();
		while ($emphonetrunk_obj) {
			array_push($emphonetrunk,$emphonetrunk_obj->trunk);
			$emphonetrunk_obj=next($controller_conf->ILEmPhones->arrILEmPhones);
		};
		
		/*
		//trunks list (0001924)
		reset($controller_conf->ILtrunks->arrILtrunks);
		$trunk_obj=current($controller_conf->ILtrunks->arrILtrunks);
		$trunklist_arr = array();
		while ($trunk_obj) {
			$trunkid = $trunk_obj->IDTrunk;
			if( !in_array($trunkid,$emphonetrunk) ){
				array_push($trunklist_arr,$trunkid);
			}
			$trunk_obj=next($controller_conf->ILtrunks->arrILtrunks);
		};
		sort($trunklist_arr,SORT_NUMERIC);
		$trunklist = implode(',', $trunklist_arr);
		*/

		/*
		$trunklist = '';
		foreach($controller_conf->ILCASTrunks->arrCASTrunks AS $key => $elem){
			$trunklist .= ','.$elem->trunk;
		}
		*/
		//var_dump($trunklist);







		// ------------------------------------------------------------------
		// (0001924) Формирование timeslot списка 
		// ------------------------------------------------------------------
		$timeslotlist_trunk = "";
		$timeslotlist = "";
		$tslist = array();

		// isdn timeslot list -----------------------------------------------
		$blocklist = $controller_conf->ILISDNTrunks->arrISDNTrunks;
		reset($blocklist);
		$block_obj = current($blocklist);
	
		while ($block_obj) {
			$ts = array($block_obj->trunk,$block_obj->timeslots);
			if(!ts_check_exist($tslist,$ts)){
				array_push($tslist,$ts);
			}
			if(!ts_check_exist($tslist,array($block_obj->trunk,16))){
				array_push($tslist,array($block_obj->trunk,16));
			}
			$block_obj=next($blocklist);
		};
		

		// isdn_qsig timeslot list ------------------------------------------
		$blocklist = $controller_conf->IL_ISDN_QSIGs->arr_ISDN_QSIG;
		reset($blocklist);
		$block_obj = current($blocklist);
		
		while ($block_obj) {
			$ts = array($block_obj->trunk,$block_obj->timeslots);
			if(!ts_check_exist($tslist,$ts)){
				array_push($tslist,$ts);
			}
			if(!ts_check_exist($tslist,array($block_obj->trunk,16))){
				array_push($tslist,array($block_obj->trunk,16));
			}
			$block_obj=next($blocklist);
		};


		// isdn_ats_qsig timeslot list ------------------------------------------
		$blocklist = $controller_conf->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG;
		reset($blocklist);
		$block_obj = current($blocklist);
		
		while ($block_obj) {
			if($block_obj->transport != 'E1 timeslot'){
				$block_obj=next($blocklist); 
				continue;
			}
			
			$ts = array($block_obj->trunk,$block_obj->timeslot);
			if(!ts_check_exist($tslist,$ts)){
				array_push($tslist,$ts);
			}
			
			$block_obj=next($blocklist);
		};


		// SS7 timeslot list ------------------------------------------
		reset($controller_conf->ILlinksets->arrILlinksets);
		$linkset_obj = current($controller_conf->ILlinksets->arrILlinksets);
		
		while ($linkset_obj) {
			//links
			$blocklist = $linkset_obj->links;
			reset($blocklist);
			$block_obj = current($blocklist);

			while ($block_obj) {
				$ts = array($block_obj->trunk,$block_obj->timeslot);
				if(!ts_check_exist($tslist,$ts)){
					array_push($tslist,$ts);
				}
				$block_obj=next($blocklist);
			};
			//isups
			$blocklist = $linkset_obj->isups;
			reset($blocklist);
			$block_obj = current($blocklist);

			while ($block_obj) {
				$ts = array($block_obj->trunk,$block_obj->timeslots);
				if(!ts_check_exist($tslist,$ts)){
					array_push($tslist,$ts);
				}
				$block_obj=next($blocklist);
			};
			
			$linkset_obj = next($controller_conf->ILlinksets->arrILlinksets);
		};


		// CAS timeslot list ------------------------------------------
		// условие убрано по задаче (0002153)
		/*reset($controller_conf->ILCASTrunks->arrCASTrunks);
		$cas_obj=current($controller_conf->ILCASTrunks->arrCASTrunks);
		while ($cas_obj) {
			//cas_channel
			$blocklist = $cas_obj->cas_channel;
			reset($blocklist);
			$block_obj = current($blocklist);

			while ($block_obj) {
				$ts = array($block_obj->trunk,$block_obj->timeslot);
				if(!ts_check_exist($tslist,$ts)){
					array_push($tslist,$ts);
				}
				$block_obj=next($blocklist);
			};
			$cas_obj=next($controller_conf->ILCASTrunks->arrCASTrunks);
		};*/


		// do timeslot string list ----------------------------------------------
		foreach ($tslist as $key => $val) {
			$timeslotlist_trunk .= empty($timeslotlist_trunk) ? $val[0] : ','.$val[0];
			$timeslotlist .= empty($timeslotlist) ? $val[1] : ','.$val[1];
		}


		//var_dump($timeslotlist);
		// ------------------------------------------------------------------
		// (0001924) Формирование timeslot списка (END)
		// ------------------------------------------------------------------




		
		
		$script .= sprintf("OnAddConnection(%d,\"%s\" ,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\");\n",
							-1,
							$trunklist,
							$obj->name,
							$obj->type,
							$obj->radio_rx_addr,
							$obj->radio_rx_port,
							$obj->radio_tx_addr,
							$obj->radio_tx_port,
							$obj->radio_tx_ttl,
							$obj->radio_tx_qos_dscp,
							$obj->radio_codec,
							$obj->radio_freq_no,
							$obj->radio_freq_chan,
							$obj->cas_trunk_no,
//							$trunklist,

							$obj->cas_trunk_timeslot,
							$timeslotlist_trunk,
							$timeslotlist,

							$obj->radio_bss_enable,
							$obj->radio_rx_delay_msec,
							$obj->radio_tx_delay_msec,
							$obj->radio_selcal_delay_msec,
							$obj->radio_selcal_sh_enable,

							$obj->vad_voice_th_msec,
							$obj->vad_silence_th_msec,
							$obj->vad_e_th_dB,

							$obj->radio_ng_enable,

							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);
		$obj = next($router_conf->connection->arrConnections);
	};
	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	printf("<input id=\"edConnection_cas_trunk_no_list\" type=\"hidden\" value=".$trunklist.">");
	printf("<input id=\"edConnection_cas_trunk_timeslotlist_trunk\" type=\"hidden\" value=".$timeslotlist_trunk.">");
	printf("<input id=\"edConnection_cas_trunk_timeslot_list\" type=\"hidden\" value=".$timeslotlist.">");
?>


<!------------------------------------------------------------------------------------>
<!--										Recorder Patterns:						-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('RecorderPatternContainerHeader','RecorderPatternContainer')">
	<div class="sec" style="display:inline;float:left">Recorder Patterns&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddRecorderPattern();doSectionShow('RecorderPatternContainerHeader','RecorderPatternContainer');" title="Add Recorder Pattern" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="RecorderPatternContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('RecorderPatternContainerHeader','RecorderPatternContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="RecorderPatternContainer">
		<input name="hidRecorderPatternSetCount" id="hidRecorderPatternSetCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>

<?php

/*
	// ------------------------------------------------------------------
	// (0001924) Формирование списка доступных слотов (при sign_type=ak)
	// ------------------------------------------------------------------
	$aktarget_cnt = count($controller_conf->ILAKs->arrILAKs);
	$disable_bus = explode(',',$controller_conf->ILctrlobj->disable_bus);
	$slot_list = '';
	// (0001924) Список AK Configuration пуст, Disable bus = 8,...,31, тогда список AK targets - slot = 0,1,2,3,4,5,6,7
	if( $aktarget_cnt === 0 ){
		for ($i = 0; $i <= 31; $i++) {
			if( !in_array($i,$disable_bus) ){
				$slot_list .= $slot_list=='' ? $i : ','.$i; 
			}
		}
	// (0001924) Список AK Configuration - Slot = 0,1,2,3,4,5,6,7, Disable bus = 4,5,6,7, тогда список AK targets - slot = 0,1,2,3		
	} else {
		foreach ($controller_conf->ILAKs->arrILAKs as $key => $value) {
			if( !in_array($value->Slot,$disable_bus) ) $slot_list .= $slot_list=='' ? $value->Slot : ','.$value->Slot; 
		}
	}


	// ------------------------------------------------------------------
	// (0001924) Формирование trunks list (при sign_type=trunk)
	// ------------------------------------------------------------------
	// только trunk-и с настроенным типом сигнализации
	// ------------------------------------------------------------------
	$trunklist_sig = array();
	// isdn timeslot list -----------------------------------------------
	$blocklist = $controller_conf->ILISDNTrunks->arrISDNTrunks;
	reset($blocklist);
	$block_obj = current($blocklist);
	while ($block_obj) {
		array_push($trunklist_sig,$block_obj->trunk);
		$block_obj=next($blocklist);
	};
	// isdn_qsig timeslot list ------------------------------------------
	$blocklist = $controller_conf->IL_ISDN_QSIGs->arr_ISDN_QSIG;
	reset($blocklist);
	$block_obj = current($blocklist);
	while ($block_obj) {
		array_push($trunklist_sig,$block_obj->trunk);
		$block_obj=next($blocklist);
	};
	// isdn_ats_qsig timeslot list --------------------------------------
	$blocklist = $controller_conf->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG;
	reset($blocklist);
	$block_obj = current($blocklist);
	while ($block_obj) {
		if($block_obj->transport == 'E1 timeslot'){
			array_push($trunklist_sig,$block_obj->trunk);
		}
		$block_obj=next($blocklist);
	};
	// SS7 timeslot list ------------------------------------------------
	reset($controller_conf->ILlinksets->arrILlinksets);
	$linkset_obj = current($controller_conf->ILlinksets->arrILlinksets);
	
	while ($linkset_obj) {
		//links
		$blocklist = $linkset_obj->links;
		reset($blocklist);
		$block_obj = current($blocklist);
		while ($block_obj) {
			array_push($trunklist_sig,$block_obj->trunk);
			$block_obj=next($blocklist);
		};
		//isups
		$blocklist = $linkset_obj->isups;
		reset($blocklist);
		$block_obj = current($blocklist);
		while ($block_obj) {
			array_push($trunklist_sig,$block_obj->trunk);
			$block_obj=next($blocklist);
		};
		$linkset_obj = next($controller_conf->ILlinksets->arrILlinksets);
	};
	// CAS timeslot list ------------------------------------------------
	reset($controller_conf->ILCASTrunks->arrCASTrunks);
	$cas_obj=current($controller_conf->ILCASTrunks->arrCASTrunks);
	while ($cas_obj) {
		//cas_channel
		$blocklist = $cas_obj->cas_channel;
		reset($blocklist);
		$block_obj = current($blocklist);
		while ($block_obj) {
			array_push($trunklist_sig,$block_obj->trunk);
			$block_obj=next($blocklist);
		};
		$cas_obj=next($controller_conf->ILCASTrunks->arrCASTrunks);
	};
	// emphone list -----------------------------------------------------
	$blocklist = $controller_conf->ILEmPhones->arrILEmPhones;
	reset($blocklist);
	$block_obj = current($blocklist);
	while ($block_obj) {
		array_push($trunklist_sig,$block_obj->trunk);
		$block_obj=next($blocklist);
	};
	// router connections -----------------------------------------------
	$blocklist = $router_conf->connection->arrConnections;
	reset($blocklist);
	$block_obj = current($blocklist);
	while ($block_obj) {
		array_push($trunklist_sig,$block_obj->cas_trunk_no);
		$block_obj=next($blocklist);
	};
	// ------------------------------------------------------------------
	// Result trunks list
	// ------------------------------------------------------------------
	reset($controller_conf->ILtrunks->arrILtrunks);
	$trunk_obj=current($controller_conf->ILtrunks->arrILtrunks);
	$trunklist_arr = array();
	while ($trunk_obj) {
		$trunkid = $trunk_obj->IDTrunk;
		if( in_array($trunkid,$trunklist_sig) ){
			array_push($trunklist_arr,$trunkid);
		}
		$trunk_obj=next($controller_conf->ILtrunks->arrILtrunks);
	};
	sort($trunklist_arr,SORT_NUMERIC);
	$trunklist = implode(',', $trunklist_arr);


	// ------------------------------------------------------------------
	// (0001924) Формирование timeslot списка 
	// ------------------------------------------------------------------
	$timeslotlist_trunk = "";
	$timeslotlist = "";
	$tslist = array();

	// isdn timeslot list -----------------------------------------------
	$blocklist = $controller_conf->ILISDNTrunks->arrISDNTrunks;
	reset($blocklist);
	$block_obj = current($blocklist);
	while ($block_obj) {
		$ts = array($block_obj->trunk,$block_obj->timeslots);
		if(!ts_check_exist($tslist,$ts)){
			array_push($tslist,$ts);
		}
		if(!ts_check_exist($tslist,array($block_obj->trunk,16))){
			array_push($tslist,array($block_obj->trunk,16));
		}
		$block_obj=next($blocklist);
	};
	// isdn_qsig timeslot list ------------------------------------------
	$blocklist = $controller_conf->IL_ISDN_QSIGs->arr_ISDN_QSIG;
	reset($blocklist);
	$block_obj = current($blocklist);
		
	while ($block_obj) {
		$ts = array($block_obj->trunk,$block_obj->timeslots);
		if(!ts_check_exist($tslist,$ts)){
			array_push($tslist,$ts);
		}
		if(!ts_check_exist($tslist,array($block_obj->trunk,16))){
			array_push($tslist,array($block_obj->trunk,16));
		}
		$block_obj=next($blocklist);
	};
	// isdn_ats_qsig timeslot list ------------------------------------------
	$blocklist = $controller_conf->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG;
	reset($blocklist);
	$block_obj = current($blocklist);
	while ($block_obj) {
		if($block_obj->transport != 'E1 timeslot'){
			$block_obj=next($blocklist); 
			continue;
		}
		$ts = array($block_obj->trunk,$block_obj->timeslot);
		if(!ts_check_exist($tslist,$ts)){
			array_push($tslist,$ts);
		}
			
		$block_obj=next($blocklist);
	};
	// SS7 timeslot list ------------------------------------------
	reset($controller_conf->ILlinksets->arrILlinksets);
	$linkset_obj = current($controller_conf->ILlinksets->arrILlinksets);
	while ($linkset_obj) {
		//links
		$blocklist = $linkset_obj->links;
		reset($blocklist);
		$block_obj = current($blocklist);
		while ($block_obj) {
			$ts = array($block_obj->trunk,$block_obj->timeslot);
			if(!ts_check_exist($tslist,$ts)){
				array_push($tslist,$ts);
			}
			$block_obj=next($blocklist);
		};
		//isups
		$blocklist = $linkset_obj->isups;
		reset($blocklist);
		$block_obj = current($blocklist);
		while ($block_obj) {
			$ts = array($block_obj->trunk,$block_obj->timeslots);
			if(!ts_check_exist($tslist,$ts)){
				array_push($tslist,$ts);
			}
			$block_obj=next($blocklist);
		};
		$linkset_obj = next($controller_conf->ILlinksets->arrILlinksets);
	};
	// CAS timeslot list ------------------------------------------
	reset($controller_conf->ILCASTrunks->arrCASTrunks);
	$cas_obj=current($controller_conf->ILCASTrunks->arrCASTrunks);
	while ($cas_obj) {
		//cas_channel
		$blocklist = $cas_obj->cas_channel;
		reset($blocklist);
		$block_obj = current($blocklist);
		while ($block_obj) {
			$ts = array($block_obj->trunk,$block_obj->timeslot);
			if(!ts_check_exist($tslist,$ts)){
				array_push($tslist,$ts);
			}
			$block_obj=next($blocklist);
		};
		$cas_obj=next($controller_conf->ILCASTrunks->arrCASTrunks);
	};

	//emphone list ------------------------------------------------
	$blocklist = $controller_conf->ILEmPhones->arrILEmPhones;
	reset($blocklist);
	$block_obj = current($blocklist);
	while ($block_obj) {
		for($i=1;$i<=16;$i++){
			if($block_obj->hdlc_timeslot!=$i){
				$ts = array($block_obj->trunk,$i);
			}
			array_push($tslist,$ts);
		}
		$block_obj=next($blocklist);
	};
	
	
	// ------------------------------------------------------------------
	// Result timeslot string list
	// ------------------------------------------------------------------
	foreach ($tslist as $key => $val) {
		$timeslotlist_trunk .= empty($timeslotlist_trunk) ? trim($val[0]) : ','.trim($val[0]);
		$timeslotlist .= empty($timeslotlist) ? trim($val[1]) : ','.trim($val[1]);
	}
*/	


// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Времянка. Формирование списков по условиям задачи 1924 пока закомментированы, из-за неприятия настройщиками.
// Далее 1924 будет переделана по принципу 1925 - вывод сообщений оператору о возникающих коллизиях.
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	// ------------------------------------------------------------------
	// (0001924) Формирование списка доступных слотов (при sign_type=ak)
	// ------------------------------------------------------------------
	$aktarget_cnt = count($controller_conf->ILAKs->arrILAKs);
	$disable_bus = explode(',',$controller_conf->ILctrlobj->disable_bus);
	$slot_list = '';
	// (0001924) Список AK Configuration пуст, Disable bus = 8,...,31, тогда список AK targets - slot = 0,1,2,3,4,5,6,7
	if( $aktarget_cnt === 0 ){
		for ($i = 0; $i <= 31; $i++) {
			//if( !in_array($i,$disable_bus) ){
				$slot_list .= $slot_list=='' ? $i : ','.$i; 
			//}
		}
	// (0001924) Список AK Configuration - Slot = 0,1,2,3,4,5,6,7, Disable bus = 4,5,6,7, тогда список AK targets - slot = 0,1,2,3		
	} else {
		foreach ($controller_conf->ILAKs->arrILAKs as $key => $value) {
			//if( !in_array($value->Slot,$disable_bus) ) $slot_list .= $slot_list=='' ? $value->Slot : ','.$value->Slot; 
			$slot_list .= $slot_list=='' ? $value->Slot : ','.$value->Slot; 
		}
	}

	// ------------------------------------------------------------------
	// Result trunks list
	// ------------------------------------------------------------------
	reset($controller_conf->ILtrunks->arrILtrunks);
	$trunk_obj=current($controller_conf->ILtrunks->arrILtrunks);
	$trunklist_arr = array();
	while ($trunk_obj) {
		$trunkid = $trunk_obj->IDTrunk;
		//if( in_array($trunkid,$trunklist_sig) ){
			array_push($trunklist_arr,$trunkid);
		//}
		$trunk_obj=next($controller_conf->ILtrunks->arrILtrunks);
	};
	sort($trunklist_arr,SORT_NUMERIC);
	$trunklist = implode(',', $trunklist_arr);
	// ------------------------------------------------------------------
	// Result timeslot string list
	// ------------------------------------------------------------------
	$timeslotlist_trunk = "";
	$timeslotlist = "";
	reset($trunklist_arr);
	foreach ($trunklist_arr as $key => $value){
		for($i=0;$i<=31;$i++){
			$timeslotlist_trunk .= empty($timeslotlist_trunk) ? $value : ','.$value;
			$timeslotlist .= empty($timeslotlist) ? strval($i) : ','.strval($i);
		}
	}
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	if(empty($trunklist)) $trunklist = " ";


	reset($router_conf->ILRecorderPatterns->arrILRecorderPatterns);
	$obj=current($router_conf->ILRecorderPatterns->arrILRecorderPatterns);
	//var_dump($router_conf->ILRecorderPatterns);
	//var_dump($obj);	return;
	$script = "";
	
	while ($obj) {
		//var_dump($obj); echo("<br><br>");
		$script .= sprintf("OnAddRecorderPattern(%d,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s');\n",
							-1,
							$obj->recorder_pattern_id,
							$obj->sign_type,
							$obj->slot,
							$slot_list,
							$obj->channel,
							$obj->trunk,
							$trunklist,
							$obj->timeslot,
							$timeslotlist_trunk,
							$timeslotlist,
							addslashes(htmlspecialchars($obj->caller)),
							addslashes(htmlspecialchars($obj->called)),
							$obj->name,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);

		reset($obj->recorder);
		$obj_int = current($obj->recorder);
		while ($obj_int) {
		//var_dump($obj_int);	echo "<br><br><br>";
			$script .= sprintf("OnAddPatternRec(%d,%d,'%s','%s','%s','%s','%s');\n",
								-1,
								$obj_int->recorder_pattern_id,
								$obj_int->server,
								addslashes(htmlspecialchars($obj_int->url_path)),
								addslashes(htmlspecialchars($obj_int->sdp_uri)),
								base64_encode($obj_int->GetCommentLines()),
								base64_encode($obj_int->GetUnknownLines())
								);
			$obj_int = next($obj->recorder);
		}
		
		$obj=next($router_conf->ILRecorderPatterns->arrILRecorderPatterns);
	};
	//var_dump($script);
	if ($script != "") {
		//$script .= sprintf("UpdateBoardControls_AKconfig();\n");
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	
	printf("<input id=\"edRecorderPattern_slot_list\" type=\"hidden\" value=".$slot_list.">");
	printf("<input id=\"edRecorderPattern_trunk_list\" type=\"hidden\" value=".$trunklist.">");
	
	printf("<input id=\"edRecorderPattern_trunk_timeslotlist_trunk\" type=\"hidden\" value=".$timeslotlist_trunk.">");
	printf("<input id=\"edRecorderPattern_trunk_timeslot_list\" type=\"hidden\" value=".$timeslotlist.">");
	
?>





<!------------------------------------------------------------------------------------>
<!--										Radio ED-137 Patterns:					-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('RadioED137PatternContainerHeader','RadioED137PatternContainer')">
	<div class="sec" style="display:inline;float:left">Radio ED-137 Patterns&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="doClearClick(event); OnAddRadioED137Pattern();doSectionShow('RadioED137PatternContainerHeader','RadioED137PatternContainer');" title="Add Radio ED-137 Pattern" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="RadioED137PatternContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('RadioED137PatternContainerHeader','RadioED137PatternContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="RadioED137PatternContainer">
		<input name="hidRadioED137PatternSetCount" id="hidRadioED137PatternSetCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>

<?php

	reset($router_conf->ILRadioED137Patterns->arrILRadioED137Patterns);
	$obj=current($router_conf->ILRadioED137Patterns->arrILRadioED137Patterns);
	//var_dump($router_conf->ILRadioED137Patterns);
	//var_dump($obj);	return;
	$script = "";
	
	while ($obj) {
		//var_dump($obj); echo("<br><br>");
		$script .= sprintf("OnAddRadioED137Pattern(%d,'%s','%s','%s','%s','%s','%s','%s','%s',    '%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s',    '%s','%s','%s');\n",
							-1,
							$obj->recorder_pattern_id,
							$obj->sign_type,
							$obj->slot,
							$obj->channel,
							$obj->trunk,
							$obj->timeslot,
							
							$obj->snmp_port,
							$obj->session_max_count,
							$obj->frequency,
							$obj->frequency_spacing,
							$obj->permission_enable,
							$obj->permission_normal,
							$obj->permission_emergency,
							$obj->climax_offset,
							$obj->rf_output_power,
							$obj->carrier_squ_threshold,
							$obj->sn_squ_threshold,
							$obj->squ_function,
							$obj->transmission_depend_on_squ,
							$obj->qos_dscp_for_voice,
							$obj->ptt_collision_handling,
							$obj->coupling_ptt_collision_handling,
							$obj->linked_session_support,
							
							$obj->name,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);

							//addslashes(htmlspecialchars($obj->caller)),
							//addslashes(htmlspecialchars($obj->called)),
		
		$obj=next($router_conf->ILRadioED137Patterns->arrILRadioED137Patterns);
	};
	//var_dump($script);
	if ($script != "") {
		//$script .= sprintf("UpdateBoardControls_AKconfig();\n");
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	
?>







<!------------------------------------------------------------------------------------>
<!--									Patterns:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption  onclick="doSectionSwitch('PatternsContainerHeader','PatternsContainer')">
	<div class="sec" style="display:inline;float:left">Patterns&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddPattern(-1,'','','',null,null,0,'','');Pattern_List(); doSectionShow('PatternsContainerHeader','PatternsContainer'); doChangeEvent();" title="Add pattern" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="PatternsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('PatternsContainerHeader','PatternsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="PatternsContainer">
		<input name="hidPatternCount" id="hidPatternCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>
<?php
	reset($router_conf->patterns->arrPatterns);
	$obj = current($router_conf->patterns->arrPatterns);
//var_dump($obj);	
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddPattern(%d,\"%s\",\"%s\",\"%s\",'%s',\"%s\",%d,\"%s\",\"%s\");\n",
							-1,
							$obj->name,
							addslashes(htmlspecialchars($obj->called)),
							addslashes(htmlspecialchars($obj->caller)),
							addslashes(htmlspecialchars($obj->group)),
							$obj->target,
							1,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);

							//addslashes(htmlspecialchars($obj->name)),

		//$script .= sprintf("addPatterntargetRow(%d);\n",-1);
							

		$obj = next($router_conf->patterns->arrPatterns);
	};
	

	if ($script != "") {
		$script .= sprintf("OnAddPattern_Plus();");
		$script .= "UpdatePatternControls();\n";
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	
	//echo var_dump($router_conf->patterns);
?>


<!------------------------------------------------------------------------------------>
<!--									Redirect Patterns:							-->
<!------------------------------------------------------------------------------------>
<!-- div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption>
	<div class="sec" style="display:inline;float:left">Redirect Patterns&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" onClick="OnAddRedirectPattern(-1,'','','',null,null,0,'','');RedirectPattern_List(); doSectionShow('RedirectPatternsContainerHeader','RedirectPatternsContainer'); doChangeEvent();" title="Add redirect pattern" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="RedirectPatternsContainerHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doSectionSwitch('RedirectPatternsContainerHeader','RedirectPatternsContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="RedirectPatternsContainer">
		<input name="hidRedirectPatternCount" id="hidRedirectPatternCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div -->
<?php/*
	reset($router_conf->redirect->arrRedirectPatterns);
	$obj = current($router_conf->redirect->arrRedirectPatterns);
	//var_dump($router_conf->redirect);	
	$script = "";
	while ($obj) {
		$script .= sprintf("OnAddRedirectPattern(%d,\"%s\",\"%s\",\"%s\",'%s',\"%s\",%d,\"%s\",\"%s\");\n",
							-1,
							addslashes(htmlspecialchars($obj->name)),
							addslashes(htmlspecialchars($obj->called)),
							addslashes(htmlspecialchars($obj->caller)),
							addslashes(htmlspecialchars($obj->group)),
							$obj->target,
							1,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);

		//$script .= sprintf("addPatterntargetRow(%d);\n",-1);
							

		$obj = next($router_conf->redirect->arrRedirectPatterns);
	};
	

	if ($script != "") {
		$script .= sprintf("OnAddRedirectPattern_Plus();");
		$script .= "UpdateRedirectPatternControls();\n";
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
	
	//echo var_dump($router_conf->redirect);*/
?>








<!--
	reset($router_conf->ILRecorderPatterns->arrILRecorderPatterns);
	$obj=current($router_conf->ILRecorderPatterns->arrILRecorderPatterns);
	//var_dump($router_conf->ILRecorderPatterns);
	//var_dump($obj);	return;
	$script = "";
	
	while ($obj) {
		//var_dump($obj); echo("<br><br>");
		$script .= sprintf("OnAddRecorderPattern(%d,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s');\n",
							-1,
							$obj->recorder_pattern_id,
							$obj->sign_type,
							$obj->slot,
							$slot_list,
							$obj->channel,
							$obj->trunk,
							$trunklist,
							$obj->timeslot,
							$timeslotlist_trunk,
							$timeslotlist,
							addslashes(htmlspecialchars($obj->caller)),
							addslashes(htmlspecialchars($obj->called)),
							$obj->name,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);

		reset($obj->recorder);
		$obj_int = current($obj->recorder);
		while ($obj_int) {
		//var_dump($obj_int);	echo "<br><br><br>";
			$script .= sprintf("OnAddPatternRec(%d,%d,'%s','%s','%s','%s','%s');\n",
								-1,
								$obj_int->recorder_pattern_id,
								$obj_int->server,
								addslashes(htmlspecialchars($obj_int->url_path)),
								addslashes(htmlspecialchars($obj_int->sdp_uri)),
								base64_encode($obj_int->GetCommentLines()),
								base64_encode($obj_int->GetUnknownLines())
								);
			$obj_int = next($obj->recorder);
		}
		
		$obj=next($router_conf->ILRecorderPatterns->arrILRecorderPatterns);
	};
-->

<!------------------------------------------------------------------------------------>
<!--								Phone Number Tables:							-->
<!------------------------------------------------------------------------------------>

<!-- // формирование списка каналов -->
<?php
	/*
	$channel_list = "";

	$tmpstr = "";
	foreach($controller_conf->ILISDNTrunks->arrISDNTrunks AS $key => $elem){
		$tmpstr .= '<option>'.$elem->isdn_name.'</option>';
	}
	if($tmpstr!="")	$channel_list .= "<optgroup label='isdn'>".$tmpstr."</optgroup>";

	$tmpstr = "";
	foreach($controller_conf->IL_ISDN_QSIGs->arr_ISDN_QSIG AS $key => $elem){
		$tmpstr .= '<option>'.$elem->isdn_name.'</option>';
	}
	if($tmpstr!="")	$channel_list .= "<optgroup label='isdn qsig'>".$tmpstr."</optgroup>";

	$tmpstr = "";
	foreach($controller_conf->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG AS $key => $elem){
		$tmpstr .= '<option>'.$elem->isdn_name.'</option>';
	}
	if($tmpstr!="")	$channel_list .= "<optgroup label='isdn ats qsig'>".$tmpstr."</optgroup>";
	*/

	//$channel_list="<option value=0>Zero</option><option value=1>One</option><option value=2>Two</option>";

	//$channel_list .= "<optgroup label='other'><option value='other'>other...</option></optgroup>";
	//var_dump($channel_list);


/*
	$channel_list = "";
	// isdn
	foreach($controller_conf->ILISDNTrunks->arrISDNTrunks as $key => $elem){
		$channel_list .= '<option>'.$elem->isdn_name.'</option>';
	}
	foreach($controller_conf->IL_ISDN_QSIGs->arr_ISDN_QSIG as $key => $elem){
		$channel_list .= '<option>'.$elem->isdn_name.'</option>';
	}
	foreach($controller_conf->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG as $key => $elem){
		$channel_list .= '<option>'.$elem->isdn_name.'</option>';
	}
	
	// cas
	foreach($controller_conf->ILCASTrunks->arrCASTrunks as $key => $elem){
		foreach($elem->cas_channel as $chkey => $ch){
			$channel_list .= '<option>'.$ch->channel_name.'</option>';
		}
	}

	// tone signaling
	foreach($controller_conf->ILToneTrunks->arrToneTrunks as $key => $elem){
		$channel_list .= '<option>'.$elem->tone_name.'</option>';
	}

	// ak
	foreach($controller_conf->ILAKs->arrILAKs as $key => $elem){
		foreach($elem->channel as $chkey => $ch){
			$channel_list .= '<option>'.$ch->name.'</option>';
		}
	}
*/


	$channel_list = '<option></option>';
	//$channel_list = '';
	// isdn
	foreach($controller_conf->ILISDNTrunks->arrISDNTrunks as $key => $elem){
		$timeslot = (empty($elem->timeslots) or strpos($elem->timeslots,',')>0) ? '' : '-'.$elem->timeslots;
		$resource_id = 'trunk-'.$elem->trunk.$timeslot;
		$channel_list .= '<option value='.$resource_id.'>'.$elem->isdn_name.'</option>';
	}
	foreach($controller_conf->IL_ISDN_QSIGs->arr_ISDN_QSIG as $key => $elem){
		$timeslot = (empty($elem->timeslots) or strpos($elem->timeslots,',')>0) ? '' : '-'.$elem->timeslots;
		$resource_id = 'trunk-'.$elem->trunk.$timeslot;
		$channel_list .= '<option value='.$resource_id.'>'.$elem->isdn_name.'</option>';
	}
	foreach($controller_conf->IL_ISDN_ATS_QSIGs->arr_ISDN_ATS_QSIG as $key => $elem){
		$timeslot = (empty($elem->timeslots) or strpos($elem->timeslots,',')>0) ? '' : '-'.$elem->timeslots;
		$resource_id = 'trunk-'.$elem->trunk.$timeslot;
		$channel_list .= '<option value='.$resource_id.'>'.$elem->isdn_name.'</option>';
	}
	
	// cas
	foreach($controller_conf->ILCASTrunks->arrCASTrunks as $key => $elem){
		foreach($elem->cas_channel as $chkey => $ch){
			$resource_id = 'trunk-'.$ch->trunk.'-'.$ch->timeslot;
			$channel_list .= '<option value='.$resource_id.'>'.$ch->channel_name.'</option>';
		}
	}

	// tone signaling
	foreach($controller_conf->ILToneTrunks->arrToneTrunks as $key => $elem){
		$timeslot = (empty($elem->timeslots) or strpos($elem->timeslots,',')>0) ? '' : '-'.$elem->timeslots;
		$resource_id = 'trunk-'.$elem->trunk.$timeslot;
		$channel_list .= '<option value='.$resource_id.'>'.$elem->tone_name.'</option>';
	}

	// ak
	foreach($controller_conf->ILAKs->arrILAKs as $key => $elem){
		foreach($elem->channel as $chkey => $ch){
			$resource_id = 'board-'.$ch->slot.'-'.$ch->id;
			$channel_list .= '<option value='.$resource_id.'>'.$ch->name.'</option>';
		}
	}



	//$res = iconv("UTF-8", "CP866", "АТСС" );
	//echo $res;
	//echo mb_internal_encoding();


?>


<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption  onclick="doSectionSwitch('PhoneNumberTablesHeader','PhoneNumberTablesContainer')">
	<div class="sec" style="display:inline;float:left">Phone Number Tables&nbsp;</div>
	<img class="imglink" style="display:inline;float:left;margin-top:2px" 
	onClick="doClearClick(event); OnAddPhoneNumberTable(-1,'','','',0,'<?php echo $channel_list; ?>','','');PhoneNumberTable_List(); doSectionShow('PhoneNumberTablesHeader','PhoneNumberTablesContainer'); doChangeEvent();" title="Add Phone Number Tables" src="/images/add.gif">
	<div style="width:100%;text-align:right;">
	<img id="PhoneNumberTablesHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('PhoneNumberTablesHeader','PhoneNumberTablesContainer')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top">
	<td id="PhoneNumberTablesContainer">
		<input name="hidPhoneNumberTableCount" id="hidPhoneNumberTableCount" type="hidden" value="0">
	</td>
</tr>
</table>
</div>

<?php

	reset($router_conf->phonenumbertables->arrPhoneNumberTable);
	$obj = current($router_conf->phonenumbertables->arrPhoneNumberTable);
	$script = "";
	while ($obj) {
		
		reset($obj->item);
		$item_obj = current($obj->item);
		$item_set = "";
		while ($item_obj) {
			if($item_obj->id == $obj->id) $item_set .= $item_obj->id . ',' . $item_obj->in . ',' . $item_obj->out . '|!|';
			$item_obj = next($obj->item);
		};
		
		
		$script .= sprintf("OnAddPhoneNumberTable(%d,%d,\"%s\",\"%s\",%d,\"%s\",\"%s\",\"%s\");\n",
							-1,
							$obj->id,
							addslashes(htmlspecialchars($obj->name)),
							$item_set,
							1,
							$channel_list,
							base64_encode($obj->GetCommentLines()),
							base64_encode($obj->GetUnknownLines())
							);

		$obj = next($router_conf->phonenumbertables->arrPhoneNumberTable);
	};
	

	if ($script != "") {
		$script .= sprintf("OnAddPhoneNumberTable_Plus('".$channel_list."');");
		$script .= "PhoneNumberTable_List();\n";
		printf("<script type=\"text/javascript\">\n");
		printf($script);
		printf("</script>\n");
	}

?>


<!------------------------------------------------------------------------------------>
<!--								Check patterns:									-->
<!------------------------------------------------------------------------------------>
<div class="secht">
<table class="nb" cellpadding="0" cellspacing="0" width="90%">
<caption onclick="doSectionSwitch('CheckPatternsHeader','CheckPatterns')">
	<div class="sec" style="display:inline;float:left">Check patterns&nbsp;</div>
	<div style="width:100%;text-align:right;">
	<img id="CheckPatternsHeader" showmode="1" class="imglink" style="margin-top:0px" onClick="doClearClick(event); doSectionSwitch('CheckPatternsHeader','CheckPatterns')" src="/images/arrow_up.png">
	</div>
</caption>
<tr valign="top" id="CheckPatterns">
	<td id="CheckPatternsContainer" style="width:170px;">
	</td>
	<td id="CheckPatternsResultContainer">
	</td>
</tr>
</table>
</div>
<?php
	
	$script = sprintf("OnAddCheckPatterns('".$_GET['pcalled']."','".$_GET['pcaller']."','".$_GET['pgroup']."');\n");
	$script .= sprintf("OnAddCheckPatternsResult();\n");
	$script .= sprintf("OnAddCheckPatternsMessage();\n");

	if ($script != "") {
		printf("<script type=\"text/javascript\">\n");
		printf("<!--\n");
		printf($script);
		printf("//-->\n");
		printf("</script>\n");
	}
?>


<div id="nullt">&nbsp;</div><div style="clear: both"></div>

<!--table class="nb">
<tr>

<td colspan="2" style="vertical-align:bottom">
<input type="submit" class="inputbt" name="drvApply" value=" Save changes " onclick=" var errmsg=onCheckBeforeSave(); if(errmsg!='') {alert(errmsg);return false;} ">
</td>
<td><span name="errmsg"></span><td>

</tr>
</table -->
<br><br><br><br><br><br><br><br><br><br><br><br>
<!-- div class="block-fixed">
<div class="block-fixed-footer">
<input type="submit" class="inputbt" name="drvApply" value=" Save changes " onclick=" var errmsg=onCheckBeforeSave(); if(errmsg!='') {alert(errmsg);return false;} ">
</div>
</div -->


<div class="block-fixed">
<div class="block-fixed-footer">


<!-- div id="div_infoview"></div>
<table id="div_infoview_ignore" class="nb" style="display:none;">
<tr style="vertical-align:middle">
<td><input type="checkbox" name="cbSaveAnyway" id="cbSaveAnyway" value="0" onchange="onCheckClick('cbSaveAnyway');"></td>
<td><a class="imglink" id="acbSaveAnyway" onClick="ToggleCheckBox('cbSaveAnyway');">Save ignoring warnings</a></td>
</tr>
</table -->
<div id="div_infoview"></div>
<table id="div_infoview_ignore" class="nb" style="display:none;">
<tr style="vertical-align:middle">
<td><input type="checkbox" name="cbSaveAnyway" id="cbSaveAnyway" value="0" onchange=""></td>
<td><a class="imglink" id="acbSaveAnyway" onClick="ToggleCheckBox('cbSaveAnyway');">Save ignoring warnings</a></td>
</tr>
</table>


<table class="nb">
<tr style="vertical-align:middle">
<td  colspan="2"><input type="hidden" name="cbRebootRouter" id="cbRebootRouter" value="0"></td>
</tr>
<tr>

<td colspan="1" style="vertical-align:bottom">
<input type="submit" class="inputbt" name="drvApply" value=" Save " onclick="onSaveClick(); var errmsg=onCheckBeforeSave(); if(errmsg!='') {alert(errmsg);return false;} else {onPreSaveSetting(this);}">
</td>
<td colspan="1" style="vertical-align:bottom">
<input type="submit" class="inputbt" name="drvApplyRestart" value=" Save & Restart " onclick="onSaveClick(); var errmsg=onCheckBeforeSave(); if(errmsg!='') {alert(errmsg);return false;} else {onPreSaveSetting(this); onSaveClick();}">
</td>

</tr>
</table>
</div>
</div>




<script type="text/javascript">
doSectionCountCheck('SignallingTargetsContainerHeader','SignallingTargetsContainer','Signalling',0);
doSectionCountCheck('AKTargetsContainerHeader','AKTargetsContainer','AKTarget',0);
doSectionCountCheck('ModemTargetsContainerHeader','ModemTargetsContainer','ModemTarget',0);
doSectionCountCheck('ConnectionContainerHeader','ConnectionContainer','Connection',0);
doSectionCountCheck('RecorderContainerHeader','RecorderContainer','Recorder',0);
doSectionCountCheck('PatternsContainerHeader','PatternsContainer','Pattern',0);
doSectionCountCheck('PhoneNumberTablesHeader','PhoneNumberTablesContainer','PhoneNumberTable',0);
doSectionCountCheck('RecorderPatternContainerHeader','RecorderPatternContainer','RecorderPattern',0);
doSectionCountCheck('RadioED137PatternContainerHeader','RadioED137PatternContainer','RadioED137Pattern',0);
//doSectionCountCheck('RedirectPatternsContainerHeader','RedirectPatternsContainer','RedirectPattern',0);

TargetAK_List();
Pattern_List();
//RedirectPattern_List();
Signaling_List();
if(getCookie('RMainContainerHeader')!=1) doSectionHide('RMainContainerHeader','RMainContainer');
if(getCookie('SignallingTargetsContainerHeader')!=1) doSectionHide('SignallingTargetsContainerHeader','SignallingTargetsContainer');
if(getCookie('AKTargetsContainerHeader')!=1) doSectionHide('AKTargetsContainerHeader','AKTargetsContainer');
if(getCookie('ModemTargetsContainerHeader')!=1) doSectionHide('ModemTargetsContainerHeader','ModemTargetsContainer');
if(getCookie('ConnectionContainerHeader')!=1) doSectionHide('ConnectionContainerHeader','ConnectionContainer');
if(getCookie('RecorderContainerHeader')!=1) doSectionHide('RecorderContainerHeader','RecorderContainer');
if(getCookie('PatternsContainerHeader')!=1) doSectionHide('PatternsContainerHeader','PatternsContainer');
if(getCookie('PhoneNumberTablesHeader')!=1) doSectionHide('PhoneNumberTablesHeader','PhoneNumberTablesContainer');
if(getCookie('CheckPatternsHeader')!=1) doSectionHide('CheckPatternsHeader','CheckPatterns');
if(getCookie('RecorderPatternContainerHeader')!=1) doSectionHide('RecorderPatternContainerHeader','RecorderPatternContainer');
if(getCookie('RadioED137PatternContainerHeader')!=1) doSectionHide('RadioED137PatternContainerHeader','RadioED137PatternContainer');
//if(getCookie('RedirectPatternsContainerHeader')!=1) doSectionHide('RedirectPatternsContainerHeader','RedirectPatternsContainer');
//alert( document.cookie );
</script>



</form>

<?php require_once(dirname(__FILE__).'/common_footer.inc'); ?>
</body>
</html>
