<?php

//require_once(dirname(__FILE__).'/session.cgi');
//var_dump($session);

function CheckAccess(&$errCode) {
	require_once(dirname(__FILE__).'/ssn_controls.inc');
	$sIP = $_SERVER['REMOTE_ADDR'];
	$sSID = $_COOKIE['IL_SID'];
	$aSSNFile = new CustomSSNFile();
	$aSSNFile->CheckAllSessions();
	$sSTATE = $aSSNFile->GetSessionState($sSID, $sIP);
	if ($sSTATE === 100) {
		$aSSNFile->SetSessionState($sSID, $sIP, $sSTATE);
		return true;
	} else {
		$errCode = 0;
		return false;
	};
};

function DoLogout() {
	require_once(dirname(__FILE__).'/ssn_controls.inc');
	$sIP = $_SERVER['REMOTE_ADDR'];
	$sSID = $_COOKIE['IL_SID'];
	$aSSNFile = new CustomSSNFile("/var/boa_sessions");
	return $aSSNFile->DeleteSession($sSID, $sIP);
};

/*
function CheckRootPassword($user_password) {
	$passwordFileName = '/etc/shadow';
	$md5HASH = '';
	$userName = 'root';
	// find HASH
	$fPassword = fopen($passwordFileName, 'r');
	if ($fPassword) {
		while (!feof($fPassword)) {
			$sLN = fgets($fPassword);
			$arrDiv = explode(':', $sLN);
			if (trim($arrDiv[0]) === $userName) {
				$md5HASH = $arrDiv[1];
				break;
			};
		};
		fclose($fPassword);
	} else {
		// imposible!!!
		return false;
	};
	return (bool)($md5HASH === crypt($user_password, $md5HASH));
};

function DoLogin($sUSR, $sPSWD) {
	// $res values:
	//  1 - successfully logging
	//  0 - access deny
	// -1 - expired time to logging
	// -2 - expired count to logging
	// -3 - system error while logging
	require_once(dirname(__FILE__).'/ssn_controls.inc');
	$logLIMIT = 3;
	$sIP = $_SERVER['REMOTE_ADDR'];
	$sSID = $_COOKIE['IL_SID'];
	$aSSNFile = new CustomSSNFile("/var/boa_sessions");
	$sSTATE = $aSSNFile->GetSessionState($sSID, $sIP);
	$res = -1;
	if ($sSTATE > -1) {
		if ($sSTATE < $logLIMIT) {
			$res = (int)CheckRootPassword($sPSWD);
			if ($res)
				$sSTATE = 100;
			else
				$sSTATE++;
			if (!$aSSNFile->SetSessionState($sSID, $sIP, $sSTATE)) {
				$res = -3;
			};
		} else {
			$res = -2;
		};
	};
	// print_r($_COOKIE);
	return $res;
};
*/




/*
function CheckRootPassword($userName,$user_password) {
	require_once(dirname(__FILE__).'/conf_websetup.inc');
	if (file_exists(WEBSETUPCONFFILE)) {
		$web_conf = new WebSetupConfFile(WEBSETUPCONFFILE);
		if(empty($web_conf->userconf->arrUserConfs)) defaultWebSetup();
	} else { 
		defaultWebSetup(); 
	}
	$web_conf = new WebSetupConfFile(WEBSETUPCONFFILE);
	
	$md5HASH = '';
	if( empty($web_conf->userconf->arrUserConfs) ) return false;
	foreach ( $web_conf->userconf->arrUserConfs as $key => $value) {
		if($value->user == $userName){
			$md5HASH = $value->pass;
			break;
		}
	}
	return (bool)($md5HASH === crypt($user_password, $md5HASH));
};
*/
function CheckRootPassword($userName,$user_password) {
	$res = false;
	require_once(dirname(__FILE__).'/conf_websetup.inc');
	if (file_exists(WEBSETUPCONFFILE)) {
		$web_conf = new WebSetupConfFile(WEBSETUPCONFFILE);
		if(empty($web_conf->userconf->arrUserConfs)) defaultWebSetup();
	} else { 
		defaultWebSetup(); 
	}
	$web_conf = new WebSetupConfFile(WEBSETUPCONFFILE);
	
	// детектор пользователя и его пароля
	$pass_hash = '';
	if( empty($web_conf->userconf->arrUserConfs) ) return false;
	foreach ( $web_conf->userconf->arrUserConfs as $key => $value) {
		if($value->user == $userName){
			$pass_hash = $value->pass;
			break;
		}
	}

	// проверка пароля зашифрованного методом md5
	$res = (bool)($pass_hash === crypt($user_password, $pass_hash));
	if($res) return $res;
	
	// проверка пароля зашифрованного методом aes256
	if(function_exists('openssl_get_cipher_methods') && file_exists('/etc/private/websetup.key')){
		if(proc_check_avalable_encryption('AES-256-CBC') && !empty($pass_hash)) {
			$key_base64 = file_get_contents('/etc/private/websetup.key');
			$iv = substr($key_base64, 0, 16);
			$key = base64_decode($key_base64);
			$meth='AES-256-CBC';
			$user_password = base64_encode(openssl_encrypt($user_password, $meth, $key, 0, $iv));
			if($user_password==$pass_hash) $res=true;
		}
	}
	if($res) return $res;

	// проверка пароля зашифрованного методом bf-cbc
	if(function_exists('openssl_get_cipher_methods') && file_exists('/etc/private/websetup.key')){
		if(proc_check_avalable_encryption('bf-cbc') && !empty($pass_hash)) {
			$meth='BF-CBC';
			$key_base64 = file_get_contents('/etc/private/websetup.key');
			$ivlen = openssl_cipher_iv_length('BF-CBC');
			$iv = substr($key_base64, 0, $ivlen);
			$enkey = base64_decode($key_base64);
			$user_password = base64_encode(openssl_encrypt($user_password, $meth, $enkey, OPENSSL_RAW_DATA | OPENSSL_ZERO_PADDING, $iv));
			$user_password = str_replace('=','$',$user_password);
			if($user_password==$pass_hash) $res=true;
		}
	}
	
	return $res;
	
}

// проверка наличия метода шифрования
function proc_check_avalable_encryption($meth){
	$res = false;
	if(function_exists('openssl_get_cipher_methods')){
		$avalible_methods = openssl_get_cipher_methods();
		foreach ($avalible_methods as $key => $value) {
			if( $value == $meth ) $res = true;
			//var_dump($value);var_dump('<br>');
		}
		// проверка для метода aes256 наличия файла ключа
		if( $meth=='AES-256-CBC' && !file_exists('/etc/private/websetup.key')) $res = false;
		if( $meth=='bf-cbc' && !file_exists('/etc/private/websetup.key')) $res = false;
	}
	return $res;
}

/*
// Сброс настроек websetup.conf по-умолчанию. Переход на новую систему авторизации, с суперпользователя на web-пользователей.
// Если есть доступ к суперпользователю, то берем данные его учетки, иначе устанавливаем по-умолчанию root, 12345
function defaultWebSetup(){
	$passwordFileName = '/etc/shadow';
	$userName = 'root';
	$md5HASH = '';
	// если есть доступ к суперпользователю, то переносим данные его аккаунта
	if (file_exists($passwordFileName)) {
		$fPassword = fopen($passwordFileName, 'r');
		if ($fPassword) {
			while (!feof($fPassword)) {
				$sLN = fgets($fPassword);
				$arrDiv = explode(':', $sLN);
				if (trim($arrDiv[0]) === $userName) {
					$md5HASH = $arrDiv[1];
					break;
				};
			};
			fclose($fPassword);		
		}	
	}
	if(empty($md5HASH)) $md5HASH = crypt('12345', '$1$wellcome');

	$content = '[sysuser]'.PHP_EOL.'uid=1'.PHP_EOL.'user='.$userName.PHP_EOL.'name=Default account needs to be changed'.PHP_EOL.'pass='.$md5HASH;
	file_put_contents(WEBSETUPCONFFILE, $content);
}
*/

// Сброс настроек websetup.conf по-умолчанию. 
function defaultWebSetup(){
	$user_name = 'user0';
	$user_pass = '1234';
	

	// aes256 если не доступно, то md5
	$meth='AES-256-CBC';
	$res = false;
	if(function_exists('openssl_get_cipher_methods')){
		$avalible_methods = openssl_get_cipher_methods();
		foreach ($avalible_methods as $key => $value) {
			if( $value == $meth ) $res = true;
		}
		// проверка для метода aes256 наличия файла ключа
		if( $meth=='AES-256-CBC' && !file_exists('/etc/private/websetup.key')) $res = false;
	}
	if($res){
		$key_base64 = file_get_contents('/etc/private/websetup.key');
		$iv = substr($key_base64, 0, 16);
		$key = base64_decode($key_base64);
		$user_pass = base64_encode(openssl_encrypt($user_pass, $meth, $key, 0, $iv));
	} else {
		// md5
		$user_pass = crypt($user_pass, '$1$wellcome');
	}


	$content = '[sysuser]'.PHP_EOL.'uid=1'.PHP_EOL.'user='.$user_name.PHP_EOL.'name=Default account needs to be changed'.PHP_EOL.'pass='.$user_pass;
	file_put_contents(WEBSETUPCONFFILE, $content);
}




function DoLogin($sUSR, $sPSWD) {
	// $res values:
	//  1 - successfully logging
	//  0 - access deny
	// -1 - expired time to logging
	// -2 - expired count to logging
	// -3 - system error while logging
	require_once(dirname(__FILE__).'/ssn_controls.inc');
	$logLIMIT = 3;
	$sIP = $_SERVER['REMOTE_ADDR'];
	$sSID = $_COOKIE['IL_SID'];
	$aSSNFile = new CustomSSNFile("/var/boa_sessions");
	$sSTATE = $aSSNFile->GetSessionState($sSID, $sIP);
	$res = -1;
	if ($sSTATE > -1) {
		if ($sSTATE < $logLIMIT) {
			$res = (int)CheckRootPassword($sUSR,$sPSWD);
			if ($res)
				$sSTATE = 100;
			else
				$sSTATE++;
			if (!$aSSNFile->SetSessionState($sSID, $sIP, $sSTATE)) {
				$res = -3;
			};
		} else {
			$res = -2;
		};
	};
	//print_r($_COOKIE);
	return $res;
};



function printMainPage($PagesScript, $WorkScript) {
	print "<html>\n";
	print "<head>\n";
	print "<meta http-equiv='pragma' content='no-cache'>\n";
	print "<meta http-equiv='Cache-Control' content='no-cache'>\n";
	print "<meta http-equiv='expires' content='-1'>\n";
	print "<title>Hardware v5.0 control interface</title>\n";
	print "<script language='JavaScript' type='text/JavaScript' src='/il.js'></script>\n";
	print "<link rel='stylesheet' type='text/css' href='/il.css' media='screen'>\n";
	print "<style type='text/css' media='screen'>\n";
	print "  <!-- @import '/il.css'; -->\n";
	print "</style>\n";
	print "</head>\n";
	print "<frameset rows='40,*' cols='*' framespacing='0' frameborder='no' border='0'>\n";
	print " <frame src='" . $PagesScript;
	print "' name='topFrame' scrolling='no' noresize >\n";
	print " <frame src='" . $WorkScript;
	print "' name='mainFrame'>\n";
	print "</frameset>\n";
	print "<noframes>\n";
	print "<body>\n";
	print "</body>\n";
	print "</noframes>\n";
	print "</html>\n";
};

function printAccessDenied($reason) {
	// TODO: not supported atm - full access!!!
	switch ($reason) {
		case -1:
			header("Location: /denied.html");
			break;
		case 0:
			header("Location: /denied.html");
			break;
		default:
			print "Login error ($reason)<br>\n";
			break;
	}
};

?>
