<?php
require_once(dirname(__FILE__).'/conf_types.inc');
define("WEBSETUPCONFFILE", '/usr/local/etc/websetup.conf');


//-------------------------------------------------------------------------------------------- 

class User_conf extends CustomSection {
	public $uid  = "";
	public $user = "";
	public $name  = "";
	public $pass  = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "uid=" . $this->uid . "\n"
				. "user=" . $this->user . "\n"
				. "name=" . $this->name . "\n"
				. "pass=" . $this->pass . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "uid")
					$this->uid = $sValue;
				elseif ($sName === "user")
					$this->user = $sValue;
				elseif ($sName === "name")
					$this->name = $sValue;
				elseif ($sName === "pass")
					$this->pass = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class User_confs  {
	public $arrUserConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new User_conf();
		$this->arrUserConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrUserConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrUserConfs[$i++]) {
			$sRes = $sRes . "[sysuser]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrUserConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

//-------------------------------------------------------------------------------------------- 


class Snmp_conf extends CustomSection {
	public $snmp_state  = "";
	public $snmp_receiver1  = "";
	public $snmp_receiver2  = "";
	public $snmp_port  = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "snmp_state=" . $this->snmp_state . "\n"
				. "snmp_receiver1=" . $this->snmp_receiver1 . "\n"
				. "snmp_receiver2=" . $this->snmp_receiver2 . "\n"
				. "snmp_port=" . $this->snmp_port . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "snmp_state")
					$this->snmp_state = $sValue;
				elseif ($sName === "snmp_receiver1")
					$this->snmp_receiver1 = $sValue;
				elseif ($sName === "snmp_receiver2")
					$this->snmp_receiver2 = $sValue;
				elseif ($sName === "snmp_port")
					$this->snmp_port = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Snmp_confs {
	public $arrSnmpConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Snmp_conf();
		$this->arrSnmpConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrSnmpConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrSnmpConfs[$i++]) {
			$sRes = $sRes . "[snmp]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrSnmpConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

//-------------------------------------------------------------------------------------------- 


# ######################################
class WebSetupConfFile extends CustomConfFile {
	public $userconf;
	public $snmpconf;
	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->userconf = new User_confs();
		$this->snmpconf = new Snmp_confs();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "sysuser")
				$this->userconf->AddAsSection($sSectionValues);
			elseif ($sSectionName === "snmp")
				$this->snmpconf->AddAsSection($sSectionValues);
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for common.conf\n");

		$this->PutLine($this->userconf->GetAsSections());
		$this->PutLine($this->snmpconf->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};

		$this->copyBufferToConf();
	}
	
};


?>
