<?php
define("HARDSCRIPTFILE", "/usr/local/etc/interlink.sh");
define("HARDSCRIPTFILE_BAK", HARDSCRIPTFILE . ".bak");
define("ILSERVERFILE", "/usr/local/sbin/server");
define("ILVMANFILE", "/usr/local/sbin/vman");
define("ILCONTROLLERFILE", "/usr/local/sbin/controller");
define("STATS_CONTROLLER", "/var/log/controller-status.html");
define("ILROUTERFILE", "/usr/local/sbin/router");

define("NETWORKCONFIGFILE", "/etc/network.config");
define("SYSTEMCONFIGFILE", "/etc/system.conf");
define("HOSTNAMEFILE", "/etc/HOSTNAME");
define("ETCHOSTS", "/etc/hosts");
define("NETWORKCONFIGFILE_BAK", NETWORKCONFIGFILE.".bak");
define("SYSTEMCONFIGFILE_BAK", SYSTEMCONFIGFILE.".bak");
define("HOSTNAMEFILE_BAK", HOSTNAMEFILE.".bak");
define("ETCHOSTS_BAK", ETCHOSTS.".bak");

//define("SYSLOGFILE", "/usr/local/etc/syslog.conf");
define("SYSLOGFILE", "/etc/syslog.conf");
define("SYSLOGFILE_BAK", SYSLOGFILE.".bak");

define("ECCOEFFS_MONITORING_DIR","/var/monitoring/ec_coeffs");
define("ECCOEFFS_ETC_DIR","/usr/local/etc/ec_coeffs");

define("HOSTNAME", "/etc/hostname");


function getCPUInfo() {
	$fp = fopen("/proc/cpuinfo", "r");
	if ($fp) {
		$sChipName = "Unknown chip";
		while (!feof($fp)) {
			$sTMP = fgets($fp);
			if ($sTMP) {
				list($sName, $sValue) = explode(":", $sTMP, 2);
				$sName = trim($sName);
				if($sName==="chip")     $sChipName = trim($sValue);
				if($sName==="cpu")      $sCPU      = trim($sValue);
				if($sName==="revision") $sRevision = trim($sValue);
			} else {
				break;
			}
		};
		if ($sChipName === "Unknown chip") $sChipName = "MPC".$sCPU." [".$sRevision."]";
	};
  print($sChipName);
	if ($fp) fclose($fp);
};

function getSomeMemInfo($sMemType) {
	$fp = fopen("/proc/meminfo", "r");
	$sMEM = "UNKNOWN";
	if ($fp) {
		while (!feof($fp)) {
			$sTMP = fgets($fp);
			if ($sTMP) {
				list($sName, $sValue) = explode(":", $sTMP, 2);
				$sName = trim($sName);
				if ($sName === $sMemType) {
					$sMEM = trim($sValue);
					break;
				};
			} else {
				break;
			};
		};
		$sMEM = sprintf("%s", $sMEM);
	};
	print $sMEM;
	if ($fp)
		fclose($fp);
};

function getRAMInfo() {
	getSomeMemInfo("MemTotal");
};

function getFlushInfo() {
	$fp = fopen("/proc/mtd", "r");
	$sFLASH = "UNKNOWN";
	if ($fp) {
		while (!feof($fp)) {
			$sTMP = fgets($fp);
			if ($sTMP) {
				list($sName, $sValue) = explode(":", $sTMP, 2);
				$sName = trim($sName);
				if ($sName === "mtd0") {
					$sFLASH = trim($sValue);
					list($sName, $sValue, $sFLASH) = explode(" ", $sFLASH, 3);
					break;
				};
			} else {
				break;
			};
		};
		$sFLASH = sprintf("%s", $sFLASH);
	};
	print $sFLASH;
	if ($fp)
		fclose($fp);
};

function getDSPCount() {
	$iDSP = 0;
	$eLVL = error_reporting();
	error_reporting($eLVL ^ E_WARNING); #OFF WARNINGS
	do {
		$fp = fopen("/proc/voice/mcc/dec-" . ((string)$iDSP), "r");
		if ($fp) {
			$iDSP++;
			fclose($fp);
		} else {
			break;
		};
	} while (true);
	error_reporting($eLVL);
	return $iDSP;
};

function getDSPInfo() {
  $a = getDSPCountEx();
	printf("%d", $a);
	if($a>0)print(" [DSP 4.2]");
};


function getFRAMERInfo() {
	$iE1 = 0;
	$sE1 = "Unknown type";
	$eLVL = error_reporting();
	error_reporting($eLVL ^ E_WARNING); #OFF WARNINGS
	do {
		$fp = fopen("/proc/driver/hdlc/peb22554/" . ((string)$iE1), "r");
		if ($fp) {
			// PPC
			$iE1++;
			fclose($fp);
			$sE1 = "peb22554";
		} else {
			// 486
			$fp = fopen("/proc/driver/hdlc-drv/ds21x54/" . ((string)$iE1), "r");
			if ($fp) {
				$iE1++;
				fclose($fp);
				$sE1 = "ds21x54";
			} else {
				break;
			};
		};
	} while (true);
	error_reporting($eLVL);
	printf("%d [%s]", $iE1, $sE1);
};

function getOSVersionInfo() {
	$fp = fopen("/proc/version", "r");
	$sOS = "UNKNOWN";
	if ($fp) {
		$sTMP = fgets($fp);
		if ($sTMP) {
			list($sName, $sValue, $sOS, $sTMP) = explode(" ", $sTMP, 4);
			$sOS = sprintf("%s [%s %s]", $sName, $sValue, $sOS);
		};
		fclose($fp);
	};
	print $sOS;
};

function getFSVersionInfo() {
	$fp = fopen("/etc/fs.tag", "r");
	$sFS = "UNKNOWN";
	if ($fp) {
		$sFS = fgets($fp);
		fclose($fp);
	};
	print $sFS;
};

function getRTPInfo() {
	$eLVL = error_reporting();
	error_reporting($eLVL ^ E_WARNING); #OFF WARNINGS
	$fp = fopen("/proc/voice/version", "r");
	error_reporting($eLVL);
	$sRTP = "ABSENT";
	if ($fp) {
		$sTMP = fgets($fp);
		if ($sTMP) {
			list($sTMP, $sVersion, $sValue, $sRTP, $sTMP) = explode(" ", $sTMP, 5);
			$sRTP = sprintf("%s [%s %s]", $sVersion, $sValue, $sRTP);
		};
		fclose($fp);
	};
	print $sRTP;
};

function getCodecVersionInfo($aCodec) {
	$eLVL = error_reporting();
	error_reporting($eLVL ^ E_WARNING); #OFF WARNINGS
	$fp = fopen("/proc/voice/version", "r");
	error_reporting($eLVL);
	$sCodec = "ABSENT";
	if ($fp) {
		fgets($fp);
		fgets($fp);
		while (!feof($fp)) {
			$sTMP = fgets($fp);
			if ($sTMP) {
				list($sTMP, $sName, $sVersion, $sValue, $sBuild, $sTMP) = explode("\t", $sTMP, 6);
				$sName = trim($sName);
				if ($sName === $aCodec) {
					$sCodec = sprintf("v%s.%s [capacity: %s channels on DSP]", $sVersion, $sBuild, $sValue);
					break;
				};
			} else {
				break;
			};
		};
		fclose($fp);
	};
	print $sCodec;
};

function getG711VersionInfo() {
	getCodecVersionInfo("g711");
};

function getG723VersionInfo() {
	getCodecVersionInfo("g723");
};

function getG729VersionInfo() {
	getCodecVersionInfo("g729");
};

function getG711mVersionInfo() {
	getCodecVersionInfo("g711m");
};

function getMODEMVersionInfo() {
	$eLVL = error_reporting();
	error_reporting($eLVL ^ E_WARNING); #OFF WARNINGS
	$fp = fopen("/proc/modem/version", "r");
	error_reporting($eLVL);
	$sMODEM = "ABSENT";
	if ($fp) {
		$sTMP = fgets($fp);
		if ($sTMP) {
			list($sTMP, $sVersion, $sValue, $sBuild, $sTMP) = explode(" ", $sTMP, 5);
			$sMODEM = sprintf("v.%s [build %s]", $sValue, $sBuild);
		};
		fclose($fp);
	};
	print $sMODEM;
};

function getServerInfo() {
	$sVER = shell_exec(ILSERVERFILE . " --version");
	list($sTMP, $sVER) = explode(": ", $sVER, 2);
	print $sVER;
};

function isUnderAutoconfig() {
	$s = shell_exec("/bin/ps -A | /bin/grep autoconfig");
	return !empty($s);
}

function isControllerRunning()
{
	$s = shell_exec("/bin/ps -A | /bin/grep controller");
	return !empty($s);
}

function isRouterRunning()
{
	$s = shell_exec("/bin/ps -A | /bin/grep router");
	return !empty($s);
}

function getTotalMemInfo() {
	getSomeMemInfo("MemTotal");
};

function getFreeMemInfo() {
	getSomeMemInfo("MemFree");
};

function getActiveMemInfo() {
	getSomeMemInfo("Active");
};

function getInactiveMemInfo() {
	getSomeMemInfo("Inactive");
};

function getCachedMemInfo() {
	getSomeMemInfo("Cached");
};

function getSomeDSPInfo($iDSP, &$sDSPcodec, &$sBus, &$sBaseTS, &$sCapacity) {
	$sDSPcodec = "----";
	$eLVL = error_reporting();
	$bFND = false;
	error_reporting($eLVL ^ E_WARNING); #OFF WARNINGS
	# open map file
	$fp = fopen("/proc/dspmap", "r");
	if ($fp) {
		while (!feof($fp)) {
			$sTMP = fgets($fp);
			if ($sTMP) {
				list($sDSP, $sBus, $sBaseTS, $sCapacity, $sCodec) = explode("\t", $sTMP, 6);
				if ($iDSP == $sDSP) {
					$bFND = true;
					$sDSPcodec = $sCodec;
					break;
				};
			} else {
				break;
			};
		};
		fclose($fp);
	};

	error_reporting($eLVL);
	if (trim($sDSPcodec) === "")
		$sDSPcodec = "----";

	return $bFND;
};



function getSomeDSPVersion($iDSP, &$sDSPcodec, &$sVersion, &$sChns, &$sCaps, &$sMIPS, &$sTout, &$sStest, &$sAcc) {
	$sVersion = "----";
	$eLVL = error_reporting();
	$bFND = false;
	error_reporting($eLVL ^ E_WARNING); #OFF WARNINGS
	$fp = fopen("/proc/voice/version", "r");
	if ($fp) {
		if(!feof($fp)) fgets($fp);
		if(!feof($fp)) fgets($fp);
		while (!feof($fp)) {
			$sTMP = fgets($fp);
			if ($sTMP) {
				list($sDSP, $sDSPcodec, $sVer, $sChns, $sCaps, $sMIPS, $sTout, $sStest, $sAcc) = explode("\t", $sTMP, 9);
				if ($iDSP == intval($sDSP) ) {
					//var_dump($iDSP.'/'.$sDSP.'||||');
					$bFND = true;
					$sVersion = $sVer;
					break;
				};
			} else {
				break;
			};
		};
		fclose($fp);
	};

	error_reporting($eLVL);
	if (trim($sVersion) === "")
		$sVersion = "----";

	return $bFND;
};



/*
function getSomeDSPInfo($iDSP,&$sDSPcodec)
{
	$sDSPcodec="----";
	$eLVL = error_reporting();
	$bFND = false;
	error_reporting($eLVL^E_WARNING);#OFF WARNINGS
# is it modem?
	$fp = fopen("/proc/modem/status/".((string)($iDSP*2)),"r");# 2 modems on DSP
	if ($fp)
	{
		$bFND=true;
		$sDSPcodec="modem[".((string)($iDSP*2))."]";
		fclose($fp);
	};
# is it voice codec
	if (!$bFND)
	{
		$fp = fopen(sprintf("/proc/voice/dsp%d/status",$iDSP),"r");# 1 codec on DSP
		if ($fp)
		{
			$bFND=true;
			$sTMP=fgets($fp);
			if ($sTMP)
			{
				list($sTMP,$sDSPcodec)=explode(":",$sTMP,2);
		$sDSPcodec=trim($sDSPcodec);
			};
			fclose($fp);
		};
	};
# is it empty dsp
	if (!$bFND)
	{
		$fp = fopen("/proc/voice/mcc/dec-".((string)$iDSP),"r");
		if ($fp)
		{
			$bFND=true;
			fclose($fp);
		};
	};
	error_reporting($eLVL);
	return $bFND;
};*/

function getDSPCountEx() {
  $s = shell_exec(ILVMANFILE);
	$pos_map = strpos($s, "dsp map:");
	$pos_bus = strpos($s, "dsp bus info:");
	if($pos_bus)$s_map = substr($s, $pos_map, $pos_bus - $pos_map);
	else $s_map = substr($s, $pos_map);
	$a_map = explode("\n", $s_map);
	$res = 0;
	for($i=0;$i<count($a_map);$i++) if( substr($a_map[$i],0,4) == "\tdsp" ) $res++;
	return $res;
};


function getFreeTimeSlots() {
	$s = shell_exec(ILVMANFILE);
	$a = explode("\n", substr($s, strpos($s, "dsp bus info:")));
	for($i=1;$i<=8;$i++) {
		$a[$i] = substr($a[$i],strpos($a[$i], "free:")+5);
	}
  return $a;
}

function getDSPInfoRows($trParams, $tdParams, $tdParams2) {
	$sDSPcodec = '';
	for ($i=0;$i<4;$i++) {
		for ($j=0;$j<4;$j++) {
			$banks[0][$i][$j]=-1;
			$banks[1][$i][$j]=-1;
		}
	}
	$k=0;
	while (true) {
		if ($k>=32) break;
		if (!getSomeDSPInfo($k++,$sCodec,$sBus,$sTS,$sCapacity)) continue;
		$iBus = (int)Trim($sBus);
		$iBank = 1;
		if ( ($iBus>7) && ($iBus<12) ) {
			$iBank=0;
			$i=$iBus-8;
			$j=0;
		}else
		{
			$i=$iBus-12;
			$j=0;
		}
		while ($banks[$iBank][$i][$j]!==-1) {
			if ($j==4) {
				break;
			}
			$j++;
		}
		if ($j==4) {
			continue;
		}
		$banks[$iBank][$i][$j]=$k-1;
	}
	$a = getFreeTimeSlots();
	for($k=0;$k<2;$k++) {
		print("<tr>");
		print("<td class=\"infoTableHeaderEx\">&nbsp;Bank #".(string)($k+1)."</td>");
		print("</tr>");
		print("<tr>");
		for($j=0;$j<4;$j++) {
			print("<td class=\"infoTableHeader\">&nbsp;DSP</td>");
			print("<td class=\"infoTableHeader\">Codec</td>");
			print("<td class=\"infoTableHeader\" style=\"width:20px;\" >Version</td>");
		}
		print("<td class=\"infoTableHeader\">&nbsp;Bus#</td>");
		print("<td class=\"infoTableHeader\">Free t/s</td>");
		print("</tr>");
		
		for($j=0;$j<4;$j++) {
			print "<tr " . $trParams . ">\n";
			for($i=0;$i<4;$i++) {
				$iDSP = $banks[$k][$j][$i];
				
				if ( $iDSP!==-1 ) {
					getSomeDSPInfo($iDSP,$sDSPcodec,$sBus,$sTS,$sCapacity); 
					getSomeDSPVersion($iDSP, $sDSPcodec_version, $sVersion, $sChns, $sCaps, $sMIPS, $sTout, $sStest, $sAcc);
					//getSomeDSPVersion(1, $sDSPcodec_version, $sVersion, $sChns, $sCaps, $sMIPS, $sTout, $sStest, $sAcc);
					printf("<td ".$tdParams.">\n%02d</td>", $iDSP);
				} else
				{
					$sDSPcodec = "&nbsp;";
					$sVersion = "&nbsp;";
					printf("<td ".$tdParams.">\n--</td>");
				}
				
				//print "<td ".$tdParams2.">\n".$sDSPcodec." | ".$sVersion."</td>";
				print "<td ".$tdParams2.">\n".$sDSPcodec."</td>";
				print "<td ".$tdParams2.">\n".$sVersion."</td>";
			};
			printf("<td ".$tdParams.">\n%2d</td>", $j+8+$k*4);
			printf("<td ".$tdParams.">\n%2d</td>", $a[$j+$k*4+1]);
			print "</tr>";
		};
	};
};

function RebootHardware() {
	// return exec("/sbin/halt");
	// exec("/sbin/shutdown -r +1 RebootFromWebAdmin");
	// exec("php /cgi-bin/reboot.cgi >/dev/null &");
	// return exec("/sbin/shutdown -r +1 RebootFromWebAdmin > /dev/null &");
	return exec("/cgi-bin/dreboot.sh > /dev/null &");
};

function RereadServerParams() {
	return exec("/bin/killall -HUP server");
};

function RereadControllerParams() {
	return exec("/bin/killall -HUP controller");
};

function RereadRouterParams() {
	return exec("/bin/killall -HUP router");
};

function RestartRouter() {
	if ( !isRouterRunning() ) return;
	exec("/bin/killall router");
	$tryWait=0;
	while(true)
	{
		sleep(1);
		$tryWait++;
		if ( (!isRouterRunning()) || ($tryWait>5) ) break;
	}
	return exec(ILROUTERFILE . " -D");
};

function RestartController() {
	if ( !isControllerRunning() ) return;
	exec("/bin/killall controller");
	$tryWait=0;
	while(true)
	{
		sleep(1);
		$tryWait++;
		if ( (!isControllerRunning()) || ($tryWait>5) ) break;
	}
	return exec(ILCONTROLLERFILE . " -D");
};

function RestartServer($KillOnly = false) {
	exec("/bin/killall server");
	if ($KillOnly)
		return true;
	else
		return exec(ILSERVERFILE . " -D");
};

function CollectControllerStats() {
	$controller_process = exec("ps -w aux |grep controller |grep -v grep");
	if(empty($controller_process)){
		$text = "<br><br><h3>Controller stopped</h3>";
		$fp = fopen(STATS_CONTROLLER, "w");
		fwrite($fp, $text);
		fclose($fp);		
	} else {
		exec("/bin/killall -USR2 controller");
	}
	// ToDo: wait for file change
	sleep(1);
	return true;
};

function getControllerStats() {
	if (!is_readable(STATS_CONTROLLER)) {
		return 'Statistics is not available.';
	}

	if (!function_exists("file_get_contents")) {
		$stats = '';
		$fp = fopen(STATS_CONTROLLER, "r");
		if ($fp) {
			while (!feof($fp)) {
				$sTMP = fgets($fp);
				$stats .= $sTMP;
			};
			fclose($fp);
		};
	} else {
		$stats = file_get_contents(STATS_CONTROLLER);
	}

	// TODO: <body> may be complex
	$pos = stripos($stats, '<body>');
	if ($pos !== false) {
		$stats = substr($stats, $pos + 6);
	}
	$pos = stripos($stats, '</body>');
	if ($pos !== false) {
		$stats = substr($stats, 0, $pos);
	}
	return $stats;
};

function getSyslogData() {
	$tr1 = '<tr class="bgsel" onMouseOver="this.style.backgroundColor=\'#D3D3D3\'" onMouseOut="this.style.backgroundColor=\'#F5F5F5\'">';
	$tr2 = '</tr>';

	//TODO: get syslog filename from /etc/syslog.conf : "*.* /var/log/messages"
	$fsyslogconf = '/etc/syslog.conf';
	if (!is_readable($fsyslogconf)) {
		return sprintf($tr1 . "<td class=\"infoLineValue\" colspan=\"6\">%s</td>" . $tr2,
						'syslog data is not available.');
	}
	$fp = fopen($fsyslogconf, "r");
	if ($fp) {
		while (!feof($fp)) {
			$line = fgets($fp);
			if (eregi('^[*.;a-zA-Z0-9]+' . '[[:blank:]]+' . '[/](.*)$', trim($line), $regs)) {
				$fsyslog = '/'.$regs[1];
				break;
			}
		};
		fclose($fp);
	};

	//$fsyslog = '/var/log/messages';
	if (!is_readable($fsyslog)) {
		return sprintf($tr1 . "<td class=\"infoLineValue\" colspan=\"6\">%s</td>" . $tr2,
						'syslog data is not available.');
	}

	if (!function_exists("file")) {
		$lines = '';
		$fp = fopen($fsyslog, "r");
		if ($fp) {
			while (!feof($fp)) {
				$sTMP = fgets($fp);
				$lines .= $sTMP;
			};
			fclose($fp);
		};
		$lines = explode("\n", $lines);
	} else {
		$lines = file($fsyslog);
	}

	$lines = array_slice($lines, -500, 500);
//	$res =
//		'<tr>' .
//			'<td class="infoTableHeader">&nbsp;month</td>' .
//			'<td class="infoTableHeader">day</td>' .
//			'<td class="infoTableHeader">time</td>' .
//			'<td class="infoTableHeader">host</td>' .
//			'<td class="infoTableHeader">proc</td>' .
//			'<td class="infoTableHeader">message</td>' .
//		"</tr>\n";
	foreach ($lines as $line_num => $line) {
		//Jan  2 03:42:40 rino_IL_host proftpd[472]: connect from 192.168.1.201

		if (eregi('^([a-zA-Z]+)' . '[ ]+' . '([0-9]+)' . '[ ]+' . '(.*)$', trim($line), $regs)) {
			$month = $regs[1];
			$day = $regs[2];
			list($time, $host, $proc_and_msg) = explode(" ", $regs[3], 3);
			list($proc, $msg) = explode(": ", $proc_and_msg, 2);
			if (!$msg)
				$msg = '&nbsp;';
			$res .= sprintf(
				$tr1 .
					"<td class=\"infoLineParamLite\">%s</td>" .
					"<td class=\"infoLineParamLite\">%s</td>" .
					"<td class=\"infoLineParamLite\">%s</td>" .
					"<td class=\"infoLineParamLite\">%s</td>" .
					"<td class=\"infoLineParamLite\">%s</td>" .
					"<td class=\"infoLineValue\">%s</td>" .
				$tr2,
				$month, $day, $time, $host, $proc, $msg);
		} else {
			$res .= sprintf($tr1 . "<td class=\"infoLineValue\" colspan=\"6\">%s</td>" . $tr2, trim($line));
		}
		$res .= "\n";
	}

	if (!$res)
		$res = sprintf($tr1 . "<td class=\"infoLineValue\" colspan=\"6\">%s</td>" . $tr2,
			'syslog data is empty.');

	return $res;
};


function Inform_AutoConfig() {
	
	// user identificator
	$userid = $_COOKIE['USER_ID'];
	if(!(is_numeric($userid))){
		$userid = 'ffffffff';
	} else {
		if( strlen($userid)<8 && $userid<=4294967295) {
			$userid = dechex($userid);
			$userid = str_pad($userid, 8, '0', STR_PAD_LEFT);
		} else {
			$userid = 'ffffffff';
		}
	}
	// command
	$reqcode = '02';
	
	if (!isUnderAutoconfig()) return;
	/*// packet identification signature
	$hex = '0A 09 08 07 06 05 04 03 02 01 01 02 03 04 05 06 07 08 09 0A';
	$hex =  str_replace(" ","",$hex);
	for($i=0,$str_packet='';$i<strlen($hex);$i+=2) $str_packet .= chr(hexdec(substr($hex,$i,2)));
	// regenerate configuration command & userID
	$str_packet .= chr(2);*/

	// packet identification signature
	$hex = '0A 09 08 07 06 05 04 03 02 01 01 02 03 04 05 06 07 08 09 0A';
	$hex =  str_replace(" ","",$hex).$reqcode.$userid;
	for($i=0,$str_packet='';$i<strlen($hex);$i+=2) $str_packet .= chr(hexdec(substr($hex,$i,2)));

	try {
		$fp = fsockopen("udp://127.0.0.1", 50000, $errno, $errstr);
		if($fp){
			// send packet
			fwrite($fp,$str_packet);
			
			// wait answer (delay before reload)
			stream_set_blocking($fp, TRUE);
			stream_set_timeout($fp,5);
			$data="";
			$info = stream_get_meta_data($fp);
			while( (strlen($data)<26)&&(!$info['timed_out']) )
			{
			    $data .= fread($fp,26);
			    $info = stream_get_meta_data($fp);
			    ob_flush;
			    flush();
			}
			//if ($info['timed_out']) { echo "Connection Timed Out!"; } else { echo $data; } 		

			fclose($fp);
			
			
		}
	} catch (Exception $e) {
		die("autoconfig was not informed about changes: $errno - $errstr<br>\n");
	}
	
	return;
};

function getHardwareID() {
	
	$sID = "UNKNOWN";
	
	$file = "/var/monitoring/dip";
	if(file_exists($file)) $fp = fopen($file, 'r');
		
	if ($fp) {
		$sID = fgets($fp);
		if(empty($sID)) $sID = "UNKNOWN";
		fclose($fp);
	} 
	print $sID;
};


function SaveECcoeffs() {

	$eccoeffs = $_COOKIE['eccoeffs'];
	if(empty($eccoeffs)) return;
	$eccoeffs = explode(",",$eccoeffs);
	
	if ( isControllerRunning() ) {
		exec("/bin/killall controller");
		$tryWait=0;
		while(true)
		{
			sleep(1);
			$tryWait++;
			if ( (!isControllerRunning()) || ($tryWait>5) ) break;
		}
	}

	if(!file_exists(ECCOEFFS_ETC_DIR)) {mkdir(ECCOEFFS_ETC_DIR,0777,true);}

	foreach ($eccoeffs as $key => $val){ 
		$file = ECCOEFFS_MONITORING_DIR."/".$val;
		$newfile = ECCOEFFS_ETC_DIR."/".$val;
		if (file_exists($file)) copy($file,$newfile);
	}
	
	if ( !isControllerRunning() )
	return exec(ILCONTROLLERFILE . " -D");

};


?>
