#! /bin/php
<?php
//-----------------------------------------------------------------------------------------------------------------------
// К задаче 0001921 
// Преобразование файлов конфигурации "controller.conf" и "router.conf".
//
// В "controller.conf" в секцию [ak-channel] добавляем параметр "default_cid", 
// его значение устанавливаем из "router.conf" - [ak] - "incoming caller id", соответственно слоту и каналу.
// Параметр "router.conf" - [ak] - "incoming caller id" удаляем.
// Параметр "router.conf" - [ak] - "outcoming caller id" переименовываем в "caller".
//-----------------------------------------------------------------------------------------------------------------------

define("CONTROLLERCONFFILE", "/usr/local/etc/controller.conf");
define("ROUTERCONFFILE", '/usr/local/etc/router.conf');

copy(CONTROLLERCONFFILE,CONTROLLERCONFFILE.'_'.date('ymd-h:i:s'));
copy(ROUTERCONFFILE,ROUTERCONFFILE.'_'.date('ymd-h:i:s'));


class ak_section {
	public $slot = null;
	public $channel = null;
	public $incoming_caller_id = null;
	public $outcoming_caller_id = null;
};

$ak_sections = array();
$router_data = '';
$incoming_caller_id_exist = false;

$frouter = fopen(ROUTERCONFFILE, 'r');
if($frouter){
    while (($line = fgets($frouter)) !== false) {
		$router_data .= $line;
		if( trim($line) == '[ak]' ){
			$sec_ak_name = true;
			$ak_sec = new ak_section;
			while ($sec_ak_name) {
				$line = fgets($frouter);
				$line = trim($line);
				if( $line == false || empty($line) || $line == '' || (strpos($line,'[') == 0 && strpos($line,']') == strlen($line)-1) ){
					$sec_ak_name = false;
				} else {
					if( strpos($line,'slot') === 0 ) { 
						$ak_slot = explode('=',$line); 
						$ak_sec->slot = trim($ak_slot[1]); 
					}
					if( strpos($line,'channel') === 0 ) { 
						$ak_channel = explode('=',$line); 
						$ak_sec->channel = trim($ak_channel[1]); 
					}
					if( strpos($line,'incoming caller id') === 0 ) { 
						$ak_incoming_caller_id = explode('=',$line); 
						$ak_sec->incoming_caller_id = trim($ak_incoming_caller_id[1]); 
						$line = 'noinclude';
						$incoming_caller_id_exist = true;
					}
					if( strpos($line,'outcoming caller id') === 0 ) { 
						$ak_outcoming_caller_id = explode('=',$line); 
						$ak_sec->outcoming_caller_id = trim($ak_outcoming_caller_id[1]); 
						$line = str_replace('outcoming caller id','caller',$line);
					}
				}
				if($line != 'noinclude') $router_data .= $line.PHP_EOL;
			}
			array_push($ak_sections,$ak_sec);
		}
    }
	
    fclose($frouter);
}

$frouter = fopen(ROUTERCONFFILE, 'w+');
if($frouter){
	fwrite($frouter, $router_data);
    fclose($frouter);
}

/*
foreach ($ak_sections as $key => $value) {
	var_dump($value);
	echo '<br>';
}
*/


if(!$incoming_caller_id_exist) return; // исключение повторного переноса параметров

class Channel_section {
	public $slot = null;
	public $id = null;
};

$control_data = '';

$fcontrol = fopen(CONTROLLERCONFFILE, 'r');
if($fcontrol){
	
    while (($line = fgets($fcontrol)) !== false) {
		$line = trim($line);
		$control_data .= $line.PHP_EOL;
		//echo $line, '<br>';
		
		if( $line == '[ak-channel]' ){
			$ak_channel_block = true;
			$ch_sec = new Channel_section;
			$ch_sec->slot = null;
			$ch_sec->id = null;
			
			while ($ak_channel_block) {
				$line = fgets($fcontrol);
				$line = trim($line);
				if( $line == false || empty($line) || $line == '' || (strpos($line,'[') < strpos($line,']')) ){
					if( $line != '[ak-channel]' ) $ak_channel_block = false;
					
					foreach ($ak_sections as $key => $value) {
						if( trim($value->slot) == trim($ch_sec->slot) && trim($value->channel) == trim($ch_sec->id) ){
							$control_data .= 'default_cid='.$value->incoming_caller_id.PHP_EOL;
						}
						//var_dump($value->slot.':'.$value->channel.'/'.$ch_sec->slot.':'.$ch_sec->id.', ');
					}

					$control_data .= $line;
					if( $line == '[ak-channel]' ) {
						//$control_data .= PHP_EOL.$line.PHP_EOL;
						$control_data .= PHP_EOL;
						$ch_sec = new Channel_section;
						$ch_sec->slot = null;
						$ch_sec->id = null;
						//echo('<br>');
					}
					
				} else {
					if( strpos($line,'slot=') === 0 ) { 
						$param = explode('=',$line); 
						$ch_sec->slot = $param[1];
					}
					if( strpos($line,'id=') === 0 ) { 
						$param = explode('=',$line); 
						$ch_sec->id = $param[1]; 
						//var_dump('ak-cannel: '.$ch_sec->slot.':'.$ch_sec->id.   ' // '.strpos($line,'id=').'<br>');						
					}
					if( strpos($line,'default_cid') > -1 ) { 
						$line = 'noinclude';
					}
					if($line != 'noinclude') $control_data .= $line.PHP_EOL;
				}
			}
			$control_data .= PHP_EOL;
			//echo('<br>');
			
		}
    }
    fclose($fcontrol);
}

$fcontrol = fopen(CONTROLLERCONFFILE, 'w+');
if($fcontrol){
	fwrite($fcontrol, $control_data);
    fclose($fcontrol);
}


?>