<?php
require_once(dirname(__FILE__) . '/conf_controls.inc');

class CustomShellScriptFile {
	private $pfFile = null;
	private $bOpen = false;
	private $sFileName = "";

	public function DoOpen($aFileName) {
		if ($this->bOpen) {
			fflush($this->pfFile);
			fclose($this->pfFile);
			$this->bOpen = false;
		}

		$this->pfFile = fopen($aFileName, "r+");
		if ($this->pfFile != null) {
			$this->sFileName = $aFileName;
			$sTMP = fgets($this->pfFile);
			if ($sTMP) {
				$sTMP = trim($sTMP);
				if (strpos($sTMP, "#!") === false) {
					if (rewind($this->pfFile)) {
						if (fputs($this->pfFile, "#!/bin/sh\n") <= 0) {
							$this->bOpen = false;
							fflush($this->pfFile);
							fclose($this->pfFile);
							printf("Filename='%s' open - FAIL (4)\n", $aFileName);
						} else {
							$this->bOpen = true;
						}

					} else {
						$this->bOpen = false;
						fflush($this->pfFile);
						fclose($this->pfFile);
						printf("Filename='%s' open - FAIL (3)\n", $aFileName);
					}

				} else {
					$this->bOpen = true;
				}

			} else {
				$this->bOpen = false;
				fflush($this->pfFile);
				fclose($this->pfFile);
				printf("Filename='%s' open - FAIL (2)\n", $aFileName);
			}

		} else {
			printf("Filename='%s' open - FAIL (1)\n", $aFileName);
		}

		return $this->bOpen;
	}

	
	
	public function DoSimplyOpen($aFileName) {
		if ($this->bOpen) {
			fflush($this->pfFile);
			fclose($this->pfFile);
			$this->bOpen = false;
		}

		$this->sFileName = $aFileName;
		$this->pfFile = fopen($aFileName, "r");
		if ($this->pfFile != null) {
			//$this->sFileName = $aFileName;
			$sTMP = fgets($this->pfFile);
			if ($sTMP) {
				rewind($this->pfFile);
				$this->bOpen = true;

			} else {
				$this->bOpen = false;
				fflush($this->pfFile);
				fclose($this->pfFile);
				printf("Filename='%s' open - FAIL (2)\n", $aFileName);
			}

		} else {
			printf("Filename='%s' open - FAIL (1)\n", $aFileName);
		}

		return $this->bOpen;
	}
	
	
	
	function DoClose() {
		if ($this->bOpen) {
			$this->bOpen = false;
			fflush($this->pfFile);
			fclose($this->pfFile);
			return true;
		} else {
			return false;
		}
	}

	function Clear() {
		if ($this->bOpen) {
			$this->bOpen = false;
			fflush($this->pfFile);
			fclose($this->pfFile);
			$this->pfFile = fopen($this->sFileName, "w");
			if ($this->pfFile) {
				fflush($this->pfFile);
				fclose($this->pfFile);
				$this->pfFile = fopen($this->sFileName, "r+");
				if ($this->pfFile) {
					fputs($this->pfFile, "#!/bin/sh\n");
					$this->bOpen = true;
				}
			}
		}
		return $this->bOpen;
	}
	
	function PutLine($sLine) {
		if ($this->bOpen) {
			return (fputs($this->pfFile, $sLine . "\n") > 0);
		} else {
			return false;
		}
	}

	public function __construct($aFileName, $nFileType) {
		// if ($aFileName) $this->DoOpen($aFileName);
		if ($aFileName) {
			if($nFileType == 0) $this->DoSimplyOpen($aFileName); //opening without change
			if($nFileType == 1) $this->DoOpen($aFileName);
		}
	}

	// only non comment string
	public function getNextStr(&$sValue) {
		if ($this->bOpen) {
			do {
				if (feof($this->pfFile)) {
					$sValue = "eof";
					return false;
				} else {
					$sValue = fgets($this->pfFile);
					if ($sValue) {
						$sValue = trim($sValue);
						if ((strlen($sValue) > 0) & (strpos($sValue, "#") !== 0)) {
							return true;
						}
					} else {
						$sValue = "error fail";
						return false;
					}
				}
			} while (true);
		} else {
			$sValue = "no file";
			return false;
		}
		return false;
	}

	// any string (for all string reading)
	public function getNextFullStr(&$sValue) {
		if ($this->bOpen) {
			do {
				if (feof($this->pfFile)) {
					$sValue = "eof";
					return false;
				} else {
					$sValue = fgets($this->pfFile);
					if ($sValue) {
						$sValue = trim($sValue);
						if (strlen($sValue) > 0) {
							return true;
						}
					} else {
						$sValue = "error fail";
						return false;
					}
				}
			} while (true);
		} else {
			$sValue = "no file";
			return false;
		}
		return false;
	}
	
	// only comment string
	public function getNextCommentStr(&$sValue) {
		if ($this->bOpen) {
			do {
				if (feof($this->pfFile)) {
					$sValue = "eof";
					return false;
				} else {
					$sValue = fgets($this->pfFile);
					if ($sValue) {
						$sValue = trim($sValue);
						if ((strlen($sValue) > 0) & (strpos(trim($sValue), "#") === 0)) {
							return true;
						}
					} else {
						$sValue = "error fail";
						return false;
					}
				}
			} while (true);
		} else {
			$sValue = "no file";
			return false;
		}
		return false;
	}
	
	function __destruct() {
		if ($this->bOpen) {
			fflush($this->pfFile);
			fclose($this->pfFile);
		}
		$this->bOpen = false;
	}

	function SetAtFirst() {
		if ($this->bOpen) {
			return rewind($this->pfFile);
		} else {
			return false;
		}
	}
}

class IL_rc_local_ShellScriptFile extends CustomShellScriptFile {
	private $PreDrvArr;
	private $DrvArr;
	private $NetArr;
	public $CodecArr;
	public $ModemArr;
	private $ServersArr;
	public $CreateModems;
	public $isServerRun;
	public $isControllerRun;
	public $isRouterRun;
	public $drvparams;
	public $netparams;
	public $syslog_comment;

	public function __construct($aFileName, $nFileType) {
		parent::__construct($aFileName, $nFileType);
		$this->PreDrvArr = array();
		$this->DrvArr = array();
		$this->CodecArr = array();
		$this->CreateModems = false; //get pppd existance from hardware script!
		$this->ModemArr = array();
		$this->ServersArr = array();

		$this->drvparams = array();
		$this->drvparams['mcc_ss7'] = 0; //4;
		$this->drvparams['mcc_num_of_mcc_trans'] = 0; //60;
		$this->drvparams['mcc_num_of_mcc_data'] = 0;  //60;
		$this->drvparams['g711mcc_channels'] = 0;  //60
		$this->drvparams['netconsole_dev'] = "";
		$this->drvparams['netconsole_target_ip'] = "";
		$this->drvparams['netconsole_target_port'] = "";
		$this->drvparams['netconsole_source_port'] = "";

		$this->netparams = array();
		//$this->netparams['DHCP']='no';
		
		$this->ReadAllInMemory();
	}

	function __destruct() {
		parent::__destruct();
	}

	function ReadPreDrvArr() {
		parent::SetAtFirst();
		$iIx = 0;
		while (parent::getNextStr($sTMP)) {
			if (strpos($sTMP, "modprobe") === 0) {
				break;
			} else {
				$this->PreDrvArr[$iIx++] = $sTMP;
			}
		}
	}

	function ReadDrvArr() {
		parent::SetAtFirst();
		$this->DrvArr = array();
		$sTMP = '';
		while (parent::getNextStr($sTMP)) {
			list($cmd, $drv, $params) = explode(" ", $sTMP, 3);
			if ($cmd == 'modprobe') {
				$this->DrvArr[] = $drv;
				if ($drv == 'mcc') {
					$this->SetDrvParam('ss7', $params, 'mcc_');
					$this->SetDrvParam('num_of_mcc_trans', $params, 'mcc_');
					$this->SetDrvParam('num_of_mcc_data', $params, 'mcc_');
				} elseif ($drv == 'g711mcc') {
					$this->SetDrvParam('channels', $params, 'g711mcc_');
				} elseif ($drv == 'netconsole') {
					$this->SetDrvParam('dev', $params, 'netconsole_');
					$this->SetDrvParam('target_ip', $params, 'netconsole_');
					$this->SetDrvParam('target_port', $params, 'netconsole_');
					$this->SetDrvParam('source_port', $params, 'netconsole_');
				}
			}
		}
		//logmsg("ReadDrvArr:".print_r($this->DrvArr, true));
	}

	function SetDrvParam($pname, $pstr, $prefix) {
		$pos = stripos($pstr, $pname . '=');
		if ($pos >= 0) {
			list($pvalue,) = explode(' ', substr($pstr, $pos + strlen($pname . '=')), 2);
			$this->drvparams[$prefix . $pname] = $pvalue;
		}
	}

	public function GetFucked() {
		return print_r($this->drvparams, true);
	}

	
	//------------------------------------------------------------------------------------------------

	function ReadNetArr() {
		parent::SetAtFirst();
		$this->NetArr = array();
		$sTMP = '';
		while (parent::getNextStr($sTMP)) {
			list($net, $params) = explode("=", $sTMP, 2);
			if( !empty($net) && !empty($params) ) $this->netparams[$net] = $params;
			if( !empty($net) && empty($params) && strpos($sTMP,'=')==false ) $this->netparams["p".count($this->netparams)] = $net; // для значений без названия параметра (см. файл HOSTNAME)
		}
		//logmsg("ReadNetArr:".print_r($this->NetArr, true));
	}

	
	function SaveNetArr($nFileType) {

		shell_exec("/sbin/sys.rw");

		$fh = fopen($this->sFileName, "w");
		fclose($fh);
		
		$fh = fopen($this->sFileName, 'w');
		rewind($fh);
		foreach ($this->netparams as $key => $value){
			if($nFileType==0) fwrite($fh, trim($value)."\n");
			if($nFileType==1) fwrite($fh, $key."=".$value."\n");
		}
		fclose($fh);

		shell_exec("/sbin/sys.ro");
		
	}	


	// replace string in file
	function FileStrReplace($search,$replace) {

		shell_exec("/sbin/sys.rw");
		$file = file_get_contents($this->sFileName);
		$file = str_replace($search, $replace, $file);
		//$file = preg_replace($search, $replace, $file);
		file_put_contents($this->sFileName, $file);
		shell_exec("/sbin/sys.ro");
		
	}	

	// ----------------------------------------------------------------------------------------------
	// syslog.conf
	
	// read all string
	function ReadSyslogFullArr() {
		parent::SetAtFirst();
		$this->NetArr = array();
		$sTMP = '';
		while (parent::getNextFullStr($sTMP)) {
			list($net, $params) = explode("=", $sTMP, 2);
			if( !empty($net) && !empty($params) ) $this->syslog_param[$net] = $params;
			if( !empty($net) && empty($params) ) $this->syslog_param["p".count($this->syslog_param)] = $net;
		}
		//logmsg("ReadNetArr:".print_r($this->NetArr, true));
	}

	// read all comment string
	function ReadSyslogCommentArr() {
		parent::SetAtFirst();
		$this->NetArr = array();
		$sTMP = '';
		while (parent::getNextCommentStr($sTMP)) {
			$this->syslog_comment["p".count($this->syslog_comment)] = $sTMP;
		}
		//logmsg("ReadNetArr:".print_r($this->NetArr, true));
	}
	
	function SaveNetSyslogArr($nFileType) {

		shell_exec("/sbin/sys.rw");

		$fh = fopen($this->sFileName, "w");
		fclose($fh);
		
		$fh = fopen($this->sFileName, 'w');
		rewind($fh);
		// save comments
		foreach ($this->syslog_comment as $key => $value){
			fwrite($fh, trim($value)."\n");
		}
		// save params
		foreach ($this->netparams as $key => $value){
			$value = trim($value);
			if(!empty($value)){
				if($nFileType==0) fwrite($fh, trim($value)."\n");
				if($nFileType==1) fwrite($fh, $key."=".$value."\n");
			}
		}
		fclose($fh);

		shell_exec("/sbin/sys.ro");
		
	}	
	
	
	
	//------------------------------------------------------------------------------------------------
	
	
	function ReadCodecArr() {
		parent::SetAtFirst();
		$iIx = 0;
		while (parent::getNextStr($sTMP)) {
			if (strpos($sTMP, "vman") === 0) {
				$this->CodecArr[$iIx++] = $sTMP;
			}
		}
	}

	function ReadModemArr() {
		parent::SetAtFirst();
		$iIx = 0;
		while (parent::getNextStr($sTMP)) {
			if (strpos($sTMP, "mctl") === 0) {
				$this->ModemArr[$iIx++] = $sTMP;
			}
		}
	}

	function ReadServices() {
		parent::SetAtFirst();
		$this->isServerRun = false;
		$this->isControllerRun = false;
		$this->isRouterRun = false;
		$this->isAutoconfigRun = false;
		while (parent::getNextStr($sTMP)) {
			if (strpos($sTMP, "server") === 0)
				$this->isServerRun = true;
			if (strpos($sTMP, "controller") === 0)
				$this->isControllerRun = true;
			if (strpos($sTMP, "router") === 0)
				$this->isRouterRun = true;
			if (strpos($sTMP, "autoconfig") === 0)
				$this->isAutoconfigRun = true;
		}
	}

	function ReadServersArr() {
		parent::SetAtFirst();
		$iIx = 0;
		$ReadSectionStarted = false;
		while (parent::getNextStr($sTMP)) {
			if ($ReadSectionStarted) {
				if (strpos($sTMP, "boa") === 0) {
					break;
				} else {
					$this->ServersArr[$iIx++] = $sTMP;
				}
			} else {
				if ((strpos($sTMP, "server") === 0) || (strpos($sTMP, "ifconfig") === 0)) {
					$this->ServersArr[$iIx++] = $sTMP;
					$ReadSectionStarted = true;
				}
			}
		}
	}

	function InitCreateModemsStatus() {
		parent::SetAtFirst();
		while (parent::getNextStr($sTMP)) {
			// if (strpos($sTMP,"pppd ")>0)
			// if (preg_match("/\bpppd \b/i", $sTMP))
			if (eregi("pppd(.*)>> ", $sTMP)) {
				$this->CreateModems = true;
				break;
			}
		}
	}

	function ReadAllInMemory() {
		// $this->ReadPreDrvArr();
		$this->ReadDrvArr();
		$this->ReadCodecArr();
		$this->ReadModemArr();
		$this->ReadServices();
		
		$this->ReadNetArr();
		$this->ReadSyslogCommentArr();
		// $this->ReadServersArr();
		// $this->InitCreateModemsStatus();
	}

	function DoWriteArray($anARR) {
		foreach ($anARR as $tmp)
			parent::PutLine($tmp);
	}

	function WritePreDrvArr() {
		$this->DoWriteArray($this->PreDrvArr);
	}

	function WriteDrvArr() {
		//$this->DoWriteArray($this->DrvArr);
		$i = 0;
		$s = '';
		while ($this->GetDriverFull($i++, $s))
			parent::PutLine("modprobe " . $s);
	}

	function WriteCodecArr() {
		$this->DoWriteArray($this->CodecArr);
	}

	function WriteModemArr() {
		$this->DoWriteArray($this->ModemArr);
	}

	function WriteServersArr() {
		$this->DoWriteArray($this->ServersArr);
	}

	function WriteNecessarily() {
		require_once(dirname(__FILE__) . '/scripts.inc');
		$sSrcipt = GetWWWAutoStartScript();
		$this->DoWriteArray(explode("\n", $sSrcipt));
		$sSrcipt = GetPPPAutoStartScript($this->CreateModems);
		$this->DoWriteArray(explode("\n", $sSrcipt));
	}

	function FlushAll() {
		parent::Clear();
		// parent::PutLine("# Before driver loading section");
		// $this->WritePreDrvArr();
		parent::PutLine("# Driver loading section");
		$this->WriteDrvArr();
		parent::PutLine("# DSP configuration section");
		$this->WriteCodecArr();
		$this->WriteModemArr();
		parent::PutLine("# Services startup section");
		if ($this->isServerRun)
			parent::PutLine("server -D");
		if ($this->isControllerRun)
			parent::PutLine("controller -D");
		if ($this->isRouterRun)
			parent::PutLine("router -D");
		if ($this->isAutoconfigRun)
			parent::PutLine("autoconfig -D");
		// parent::PutLine("# Services starting section");
		// $this->WriteServersArr();
		// $this->WriteNecessarily();
	}

	# Get configuration
	function GetPreDriver($iIndex, &$sServer) {
		$sServer = $this->PreDrvArr[$iIndex];
		if ($sServer) {
			return true;
		} else {
			return false;
		}
	}

	function GetDriver($iIndex, &$sDriver) {
		$sTMP = $this->DrvArr[$iIndex];
		if ($sTMP) {
			//list($sTMP, $sDriver) = explode(" ", $sTMP, 2);
			//$sDriver = trim($sDriver);
			$sDriver = $sTMP;
			return true;
		} else {
			return false;
		}
	}

/*
	function GetDriverFull($iIndex, &$sDriver) {
		$res = $this->GetDriver($iIndex, $sDriver);
		if ($res) {
			if (strcasecmp($sDriver, 'mcc') == 0) {
					$sDriver = sprintf("%s ss7=%s num_of_mcc_trans=%s num_of_mcc_data=%s",
					$sDriver,
					$this->drvparams['mcc_ss7'],
					$this->drvparams['mcc_num_of_mcc_trans'],
					$this->drvparams['mcc_num_of_mcc_data']);
			} else
				if (strcasecmp($sDriver, 'g711mcc') == 0) {
					$sDriver = sprintf("%s channels=%s", $sDriver, $this->drvparams['g711mcc_channels']);
				}
		}
		return $res;
	}
*/
	function GetDriverFull($iIndex, &$sDriver) {
		$res = $this->GetDriver($iIndex, $sDriver);

		if ($res) {
			if (strcasecmp($sDriver, 'mcc') == 0) {
					$sDriver = sprintf("%s ss7=%s num_of_mcc_trans=%s num_of_mcc_data=%s",
					$sDriver,
					$this->drvparams['mcc_ss7'],
					$this->drvparams['mcc_num_of_mcc_trans'],
					$this->drvparams['mcc_num_of_mcc_data']);
			} elseif (strcasecmp($sDriver, 'g711mcc') == 0) {
					$sDriver = sprintf("%s channels=%s", $sDriver, $this->drvparams['g711mcc_channels']);
			} elseif (strcasecmp($sDriver, 'netconsole') == 0) {
					$sDriver = sprintf("%s dev=%s target_ip=%s target_port=%s source_port=%s",
					$sDriver,
					$this->drvparams['netconsole_dev'],
					$this->drvparams['netconsole_target_ip'],
					$this->drvparams['netconsole_target_port'],
					$this->drvparams['netconsole_source_port']);
			}
		}
		return $res;
	}


	function GetCodec($iIndex, &$sDSP, &$sCODEC) {
		$sTMP = $this->CodecArr[$iIndex];
		if ($sTMP) {
			list($sTMP, $sTMP, $sDSP, $sCODEC) = explode(" ", $sTMP, 4);
			$sDSP = trim($sDSP);
			$sCODEC = trim($sCODEC);
			return true;
		} else {
			return false;
		}
	}

	function GetModem($iIndex, &$sDSP) {
		$sTMP = $this->ModemArr[$iIndex];
		if ($sTMP) {
			list($sTMP, $sTMP, $sDSP) = explode(" ", $sTMP, 3);
			$sDSP = trim($sDSP);
			$iDSP = ((int)$sDSP) / 2;
			$sDSP = (string)$iDSP;
			return true;
		} else {
			return false;
		}
	}

	function GetServer($iIndex, &$sServer) {
		$sTMP = $this->ServersArr[$iIndex];
		if ($sTMP) {
			$sServer = trim($sTMP);
			return true;
		} else {
			return false;
		}
	}

	# Put configuration

	function SetInitScript($sCommands) {
		$this->PreDrvArr = array();
		foreach ($sCommands as $cmd)
			$this->PreDrvArr[] = trim($cmd);
	}

	function SetDrivers($sDrivers) {
		$this->DrvArr = array();
		foreach ($sDrivers as $drv)
			$this->DrvArr[] = trim($drv);
	}

	function SetDSPProgs($sCODECs) {
		$this->CodecArr = array();
		$this->ModemArr = array();
		$iDSP = 0;
		while ($sCODECs[$iDSP]) {
			if ($sCODECs[$iDSP] !== "----") {
				if ($sCODECs[$iDSP] === "modem") {
					$this->ModemArr[] = "mctl -i " . ((string)(2 * $iDSP));
				} else {
					if($sCODECs[$iDSP]!=="-1")
					$this->CodecArr[] = "vman -i " . ((string)$iDSP) . " " . $sCODECs[$iDSP];
				}
			}
			$iDSP++;
		}
	}

	function SetFinalScript($sCommands) {
		$this->ServersArr = array();
		foreach ($sCommands as $cmd)
			$this->ServersArr[] = trim($cmd);
	}
}

class DirModuleHolder {
	private $arrDRV = array();

	function __construct($aDirName) {
		$d = dir($aDirName);
		if(!$d) return;
		while (false !== ($entry = $d->read())) {
			list($drvmodule, $drvext) = explode(".", $entry, 2);
			if ($drvext === "o") {
				$this->arrDRV[] = $drvmodule;
			}
		}
		$d->close();
	}

	public function getDRVarr() {
		return $this->arrDRV;
	}
}

function DoApplyLocalRC($rcOLD, $rcNEW) {
	$i = 0;
	$sDrv = '';
	$arrDrvDeleted = array();
	while ($rcOLD->GetDriverFull($i, $sDrv))
		$arrDrvDeleted[$i++] = $sDrv;

	$i = 0;
	$sDrv = '';
	$arrDrvAdded = array();
	while ($rcNEW->GetDriverFull($i, $sDrv))
		$arrDrvAdded[$i++] = $sDrv;

	$arrDrvUnchanged = array_intersect($arrDrvDeleted, $arrDrvAdded);
	$arrDrvDeleted = array_merge(array_diff($arrDrvDeleted, $arrDrvUnchanged));
	$arrDrvAdded = array_merge(array_diff($arrDrvAdded, $arrDrvUnchanged));

	//unload removed drivers  ?( > /dev/null &)
	//$s_is_server_loaded = trim(exec("killall server"));
	for ($i = 0; $i < count($arrDrvDeleted); $i++) {
		list($drv,) = explode(' ', $arrDrvDeleted[$i], 2);
		$arrDrvDeleted[$i] = $drv;
	}
	$NeedServerRestart = count($arrDrvDeleted) > 0;
	if ($NeedServerRestart)
		RestartServer(true);
	logmsg("DrvDeleted:" . print_r($arrDrvDeleted, true));
	foreach ($arrDrvDeleted as $drv)
		exec("rmmod -r $drv");

	//load added drivers
	logmsg("DrvAdded:" . print_r($arrDrvAdded, true));
	foreach ($arrDrvAdded as $drv)
		exec("insmod $drv");

	//DSP
	foreach ($rcNEW->CodecArr as $drv)
		exec($drv);
	foreach ($rcNEW->ModemArr as $drv)
		exec($drv);

	//restart server
	if ($NeedServerRestart) {
		RestartServer();
	} else
		if (count($arrDrvAdded) > 0) {
			RereadServerParams();
		}

	//if ($s_is_server_loaded=="") exec("server -D");
}





class SystemParameterConfig {
	
	public $bond0_ip = null;
	public $eth0_ip = null;
	public $eth1_ip = null;
	public $eth0_mac = null;
	public $eth1_mac = null;

	public function __construct() {
		$this->bond0_ip = shell_exec("/sbin/ifconfig -a bond0 | grep \"inet addr\" | head -n 1 | cut -d : -f 2 | cut -d \" \" -f 1");
		$this->eth0_ip = shell_exec("/sbin/ifconfig -a eth0 | grep \"inet addr\" | head -n 1 | cut -d : -f 2 | cut -d \" \" -f 1");
		$this->eth1_ip = shell_exec("/sbin/ifconfig -a eth1 | grep \"inet addr\" | head -n 1 | cut -d : -f 2 | cut -d \" \" -f 1");

		$this->eth0_mac = shell_exec("/sbin/ifconfig -a eth0 | grep 'HWaddr' | head -n 1 | sed 's/\(.*HWaddr\) \(.*\)/\2/'");
		$this->eth1_mac = shell_exec("/sbin/ifconfig -a eth1 | grep 'HWaddr' | head -n 1 | sed 's/\(.*HWaddr\) \(.*\)/\2/'");
	}

	function __destruct() {
	}

	public function IsBond() {
		//if(empty($this->bond0_ip)) { return false; } else { return true; }
		if(empty($this->eth0_mac) || empty($this->eth1_mac)) { return false; } else { return true; }
	}

}





?>
