
// for insert text into cursor place (for example in textarea tag)
function insertTextAtCursor(el, text, offset) {
    var val = el.value, endIndex, range, doc = el.ownerDocument;
    if (typeof el.selectionStart == "number"
            && typeof el.selectionEnd == "number") {
        endIndex = el.selectionEnd;
        el.value = val.slice(0, endIndex) + text + val.slice(endIndex);
        el.selectionStart = el.selectionEnd = endIndex + text.length+(offset?offset:0);
    } else if (doc.selection != "undefined" && doc.selection.createRange) {
        el.focus();
        range = doc.selection.createRange();
        range.collapse(false);
        range.text = text;
        range.select();
    }
}


function OnAddSyslog(sl_idx,sl_what,sl_where){
	var syslogcount = document.getElementById("hidSyslogCount");
	if (!syslogcount || (sl_idx < 0)) {
		syslogcount.value++;
		sl_idx = syslogcount.value;
	}

	var sl_type = (sl_what=='*.*') ? 'all' : 'manual';

	var table = document.getElementById("tabSyslogConfig");

	var rowCount = table.rows.length;
	var row = table.insertRow(rowCount);
	row.id = "syslog_row_"+sl_idx;
	
	var cell1 = row.insertCell(0);
	var element1 = document.createElement("select");
	element1.name = "syslog_select_"+sl_idx;
	element1.id = "syslog_select_"+sl_idx;
	element1.className="selectw100p";
	var s_all=false;
	var s_manual=false;
	if(sl_type=='all') s_all=true; else s_manual=true;
	element1.options[0] = new Option('all','all',s_all,s_all);
	element1.options[1] = new Option('manual','manual',s_manual,s_manual);
	element1.onchange=function(){
		var obj = document.getElementById("syslog_what_"+sl_idx);
		if(this.value=="all") {
			obj.disabled=true;
			obj.value="*.*";
		} else {
			obj.disabled=false;
			obj.value="";
		}
	}
	cell1.appendChild(element1);

	var cell2 = row.insertCell(1);
	var element2 = document.createElement("input");
	element2.type = "text";
	element2.name = "syslog_what_"+sl_idx;
	element2.id = "syslog_what_"+sl_idx;
	element2.className="selectw";
	element2.value = sl_what;
	if(sl_type=='all') element2.disabled=true;
	//element2.onchange=function(){doChangeEvent();}
	cell2.appendChild(element2);

	var cell3 = row.insertCell(2);
	var element3 = document.createElement("input");
	element3.type = "text";
	element3.name = "syslog_where_"+sl_idx;
	element3.id = "syslog_where_"+sl_idx;
	element3.className="selectw300";
	element3.value = sl_where;
	//element3.onchange=function(){doChangeEvent();}
	cell3.appendChild(element3);

	var cell4 = row.insertCell(3);
	var element4 = document.createElement("input");
	element4.type = "button";
	element4.name = "syslog_del_"+sl_idx;
	element4.id = "syslog_del_"+sl_idx;
	element4.value = "x";
	element4.style.cursor = 'pointer';
	element4.onclick = function(){row.parentNode.removeChild(row);}
	cell4.appendChild(element4);
	
}


function OnAddNtpServer(ntp_idx,ntp_address){
	var rowcount = document.getElementById("hidNtpServerCount");
	if (!rowcount || (ntp_idx < 0)) {
		rowcount.value++;
		ntp_idx = rowcount.value;
	}

	var table = document.getElementById("tabNtpServerConfig");
	//var rowCount = table.rows.length;
	var row = table.insertRow(table.rows.length);
	row.id = "ntp_server_row_"+ntp_idx;
	
	var cell1 = row.insertCell(0);
	var element1 = document.createElement("input");
	element1.type = "text";
	element1.name = "ntp_server_address_"+ntp_idx;
	element1.id = "ntp_server_address_"+ntp_idx;
	element1.className="selectw";
	element1.style="width:500px";
	element1.value = ntp_address;
	//element2.onchange=function(){doChangeEvent();}
	cell1.appendChild(element1);

	var cell2 = row.insertCell(1);
	var element2= document.createElement("input");
	element2.type = "button";
	element2.name = "ntp_server_del_"+ntp_idx;
	element2.id = "ntp_server_del_"+ntp_idx;
	element2.value = "x";
	element2.style.cursor = 'pointer';
	element2.onclick = function(){row.parentNode.removeChild(row);}
	cell2.appendChild(element2);
	
}


// DDD_UDP_FILTER_EXPR -------------------------------------------------------------------------

	function CreateArrow(Dir, ListName) {
		var Top = {"up":"10px", "down":"0px"};
		var FileName = {"up":"up.gif", "down":"dn.gif"};
		return "<div style=\"margin-top:" + Top[Dir] +
				";padding:0px;text-align:right\"" + ">" + "\n" +
			"<img class=\"imglink\" onClick=\"MoveListItem(" +
						"'" + Dir + "', '" + ListName + "')\" " +
				"src=\"/images/" + FileName[Dir] + "\" " +
				"alt=\"Move selected items " + Dir + "\"" +
			">" + "\n" +
		"</div>\n";
	}

	function CreateMultiSelectTag(Name, Source) {
		return "<select name=\"" + Name + "\" id=\"" + Name + "\" " +
			"multiple size=\"4\" class=\"selectw\">" +
			GetDDDcOptionsString( Source ) + "</select>\n";
	}

	function CreateHidden(Name, Value) {
		return "<input name=\"" + Name + "\" id=\"" + Name + "\" " +
			"type=\"hidden\" " + "value=\"" + Value + "\">";
	}

function MultiSelectCreate(Hiddens, Name) {
	
	//alert(Hiddens);
	var tr = document.createElement("tr");
	var td = document.createElement("td");
	td.className = "editLineParamTop";
	td.innerHTML = "DDD_UDP_FILTER_EXPR<br>\n" + CreateArrow("up",   Name ) + CreateArrow("down", Name );
	tr.appendChild(td);
	//alert(tr.outerHTML);

	td = document.createElement("td");
	td.className = "editLineValue";
	var s = CreateMultiSelectTag( Name, Hiddens[0]["Value"] );
	for(var i in Hiddens) s = s + CreateHidden( Hiddens[i]["Name"], Hiddens[i]["Value"] );
	td.innerHTML = s;
	tr.appendChild(td);
	return tr;
}

// ---------------------------------------------------------------------------------------------
