<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("USERGROUPCONFFILE", '/usr/local/etc/usergroup.cfg');

//define("PATTERN_TYPE_BASIC", 0);
//define("PATTERN_TYPE_TIMEOUT", 1);
//define("PATTERN_TYPE_REDIRECT", 2);

//class Router_target_signalling extends CustomSection {
//class Router_target_signallings {


class Group_list extends CustomSection {
	public $group_id  = "";
	public $group_name = "";
	public $users_list = "";
	public $user = array();
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "group_id=" . $this->group_id . "\n"
				. "group_name=" . $this->group_name . "\n"
				. "users_list=" . $this->users_list . "\n"

				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "group_id")
					$this->group_id = $sValue;
				elseif ($sName === "group_name")
					$this->group_name = $sValue;
				elseif ($sName === "users_list")
					$this->users_list = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Listen_lists{
	public $arrListenLists = array();
}

class Group_lists {
	public $arrGroupLists = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Group_list();
		$this->arrGroupLists[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrGroupLists[(int)$iIndex];
	}

	public function GetByID($groupsetID) {
		$i = 0;
		do {
			$objgroupset = $this->GetByIndex($i++);
			if ($objgroupset != null) {
				if ($objgroupset->group_id === $groupsetID) {
					break;
				};
			};
		} while ($objgroupset != null);
		return $objgroupset;
	}
	
/*
	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrGroupLists[$i++]) {
			$sRes = $sRes . "[group]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrGroupLists))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
*/	
	public function GetAsSections() {
		$sRes = "";
		foreach ($this->arrGroupLists as $groupset) {
			$sRes .= "\n[group]\n" . $groupset->GetAsFullCfgString();
			foreach ($groupset->user as $user)
				$sRes .= "\n[user]\n" . $user->GetAsFullCfgString();
		}
		return $sRes;
	}
	
	
};


class GroupUserObj extends CustomSection {
	public $group_id;
	public $id;
	
	public function AddAsSection($sSection) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));
		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			switch ($iFormat) {
				case 1:
					$props = get_object_vars($this);
					$name2 = str_replace(' ', '_', $sName);
					if (array_key_exists($sName, $props))
						$this->$sName = $sValue;
					elseif (array_key_exists($name2, $props))
						$this->$name2 = $sValue;
					else
						parent::AddUnknownLine($sTMP);
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "group_id=" . $this->group_id . "\n"
				. "id=" . $this->id . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}
	
};





//--------------------------------------------------------------------------------------------------







# ######################################
class UserGroupConfFile extends CustomConfFile {
	public $group_list;
	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->group_list = new Group_lists();
		$this->listen_list = new Listen_lists();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}
	
	
	function DoReadGroupUsers($cache) {
		if(!($cache)) return;
		reset($cache);
		$sTMP = current($cache);
		while ($sTMP) {
			$chTMP = new GroupUserObj();
			$chTMP->AddAsSection($sTMP);
			$groupsetTMP = $this->group_list->GetByID($chTMP->group_id);
		//var_dump($groupsetTMP);echo "<br><br>";
			if ($groupsetTMP) {
				$groupsetTMP->user[] = $chTMP;
				$chTMP->idx = count($groupsetTMP->user);
			}
			$sTMP = next($cache);
		};
	}
	
	

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "ctrl")
				$this->ctrl->AddAsSection($sSectionValues);
			/*elseif ($sSectionName === "pattern")
				$this->patterns->AddAsSectionEx($sSectionValues, PATTERN_TYPE_BASIC);
			elseif ($sSectionName === "timeout pattern")
				$this->patterns->AddAsSectionEx($sSectionValues, PATTERN_TYPE_TIMEOUT);
			elseif ($sSectionName === "redirect pattern")
				$this->patterns->AddAsSectionEx($sSectionValues, PATTERN_TYPE_REDIRECT);*/
			elseif ($sSectionName === "group")
				$this->group_list->AddAsSection($sSectionValues);
			elseif ($sSectionName === "user"){
				$usercache[] = $sSectionValues;
				//var_dump($usercache);echo "<br><br>";
			}
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
		//var_dump($usercache);echo "<br><br>";
		$this->DoReadGroupUsers($usercache);
	}

	function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		$this->PutLine($this->group_list->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}
};
# ######################################
?>
