<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("CHANNELCONFFILE", '/opt/ksrs-terminal/server/krs-terminal-server.conf');
define("RECEIVERCONFFILE", '/etc/snmp/snmpd.conf');
define("HOSTNAME", '/etc/hostname');

class Main_conf extends CustomSection {
	public $LogLevel  = "";
	public $LogAddress  = "";
	public $MainInPort  = "";
	public $ConfVersion  = "";
	public $UIConfVersion  = "";
	public $VoiceVersion  = "";
	public $UIFileName  = "";
	public $NetworkIFs  = "";

	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "LogLevel=" . $this->LogLevel . "\n"
				. "LogAddress=" . $this->LogAddress . "\n"
				. "MainInPort=" . $this->MainInPort . "\n"
				. "ConfVersion=" . $this->ConfVersion . "\n"
				. "UIConfVersion=" . $this->UIConfVersion . "\n"
				. "VoiceVersion=" . $this->VoiceVersion . "\n"
				. "UIFileName=" . $this->UIFileName . "\n"
				. "NetworkIFs=" . $this->NetworkIFs . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "LogLevel")
					$this->LogLevel = $sValue;
				elseif ($sName === "LogAddress")
					$this->LogAddress = $sValue;
				elseif ($sName === "MainInPort")
					$this->MainInPort = $sValue;
				elseif ($sName === "ConfVersion")
					$this->ConfVersion = $sValue;
				elseif ($sName === "UIConfVersion")
					$this->UIConfVersion = $sValue;
				elseif ($sName === "VoiceVersion")
					$this->VoiceVersion = $sValue;
				elseif ($sName === "UIFileName")
					$this->UIFileName = $sValue;
				elseif ($sName === "NetworkIFs")
					//$this->NetworkIFs = $sValue;
					$this->NetworkIFs = str_replace("\"","",$sValue);
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Main_confs {
	public $arrMainConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Main_conf();
		$this->arrMainConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrMainConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrMainConfs[$i++]) {
			$sRes = $sRes . "[MAIN]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrMainConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};


//-------------------------------------------------------------------------------------------- 

class ChSnmp_conf extends CustomSection {
	public $AgentAddress = "";
	public $ReceiverAddresses = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "AgentAddress=" . $this->AgentAddress . "\n"
				. "ReceiverAddresses=" . $this->ReceiverAddresses . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "AgentAddress")
					$this->AgentAddress = $sValue;
				elseif ($sName === "ReceiverAddresses")
					//$this->ReceiverAddresses = $sValue;
					$this->ReceiverAddresses = str_replace("\"","",$sValue);
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ChSnmp_confs {
	public $arrSnmpConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new ChSnmp_conf();
		$this->arrSnmpConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrSnmpConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrSnmpConfs[$i++]) {
			$sRes = $sRes . "[SNMP]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrSnmpConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}

	public function DoSectionForSnmpdConf() {
		$sRes = "";
		foreach($this->arrSnmpConfs as $key => $value){
			if(!empty($value)) $sRes .= "trap2sink " . trim($value) . " public\n";
		}
		foreach($this->arrSnmpConfs as $key => $value){
			if(!empty($value)) $sRes .= "rwcommunity public " . trim($value) . "\n";
		}
		return $sRes;
	}
};


//-------------------------------------------------------------------------------------------- 

class Channel_conf extends CustomSection {
	public $Connection  = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "Connection=" . $this->Connection . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function GetChannelNumber() {
		$sRes = $this->SectionName;
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "Connection")
					$this->Connection = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Channel_confs {
	public $arrConConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Channel_conf();
		$this->arrConConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrConConfs[(int)$iIndex];
	}

	/*
	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrConConfs[$i++]) {
			$sRes = $sRes . "[Channel.".$i."]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrConConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
	*/
	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrConConfs[$i++]) {
			$sRes = $sRes . "[" . $obj->GetChannelNumber()."]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrConConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
	

};

//-------------------------------------------------------------------------------------------- 

class ChAudio_conf extends CustomSection {
	public $SectionName = "";
	public $InDevice = "";
	public $OutDevice = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "InDevice=" . $this->InDevice . "\n"
				. "OutDevice=" . $this->OutDevice . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "InDevice")
					$this->InDevice = $sValue;
				elseif ($sName === "OutDevice")
					$this->OutDevice = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ChAudio_confs {
	public $arrAudioConfs = array();

	public function AddAsSection($sSection,$sSectionName) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new ChAudio_conf();
		$obj->SectionName = $sSectionName;
		$this->arrAudioConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrAudioConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrAudioConfs[$i++]) {
			//var_dump($i);
			$sRes = $sRes . "[" . $this->arrAudioConfs[$i-1]->SectionName . "]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrAudioConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}

};

//-------------------------------------------------------------------------------------------- 

class ChSip_conf extends CustomSection {
	public $SectionName = "";
	public $Capacity = "";
	public $ReceiverAddress = "";
	public $URIScheme = "";
	public $MediaPorts = "";
	public $MediaAddress = "";
	public $UACRegisterCount = "";
	public $UACRegister = array();
	public $UACSubscriberCount = "";
	public $UACSubscriber = array();

	public function vname()
	{
		//$old = $var;
		//if (($key = array_search($var = 'unique'.rand().'value', !$scope ? $GLOBALS : $scope)) && $var = $old) return $key;  
        //var_dump(get_object_vars($this));
		$prop = get_object_vars($this);
		foreach($prop as $key => $value){
			
		}
    }
	
	public function GetAsFullCfgString() {

		//$this->vname();
		//return;
		//$zzz = "lkbmvrltkmlbm";
		//echo '$' . $this->vname($zzz), PHP_EOL;

		$UACRegisterLine = "";
		if(!empty($this->UACRegister)){
			foreach($this->UACRegister as $key => $value){
				$UACRegisterLine .= "UACRegister" . $key . "=" . $value . "\n";
			}
		}
		$UACSubscriberLine = "";
		if(!empty($this->UACSubscriber)){
			foreach($this->UACSubscriber as $key => $value){
				$UACSubscriberLine .= "UACSubscriber" . $key . "=" . $value . "\n";
			}
		}

		$sRes = parent::GetCommentLines()
				. "Capacity=" . $this->Capacity . "\n"
				. "ReceiverAddress=" . $this->ReceiverAddress . "\n"
				. "URIScheme=" . $this->URIScheme . "\n"
				. "MediaPorts=" . $this->MediaPorts . "\n"
				. "MediaAddress=" . $this->MediaAddress . "\n"
				. "UACRegisterCount=" . $this->UACRegisterCount . "\n"
				. $UACRegisterLine
				. "UACSubscriberCount=" . $this->UACSubscriberCount . "\n"
				. $UACSubscriberLine
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "Capacity")
					$this->Capacity = $sValue;
				elseif ($sName === "ReceiverAddress")
					$this->ReceiverAddress = $sValue;
				elseif ($sName === "URIScheme")
					$this->URIScheme = $sValue;
				elseif ($sName === "MediaPorts")
					$this->MediaPorts = $sValue;
				elseif ($sName === "MediaAddress")
					$this->MediaAddress = $sValue;
				elseif ($sName === "UACRegisterCount")
					$this->UACRegisterCount = $sValue;
				elseif ($sName === "UACSubscriberCount")
					$this->UACSubscriberCount = $sValue;

				elseif (strpos($sName, 'UACRegister') !== false){
					$i = str_replace('UACRegister','',$sName);
					$this->UACRegister[$i] = $sValue;
				}
				elseif (strpos($sName, 'UACSubscriber') !== false){
					$i = str_replace('UACSubscriber','',$sName);
					$this->UACSubscriber[$i] = $sValue;
				}

				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ChSip_confs {
	public $arrSipConfs = array();

	public function AddAsSection($sSection,$sSectionName) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new ChSip_conf();
		$obj->SectionName = $sSectionName;
		$this->arrSipConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrSipConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrSipConfs[$i++]) {
			$sRes = $sRes . "[SIP.4]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrSipConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

//-------------------------------------------------------------------------------------------- 

class ChRadioLira_conf extends CustomSection {
	public $ChannelNumber = "";
	public $ChannelType = "";
	public $SectionName = "";
	public $LocalAddress = "";
	public $LocalAddressPort = "";
	public $RemoteAddress = "";
	public $RemoteAddressPort = "";
	public $LocationType = "";
	public $LocationPlace = "";
	public $CallName = "";

	/*
	public function GetAsFullCfgString() {
		if(!empty($this->LocalAddressPort)) $this->LocalAddressPort = ":" . $this->LocalAddressPort;
		if(!empty($this->RemoteAddressPort)) $this->RemoteAddressPort = ":" . $this->RemoteAddressPort;
		if(!empty($this->LocationPlace)) {
			$this->LocationPlace = "_#" . $this->LocationPlace;
			$sRes = parent::GetCommentLines()
				. "Location=" . $this->LocationType . $this->LocationPlace . "\n"
				. parent::GetUnknownLines();
		} else {
			$sRes = parent::GetCommentLines()
				. "LocalAddress=" . $this->LocalAddress . $this->LocalAddressPort. "\n"
				. "RemoteAddress=" . $this->RemoteAddress . $this->RemoteAddressPort . "\n"
				. parent::GetUnknownLines();
		}
		return $sRes;
	}
	*/
	/*
	public function GetAsFullCfgString() {

		//$sRes = ""; //parent::GetCommentLines();
		$sRes = parent::GetCommentLines();

		if(!empty($this->LocalAddressPort)) {
			$this->LocalAddress = "LocalAddress=" . $this->LocalAddress . ":" . $this->LocalAddressPort;
			$sRes = $sRes . $this->LocalAddress . "\n";
		}
		if(!empty($this->RemoteAddressPort)) {
			$this->RemoteAddress = "RemoteAddress=" . $this->RemoteAddress . ":" . $this->RemoteAddressPort;
			$sRes = $sRes . $this->RemoteAddress . "\n";
		}
		if(!empty($this->LocationPlace)) {
			$this->LocationType = "Location=" . $this->LocationType . "_#" . $this->LocationPlace;
			$sRes = $sRes . $this->LocationType . "\n";
		}
		
		$sRes = $sRes . parent::GetUnknownLines();
		
		return $sRes;
	}
	*/
	public function GetAsFullCfgString() {

		$sRes = parent::GetCommentLines();

		if(!empty($this->LocalAddress)) {
			if(!empty($this->LocalAddressPort)) $this->LocalAddressPort = ":" . trim($this->LocalAddressPort);
			$this->LocalAddress = "LocalAddress=" . $this->LocalAddress . $this->LocalAddressPort;
			$sRes = $sRes . $this->LocalAddress . "\n";
		}
		if(!empty($this->RemoteAddress)) {
			if(!empty($this->RemoteAddressPort)) $this->RemoteAddressPort = ":" . trim($this->RemoteAddressPort);
			$this->RemoteAddress = "RemoteAddress=" . $this->RemoteAddress . $this->RemoteAddressPort;
			$sRes = $sRes . $this->RemoteAddress . "\n";
		}
		if(!empty($this->LocationType)) {
			if(!empty($this->LocationPlace)) $this->LocationPlace = "_#" . $this->LocationPlace;
			$this->LocationType = "Location=" . $this->LocationType . $this->LocationPlace;
			$sRes = $sRes . $this->LocationType . "\n";
		}
		if(!empty($this->CallName)) {
			$this->CallName = "CallName=" . $this->CallName;
			$sRes = $sRes . $this->CallName . "\n";
		}
		
		$sRes = $sRes . parent::GetUnknownLines();
		
		return $sRes;
	}


	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "LocalAddress"){
					$arrLocalAddress = explode(":",$sValue);
					if(isset($arrLocalAddress[0])) $this->LocalAddress = $arrLocalAddress[0]; else $this->LocalAddress = "";
					if(isset($arrLocalAddress[1])) $this->LocalAddressPort = $arrLocalAddress[1]; else $this->LocalAddressPort = "";
				}
				elseif ($sName === "RemoteAddress"){
					$arrRemoteAddress = explode(":",$sValue);
					if(isset($arrRemoteAddress[0])) $this->RemoteAddress = $arrRemoteAddress[0]; else $this->RemoteAddress = "";
					if(isset($arrRemoteAddress[1])) $this->RemoteAddressPort = $arrRemoteAddress[1]; else $this->RemoteAddressPort = "";
				}
				elseif ($sName === "Location"){
					$arrLocation = explode("_#",$sValue);
					if(isset($arrLocation[0])) $this->LocationType = $arrLocation[0]; else $this->LocationType = "";
					if(isset($arrLocation[1])) $this->LocationPlace = $arrLocation[1]; else $this->arrLocation = "";
				}
				elseif ($sName === "CallName"){
					$CallName = $sValue;
					if(isset($CallName)) $this->CallName = $CallName; else $this->CallName = "";
				}
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class ChRadioLira_confs {
	public $arrRadioLiraConfs = array();

	public function AddAsSection($sSection,$sSectionName) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new ChRadioLira_conf();
		$obj->SectionName = $sSectionName;
		$obj->ChannelType = strpos($sSectionName,"RADIO-LIRA.")!==false ? "радио" : "РП";

		$obj->ChannelNumber = str_replace("LIRA.","",str_replace("RADIO-LIRA.","",$sSectionName));

		$this->arrRadioLiraConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrRadioLiraConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrRadioLiraConfs[$i++]) {
			//var_dump($i);
			$sRes = $sRes . "[" . $this->arrRadioLiraConfs[$i-1]->SectionName . "]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrRadioLiraConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}

};



# ######################################

/*
class ChannelConfFile extends CustomConfFile {
	public $mainconf;
	public $snmpconf;
	public $channelconf;
	public $liraconf;
	public $audioconf;
	public $sipconf;
	public $radioliraconf;
	public $fileconf;
	public $unknownparams;



	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->mainconf = new Main_confs();
		$this->snmpconf = new ChSnmp_confs();
		$this->channelconf = new Channel_confs();
		$this->audioconf = new ChAudio_confs();
		$this->sipconf = new ChSip_confs();
		$this->radioliraconf = new ChRadioLira_confs();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "MAIN")
				$this->mainconf->AddAsSection($sSectionValues);
			elseif ($sSectionName === "SNMP")
				$this->snmpconf->AddAsSection($sSectionValues);
			elseif (  strpos($sSectionName, 'Channel.') !== false && $sSectionName != "Channel.2147483647" )
				$this->channelconf->AddAsSection($sSectionValues);

			//elseif (  strpos($sSectionName, 'LIRA.') !== false )
			//	$this->liraconf->AddAsSection($sSectionValues);
			elseif (  strpos($sSectionName, 'AUDIO.') !== false )
				$this->audioconf->AddAsSection($sSectionValues,$sSectionName);
			elseif (  strpos($sSectionName, 'SIP.') !== false )
				$this->sipconf->AddAsSection($sSectionValues,$sSectionName);
			elseif (  strpos($sSectionName, 'RADIO-LIRA.') !== false )
				$this->radioliraconf->AddAsSection($sSectionValues,$sSectionName);
			elseif (  strpos($sSectionName, 'LIRA.') !== false )
				$this->radioliraconf->AddAsSection($sSectionValues,$sSectionName);
			//elseif (  strpos($sSectionName, 'FILE.') !== false )
			//	$this->fileconf->AddAsSection($sSectionValues);

			else 
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		$this->PutLine($this->mainconf->GetAsSections());
		$this->PutLine($this->snmpconf->GetAsSections());
		$this->PutLine($this->channelconf->GetAsSections());

		$this->PutLine($this->audioconf->GetAsSections());
		$this->PutLine($this->sipconf->GetAsSections());
		$this->PutLine($this->radioliraconf->GetAsSections());


		if (count($this->unknownparams) > 0) {
			//$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}
	
	
};
*/


class ChannelConfFile extends CustomConfFile {
	public $mainconf;
	public $snmpconf;
	public $channelconf;
	public $liraconf;
	public $audioconf;
	public $sipconf;
	public $radioliraconf;
	public $fileconf;
	public $unknownparams;



	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->mainconf = new Main_confs();
		$this->snmpconf = new ChSnmp_confs();
		$this->channelconf = new Channel_confs();
		$this->audioconf = new ChAudio_confs();
		$this->sipconf = new ChSip_confs();
		$this->radioliraconf = new ChRadioLira_confs();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "MAIN")
				$this->mainconf->AddAsSection($sSectionValues);
			elseif ($sSectionName === "SNMP")
				$this->snmpconf->AddAsSection($sSectionValues);
			elseif (  strpos($sSectionName, 'Channel.') !== false && $sSectionName != "Channel.2147483647" )
				$this->channelconf->AddAsSection($sSectionValues);

			//elseif (  strpos($sSectionName, 'LIRA.') !== false )
			//	$this->liraconf->AddAsSection($sSectionValues);
			elseif (  strpos($sSectionName, 'AUDIO.') !== false )
				$this->audioconf->AddAsSection($sSectionValues,$sSectionName);
			elseif (  strpos($sSectionName, 'SIP.') !== false )
				$this->sipconf->AddAsSection($sSectionValues,$sSectionName);
			elseif (  strpos($sSectionName, 'RADIO-LIRA.') !== false )
				$this->radioliraconf->AddAsSection($sSectionValues,$sSectionName);
			elseif (  strpos($sSectionName, 'LIRA.') !== false )
				$this->radioliraconf->AddAsSection($sSectionValues,$sSectionName);
			//elseif (  strpos($sSectionName, 'FILE.') !== false )
			//	$this->fileconf->AddAsSection($sSectionValues);

			else 
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	/*
	function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		$this->PutLine($this->mainconf->GetAsSections());
		$this->PutLine($this->snmpconf->GetAsSections());
		$this->PutLine($this->channelconf->GetAsSections());

		$this->PutLine($this->audioconf->GetAsSections());
		$this->PutLine($this->sipconf->GetAsSections());
		$this->PutLine($this->radioliraconf->GetAsSections());


		if (count($this->unknownparams) > 0) {
			//$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}
	*/
	
	function FixToFile() {

		//$this->doBackup();
		//$this->doBuffer();
		
		//$this->sFileName = $this->sFileName.'.tmp';

		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		$this->PutLine($this->mainconf->GetAsSections());
		$this->PutLine($this->snmpconf->GetAsSections());
		$this->PutLine($this->channelconf->GetAsSections());

		$this->PutLine($this->audioconf->GetAsSections());
		$this->PutLine($this->sipconf->GetAsSections());
		$this->PutLine($this->radioliraconf->GetAsSections());


		if (count($this->unknownparams) > 0) {
			//$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
		
		
		$this->copyBufferToConf();
		
	}
	
	
	
};





# ######################################


class ReceiverConfFile extends CustomConfFile {
	public $snmpconf;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->snmpconf = new ChSnmp_confs();
	}

	function FixToFile() {
		$this->RemoveMatchLine("trap2sink, rwcommunity");
		$this->PutLineFirst($this->snmpconf->DoSectionForSnmpdConf());
	}
};


?>
