<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("COMMONCONFFILE", '/usr/local/etc/common.cfg');
define("HOSTNAME", '/etc/hostname');

class Common_conf extends CustomSection {
	public $kts_name  = "";
	public $kts_version = "";
	public $kts_id  = "";
	public $basickbd  = "";
	public $device_id  = "";
	public $device_fixed  = "";
	public $extkbd  = "";
	public $timeout  = "";
	public $duration  = "";
	public $MissedIndicationTimeout  = "";
//	public $VolumeSpk  = "";
//	public $VolumeMic  = "";
//	public $VolHandSpk  = "";
//	public $VolHandMic  = "";
	public $rtp_radio  = "";
	public $rtp_ggs  = "";
	public $vad_indication = "";
	public $self_listing = "";
	public $encoder = "";
	 
	 
	
//	public $Comments = array();
//	public $Unknowns = array();
	//public $Comments = "";
	//public $Unknowns = "";
	
	
	public function GetAsFullCfgString() {
		
//$zz = parent::GetCommentLines();
//var_dump( $zz );return;		
		$sRes = parent::GetCommentLines()
				. "kts_name=" . $this->kts_name . "\n"
				. "kts_version=" . $this->kts_version . "\n"
				. "kts_id=" . $this->kts_id . "\n"
				. "basickbd=" . $this->basickbd . "\n"
				. "device_id=" . $this->device_id . "\n"
				. "device_fixed=" . $this->device_fixed . "\n"
				. "extkbd=" . $this->extkbd . "\n"
				. "timeout=" . $this->timeout . "\n"
				. "duration=" . $this->duration . "\n"
				. "MissedIndicationTimeout=" . $this->MissedIndicationTimeout . "\n"
//				. "VolumeSpk=" . $this->VolumeSpk . "\n"
//				. "VolumeMic=" . $this->VolumeMic . "\n"
//				. "VolHandSpk=" . $this->VolHandSpk . "\n"
//				. "VolHandMic=" . $this->VolHandMic . "\n"
				. "rtp_radio=" . $this->rtp_radio . "\n"
				. "rtp_ggs=" . $this->rtp_ggs . "\n"
				. "vad_indication=" . $this->vad_indication . "\n"
				. "self_listing=" . $this->self_listing . "\n"
				. "encoder=" . $this->encoder . "\n"
				. parent::GetUnknownLines();
		//var_dump($this);
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "kts_name")
					$this->kts_name = $sValue;
				elseif ($sName === "kts_version")
					$this->kts_version = $sValue;
				elseif ($sName === "kts_id")
					$this->kts_id = $sValue;
				elseif ($sName === "basickbd")
					$this->basickbd = $sValue;
				elseif ($sName === "device_id")
					$this->device_id = $sValue;
				elseif ($sName === "device_fixed")
					$this->device_fixed = $sValue;
				elseif ($sName === "extkbd")
					$this->extkbd = $sValue;
				elseif ($sName === "timeout")
					$this->timeout = $sValue;
				elseif ($sName === "duration")
					$this->duration = $sValue;
				elseif ($sName === "MissedIndicationTimeout")
					$this->MissedIndicationTimeout = $sValue;
//				elseif ($sName === "VolumeSpk")
//					$this->VolumeSpk = $sValue;
//				elseif ($sName === "VolumeMic")
//					$this->VolumeMic = $sValue;
//				elseif ($sName === "VolHandSpk")
//					$this->VolHandSpk = $sValue;
//				elseif ($sName === "VolHandMic")
//					$this->VolHandMic = $sValue;
				elseif ($sName === "rtp_radio")
					$this->rtp_radio = $sValue;
				elseif ($sName === "rtp_ggs")
					$this->rtp_ggs = $sValue;
				elseif ($sName === "vad_indication")
					$this->vad_indication = $sValue;
				elseif ($sName === "self_listing")
					$this->self_listing = $sValue;
				elseif ($sName === "encoder")
					$this->encoder = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Common_confs  {
	public $arrCommonConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Common_conf();
		$this->arrCommonConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrCommonConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrCommonConfs[$i++]) {
			$sRes = $sRes . "[common]\n" . $obj->GetAsFullCfgString();
//var_dump($i.' '.$Res);return;		
			if ($i < count($this->arrCommonConfs))
				$sRes = $sRes . "\n";
		};
//var_dump($sRes); return;
		return $sRes;
	}
};


//-------------------------------------------------------------------------------------------- 




class AudioCommon_conf extends CustomSection {
    public $VolumeSpk = "";
    public $VolumeMic = "";
	public $VolHandSpk = "";
	public $VolHandMic = ""; 
	public $mic_gain = "";
	public $rec_gain = "";
	public $spk_gain = "";
	
	public function GetAsFullCfgString() {
		
		$sRes = parent::GetCommentLines()
				. "VolumeSpk=" . $this->VolumeSpk . "\n"
				. "VolumeMic=" . $this->VolumeMic . "\n"
				. "VolHandSpk=" . $this->VolHandSpk . "\n"
				. "VolHandMic=" . $this->VolHandMic . "\n"
				. "mic_gain=" . $this->mic_gain . "\n"
				. "rec_gain=" . $this->rec_gain . "\n"
				. "spk_gain=" . $this->spk_gain . "\n"
				. parent::GetUnknownLines();
		//var_dump($this);
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "VolumeSpk")
					$this->VolumeSpk = $sValue;
				elseif ($sName === "VolumeMic")
					$this->VolumeMic = $sValue;
				elseif ($sName === "VolHandSpk")
					$this->VolHandSpk = $sValue;
				elseif ($sName === "VolHandMic")
					$this->VolHandMic = $sValue;
				elseif ($sName === "mic_gain")
					$this->mic_gain = $sValue;
				elseif ($sName === "rec_gain")
					$this->rec_gain = $sValue;
				elseif ($sName === "spk_gain")
					$this->spk_gain = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class AudioCommon_confs  {
	public $arrAudioCommonConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new AudioCommon_conf();
		$this->arrAudioCommonConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrAudioCommonConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrAudioCommonConfs[$i++]) {
			$sRes = $sRes . "[audio]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrAudioCommonConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};


//-------------------------------------------------------------------------------------------- 




class Net_conf extends CustomSection {
	public $dhcp  = "";
	public $ip  = "";
	public $mask  = "";
	public $gate  = "";
	public $dns1  = "";
	public $dns2  = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "dhcp=" . $this->dhcp . "\n"
				. "ip=" . $this->ip . "\n"
				. "mask=" . $this->mask . "\n"
				. "gate=" . $this->gate . "\n"
				. "dns1=" . $this->dns1 . "\n"
				. "dns2=" . $this->dns2 . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "dhcp")
					$this->dhcp = $sValue;
				elseif ($sName === "ip")
					$this->ip = $sValue;
				elseif ($sName === "mask")
					$this->mask = $sValue;
				elseif ($sName === "gate")
					$this->gate = $sValue;
				elseif ($sName === "dns1")
					$this->dns1 = $sValue;
				elseif ($sName === "dns2")
					$this->dns2 = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Net_confs {
	public $arrNetConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Net_conf();
		$this->arrNetConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrNetConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrNetConfs[$i++]) {
			$sRes = $sRes . "[net]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrNetConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

//-------------------------------------------------------------------------------------------- 


class Snmp_conf extends CustomSection {
	public $snmp_state  = "";
	public $snmp_receiver1  = "";
	public $snmp_receiver2  = "";
	public $snmp_port  = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "snmp_state=" . $this->snmp_state . "\n"
				. "snmp_receiver1=" . $this->snmp_receiver1 . "\n"
				. "snmp_receiver2=" . $this->snmp_receiver2 . "\n"
				. "snmp_port=" . $this->snmp_port . "\n"
				. parent::GetUnknownLines();
//var_dump($sRes); return;
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "snmp_state")
					$this->snmp_state = $sValue;
				elseif ($sName === "snmp_receiver1")
					$this->snmp_receiver1 = $sValue;
				elseif ($sName === "snmp_receiver2")
					$this->snmp_receiver2 = $sValue;
				elseif ($sName === "snmp_port")
					$this->snmp_port = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Snmp_confs {
	public $arrSnmpConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Snmp_conf();
		$this->arrSnmpConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrSnmpConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrSnmpConfs[$i++]) {
			$sRes = $sRes . "[snmp]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrSnmpConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

//-------------------------------------------------------------------------------------------- 


class Time_conf extends CustomSection {
	public $ntp  = "";
	public $ntp_server1  = "";
	public $ntp_server2  = "";
	public $ntp_interval = "";
	public $ntp_utc = "";

	public $time_year  = "";
	public $time_month  = "";
	public $time_day  = "";
	public $time_hour  = "";
	public $time_min  = "";
	public $time_sec  = "";

	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "ntp=" . $this->ntp . "\n"
				. "ntp_server1=" . $this->ntp_server1 . "\n"
				. "ntp_server2=" . $this->ntp_server2 . "\n"
				. "ntp_interval=" . $this->ntp_interval . "\n"
				. "ntp_utc=" . $this->ntp_utc . "\n"
				. "time_year=" . $this->time_year . "\n"
				. "time_month=" . $this->time_month . "\n"
				. "time_day=" . $this->time_day . "\n"
				. "time_hour=" . $this->time_hour . "\n"
				. "time_min=" . $this->time_min . "\n"
				. "time_sec=" . $this->time_sec . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "ntp")
					$this->ntp = $sValue;
				elseif ($sName === "ntp_server1")
					$this->ntp_server1 = $sValue;
				elseif ($sName === "ntp_server2")
					$this->ntp_server2 = $sValue;
				elseif ($sName === "ntp_interval")
					$this->ntp_interval = $sValue;
				elseif ($sName === "ntp_utc")
					$this->ntp_utc = $sValue;

				elseif ($sName === "time_year")
					$this->time_year = $sValue;
				elseif ($sName === "time_month")
					$this->time_month = $sValue;
				elseif ($sName === "time_day")
					$this->time_day = $sValue;
				elseif ($sName === "time_hour")
					$this->time_hour = $sValue;
				elseif ($sName === "time_min")
					$this->time_min = $sValue;
				elseif ($sName === "time_sec")
					$this->time_sec = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Time_confs {
	public $arrTimeConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Time_conf();
		$this->arrTimeConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrTimeConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrTimeConfs[$i++]) {
			$sRes = $sRes . "[ntp]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrTimeConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};


//-------------------------------------------------------------------------------------------- 


class ChRadioLira_common_conf extends CustomSection {
	public $Speaker = "1";
	public $Microphone = "2";
	public $Recorder = "3";
	public $Sip = "4";

	public $Handset = "";
	public $Headset = "";
	public $External_speaker = "";
	public $Tangenta = "";
	public $Table_microphone = "";

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "Speaker=" . $this->Speaker . "\n"
				. "Microphone=" . $this->Microphone . "\n"
				. "Recorder=" . $this->Recorder . "\n"
				. "Sip=" . $this->Sip . "\n"
				. "Handset=" . $this->Handset . "\n"
				. "Headset=" . $this->Headset . "\n"
				. "External_speaker=" . $this->External_speaker . "\n"
				. "Tangenta=" . $this->Tangenta . "\n"
				. "Table_microphone=" . $this->Table_microphone . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "Speaker")
					$this->Speaker = $sValue;
				elseif ($sName === "Microphone")
					$this->Microphone = $sValue;
				elseif ($sName === "Recorder")
					$this->Recorder = $sValue;
				elseif ($sName === "Sip")
					$this->Sip = $sValue;

				elseif ($sName === "Handset")
					$this->Handset = $sValue;
				elseif ($sName === "Headset")
					$this->Headset = $sValue;
				elseif ($sName === "External_speaker")
					$this->External_speaker = $sValue;
				elseif ($sName === "Tangenta")
					$this->Tangenta = $sValue;
				elseif ($sName === "Table_microphone")
					$this->Table_microphone = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}	
};

class ChRadioLira_common_confs {
	public $arrRadioLiraConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new ChRadioLira_common_conf();
		$this->arrRadioLiraConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}


	public function GetByIndex($iIndex) {
		return $this->arrRadioLiraConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrRadioLiraConfs[$i++]) {
			$sRes = $sRes . "[channels]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrRadioLiraConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

//-------------------------------------------------------------------------------------------- 





# ######################################
class CommonConfFile extends CustomConfFile {
	public $comconf;
	public $audioconf;
	public $netconf;
	public $timeconf;
	public $snmpconf;
	public $unknownparams;
	public $channelconf;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->comconf = new Common_confs();
		$this->audioconf = new AudioCommon_confs();
		$this->netconf = new Net_confs();
		$this->timeconf = new Time_confs();
		$this->snmpconf = new Snmp_confs();
		$this->unknownparams = array();
		$this->channelconf = new ChRadioLira_common_confs();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "common")
				$this->comconf->AddAsSection($sSectionValues);
			elseif ($sSectionName === "audio")
				$this->audioconf->AddAsSection($sSectionValues);
			elseif ($sSectionName === "net")
				$this->netconf->AddAsSection($sSectionValues);
			elseif ($sSectionName === "ntp")
				$this->timeconf->AddAsSection($sSectionValues);
			elseif ($sSectionName === "snmp")
				$this->snmpconf->AddAsSection($sSectionValues);
			elseif ($sSectionName === "channels")
				$this->channelconf->AddAsSection($sSectionValues);
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		//$this->PutLine($this->ctrl->GetAsSections());
		$this->PutLine($this->comconf->GetAsSections());
		$this->PutLine($this->audioconf->GetAsSections());
		$this->PutLine($this->netconf->GetAsSections());
		$this->PutLine($this->timeconf->GetAsSections());
		$this->PutLine($this->snmpconf->GetAsSections());
		$this->PutLine($this->channelconf->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};

		$this->copyBufferToConf();
		
	}
};


?>
