<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("KEYTYPECONFFILE", '/usr/local/etc/keytype.cfg');

class KeyType_list extends CustomSection {
	public $kt_id  = "";
	public $kt_func = "";
	public $kt_name = "";
	public $kt_pref = "";
	public $keygroup_id = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "kt_id=" . $this->kt_id . "\n"
				. "kt_func=" . $this->kt_func . "\n"
				. "kt_name=" . $this->kt_name . "\n"
				. "kt_pref=" . $this->kt_pref . "\n"
				. "keygroup_id=" . $this->keygroup_id . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "kt_id")
					$this->kt_id = $sValue;
				elseif ($sName === "kt_func")
					$this->kt_func = $sValue;
				elseif ($sName === "kt_name")
					$this->kt_name = $sValue;
				elseif ($sName === "kt_pref")
					$this->kt_pref = $sValue;
				elseif ($sName === "keygroup_id")
					$this->keygroup_id = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class KeyType_lists {
	public $arrKeyTypes = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new KeyType_list();
		$this->arrKeyTypes[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrKeyTypes[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrKeyTypes[$i++]) {
			$sRes = $sRes . "[keytype]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrKeyTypes))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

# ######################################
class KeytypeConfFile extends CustomConfFile {
	public $keytype;
	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->keytype = new KeyType_lists();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "keytype")
				$this->keytype->AddAsSection($sSectionValues);
			//elseif ($sSectionName === "kt_name")
			//	$this->kt_name->AddAsSection($sSectionValues);
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		//$this->PutLine($this->ctrl->GetAsSections());
		$this->PutLine($this->kt_id->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}
};
# ######################################
?>
