<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("ROUTERCONFFILE", '/usr/local/etc/router.conf');

define("PATTERN_TYPE_BASIC", 0);
define("PATTERN_TYPE_TIMEOUT", 1);
define("PATTERN_TYPE_REDIRECT", 2);

class Router_ctrl extends CustomSection {
	public $session_timeout = "7";
	public $host = "127.0.0.1:20000";
	public $cdr_hosts = "192.168.1.200:35500";
	//public $require_incoming_dtmf = "true";
	//public $require_outgoing_dtmf = "true";

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = trim(current($tmpARR));

		$iFormat = 0;
		$sName = "";
		$sValue = "";

		$i = 0;
		while ($i++ < count($tmpARR)) {
			parent::CheckValue($sTMP, $iFormat, $sName, $sValue);
			switch ($iFormat) {
				case 1:
					if ($sName === "session timeout") { $this->session_timeout = $sValue;	} else
					if ($sName === "host") { $this->host = $sValue;	} else
					if ($sName === "cdr hosts") { $this->cdr_hosts = $sValue;	} else
					//if ($sName === "require incoming dtmf") {
					//	$this->require_incoming_dtmf = $sValue;	} else
					//if ($sName === "require outgoing dtmf") {
					//	$this->require_outgoing_dtmf = $sValue;	} else
					parent::AddUnknownLine($sTMP);
					break;
				case 2:
					parent::AddCommentLine($sTMP);
					break;
			};
			$sTMP = trim(next($tmpARR));
		};
	}

	public function GetAsSections() {
		$sRes = "[ctrl]\n";
		$sRes = $sRes . parent::GetCommentLines();
		$sRes = $sRes . "session timeout=" . $this->session_timeout . "\n";
		$sRes = $sRes . "host=" . $this->host . "\n";
		$sRes = $sRes . "cdr hosts=" . $this->cdr_hosts . "\n";
		//$sRes = $sRes . "require incoming dtmf=" . $this->require_incoming_dtmf . "\n";
		//$sRes = $sRes . "require outgoing dtmf=" . $this->require_outgoing_dtmf . "\n";
		$sRes = $sRes . parent::GetUnknownLines();
		return $sRes;
	}
};

class Router_pattern extends CustomSection {
	public $name = "";
	public $called = "";
	public $caller = "";
	public $group = "";
	public $target = "";
	public $type = PATTERN_TYPE_BASIC;
	public $targets = array('1','2');
	
	public function GetAsFullCfgString() {

		foreach ($this->targets as $key => $value) {
			//$target = $target."target=".$value."\n";
			$target = $target.$value." ";
		}
		$target = "target=".$target."\n";

		$name = (empty($this->name))?"":"name=" . $this->name . "\n";
		$caller = (empty($this->caller))?"":"caller=" . $this->caller . "\n";
		$group = (empty($this->group))?"":"group=" . $this->group . "\n";
		
		$sRes = parent::GetCommentLines()
				. $name
				. "called=" . $this->called . "\n"
//				. "caller=" . $this->caller . "\n"
				. $caller
//				. "group=" . $this->group . "\n"
				. $group
				. $target
				. parent::GetUnknownLines();
		return $sRes;
	}
	
	
	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "called")
					$this->called = $sValue;
				elseif ($sName === "caller")
					$this->caller = $sValue;
				elseif ($sName === "group")
					$this->group = $sValue;
				elseif ($sName === "target")
					$this->target = $sValue;
				elseif ($sName === "name")
					$this->name = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Router_patterns {
	public $arrPatterns = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Router_pattern();
		$this->arrPatterns[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function AddAsSectionEx($sSection, $patterntype) {
		$obj = $this->AddAsSection($sSection);
		if ($obj)
			$obj->type = $patterntype;
	}

	public function GetByIndex($iIndex) {
		return $this->arrPatterns[(int)$iIndex];
	}

	public function GetByTarget($bName) {
		$i = 0;
		do {
			$obj = $this->GetByIndex($i++);
			if ($obj != null) {
				if ($obj->target === $bName) {
					break;
				};
			};
		} while ($obj != null);
		return $obj;
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while (($obj = $this->arrPatterns[$i++])) {
			//$sRes = $sRes . "[pattern]\n" . $objValue->GetAsFullCfgString();
			switch ($obj->type) {
				case PATTERN_TYPE_BASIC:
					$sRes = $sRes . "[pattern]\n";
					break;
				case PATTERN_TYPE_TIMEOUT:
					$sRes = $sRes . "[timeout pattern]\n";
					break;
				case PATTERN_TYPE_REDIRECT:
					$sRes = $sRes . "[redirect pattern]\n";
					break;
				default:
					break;
			}
			$sRes = $sRes . $obj->GetAsFullCfgString();

			if ($i < count($this->arrPatterns))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

class Router_target_ak extends CustomSection {
	public $name = "";
	public $slot = 0;
	public $channel = 0;
	public $income_caller_id = "";
	public $outcome_caller_id = "";
	public $called = "";

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "name=" . $this->name . "\n"
				. "slot=" . $this->slot . "\n"
				. "channel=" . $this->channel . "\n"
				. "incoming caller id=" . $this->income_caller_id . "\n"
				. "outcoming caller id=" . $this->outcome_caller_id . "\n"
				. "called=" . $this->called . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "name")
					$this->name = $sValue;
				elseif ($sName === "slot")
					$this->slot = $sValue;
				elseif ($sName === "channel")
					$this->channel = $sValue;
				elseif ($sName === "incoming caller id")
					$this->income_caller_id = $sValue;
				elseif ($sName === "outcoming caller id")
					$this->outcome_caller_id = $sValue;
				elseif ($sName === "called")
					$this->called = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Router_target_aks {
	public $arrAKTargets = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Router_target_ak();
		$this->arrAKTargets[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrAKTargets[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrAKTargets[$i++]) {
			$sRes = $sRes . "[ak]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrAKTargets))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

class Router_target_modem extends CustomSection {
	public $name = "";
	public $originate = "no";
	public $fax = "no";

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "name=" . $this->name . "\n"
				. "originate=" . $this->originate . "\n"
				. "fax=" . $this->fax . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "name")
					$this->name = $sValue;
				elseif ($sName === "originate")
					$this->originate = $sValue;
				elseif ($sName === "fax")
					$this->fax = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Router_target_modems {
	public $arrModemTargets = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Router_target_modem();
		$this->arrModemTargets[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrModemTargets[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrModemTargets[$i++]) {
			$sRes = $sRes . "[modem]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrModemTargets))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

/*
class Router_connection extends CustomSection {
	public $type = "";
	public $radio_rx_addr = "";
	public $radio_rx_port = "";
	public $radio_tx_addr = "";
	public $radio_tx_port = "";
	public $radio_freq_no = "";
	public $radio_freq_chan = "";
	public $cas_trunk_no = "";
	public $cas_trunk_timeslot = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "type=" . $this->type . "\n"
				. "radio_rx_addr=" . $this->radio_rx_addr . "\n"
				. "radio_rx_port=" . $this->radio_rx_port . "\n"
				. "radio_tx_addr=" . $this->radio_tx_addr . "\n"
				. "radio_tx_port=" . $this->radio_tx_port . "\n"
				. "radio_freq_no=" . $this->radio_freq_no . "\n"
				. "radio_freq_chan=" . $this->radio_freq_chan . "\n"
				. "cas_trunk_no=" . $this->cas_trunk_no . "\n"
				. "cas_trunk_timeslot=" . $this->cas_trunk_timeslot . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "type")
					$this->type = $sValue;
				elseif ($sName === "radio_rx_addr")
					$this->radio_rx_addr = $sValue;
				elseif ($sName === "radio_rx_port")
					$this->radio_rx_port = $sValue;
				elseif ($sName === "radio_tx_addr")
					$this->radio_tx_addr = $sValue;
				elseif ($sName === "radio_tx_port")
					$this->radio_tx_port = $sValue;
				elseif ($sName === "radio_freq_no")
					$this->radio_freq_no = $sValue;
				elseif ($sName === "radio_freq_chan")
					$this->radio_freq_chan = $sValue;
				elseif ($sName === "cas_trunk_no")
					$this->cas_trunk_no = $sValue;
				elseif ($sName === "cas_trunk_timeslot")
					$this->cas_trunk_timeslot = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};
*/
class Router_connection extends CustomSection {
	public $type = "";
	public $radio_rx_addr = "";
	public $radio_rx_port = "";
	public $radio_tx_addr = "";
	public $radio_tx_port = "";
	public $radio_freq_no = "";
	public $radio_freq_chan = "";
	public $cas_trunk_no = "";
	public $cas_trunk_timeslot = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "type=" . $this->type . "\n"
				. "radio.rx.addr=" . $this->radio_rx_addr . "\n"
				. "radio.rx.port=" . $this->radio_rx_port . "\n"
				. "radio.tx.addr=" . $this->radio_tx_addr . "\n"
				. "radio.tx.port=" . $this->radio_tx_port . "\n"
				. "radio.freq.no=" . $this->radio_freq_no . "\n"
				. "radio.freq.chan=" . $this->radio_freq_chan . "\n"
				. "cas.trunk.no=" . $this->cas_trunk_no . "\n"
				. "cas.trunk.timeslot=" . $this->cas_trunk_timeslot . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "type")
					$this->type = $sValue;
				elseif ($sName === "radio.rx.addr")
					$this->radio_rx_addr = $sValue;
				elseif ($sName === "radio.rx.port")
					$this->radio_rx_port = $sValue;
				elseif ($sName === "radio.tx.addr")
					$this->radio_tx_addr = $sValue;
				elseif ($sName === "radio.tx.port")
					$this->radio_tx_port = $sValue;
				elseif ($sName === "radio.freq.no")
					$this->radio_freq_no = $sValue;
				elseif ($sName === "radio.freq.chan")
					$this->radio_freq_chan = $sValue;
				elseif ($sName === "cas.trunk.no")
					$this->cas_trunk_no = $sValue;
				elseif ($sName === "cas.trunk.timeslot")
					$this->cas_trunk_timeslot = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Router_connections {
	public $arrConnections = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Router_connection();
		$this->arrConnections[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrConnections[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrConnections[$i++]) {
			$sRes = $sRes . "[connection]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrConnections))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};


class Router_target_signalling extends CustomSection {
	public $name = "";
	public $called = "";
	public $caller = "";
	public $codec_set = "";
	public $sigtype = "";
	
	public $sig_ss7_cg_category = "";
	public $sig_ss7_cg_nature = "";
	public $sig_ss7_cg_inetwork = "";

	public $sig_ss7_cg_plan = "";
	public $sig_ss7_cd_nature = "";
	public $sig_ss7_cd_plan = "";
	public $sig_isdn_cg_typeofnumber = "";
	public $sig_isdn_cg_plan = "";
	public $sig_isdn_cg_screeningind = "";
	public $sig_isdn_cd_typeofnumber = "";
	public $sig_isdn_cd_plan = "";
	public $sig_isdn_cd_screeningind = "";
	public $group = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "name=" . $this->name . "\n"
				. "called=" . $this->called . "\n"
				. "caller=" . $this->caller . "\n"
				. "codec set=" . $this->codec_set . "\n"
				. "sigtype=" . $this->sigtype . "\n"

				. "ss7.cg.category=" . $this->sig_ss7_cg_category . "\n"
				. "ss7.cg.nature=" . $this->sig_ss7_cg_nature . "\n"
				. "ss7.cg.inetwork=" . $this->sig_ss7_cg_inetwork . "\n"
				. "ss7.cg.plan=" . $this->sig_ss7_cg_plan . "\n"
				. "ss7.cd.nature=" . $this->sig_ss7_cd_nature . "\n"
				. "ss7.cd.plan=" . $this->sig_ss7_cd_plan . "\n"

				. "isdn.cg.typeofnumber=" . $this->sig_isdn_cg_typeofnumber . "\n"
				. "isdn.cg.plan=" . $this->sig_isdn_cg_plan . "\n"
				. "isdn.cg.screeningind=" . $this->sig_isdn_cg_screeningind . "\n"
				. "isdn.cd.typeofnumber=" . $this->sig_isdn_cd_typeofnumber . "\n"
				. "isdn.cd.plan=" . $this->sig_isdn_cd_plan . "\n"
				. "isdn.cd.screeningind=" . $this->sig_isdn_cd_screeningind . "\n"
				. "group=" . $this->group . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "name")
					$this->name = $sValue;
				elseif ($sName === "called")
					$this->called = $sValue;
				elseif ($sName === "caller")
					$this->caller = $sValue;
				elseif ($sName === "codec set")
					$this->codec_set = $sValue;
				elseif ($sName === "sigtype")
					$this->sigtype = $sValue;

				elseif ($sName === "ss7.cg.category")
					$this->sig_ss7_cg_category = $sValue;
				elseif ($sName === "ss7.cg.nature")
					$this->sig_ss7_cg_nature = $sValue;
				elseif ($sName === "ss7.cg.inetwork")
					$this->sig_ss7_cg_inetwork = $sValue;

				elseif ($sName === "ss7.cg.plan")
					$this->sig_ss7_cg_plan = $sValue;
				elseif ($sName === "ss7.cd.nature")
					$this->sig_ss7_cd_nature = $sValue;
				elseif ($sName === "ss7.cd.plan")
					$this->sig_ss7_cd_plan = $sValue;
					
					
				elseif ($sName === "isdn.cg.typeofnumber")
					$this->sig_isdn_cg_typeofnumber = $sValue;
				elseif ($sName === "isdn.cg.plan")
					$this->sig_isdn_cg_plan = $sValue;
				elseif ($sName === "isdn.cg.screeningind")
					$this->sig_isdn_cg_screeningind = $sValue;
				elseif ($sName === "isdn.cd.typeofnumber")
					$this->sig_isdn_cd_typeofnumber = $sValue;
				elseif ($sName === "isdn.cd.plan")
					$this->sig_isdn_cd_plan = $sValue;
				elseif ($sName === "isdn.cd.screeningind")
					$this->sig_isdn_cd_screeningind = $sValue;
				elseif ($sName === "group")
					$this->group = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Router_target_signallings {
	public $arrSignallingTargets = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Router_target_signalling();
		$this->arrSignallingTargets[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrSignallingTargets[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrSignallingTargets[$i++]) {
			$sRes = $sRes . "[signalling]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrSignallingTargets))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

# ######################################
class RouterConfFile extends CustomConfFile {
	public $ctrl;
	public $patterns;
	public $targets_ak;
	public $targets_modem;
	public $targets_signalling;
	public $connection;

	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->ctrl = new Router_ctrl();
		$this->patterns = new Router_patterns();
		$this->targets_ak = new Router_target_aks();
		$this->targets_modem = new Router_target_modems();
		$this->connection = new Router_connections();
		$this->targets_signalling = new Router_target_signallings();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "ctrl")
				$this->ctrl->AddAsSection($sSectionValues);
			elseif ($sSectionName === "pattern")
				$this->patterns->AddAsSectionEx($sSectionValues, PATTERN_TYPE_BASIC);
			elseif ($sSectionName === "timeout pattern")
				$this->patterns->AddAsSectionEx($sSectionValues, PATTERN_TYPE_TIMEOUT);
			elseif ($sSectionName === "redirect pattern")
				$this->patterns->AddAsSectionEx($sSectionValues, PATTERN_TYPE_REDIRECT);
			elseif ($sSectionName === "ak")
				$this->targets_ak->AddAsSection($sSectionValues);
			elseif ($sSectionName === "modem")
				$this->targets_modem->AddAsSection($sSectionValues);
			elseif ($sSectionName === "connection")
				$this->connection->AddAsSection($sSectionValues);
			elseif ($sSectionName === "signalling")
				$this->targets_signalling->AddAsSection($sSectionValues);
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	function FixToFile() {
		$this->Clear();
		$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		//commons
		$this->PutLine($this->ctrl->GetAsSections());
		//targets
		$this->PutLine($this->targets_signalling->GetAsSections());
		$this->PutLine($this->targets_ak->GetAsSections());
		$this->PutLine($this->targets_modem->GetAsSections());
		$this->PutLine($this->connection->GetAsSections());
		//patterns
		$this->PutLine($this->patterns->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}
};
# ######################################
?>
