<?php
define("SESSION_EXPIRE_TIME_IN_MINUTES", 60 * 30 * 100);  //TODO: remove 100 for release version

class CustomSSNFile {
	private $pfFile = null;
	private $bOpen = false;
	private $sFileName = '/var/boa_sessions';
	private $tFileName = '/var/boa_timestamp';
	private $sIgnoreSeparator = "#!!-->";

	public function DoOpen() {
		if ($this->bOpen) {
			fflush($this->pfFile);
			fclose($this->pfFile);
			$this->bOpen = false;
		};
		$needHeader = false;
		if (file_exists($this->sFileName)) {
			$this->pfFile = fopen($this->sFileName, "r+");
		} else {
			$this->pfFile = fopen($this->sFileName, "w");
			$needHeader = true;
		};
		if ($this->pfFile != null) {
			$this->bOpen = true;
			flock($this->pfFile, LOCK_EX);
		} else {
			printf("Filename='%s' open - FAIL (1)\n", $this->sFileName);
		};
		if ($needHeader) {
			$sHEARD = sprintf("%57s\t%20s\t%s\t%s", "SID", "HOST IP", "STATUS", "TIME RENEW");
			$this->PutIgnoreLine($sHEARD);
		};
		return $this->bOpen;
	}
	function DoClose()
	{
		if ($this->bOpen) {
			$this->bOpen = false;
			fflush($this->pfFile);
			fclose($this->pfFile);
			return true;
		} else {
			return false;
		};
	}
	function PutLine($sLine)
	{
		if ($this->bOpen) {
			return (fputs($this->pfFile, $sLine . "\n") > 0);
		} else {
			return false;
		};
	}
	function PutIgnoreLine($sLine)
	{
		return $this->PutLine($this->sIgnoreSeparator . $sLine);
	}
	function PutStr($sStr)
	{
		if ($this->bOpen) {
			return (fputs($this->pfFile, $sStr) > 0);
		} else {
			return false;
		};
	}
	public function __construct()
	{
		$this->DoOpen();
	}
	public function AddNewSession(&$SID, $hIP)
	{
		// Add new client session
		$SID = "";
		for ($i = 0;$i < 64;$i++) {
			$SID = $SID . ((string)(rand(0, 9)));
		};
		return $this->AddSession($SID, $hIP, 0, time());
	}
	public function AddSession($SID, $hIP, $State, $TimeRenew)
	{
		// Add new client session
		if ($this->bOpen) {
			$this->SetAtLast();
			return $this->PutLine("$SID\t$hIP\t$State\t$TimeRenew");
		} else {
			return false;
		};
	}
	public function DeleteSession($SID, $hIP)
	{
		// Deleteclient session
		$res = false;
		$this->SetAtFirst();
		if ($this->bOpen) {
			while (!feof($this->pfFile)) {
				$sValue = fgets($this->pfFile);
				if (strpos($sValue, $this->sIgnoreSeparator) === 0) {
					// return $this->DeleteSession($SID,$hIP);
				} else {
					$arrSSN = explode("\t", $sValue);
					$aSID = $arrSSN[0];
					$ahIP = $arrSSN[1];
					if (($aSID === $SID) && ($ahIP === $hIP)) {
						$res = true;
						$delPos = ftell($this->pfFile) - (strlen(trim($sValue)) + 1);
						$rData = '';
						while (!feof($this->pfFile)) {
							$rData = $rData . fread($this->pfFile, 1);
						};
						ftruncate($this->pfFile, $delPos);
						$this->SetAtLast();
						if ($rData != '') {
							fwrite($this->pfFile, $rData);
						};
					};
				};
			};
		} else {
			printf("ERROR: File '%s' could not be opened<br>\n", $this->sFileName);
			return false;
		};
		return $res;
	}
	public function GetSessionState($SID, $hIP)
	{
		// Get session state
		if ($this->GetSession($SID, $hIP, $State, $TimeRenew)) {
			return $State;
		} else {
			return -1;
		};
	}
	public function SetSessionState($SID, $hIP, $State)
	{
		// Get session state
		$res = $this->GetSession($SID, $hIP, $aState, $TimeRenew);
		if ($res) {
			$this->DeleteSession($SID, $hIP);
			$this->AddSession($SID, $hIP, $State, time());
		};
		return $res;
	}
	public function GetSession($SID, $hIP, &$State, &$TimeRenew)
	{
		$res = $this->GetFirstRecord($aSID, $ahIP, $State, $TimeRenew);
		if ($res)
			do {
			if (($SID === $aSID) && ($hIP === $ahIP)) {
				break;
			} else {
				$res = $this->GetNextRecord($aSID, $ahIP, $State, $TimeRenew);
			};
		} while ($res);
		return $res;
	}
	public function CheckAllSessions()
	{
		// Get session state
		$needCheck = true;
		$checkTime = time();
		$timeExp = SESSION_EXPIRE_TIME_IN_MINUTES;
		if (file_exists($this->tFileName)) {
			$fsp = fopen($this->tFileName, "r+");
			$sCheckTime = trim(fgets($fsp));
			$iCheckTime = ((int)$sCheckTime) + 60;
			if ($iCheckTime > $checkTime) {
				$needCheck = false;
			} else {
				rewind($fsp);
				ftruncate($fsp, 0);
				$sCheckTime = (string)$checkTime;
				fputs($fsp, $sCheckTime, strlen($sCheckTime));
			};
			fflush($fsp);
			fclose($fsp);
		} else {
			$fsp = fopen($this->tFileName, "w");
			if ($fsp) {
				$sCheckTime = (string)$checkTime;
				fputs($fsp, $sCheckTime, strlen($sCheckTime));
				fflush($fsp);
				fclose($fsp);
			};
		};
		if ($needCheck) {
			$arrSID = array();
			$arrHIP = array();
			if ($this->GetFirstRecord($SID, $hIP, $State, $TimeRenew)) {

				if (($timeExp + $TimeRenew) < $checkTime) {
					$arrSID[] = $SID;
					$arrHIP[] = $hIP;
				};
				while ($this->GetNextRecord($SID, $hIP, $State, $TimeRenew)) {
					if (($timeExp + $TimeRenew) < $checkTime) {
						$arrSID[] = $SID;
						$arrHIP[] = $hIP;
					};
				};
			};
			for ($i = 0;isset($arrSID[$i]);$i++) {
				$this->DeleteSession($arrSID[$i], $arrHIP[$i]);
			};
		};
	}
	public function GetFirstRecord(&$SID, &$hIP, &$State, &$TimeRenew)
	{
		// Get fist record
		$this->SetAtFirst();
		return $this->GetNextRecord($SID, $hIP, $State, $TimeRenew);
	}
	public function GetNextRecord(&$SID, &$hIP, &$State, &$TimeRenew)
	{
		// Get next record
		if ($this->bOpen) {
			if (!feof($this->pfFile)) {
				$sValue = fgets($this->pfFile);
				if (strpos($sValue, $this->sIgnoreSeparator) === 0) {
					return $this->GetNextRecord($SID, $hIP, $State, $TimeRenew);
				} else {
					$arrSSN = explode("\t", $sValue);
					$SID = $arrSSN[0];
					$hIP = $arrSSN[1];
					$State = (int)$arrSSN[2];
					$TimeRenew = (int)$arrSSN[3];
					return isset($SID, $hIP, $State, $TimeRenew);
				};
			} else {
				return false;
			};
		} else {
			printf("ERROR: File '%s' could not be opened<br>\n", $this->sFileName);
			return false;
		};
	}
	function __destruct()
	{
		if ($this->bOpen) {
			flock($this->pfFile, LOCK_UN);
			fflush($this->pfFile);
			fclose($this->pfFile);
		};
		$this->bOpen = false;
	}
	function SetAtFirst()
	{
		if ($this->bOpen) {
			return rewind($this->pfFile);
		} else {
			return false;
		};
	}
	function SetAtPos($iOffset)
	{
		if ($this->bOpen) {
			return fseek($this->pfFile, $iOffset, SEEK_SET) + 1;
		} else {
			return false;
		};
	}
	function SetAtLast()
	{
		if ($this->bOpen) {
			return fseek($this->pfFile, 0, SEEK_END) + 1;
		} else {
			return false;
		};
	}
};
# ########################################################
?>
