<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("DEVICELISTFILE", '/usr/local/etc/devicelist.cfg');
define("HOSTNAME", '/etc/hostname');

class Device_conf extends CustomSection {
	public $device_id  = "";
	public $device_name = "";
	public $device_type = "";
	public $basickbd = "";
	public $encoder = "";
	public $device_group = "";
	public $audio1 = "";
	public $audio2 = "";
	public $audio3 = "";
	public $audio100 = "";
	public $audio101 = "";
	public $audio102 = "";
	public $audio103 = "";
	
	/*public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "device_id=" . $this->device_id . "\n"
				. "device_name=" . $this->device_name . "\n"
				. "device_type=" . $this->device_type . "\n"
				. "basickbd=" . $this->basickbd . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}*/
	
	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "device_id")
					$this->device_id = $sValue;
				elseif ($sName === "device_name")
					$this->device_name = $sValue;
				elseif ($sName === "device_type")
					$this->device_type = $sValue;
				elseif ($sName === "basickbd")
					$this->basickbd = $sValue;
				elseif ($sName === "encoder")
					$this->encoder = $sValue;
				elseif ($sName === "device_group")
					$this->device_group = $sValue;
				elseif ($sName === "audio1")
					$this->audio1 = $sValue;
				elseif ($sName === "audio2")
					$this->audio2 = $sValue;
				elseif ($sName === "audio3")
					$this->audio3 = $sValue;

				elseif ($sName === "audio100")
					$this->audio100 = $sValue;
				elseif ($sName === "audio101")
					$this->audio101 = $sValue;
				elseif ($sName === "audio102")
					$this->audio102 = $sValue;
				elseif ($sName === "audio103")
					$this->audio103 = $sValue;

				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
	
};

class Device_confs {
	public $arrDeviceConfs = array();
	public $arrKeyboardConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Device_conf();
		$this->arrDeviceConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}
	
	function doKeyboardList(){
		foreach($this->arrDeviceConfs as $key => $val){
			//$this->arrKeyboardConfs[$val->basickbd] = '';
			$this->arrKeyboardConfs[$val->basickbd] = ['selected' => ''];
		}
	}

	/*public function GetByIndex($iIndex) {
		return $this->arrCommonConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrCommonConfs[$i++]) {
			$sRes = $sRes . "[common]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrCommonConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}*/
};

# ######################################
class DeviceConfFile extends CustomConfFile {
	public $devconf;
	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->devconf = new Device_confs();
		$this->unknownparams = array();
		$this->DoReadSections();
		$this->devconf->doKeyboardList();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "device")
				$this->devconf->AddAsSection($sSectionValues);
			//elseif ($sSectionName === "user")
			//	$this->user->AddAsSection($sSectionValues);
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	/*function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		//$this->PutLine($this->ctrl->GetAsSections());
		$this->PutLine($this->devconf->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}*/
};
# ######################################
?>
