<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("MEDIAAMPCONFFILE", '/usr/local/etc/vol_amp.cfg');


class Media_level extends CustomSection {
	public $spk1_mul = "";
	public $spk1_uni = "";
	public $spk2_mul = "";
	public $spk2_uni = "";
	public $spk3_mul = "";
	public $spk3_uni = "";
	public $spk4_mul = "";
	public $spk4_uni = "";
	public $mic = "";

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "spk1_mul=" . $this->spk1_mul . "\n"
				. "spk1_uni=" . $this->spk1_uni . "\n"
				. "spk2_mul=" . $this->spk2_mul . "\n"
				. "spk2_uni=" . $this->spk2_uni . "\n"
				. "spk3_mul=" . $this->spk3_mul . "\n"
				. "spk3_uni=" . $this->spk3_uni . "\n"
				. "spk4_mul=" . $this->spk4_mul . "\n"
				. "spk4_uni=" . $this->spk4_uni . "\n"
				. "mic=" . $this->mic . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "spk1_mul")
					$this->spk1_mul = $sValue;
				elseif ($sName === "spk1_uni")
					$this->spk1_uni = $sValue;
				elseif ($sName === "spk2_mul")
					$this->spk2_mul = $sValue;
				elseif ($sName === "spk2_uni")
					$this->spk2_uni = $sValue;
				elseif ($sName === "spk3_mul")
					$this->spk3_mul = $sValue;
				elseif ($sName === "spk3_uni")
					$this->spk3_uni = $sValue;
				elseif ($sName === "spk4_mul")
					$this->spk4_mul = $sValue;
				elseif ($sName === "spk4_uni")
					$this->spk4_uni = $sValue;
				elseif ($sName === "mic")
					$this->mic = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Media_levels {
	public $arrMediaLevels = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Media_level();
		$this->arrMediaLevels[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrMediaLevels[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrMediaLevels[$i++]) {
			$sRes = $sRes . "[volume]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrMediaLevels))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

# ######################################
class MediaAmpConfFile extends CustomConfFile {
	public $media_level;
	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->media_level = new Media_levels();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "volume")
				$this->media_level->AddAsSection($sSectionValues);
//			elseif ($sSectionName === "user")
//				$this->user_list->AddAsSection($sSectionValues);
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		//$this->PutLine($this->ctrl->GetAsSections());
		$this->PutLine($this->media_level->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}
};
# ######################################
?>