$(document).ready( function () {

	// --------------------------------------------------------------------------------
	// слайдеры громкости и чувствительности
	// --------------------------------------------------------------------------------
	$( function() {
		$( "#slider_volume" ).slider({
			orientation: "vertical",
			range: "min",
			min: 0,
			max: 100,
			value: 60,
			slide: function( event, ui ) {
				$( "#volume_value" ).val( ui.value );
				debounceSliderVolume(ui);
			}
		});
		var iniVolumeSpk = document.getElementById('iniVolumeSpk').value;
		$( "#slider_volume" ).slider( "value", iniVolumeSpk );
		$( "#volume_value" ).val( $( "#slider_volume" ).slider( "value" ) );
	});	
	$( function() {
		$( "#slider_sens" ).slider({
			orientation: "vertical",
			range: "min",
			min: 0,
			max: 100,
			value: 60,
			slide: function( event, ui ) {
				$( "#sens_value" ).val( ui.value );
				debounceSliderVolume(ui);
			}
		});
		var iniVolumeMic = document.getElementById('iniVolumeMic').value;
		$( "#slider_sens" ).slider( "value", iniVolumeMic );
		$( "#sens_value" ).val( $( "#slider_sens" ).slider( "value" ) );
	});	

	$( function() {
		$( "#slider_volume" ).width("1.6em");
		$( "#slider_sens" ).width("1.6em");
		$( ".ui-slider-handle",".ui-slider" ).width("2em");
	});	
	

	// обработка колеса мышки
	$("#slider_volume")[0].addEventListener('wheel', function(event) { 
		event.preventDefault();
		var delta = 2; // wheel step
		var sval = $(this).slider("value");
		if(event.deltaY < 0) sval += delta;
		else sval -= delta;
		sval > 100 && (sval = 100);
		sval < 0 && (sval = 0);
		//console.info(sval);
		$(this).slider("value", sval);
		$( "#volume_value" ).val( sval );
		debounceSliderVolume( $( "#volume_value" )[0] );
	})
	$("#slider_sens")[0].addEventListener('wheel', function(event) { 
		event.preventDefault();
		var delta = 2; // wheel step
		var sval = $(this).slider("value");
		if(event.deltaY < 0) sval += delta;
		else sval -= delta;
		sval > 100 && (sval = 100);
		sval < 0 && (sval = 0);
		//console.info(sval);
		$(this).slider("value", sval);
		$( "#sens_value" ).val( sval );
		debounceSliderVolume( $( "#sens_value" )[0] );
	})

	// поля ввода значения
	$("#volume_value").change(function() {
		$("#slider_volume").slider("value", $(this).val());
		debounceSliderVolume(this);
	});
	$("#sens_value").change(function() {
		$("#slider_sens").slider("value", $(this).val());
		debounceSliderVolume(this);
	});

	// --------------------------------------------------------------------------------
	//
	// --------------------------------------------------------------------------------



	// --------------------------------------------------------------------------------
	// слайдеры громкости динамика трубки и чувствительности микрофона трубки
	// --------------------------------------------------------------------------------
	$( function() {
		$( "#slider_phonedyn" ).slider({
			orientation: "vertical",
			range: "min",
			min: 0,
			max: 100,
			value: 60,
			slide: function( event, ui ) {
				$( "#phone_spk_value" ).val( ui.value );
				debounceSliderVolume(ui);
			}
		});
		var iniVolHandSpk = document.getElementById('iniVolHandSpk').value;
		$( "#slider_phonedyn" ).slider( "value", iniVolHandSpk );
		$( "#phone_spk_value" ).val( $( "#slider_phonedyn" ).slider( "value" ) );
	});	
	$( function() {
		$( "#slider_phonemic" ).slider({
			orientation: "vertical",
			range: "min",
			min: 0,
			max: 100,
			value: 60,
			slide: function( event, ui ) {
				$( "#phone_mic_value" ).val( ui.value );
				debounceSliderVolume(ui);
			}
		});
		var iniVolHandMic = document.getElementById('iniVolHandMic').value;
		$( "#slider_phonemic" ).slider( "value", iniVolHandMic );
		$( "#phone_mic_value" ).val( $( "#slider_phonemic" ).slider( "value" ) );
	});	

	$( function() {
		$( "#slider_phonedyn" ).width("1.6em");
		$( "#slider_phonemic" ).width("1.6em");
		$( ".ui-slider-handle",".ui-slider" ).width("2em");
	});	
	

	// обработка колеса мышки
	$("#slider_phonedyn")[0].addEventListener('wheel', function(event) { 
		event.preventDefault();
		var delta = 2; // wheel step
		var sval = $(this).slider("value");
		if(event.deltaY < 0) sval += delta;
		else sval -= delta;
		sval > 100 && (sval = 100);
		sval < 0 && (sval = 0);
		//console.info(sval);
		$(this).slider("value", sval);
		$( "#phone_spk_value" ).val( sval );
		debounceSliderVolume( $( "#phone_spk_value" )[0] );
	})
	$("#slider_phonemic")[0].addEventListener('wheel', function(event) { 
		event.preventDefault();
		var delta = 2; // wheel step
		var sval = $(this).slider("value");
		if(event.deltaY < 0) sval += delta;
		else sval -= delta;
		sval > 100 && (sval = 100);
		sval < 0 && (sval = 0);
		//console.info(sval);
		$(this).slider("value", sval);
		$( "#phone_mic_value" ).val( sval );
		debounceSliderVolume( $( "#phone_mic_value" )[0] );
	})

	// поля ввода значения
	$("#phone_spk_value").change(function() {
		$("#slider_phonedyn").slider("value", $(this).val());
		debounceSliderVolume(this);
	});
	$("#phone_mic_value").change(function() {
		$("#slider_phonemic").slider("value", $(this).val());
		debounceSliderVolume(this);
	});

	// --------------------------------------------------------------------------------
	//
	// --------------------------------------------------------------------------------




	getMediaLevelActivity();

});


// --------------------------------------------------------------------------------
// дебонсинг событий изменения значений громкости и чувствительности, запись в файл
// --------------------------------------------------------------------------------
function debounce(func, wait, immediate) {
	var timeout;
	return function() {
		var context = this, args = arguments;
		clearTimeout(timeout);
		timeout = setTimeout(function() {
			timeout = null;
			if (!immediate) func.apply(context, args);
		}, wait);
		if (immediate && !timeout) func.apply(context, args);
	};
}

var debounceSliderVolume = debounce(function(obj){
	SliderVolumeToFile(obj);
}, 250);

/*
function SliderVolumeToFile(obj){
	//console.info( obj.id +' '+ obj.value );
	var volume_value = $( "#volume_value" )[0].value;
	var sens_value = $( "#sens_value" )[0].value;
	var level_value = 'spk ' + volume_value + ' mic ' + sens_value;
	//console.info(level_value);
	saveRTLevel(level_value);
}
*/
function SliderVolumeToFile(obj){
	//console.info( obj.id +' '+ obj.value );
	var volume_value = $( "#volume_value" )[0].value;
	var sens_value = $( "#sens_value" )[0].value;
	var phone_spk_value = $( "#phone_spk_value" )[0].value;
	var phone_mic_value = $( "#phone_mic_value" )[0].value;
	var level_value = 'spk ' + volume_value + ' mic ' + sens_value;
	level_value = level_value + ' VolHandSpk ' + phone_spk_value + ' VolHandMic ' + phone_mic_value;
	//console.info(level_value);
	saveRTLevel(level_value);
}


function saveRTLevel(level_value){
	var result = false;

	$.ajax({
		type: 'POST',
		url: '/cgi-bin/doapplyMediaLevel.cgi',
		data: ({
			level_value: level_value
		}),
		async: 0,
		timeout: 100,
		success: function() {
			//alert('success');
		},
		error:function(){
			alert('error: level_value');
		}
	});
}

// --------------------------------------------------------------------------------
//
// --------------------------------------------------------------------------------


// --------------------------------------------------------------------------------
// активность и сохранение уровней громкости и чувствительности
// --------------------------------------------------------------------------------
/*
function getMediaLevelActivity(){
	var medialevel_encoder = $('input[id=medialevel_encoder]')[0];
	
	//if(medialevel_encoder.value == 1) { $('div[id=div_medialevel]').hide(); }
	//if(medialevel_encoder.value == 0) { $('div[id=div_medialevel]').show(); }
	
	if(medialevel_encoder.value == 1){
		var div_medialevel = $('div[id=div_medialevel]')[0];
		$(div_medialevel).append('<div id="div_medialevel_shadow" />');
		var div_medialevel_shadow = $('div[id=div_medialevel_shadow]')[0];
		var div_medialevel_height = $(div_medialevel).height();
		var tab_medialevel_width = $(tab_medialevel).width();
		$(div_medialevel_shadow).css({'position':'absolute','top':'0','left':'0','width':tab_medialevel_width,'height':div_medialevel_height });
		$(div_medialevel_shadow).css({'background-color':'000','z-index':1000,'opacity':'0.1'});
	}
	if(medialevel_encoder.value == 0){
		var div_medialevel_shadow = $('div[id=div_medialevel_shadow]')[0];
		$(div_medialevel_shadow).remove();
	}

}
*/
/*
function getMediaLevelActivity(){
	var medialevel_encoder = $('input[id=medialevel_encoder]')[0];
	
	if(medialevel_encoder.value == 1){
		// div_1
		var div_medialevel_1 = $('div[id=div_medialevel_1]')[0];
		$(div_medialevel_1).append('<div id="div_shadow_1" />');
		var div_medialevel_height_1 = $(div_medialevel_1).height();
		var tab_medialevel_width_1 = $(div_medialevel_1).width();
		$(div_shadow_1).parent().css({position: 'relative'});
		$(div_shadow_1).css({top: '0', left: '0', position:'absolute','width':tab_medialevel_width_1,'height':div_medialevel_height_1, 'background-color':'000','z-index':1000,'opacity':'0.1'});		
	}
	if(medialevel_encoder.value == 0){
		// div_2
		var div_medialevel_2 = $('div[id=div_medialevel_2]')[0];
		$(div_medialevel_2).append('<div id="div_shadow_2" />');
		var div_medialevel_height_2 = $(div_medialevel_2).height();
		var tab_medialevel_width_2 = $(div_medialevel_2).width();
		$(div_shadow_2).parent().css({position: 'relative'});
		$(div_shadow_2).css({top: '0', left: '0', position:'absolute','width':tab_medialevel_width_2,'height':div_medialevel_height_2, 'background-color':'000','z-index':1000,'opacity':'0.1'});		

	}

}
*/
function getMediaLevelActivity(){
	var medialevel_encoder = $('input[id=medialevel_encoder]')[0];
	
	if(medialevel_encoder.value == 1){
		// div_1
		var div_medialevel_1 = $('div[id=div_medialevel_1]')[0];
		$(div_medialevel_1).append('<div id="div_shadow_1" />');
		var div_medialevel_height_1 = $(div_medialevel_1).height();
		$(div_shadow_1).parent().css({position: 'relative'});
		$(div_shadow_1).css({top: '0', left: '0', position:'absolute','width':'100%','height':div_medialevel_height_1, 'background-color':'000','z-index':1000,'opacity':'0.1'});		
	}
	if(medialevel_encoder.value == 0){
		// div_2
		var div_medialevel_2 = $('div[id=div_medialevel_2]')[0];
		$(div_medialevel_2).append('<div id="div_shadow_2" />');
		var div_medialevel_height_2 = $(div_medialevel_2).height();
		$(div_shadow_2).parent().css({position: 'relative'});
		$(div_shadow_2).css({top: '0', left: '0', position:'absolute','width':'100%','height':div_medialevel_height_2, 'background-color':'000','z-index':1000,'opacity':'0.1'});		

	}

}









/*
function onMediaLevelSave(level_value){
	var result = false;

	var volume_value = $( "#volume_value" )[0].value;
	var sens_value = $( "#sens_value" )[0].value;
	//alert([volume_value, sens_value]);

	$.ajax({
		type: 'POST',
		url: '/cgi-bin/doapplyServiceFromMedia.cgi',
		data: ({
			volume_value: volume_value,
			sens_value: sens_value
		}),
		async: 0,
		timeout: 100,
		success: function() {
			//alert('success');
		},
		error:function(){
			alert('error: MediaLevelSave');
		}
	});
}
*/

function onMediaLevelSave(level_value){
	var result = false;

	var volume_value = $( "#volume_value" )[0].value;
	var sens_value = $( "#sens_value" )[0].value;
	var phone_spk_value = $( "#phone_spk_value" )[0].value;
	var phone_mic_value = $( "#phone_mic_value" )[0].value;
	//alert([volume_value, sens_value, phone_spk_value, phone_mic_value]);

	$.ajax({
		type: 'POST',
		url: '/cgi-bin/doapplyServiceFromMedia.cgi',
		data: ({
			volume_value: volume_value,
			sens_value: sens_value,
			phone_spk_value: phone_spk_value,
			phone_mic_value: phone_mic_value
		}),
		async: 0,
		timeout: 100,
		success: function() {
			//alert('success');
		},
		error:function(){
			alert('error: MediaLevelSave');
		}
	});
}


