function doCopyConfig(){
	
	if(!confirm('Внимание! Подтвердите действие.\n Файлы текущей конфигурации будут изменены!')) return;
	
	var remote_ip = document.getElementById('ed_remote_ip').value;
	var mode = 0;
	var errmsg = '';
	
	// userlist
	if(document.getElementById('ed_user_check').checked){
		mode = 1;
		var get_res = get_remote_config('http://'+remote_ip,mode);
		var set_res = set_local_config(mode);
		if(!get_res || !set_res) errmsg += '- ошибка копирования абонентов\n';
		else $('div[id=ed_user_info]').fadeIn(1000).fadeOut(500);
	}
	// keylist
	if(document.getElementById('ed_key_check').checked){
		mode = 2;
		var get_res = get_remote_config('http://'+remote_ip,mode);
		var set_res = set_local_config(mode);
		if(!get_res || !set_res) errmsg += '- ошибка копирования назначения кнопок\n';
		else $('div[id=ed_key_info]').fadeIn(1000).fadeOut(500);
	}
	// Register
	if(document.getElementById('ed_Register_check').checked){
		mode = 3;
		var get_res = get_remote_config('http://'+remote_ip,mode);
		var set_res = set_local_config(mode);
		if(!get_res || !set_res) errmsg += '- ошибка копирования регистраций\n';
		else $('div[id=ed_Register_info]').fadeIn(1000).fadeOut(500);
	}
	// Subscriber
	if(document.getElementById('ed_Subscriber_check').checked){
		mode = 4;
		var get_res = get_remote_config('http://'+remote_ip,mode);
		var set_res = set_local_config(mode);
		if(!get_res || !set_res) errmsg += '- ошибка копирования подписок\n';
		else $('div[id=ed_Subscriber_info]').fadeIn(1000).fadeOut(500);
	}
	if(errmsg!=''){
		errmsg = 'Ошибка копирования конфигурации:\n\n' + errmsg;
		alert(errmsg);
	} else {
		configuration_change_notify();
	}
	

}


function get_remote_config(source_url,mode){
	var result = false;

	$.ajax({
		type: 'GET',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'get_remote_config',
			source_url: source_url,
			mode: mode
		}),
		dataType: 'text',
		async: 0,
		timeout: 5000,
		success: function(data) {
			result = data;
		},
		error:function(){
			alert('error: get_remote_config');
		}
	});
	
	return result;
}



function set_local_config(mode){
	var result = false;

	$.ajax({
		type: 'GET',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'set_local_config',
			mode: mode
		}),
		dataType: 'text',
		async: 0,
		timeout: 1000,
		success: function(data) {
			result = data;
		},
		error:function(){
			alert('error: set_local_config');
		}
	});
	
	return result;
}


function configuration_change_notify(){
	var result = false;

	$.ajax({
		type: 'GET',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'configuration_change_notify'
		}),
		dataType: 'text',
		async: 0,
		timeout: 1000,
		success: function(data) {
			result = data;
		},
		error:function(){
			alert('error: configuration_change_notify');
		}
	});
	
	return result;
}


function doDeviceReboot(ip){
	if(!confirm('Подтвердите действие на '+ip+'. Перезагрузка?')) return;

	$.ajax({
		type: 'POST',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'do_device_reboot'
		}),
		dataType: 'text',
		async: 0,
		timeout: 1000,
		success: function() {
			//alert();
			//location.reload();

			//location.href='../cgi-bin/Enter.cgi';
			location.href='../cgi-bin/WaitReboot.cgi';
		},
		error:function(){
			alert('error: do_device_reboot');
		}
	});
}

