<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("DEVICEUICONFFILE", '/usr/local/etc/deviceui.cfg');

class Device_ui extends CustomSection {
	public $device_group  = "";
	public $TabCommon = "";
	public $TabNet = "";
	public $TabUser = "";
	public $TabKey = "";
	public $TabChannel = "";
	public $TabService = "";
	public $TabConnection = "";
	public $TabMulimedia = "";
	public $TabMediaAmp = "";
	public $TabMediaCT = "";
	public $TabAlarm = "";
	public $TabTest = "";
	public $TabTech = "";
	public $TabWebSetup = "";
	public $Logout = "";

	public $Service_Basic_NumbKey = 1;
	public $Service_Basic_ExpUnit = 1;
	public $Service_Basic_AddPanel1 = 1;
	public $Service_Basic_AddPanel2 = 1;
	public $Service_Basic_AddPanel3 = 1;
	public $Service_Basic_BrightKey = 1;
	public $Service_Basic_WaitTime = 1;
	public $Service_Basic_ConversDur = 1;
	public $Service_Basic_DispCall = 1;
	public $Service_Basic_DispVad = 1;
	public $Service_Basic_SelfList = 1;
	public $Service_Basic_EncoderOn = 1;
	public $Service_Basic_EchoCan = 1;
	public $Service_Basic_SpkExt = 1;
	public $Service_Basic_PowerOut=1;
	public $Service_Basic_VolumeSpk = 1;
	public $Service_Basic_SensMic = 1;
	public $Service_Сhannels_Set = 1;
	public $Service_Сhannels_Set1 = 1;
	public $Service_Сhannels_Set2 = 1;
	public $Service_Registr_Set = 1;
	public $Service_Subscr_Set = 1;
	public $Service_Audio_Set = 1;
	public $Service_Audio_Codec = 1;
	public $Service_Audio_Mic = 1;
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "device_group=" . $this->device_group . "\n"
				. "TabCommon=" . $this->TabCommon . "\n"
				. "TabNet=" . $this->TabNet . "\n"
				. "TabUser=" . $this->TabUser . "\n"
				. "TabKey=" . $this->TabKey . "\n"
				. "TabChannel=" . $this->TabChannel . "\n"
				. "TabService=" . $this->TabService . "\n"
				. "TabConnection=" . $this->TabConnection . "\n"
				. "TabMulimedia=" . $this->TabMulimedia . "\n"
				. "TabMediaAmp=" . $this->TabMediaAmp . "\n"
				. "TabMediaCT=" . $this->TabMediaCT . "\n"
				. "TabAlarm=" . $this->TabAlarm . "\n"
				. "TabTest=" . $this->TabTest . "\n"
				. "TabTech=" . $this->TabTech . "\n"
				. "TabWebSetup=" . $this->TabWebSetup . "\n"
				. "Logout=" . $this->Logout . "\n"

				. "Service_Basic_NumbKey=" . $this->Service_Basic_NumbKey . "\n"
				. "Service_Basic_ExpUnit=" . $this->Service_Basic_ExpUnit . "\n"
				. "Service_Basic_AddPanel1=" . $this->Service_Basic_AddPanel1 . "\n"
				. "Service_Basic_AddPanel2=" . $this->Service_Basic_AddPanel2 . "\n"
				. "Service_Basic_AddPanel3=" . $this->Service_Basic_AddPanel3 . "\n"
				. "Service_Basic_BrightKey=" . $this->Service_Basic_BrightKey . "\n"
				. "Service_Basic_WaitTime=" . $this->Service_Basic_WaitTime . "\n"
				. "Service_Basic_ConversDur=" . $this->Service_Basic_ConversDur . "\n"
				. "Service_Basic_DispCall=" . $this->Service_Basic_DispCall . "\n"
				. "Service_Basic_DispVad=" . $this->Service_Basic_DispVad . "\n"
				. "Service_Basic_SelfList=" . $this->Service_Basic_SelfList . "\n"
				. "Service_Basic_EncoderOn=" . $this->Service_Basic_EncoderOn . "\n"
				. "Service_Basic_EchoCan=" . $this->Service_Basic_EchoCan . "\n"
				. "Service_Basic_SpkExt=" . $this->Service_Basic_SpkExt . "\n"
				. "Service_Basic_PowerOut=" . $this->Service_Basic_PowerOut . "\n"
				. "Service_Basic_VolumeSpk=" . $this->Service_Basic_VolumeSpk . "\n"
				. "Service_Basic_SensMic=" . $this->Service_Basic_SensMic . "\n"
				. "Service_Сhannels_Set=" . $this->Service_Сhannels_Set . "\n"
				. "Service_Сhannels_Set1=" . $this->Service_Сhannels_Set1 . "\n"
				. "Service_Сhannels_Set2=" . $this->Service_Сhannels_Set2 . "\n"
				. "Service_Registr_Set=" . $this->Service_Registr_Set . "\n"
				. "Service_Subscr_Set=" . $this->Service_Subscr_Set . "\n"
				. "Service_Audio_Set=" . $this->Service_Audio_Set . "\n"
				. "Service_Audio_Codec=" . $this->Service_Audio_Codec . "\n"
				. "Service_Audio_Mic=" . $this->Service_Audio_Mic . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "device_group")
					$this->device_group = $sValue;
				elseif ($sName === "TabCommon")
					$this->TabCommon = $sValue;
				elseif ($sName === "TabNet")
					$this->TabNet = $sValue;
				elseif ($sName === "TabUser")
					$this->TabUser = $sValue;
				elseif ($sName === "TabKey")
					$this->TabKey = $sValue;
				elseif ($sName === "TabChannel")
					$this->TabChannel = $sValue;
				elseif ($sName === "TabService")
					$this->TabService = $sValue;
				elseif ($sName === "TabConnection")
					$this->TabConnection = $sValue;
				elseif ($sName === "TabMulimedia")
					$this->TabMulimedia = $sValue;
				elseif ($sName === "TabMediaAmp")
					$this->TabMediaAmp = $sValue;
				elseif ($sName === "TabMediaCT")
					$this->TabMediaCT = $sValue;
				elseif ($sName === "TabAlarm")
					$this->TabAlarm = $sValue;
				elseif ($sName === "TabTest")
					$this->TabTest = $sValue;
				elseif ($sName === "TabTech")
					$this->TabTech = $sValue;
				elseif ($sName === "TabWebSetup")
					$this->TabWebSetup = $sValue;
				elseif ($sName === "Logout")
					$this->Logout = $sValue;

				elseif ($sName === "Service_Basic_NumbKey")
					$this->Service_Basic_NumbKey = $sValue;
				elseif ($sName === "Service_Basic_ExpUnit")
					$this->Service_Basic_ExpUnit = $sValue;
				elseif ($sName === "Service_Basic_AddPanel1")
					$this->Service_Basic_AddPanel1 = $sValue;
				elseif ($sName === "Service_Basic_AddPanel2")
					$this->Service_Basic_AddPanel2 = $sValue;
				elseif ($sName === "Service_Basic_AddPanel3")
					$this->Service_Basic_AddPanel3 = $sValue;
				elseif ($sName === "Service_Basic_BrightKey")
					$this->Service_Basic_BrightKey = $sValue;
				elseif ($sName === "Service_Basic_WaitTime")
					$this->Service_Basic_WaitTime = $sValue;
				elseif ($sName === "Service_Basic_ConversDur")
					$this->Service_Basic_ConversDur = $sValue;
				elseif ($sName === "Service_Basic_DispCall")
					$this->Service_Basic_DispCall = $sValue;
				elseif ($sName === "Service_Basic_DispVad")
					$this->Service_Basic_DispVad = $sValue;
				elseif ($sName === "Service_Basic_SelfList")
					$this->Service_Basic_SelfList = $sValue;
				elseif ($sName === "Service_Basic_EncoderOn")
					$this->Service_Basic_EncoderOn = $sValue;
				elseif ($sName === "Service_Basic_EchoCan")
					$this->Service_Basic_EchoCan = $sValue;
				elseif ($sName === "Service_Basic_SpkExt")
					$this->Service_Basic_SpkExt = $sValue;
				elseif ($sName === "Service_Basic_PowerOut")
					$this->Service_Basic_PowerOut = $sValue;
				elseif ($sName === "Service_Basic_VolumeSpk")
					$this->Service_Basic_VolumeSpk = $sValue;
				elseif ($sName === "Service_Basic_SensMic")
					$this->Service_Basic_SensMic = $sValue;
				elseif ($sName === "Service_Сhannels_Set")
					$this->Service_Сhannels_Set = $sValue;
				elseif ($sName === "Service_Сhannels_Set1")
					$this->Service_Сhannels_Set1 = $sValue;
				elseif ($sName === "Service_Сhannels_Set2")
					$this->Service_Сhannels_Set2 = $sValue;
				elseif ($sName === "Service_Registr_Set")
					$this->Service_Registr_Set = $sValue;
				elseif ($sName === "Service_Subscr_Set")
					$this->Service_Subscr_Set = $sValue;
				elseif ($sName === "Service_Audio_Set")
					$this->Service_Audio_Set = $sValue;
				elseif ($sName === "Service_Audio_Codec")
					$this->Service_Audio_Codec = $sValue;
				elseif ($sName === "Service_Audio_Mic")
					$this->Service_Audio_Mic = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Device_uis {
	public $arrDeviceLists = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Device_ui();
		$this->arrDeviceLists[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrDeviceLists[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrDeviceLists[$i++]) {
			$sRes = $sRes . "[device_ui]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrDeviceLists))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

# ######################################
class DeviceUiConfFile extends CustomConfFile {
	public $devicelist;
	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->devicelist = new Device_uis();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "device_ui")
				$this->devicelist->AddAsSection($sSectionValues);
			//elseif ($sSectionName === "action")
			//	$this->key_action->AddAsSection($sSectionValues);
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		//$this->PutLine($this->ctrl->GetAsSections());
		$this->PutLine($this->devicelist->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}
};
# ######################################
?>
