<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("KEYCONFFILE", '/usr/local/etc/keylist.cfg');

class Key_list extends CustomSection {
	public $key_id  = "";
	public $kt_id  = "";
	public $user_uid = "";
	public $kt_func  = "";
	public $kt_name  = "";
	//public $id_type  = "";
	//public $id_id  = "";
	//public $id_value  = "";

	public $call_name  = "";
	public $call_nick  = "";
	public $call_id  = "";
	public $call_ip  = "";
	public $callerid  = "";
	
	public $key_param  = "";
	//public $key_dial  = "";
	public $key_lock  = "";
	public $key_answer  = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "key_id=" . $this->key_id . "\n"
				. "kt_id=" . $this->kt_id . "\n"
				. "user_uid=" . $this->user_uid . "\n"
				. "kt_func=" . $this->kt_func . "\n"
				. "kt_name=" . $this->kt_name . "\n"

				. "call_name=" . $this->call_name . "\n"
				. "call_nick=" . $this->call_nick . "\n"
				. "call_id=" . $this->call_id . "\n"
				. "call_ip=" . $this->call_ip . "\n"
				. "callerid=" . $this->callerid . "\n"

				. "key_param=" . $this->key_param . "\n"
				. "key_lock=" . $this->key_lock . "\n"
				. "key_answer=" . $this->key_answer . "\n"

				. parent::GetUnknownLines();
		return $sRes;
				//. "id_type=" . $this->id_type . "\n"
				//. "id_id=" . $this->id_id . "\n"
				//. "id_value=" . $this->id_value . "\n"
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "key_id")
					$this->key_id = $sValue;
				elseif ($sName === "kt_id")
					$this->kt_id = $sValue;
				elseif ($sName === "user_uid")
					$this->user_uid = $sValue;
				elseif ($sName === "kt_func")
					$this->kt_func = $sValue;
				elseif ($sName === "kt_name")
					$this->kt_name = $sValue;
				/*elseif ($sName === "id_type")
					$this->id_type = $sValue;
				elseif ($sName === "id_id")
					$this->id_id = $sValue;
				elseif ($sName === "id_value")
					$this->id_value = $sValue;*/
				elseif ($sName === "call_name")
					$this->call_name = $sValue;
				elseif ($sName === "call_nick")
					$this->call_nick = $sValue;
				elseif ($sName === "call_id")
					$this->call_id = $sValue;
				elseif ($sName === "call_ip")
					$this->call_ip = $sValue;
				elseif ($sName === "callerid")
					$this->callerid = $sValue;

				elseif ($sName === "key_param")
					$this->key_param = $sValue;
				elseif ($sName === "key_lock")
					$this->key_lock = $sValue;
				elseif ($sName === "key_answer")
					$this->key_answer = $sValue;

				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Key_lists {
	public $arrKeyLists = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Key_list();
		$this->arrKeyLists[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrKeyLists[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		/*$i = 0; При таком подходе вылетает PHP Notice - смещение за рамками массива                                                                                                                                                
		while ($obj = $this->arrKeyLists[$i++]) {
			$sRes = $sRes . "[key]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrKeyLists))
				$sRes = $sRes . "\n";
		};*/
		foreach ($this->arrKeyLists as $i => $obj) {
			$sRes = $sRes . "[key]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrKeyLists))
				$sRes = $sRes . "\n";
		}
		return $sRes;
	}
};

# ######################################
class KeyConfFile extends CustomConfFile {
	public $keylist;
	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->keylist = new Key_lists();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "key")
				$this->keylist->AddAsSection($sSectionValues);
			//elseif ($sSectionName === "action")
			//	$this->key_action->AddAsSection($sSectionValues);
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		//$this->PutLine($this->ctrl->GetAsSections());
		$this->PutLine($this->keylist->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}
};
# ######################################
?>
