<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("USERCONFFILE", '/usr/local/etc/userlist.cfg');

define("PATTERN_TYPE_BASIC", 0);
define("PATTERN_TYPE_TIMEOUT", 1);
define("PATTERN_TYPE_REDIRECT", 2);

//class Router_target_signalling extends CustomSection {
//class Router_target_signallings {


class User_list extends CustomSection {
	public $uid = "";
	public $order  = "";
	public $id = "";
	public $name = "";
	public $nick = "";
	public $ip = "";
	public $device_id = "";
	public $zones_num = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "uid=" . $this->uid . "\n"
				. "order=" . $this->order . "\n"
				. "id=" . $this->id . "\n"
				. "name=" . $this->name . "\n"
				. "nick=" . $this->nick . "\n"
				. "ip=" . $this->ip . "\n"
				. "device_id=" . $this->device_id . "\n"
				. "zones_num=" . $this->zones_num . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "order")
					$this->order = $sValue;
				elseif ($sName === "uid")
					$this->uid = $sValue;
				elseif ($sName === "id")
					$this->id = $sValue;
				elseif ($sName === "name")
					$this->name = $sValue;
				elseif ($sName === "nick")
					$this->nick = $sValue;
				elseif ($sName === "ip")
					$this->ip = $sValue;
				elseif ($sName === "repeat")
					$this->repeat = $sValue;
				elseif ($sName === "timeout")
					$this->timeout = $sValue;
				elseif ($sName === "device_id")
					$this->device_id = $sValue;
				elseif ($sName === "zones_num")
					$this->zones_num = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class User_lists {
	public $arrUserLists = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new User_list();
		$this->arrUserLists[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrUserLists[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrUserLists[$i++]) {
			$sRes = $sRes . "[user]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrUserLists))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

# ######################################
class UserConfFile extends CustomConfFile {
	public $user_list;
	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->user_list = new User_lists();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "ctrl")
				$this->ctrl->AddAsSection($sSectionValues);
			elseif ($sSectionName === "pattern")
				$this->patterns->AddAsSectionEx($sSectionValues, PATTERN_TYPE_BASIC);
			elseif ($sSectionName === "timeout pattern")
				$this->patterns->AddAsSectionEx($sSectionValues, PATTERN_TYPE_TIMEOUT);
			elseif ($sSectionName === "redirect pattern")
				$this->patterns->AddAsSectionEx($sSectionValues, PATTERN_TYPE_REDIRECT);
			elseif ($sSectionName === "user")
				$this->user_list->AddAsSection($sSectionValues);
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		//$this->PutLine($this->ctrl->GetAsSections());
		$this->PutLine($this->user_list->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}
};
# ######################################
?>