<?php
//require_once(dirname(__FILE__).'/constants.php');
//require_once(dirname(__FILE__).'/database.php');
//require_once(dirname(__FILE__).'/form.php');

class Session {
	
	public $syssession;			// переменные сессии (ассоциативный массив) &$_SESSION

/* свойства объекта класса создаются автоматически в момент присваивания значения (посредством $syssession[])
	$db_ok;				// признак наличия подключения к базе
	$user_id;			// идентификатор пользователя
	$session_name;		// имя сессии
	$session_id;		// идентификатор сессии
	$login_ok;			// признак успешной авторизации
	$start_time;		// время старта сессии
	$current_time;		// время активности сессии
*/	
	
	public function __set($name, $value) {
		//$this->syssession[$this->userwebid][$name] = $value;
		$this->syssession[$name] = $value;
	}
/*
	public function __get($name) {
		if (array_key_exists($name, (array)$this->syssession[$this->userwebid]))
			return $this->syssession[$this->userwebid][$name];
		return null;
	}
	public function __isset($name) {
		return isset($this->syssession[$this->userwebid][$name]);
	}
	public function __unset($name) {
		unset($this->syssession[$this->userwebid][$name]);
	}
*/
	public function __get($name) {
		if (array_key_exists($name, (array)$this->syssession))
			return $this->syssession[$name];
		return null;
	}
	public function __isset($name) {
		return isset($this->syssession[$name]);
	}
	public function __unset($name) {
		unset($this->syssession[$name]);
	}


    function __construct() {
		$this->startSession();
    }
    function __destruct() {
    }	

	function startSession() {

		session_name('fmsession');
		session_start();

		$this->syssession = &$_SESSION;
		
		//if(empty($this->syssession['session_id'])){ 
		if(!isset($this->syssession['userwebid'])){ 
			$this->userwebid = $this->generateRandID(128);
			$this->start_time = time();
		}
		$this->current_time = time();
		$this->session_name = session_name();
		$this->session_id = session_id();


		// определение страницы перехода $session->referrer
		if (isset($this->url)) {
			if (preg_match('/(fs_(get|put)file.php)|(faxview.php)|(process.php)|(menu_(conditionprocessors|connprops|graph|itemnames|itemprops|itemtypes|officeprops|synthz).php)$/', $this->url))
				$this->referrer = isset($this->ref) ? $this->ref : '/';
			else
				$this->referrer = $this->ref = $this->url;
		} else
			$this->referrer = $this->ref = '../';
		$this->url = $_SERVER['PHP_SELF'];

		//echo $_COOKIE['fmsession'].'<br><br>';
		
	}


	function login($txt_login, $txt_password, $txt_remember) {

		$this->logged_in = false;
		$this->session_user_name = $txt_login;

		// индикатор попытки входа
		//if($this->logged_counter==NULL) $this->logged_counter = 1; else $this->logged_counter++;
		if($this->logged_counter==NULL) $this->logged_counter = 1;

		$content = file_get_contents(USER_CONF);
		$users = json_decode($content);
		
		foreach($users as $key => $row){
			if( $row->user_name == $txt_login && password_verify($txt_password, $row->user_pass) ) {
				$this->logged_in = true; 
				break;
			}
			
		}

		if($this->logged_in) $message = 'login success';
		else $message = 'login failed';
		//$this->logger( $txt_login.': '.$message );
		$this->logger($message);
		
		return $this->logged_in;
	}


/*
	// выход из системы
	// файл сессии остается в session.save_path до удаления его сборщиком мусора, но параметры авторизации из него удаляются
	// при невозможности сопоставления куки клиента и сессии сервера 
	// например, удалили куку в браузере или файл сессии в session.save_path
	// будет создана новая пара - файл сессии и кука браузера
	// название файла = идентификатор сессии, содержимое куки = идентификатор сессии
	// в обоих случаях: осуществлен выход, или удалили куку или файл сессии, необходима повторная авторизация*/
	function logout(){
		session_name('fmsession');
		session_start();
		session_unset();
		$_SESSION = array();
		setcookie(session_name(), session_id(), time()-60*60*24);
		session_destroy();		
	}


	// generateRandID - Generates a string made up of randomized 
	// letters (lower and upper case) and digits and returns
	// the sha1 hash of it to be used as a userwebid.
	// @param int $len
	// @return string
	function generateRandID($len = 128) {
		return sha1($this->generateRandStr($len));
	}
	// generateRandStr - Generates a string made up of randomized
	// letters (lower and upper case) and digits, the length
	// is a specified parameter.
	// @param $length
	// @return string
	function generateRandStr($length) {
		$randstr = "";
		for ($i=0; $i<$length; $i++) {
			$randnum = mt_rand(0,61);
			if($randnum < 10){
				$randstr .= chr($randnum+48);
			} else if ($randnum < 36) {
				$randstr .= chr($randnum+55);
			} else{
				$randstr .= chr($randnum+61);
			}
		}
		return $randstr;
	}



	
};

$session = new Session;

?>