
function OnAddPattern(pattern_idx,
					  pattern_name,
					  pattern_called,
					  pattern_caller,
					  pattern_group,
					  pattern_target,
					  insert_side, // 0 - left, 1 - right
					  pattern_comments,
					  pattern_unknowns) {
	var hid = document.getElementById("hidPatternCount");

	if (!pattern_idx || (pattern_idx < 0)){
		hid.value++;
		pattern_idx = hid.value;
	}
	if (!pattern_name)
		pattern_name = "";
	if (!pattern_called)
		pattern_called = "";
	if (!pattern_caller) pattern_caller = "";
	if (!pattern_group) pattern_group = "";
	if (!pattern_target)
		pattern_target = "";
	if (insert_side != 0 )
		insert_side = 1;
	if (!pattern_comments)
		pattern_comments = "";
	if (!pattern_unknowns)
		pattern_unknowns = "";

	//table
	var aTable = document.createElement("table");
	aTable.id = "UniquePattern" + pattern_idx;

	aTable.onclick = function() {
		var hid = document.getElementById("hidPatternCount").value;
		for(var i = 1; i <= hid; i++){
			var tablock = document.getElementById("UniquePattern"+i);
			//tablock.setAttribute("style", "float:left;background:" + GetAltColor(pattern_idx, 1, true));
			tablock.setAttribute("style", "background:" + GetAltColor(pattern_idx, 1, true));
		}
		//this.setAttribute("style", "float:left;background:" + GetAltColor(pattern_idx, 2, true));
		this.setAttribute("style", "background:" + GetAltColor(pattern_idx, 2, true));
	};

	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	aTable.className = "nbb";
	aTable.setAttribute("style", "float:left;background:" + GetAltColor(pattern_idx, 1, true));
	//aTable.style.cssText = "float:left;background:" + GetAltColor(pattern_idx, 1, true);
	aTable.style.cssText = "background:" + GetAltColor(pattern_idx, 1, true);
	aTable.setAttribute("block_type","Pattern");
	var tbody = document.createElement("tbody");

	
	AddTableCaption(tbody,
		"<div style=\"display:inline;float:left\">&nbsp;Pattern #"+pattern_idx+"&nbsp;</div>"+

		"<img class=\"imglink\" style=\"display:inline;float:left;margin-right:2px;\" OnClick=\"doClearClick(event); Pattern_Rotation('left',"+pattern_idx+")\" title=\"Move forward\" alt=\"<\" src=\"/images/lf.gif\">"+
		"<img class=\"imglink\" style=\"display:inline;float:left;margin-right:2px;\" OnClick=\"doClearClick(event); Pattern_Rotation('right',"+pattern_idx+")\" title=\"Move back\" alt=\">\" src=\"/images/rt.gif\">"+
		
		"<select name=\"edPatternPosition"+pattern_idx+"\" id=\"edPatternPosition"+pattern_idx+"\" OnClick=\"doClearClick(event);\" OnChange=\"Pattern_Move("+pattern_idx+");\" class=\"blockheader_select\" "+
		"style=\"display:inline;float:left;margin-right:2px;\" >" +
		"</select>\n"+

		"<img class=\"imglink\" style=\"display:inline;float:right;margin-right:2px;\" OnClick=\"Pattern_Delete("+pattern_idx+"); doChangeEvent();\" title=\"Delete pattern\" src=\"/images/del.gif\">");

		
	AddTableRow(tbody, "name",
		"<input name=\"edPatternName"+pattern_idx+"\" " +
		"id=\"edPatternName"+pattern_idx+"\" " +
		"type=\"text\" " +
		"value=\""+pattern_name+"\" " +
		"OnChange=\"UpdatePatternControls();doChangeEvent();\" " +
		"class=\"selectw300\">");

	AddTableRow(tbody, "called",
		"<input name=\"edPatternCalled"+pattern_idx+"\" " +
		"id=\"edPatternCalled"+pattern_idx+"\" " +
		"type=\"text\" " +
		"value=\""+pattern_called+"\" " +
		"OnChange=\"UpdatePatternControls();doChangeEvent();\" " +
		"maxlength=\"256\" size=\"10\" class=\"selectw300\">");

	AddTableRow(tbody, "caller",
		"<input name=\"edPatternCaller"+pattern_idx+"\" " +
		"id=\"edPatternCaller"+pattern_idx+"\" " +
		"type=\"text\" " +
		"value=\""+pattern_caller+"\" " +
		"OnChange=\"UpdatePatternControls();doChangeEvent();\" " +
		"maxlength=\"256\" size=\"10\" class=\"selectw300\">");

	AddTableRow(tbody, "group",
		"<input name=\"edPatternGroup"+pattern_idx+"\" " +
		"id=\"edPatternGroup"+pattern_idx+"\" " +
		"type=\"text\" " +
		"value=\""+pattern_group+"\" " +
		"OnChange=\"UpdatePatternControls();doChangeEvent();\" " +
		//"onKeyDown=\"setMask('this','99999');\" " +
		//"onKeyDown=\"var maskchar=[8,9,13,37,38,39,40,46,48,49,50,51,52,53,54,55,56,57]; if(maskchar.indexOf(event.keyCode)<0) return false;\" " +
		//"data-meiomask='integer' "+
		"maxlength=\"256\" size=\"10\" class=\"selectw300\">");

	AddTableRow(tbody, "targets",
		"<table class=\"editLineParam\" name=\"edPatternTargetTable"+pattern_idx+"\" id=\"edPatternTargetTable"+pattern_idx+"\" style=\"padding: 0px;\" >"+
		"<tr><td>target</td><td>type</td><td>routing<br>timeout</td><td>answer<br>timeout</td><td>dial<br>timeout</td><td align='center'>del</td><tr>"+
		"</table>"+
//		"<table class=\"selectw\" >"+
//		"<tr><td colspan=6 style=\"cursor:pointer;\" onclick=\"addPatterntargetRow("+pattern_idx+");\" title=\"Add new target\">+Add</td><tr>"+
//		"</table>"
		"<table class=\"infoLineParam\" style=\"padding: 0px;\">"+
		"<tr><td colspan=6 style=\"cursor:pointer; font-weight:bold; background:#ddd; padding-left: 10px;\" onclick=\"addPatterntargetRow("+pattern_idx+");doChangeEvent();\" title=\"Add new target\">+ Add</td><tr>"+
		"</table>"
		);
		
		
	aTable.appendChild(tbody);

	//finally insert
	//hid.parentNode.insertBefore(aTable, hid);
	if( insert_side == 0 ){
		var obj = document.getElementById("UniquePatternPlus");
		if(obj){
			obj.parentNode.insertBefore(aTable, obj);
			if(hid.value>1) Pattern_ChangePosition(hid.value,1);
			pattern_idx = 1;
		} else {
			hid.parentNode.insertBefore(aTable, hid);
			OnAddPattern_Plus();
		}
	} else {
		hid.parentNode.insertBefore(aTable, hid);
	}

	// pattern targets table filling (file row example: target=SIP>>RINO:1:0:2 reject:0:3:4 called:7:6:0)
	var patarr = pattern_target.split(' ');
	for(var i=0; i<patarr.length; i++){
		var tagarr = patarr[i].split(':');
		addPatterntargetRow(pattern_idx,tagarr[0],tagarr[3],tagarr[2],tagarr[1]); // attention: rotation of "routing" [3] and "dial" [1] timeout
	}
	
	//UpdatePatternControls();
	doSectionCountCheck('PatternsContainerHeader','PatternsContainer','Pattern',0);
}


function addPatterntargetRow(pattern_idx,targ,ptr,pta,ptd) {
	if(!ptr) ptr='';
	if(!pta) pta='';
	if(!ptd) ptd='';

	var hid = document.getElementById("hidPatternCount");
	if (!pattern_idx || (pattern_idx < 0)){
		pattern_idx = hid.value;
	}
	
	var table = document.getElementById("edPatternTargetTable"+pattern_idx);
	var rowCount = table.rows.length;
	var row = table.insertRow(rowCount);
	row.id = "pattern_target_row_"+pattern_idx+"_"+rowCount;
	
	var cell1 = row.insertCell(0);
	var element1 = document.createElement("select");
	element1.name = "pattern_target_"+pattern_idx+"_"+rowCount;
	element1.id = "pattern_target_"+pattern_idx+"_"+rowCount;
	element1.className="selectw220";
	element1.style="width:220px";
	element1.onchange=function(){doChangeEvent();}
	cell1.appendChild(element1);
	
	var cell2 = row.insertCell(1);
	var element2 = document.createElement("select");
	element2.name = "pattern_type_"+pattern_idx+"_"+rowCount;
	element2.id = "pattern_type_"+pattern_idx+"_"+rowCount;
	element2.className="selectw70";
	element2.style="width:70px";
	element2.onchange=function(){doChangeEvent();}
	cell2.appendChild(element2);

	
/*	var cell5 = row.insertCell(4);
	cell5.innerHTML =
	"<input class=\"inputm\" style=\"width:100%;\" " +
	"type='checkbox' "+
	"name=\"pattern_td_"+pattern_idx+"_"+rowCount+"\"" +
	"id=\"pattern_td_"+pattern_idx+"_"+rowCount+"\"" +
	"value=\"0\"" +
	"/>";*/

	var cell3 = row.insertCell(2);
	var element3 = document.createElement("input");
	element3.type = "text";
	element3.name = "pattern_target_tr_"+pattern_idx+"_"+rowCount;
	element3.id = "pattern_target_tr_"+pattern_idx+"_"+rowCount;
	element3.className="selectw40";
	element3.style="width:40px";
	element3.value = ptr;
	element3.onchange=function(){doChangeEvent();}
	cell3.appendChild(element3);

	var cell4 = row.insertCell(3);
	var element4 = document.createElement("input");
	element4.type = "text";
	element4.name = "pattern_target_ta_"+pattern_idx+"_"+rowCount;
	element4.id = "pattern_target_ta_"+pattern_idx+"_"+rowCount;
	element4.className="selectw40";
	element4.style="width:40px";
	element4.value = pta;
	element4.onchange=function(){doChangeEvent();}
	cell4.appendChild(element4);
	
	var cell5 = row.insertCell(4);
	var element5 = document.createElement("input");
	element5.type = "text";
	element5.name = "pattern_target_td_"+pattern_idx+"_"+rowCount;
	element5.id = "pattern_target_td_"+pattern_idx+"_"+rowCount;
	element5.className="selectw40";
	element5.style="width:40px";
	element5.value = ptd;
	element5.onchange=function(){doChangeEvent();}
	cell5.appendChild(element5);	
	
	var cell6 = row.insertCell(5);
	cell6.align = 'center';
	cell6.innerHTML =
	"<div style=\"cursor:pointer; text-align:center;\" onclick=\"delPatterntargetRow("+pattern_idx+","+rowCount+");doChangeEvent(); \" title=\"Delete this target\"><b>X</b></div>";

	
	var cell7 = row.insertCell(6);
	var element7 = document.createElement("input");
	element7.type = "hidden";
	element7.name = "pattern_rownum_"+pattern_idx+"_"+rowCount;
	element7.id = "pattern_rownum_"+pattern_idx+"_"+rowCount;
	element7.value = rowCount;
	cell7.appendChild(element7);

	getPatternTargets(element1,targ);
	getPatternTypes(element2,targ);
	onPatternTypesChange(element1,element2);

}

// Pattern Plus-block
function OnAddPattern_Plus() {
	var hid = document.getElementById("hidPatternCount");
	var aTable = document.createElement("table");
	aTable.id = "UniquePatternPlus";
	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	//aTable.className = "nb";
	//aTable.setAttribute("style", "float:left;background:" + GetAltColor("Plus", 4, true));
	//aTable.style.cssText = "float:left;background:" + GetAltColor("Plus", 4, true);
	aTable.className = "nbb";
	aTable.setAttribute("style", "background:" + GetAltColor("Plus", 4, true));
	aTable.style.cssText = "background:" + GetAltColor("Plus", 4, true);
	var tbody = document.createElement("tbody");

	AddTableRow(tbody, "",
		"<img  class=\"imglink\" style=\"display:inline;float:left;margin:40px 30px 20px 30px; width:100px;height:100px; text-align:center;\" onClick=\"Pattern_Plus_Delete();\" title=\"Add pattern\" src=\"/images/add_block.gif\" >");
	
	aTable.appendChild(tbody);
	hid.parentNode.insertBefore(aTable, hid);
}
function Pattern_Plus_Delete() {
	var aObj = document.getElementById("UniquePatternPlus");
	aObj.parentNode.removeChild(aObj);
	OnAddPattern();
	Pattern_List();
	OnAddPattern_Plus();

	var hid = document.getElementById("hidPatternCount");
	var tablock = document.getElementById("UniquePattern"+hid.value);
	tablock.onclick();
	document.getElementById("edPatternCalled"+hid.value).focus();
	
}

// action according the case of selected target type
function onPatternTypesChange(element1,element2){
	element2.onchange=function(){
		if(element2.value=='native'){
			element1.disabled = false;
			//element1.style.backgroundColor="#fff";
			element1.style.visibility = "visible";
		} 
		else {
			element1.disabled = true;
			element1.parentNode.style.backgroundColor="#ddd";
			element1.style.visibility = "hidden";
		}
	}
	// initializing <select> view
	if(element2.value=='native'){
		element1.disabled = false;
		element1.style.visibility = "visible";
	} 
	else {
		element1.disabled = true;
		element1.parentNode.style.backgroundColor="#ddd";
		element1.style.visibility = "hidden";
	}
}

// delete row of pattern target
function delPatterntargetRow(idx,cnt){
	var ptab = document.getElementById("edPatternTargetTable"+idx);
	var ptab_cnt = ptab.rows.length;
	if(ptab_cnt>3){
		idx = "pattern_target_row_"+idx+"_"+cnt;
		var obj = document.getElementById(idx);
		obj.parentNode.removeChild(obj);
	} else {
		alert('At least one of targets is need');
	}
}

// pattern target type combobox filling
function getPatternTypes(obj,targ){
	obj.options[0] = new Option('native','native',(targ=='native'));
	obj.options[1] = new Option('called','called',(targ=='called'));
	obj.options[2] = new Option('reject','reject',(targ=='reject'));
	for(var i=0;i<=2;i++) // for IE right work
	if (obj.options[i].defaultSelected == true)	obj.options[i].selected = true;
}

// pattern target combobox filling
function getPatternTargets(obj,targ){
	arrTargetNames.length = 0;
	EnumTargets("hidSignallingTargetCount", "edSignallingTargetName");
	EnumTargets("hidAKTargetCount", "edAKTargetName");
	EnumTargets("hidModemTargetCount", "edModemTargetName");
	for (i = 0; i < arrTargetNames.length; i++) {
		obj.options[i] = new Option(arrTargetNames[i], arrTargetNames[i],
					(arrTargetNames[i] == targ));
	if (obj.options[i].defaultSelected == true)	//IE sometimes suck without this
		obj.options[i].selected = true;
	}
}




var arrTargetNames = [];

function EnumTargets(target_counter_name, target_enumcontrol_name) {
	var obj = document.getElementById(target_counter_name);
	var cnt = obj.value;
	for (var idx = 1; idx <= cnt; idx++) {
		obj = document.getElementById(target_enumcontrol_name + idx);
		if (obj)
			arrTargetNames.push(obj.value);
	}
}

function UpdatePatternControls() {
	var obj = document.getElementById("hidPatternCount");
	if (!obj)
		return;
	var cnt = obj.value;

	arrTargetNames.length = 0;
	//arrTargetNames.push("called");
	EnumTargets("hidSignallingTargetCount", "edSignallingTargetName");
	EnumTargets("hidAKTargetCount", "edAKTargetName");
	EnumTargets("hidModemTargetCount", "edModemTargetName");

	
	/*for (var idx = 0; idx < arrTargetNames.length; idx++) {
		alert(arrTargetNames[idx]);
	}
	return;*/
/*	
	for (var idx = 1; idx <= cnt; idx++) {
		obj = document.getElementById("edPatternTarget" + idx);
		if (obj) {
			var previtem = '';
			var previndex = (obj.selectedIndex < 0) ? 0 : obj.selectedIndex;
			if (obj.selectedIndex >= 0) {
				previtem = obj.options[obj.selectedIndex].value;
			} else {
				var obj_int = document.getElementById("edPatternTarget" + idx + "_default");
				if (obj_int)
					previtem = obj_int.value;
			}
			obj.options.length = 0;

			var bSelectByIndex = true;
			for (var i = 0; i < arrTargetNames.length; i++) {
				if (arrTargetNames[i] == previtem) {
					bSelectByIndex = false;
					break;
				}
			}
			for (i = 0; i < arrTargetNames.length; i++) {
				obj.options[i] = new Option(arrTargetNames[i], arrTargetNames[i],
											(!bSelectByIndex && (arrTargetNames[i] == previtem)) || (i == previndex));
				if (obj.options[i].defaultSelected == true)	//IE sometimes suck without this
					obj.options[i].selected = true;
			}
		}
	}
*/

	for (var idx = 1; idx <= cnt; idx++) {
		
		var table = document.getElementById("edPatternTargetTable" + idx);
		var rowCount = table.rows.length;
		
		for(var tagrow = 2; tagrow < rowCount; tagrow++){
			//alert('idx='+idx+' tagrow='+tagrow);
			obj = document.getElementById("pattern_target_" + idx + "_" + tagrow);
			if (obj) {
				var previtem = '';
				var previndex = (obj.selectedIndex < 0) ? 0 : obj.selectedIndex;
				if (obj.selectedIndex >= 0) {
					previtem = obj.options[obj.selectedIndex].value;
				} else {
					//var obj_int = document.getElementById("edPatternTarget" + idx + "_default");
					var obj_int = document.getElementById("pattern_target_" + idx + "_2");
					if (obj_int)
						previtem = obj_int.value;
				}
				obj.options.length = 0;

				var bSelectByIndex = true;
				for (var i = 0; i < arrTargetNames.length; i++) {
					if (arrTargetNames[i] == previtem) {
						bSelectByIndex = false;
						break;
					}
				}
				for (i = 0; i < arrTargetNames.length; i++) {
					obj.options[i] = new Option(arrTargetNames[i], arrTargetNames[i],
												(!bSelectByIndex && (arrTargetNames[i] == previtem)) || (i == previndex));
					if (obj.options[i].defaultSelected == true)	//IE sometimes suck without this
						obj.options[i].selected = true;
				}
			}
		}
	}
	
	
	
/*	
	// targets
	for (var idx = 1; idx <= cnt; idx++) { // around patterns - idx
		var pattern_table = document.getElementById("edPatternTargetTable"+idx);
		var pattern_targets_count = pattern_table.rows.length;

		for(var tag_idx = 1; tag_idx <= pattern_targets_count; tag_idx++){ // around targets - tag_idx
			obj = document.getElementById("pattern_target_"+idx+"_"+tag_idx);
			if (obj) {
				var previtem = '';
				var previndex = (obj.selectedIndex < 0) ? 0 : obj.selectedIndex;
				if (obj.selectedIndex >= 0) {
					previtem = obj.options[obj.selectedIndex].value;
				} else {
					var obj_int = document.getElementById("edPatternTarget" + idx + "_default");
					if (obj_int)
						previtem = obj_int.value;
				}
				obj.options.length = 0;

				var bSelectByIndex = true;
				for (var i = 0; i < arrTargetNames.length; i++) {
					if (arrTargetNames[i] == previtem) {
						bSelectByIndex = false;
						break;
					}
				}
				for (i = 0; i < arrTargetNames.length; i++) {
					obj.options[i] = new Option(arrTargetNames[i], arrTargetNames[i],
												(!bSelectByIndex && (arrTargetNames[i] == previtem)) || (i == previndex));
					if (obj.options[i].defaultSelected == true)	//IE sometimes suck without this
						obj.options[i].selected = true;
				}
			}
			
			
		} // around targets - tag_idx
	} // around patterns - idx
*/	
	
	
}

function OnAddTargetSignalling(signalling_idx,
								signalling_name,
								signalling_called,
								signalling_caller,
								signalling_codec_set,
								signalling_type,
								signalling_ss7_cg_category,
								signalling_ss7_cg_nature,
								signalling_ss7_cg_inetwork,
								signalling_ss7_cg_plan,
								signalling_ss7_cd_nature,
								signalling_ss7_cd_plan,
								signalling_isdn_cg_typeofnumber,
								signalling_isdn_cg_plan,
								signalling_isdn_cg_screeningind,
								signalling_isdn_cd_typeofnumber,
								signalling_isdn_cd_plan,
								signalling_isdn_cd_screeningind,
								signalling_group,
								insert_side, // 0 - left, 1 - right
								signalling_comments,
								signalling_unknowns) {
	var hid = document.getElementById("hidSignallingTargetCount");

	hid.value++;
	if (!signalling_idx || (signalling_idx < 0))
		signalling_idx = hid.value;
	if (!signalling_name)
		signalling_name = "sig" + signalling_idx;
	if (!signalling_called)
		signalling_called = "";
	if (!signalling_caller)
		signalling_caller = "";
	if (!signalling_codec_set)
		signalling_codec_set = arrAllCodecs[0];
	if (!signalling_type)
		signalling_type = "sip";
	if (!signalling_ss7_cg_category)
		signalling_ss7_cg_category = "";
	if (!signalling_ss7_cg_nature)
		signalling_ss7_cg_nature = "";
	if (!signalling_ss7_cg_inetwork)
		signalling_ss7_cg_inetwork = "";
	if (!signalling_ss7_cg_plan)
		signalling_ss7_cg_plan = "";
	if (!signalling_ss7_cd_nature)
		signalling_ss7_cd_nature = "";
	if (!signalling_ss7_cd_plan)
		signalling_ss7_cd_plan = "";
	if (!signalling_isdn_cg_typeofnumber)
		signalling_isdn_cg_typeofnumber = "";
	if (!signalling_isdn_cg_plan)
		signalling_isdn_cg_plan = "";
	if (!signalling_isdn_cg_screeningind)
		signalling_isdn_cg_screeningind = "";
	if (!signalling_isdn_cd_typeofnumber)
		signalling_isdn_cd_typeofnumber = "";
	if (!signalling_isdn_cd_plan)
		signalling_isdn_cd_plan = "";
	if (!signalling_isdn_cd_screeningind)
		signalling_isdn_cd_screeningind = "";
	if (!signalling_group)
		signalling_group = "";
	if (insert_side != 0 )
		insert_side = 1;
	if (!signalling_comments)
		signalling_comments = "";
	if (!signalling_unknowns)
		signalling_unknowns = "";

	//table
	var aTable = document.createElement("table");
	aTable.id = "UniqueSignallingTarget" + signalling_idx;

	aTable.onclick = function() {
		var hidcnt = document.getElementById("hidSignallingTargetCount").value;
		for(var i = 1; i <= hidcnt; i++){
			var tablock = document.getElementById("UniqueSignallingTarget"+i);
			tablock.setAttribute("style", "float:left;background:" + GetAltColor(signalling_idx, 1, true));
		}
		this.setAttribute("style", "float:left;background:" + GetAltColor(signalling_idx, 2, true));
	};

	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	aTable.className = "nb UniqueSignallingTarget";
	aTable.setAttribute("style", "float:left;background:" + GetAltColor(signalling_idx, 1, true));
	aTable.style.cssText = "float:left;background:" + GetAltColor(signalling_idx, 1, true);
	aTable.setAttribute("block_type", "Signalling");
	var tbody = document.createElement("tbody");

	AddTableCaption(tbody,
		"<div style=\"display:inline;float:left\">&nbsp; #"+signalling_idx+"&nbsp;</div>"+

		"<img class=\"imglink\" style=\"display:inline;float:left;margin-right:2px;margin-top:2px;\" OnClick=\"doClearClick(event); Signaling_Rotation('left',"+signalling_idx+");\" title=\"Move forward\" alt=\"<\" src=\"/images/lf.gif\">"+
		"<img class=\"imglink\" style=\"display:inline;float:left;margin-right:2px;margin-top:2px;\" OnClick=\"doClearClick(event); Signaling_Rotation('right',"+signalling_idx+");\" title=\"Move back\" alt=\">\" src=\"/images/rt.gif\">"+

		"<select name=\"edSignalingPosition"+signalling_idx+"\" id=\"edSignalingPosition"+signalling_idx+"\" OnClick=\"doClearClick(event);\" OnChange=\"Signaling_Move("+signalling_idx+");\" class=\"blockheader_select\" "+
		"style=\"display:inline;float:left;margin-right:2px; width:40px;\" >" +
		"</select>\n"+

		"<img class=\"imglink\" style=\"display:inline;float:right;margin-right:2px;\" OnClick=\"Signaling_Delete("+signalling_idx+"); doChangeEvent();\" title=\"Delete Signalling target\" src=\"/images/del.gif\">");
		
		/*"<div style=\"display:inline;float:left\">&nbsp; #"+signalling_idx+"&nbsp;</div>"+

		"<img class=\"imglink\" style=\"display:inline;float:left;margin-right:2px;\" OnClick=\"OnMoveSignaling('left',"+signalling_idx+")\" title=\"Move forward\" alt=\"<\" src=\"/images/lf.gif\">"+
		"<img class=\"imglink\" style=\"display:inline;float:left;margin-right:2px;\" OnClick=\"OnMoveSignaling('right',"+signalling_idx+")\" title=\"Move back\" alt=\">\" src=\"/images/rt.gif\">"+

		"<img class=\"imglink\" style=\"display:inline;float:right;margin-right:2px;\" OnClick=\"OnDelTargetSignalling("+signalling_idx+"); doChangeEvent();\" title=\"Delete Signalling target\" src=\"/images/del.gif\">");
		*/
		
		
		
	AddTableRow(tbody, "name",
		"<input name=\"edSignallingTargetName"+signalling_idx+"\" " +
		"id=\"edSignallingTargetName"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_name+"\" " +
		"OnChange=\"UpdateSignallingTargetControls();\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");

	/*AddTableRow(tbody, "called",
		"<input name=\"edSignallingTargetCalled"+signalling_idx+"\" " +
		"id=\"edSignallingTargetCalled"+signalling_idx+"\" " +
		"type=\"text\" value=\""+signalling_called+"\" " +
		"maxlength=\"256\" size=\"16\" class=\"selectw\">");*/

	var tmpstr = "<table>"+
	"<tr>"+
	"<td>inexp</td>"+
	"<td><input type='text' id='inexp_"+signalling_idx+"' maxlength='256' size='16' class='selectw' style='width:242px;' "+
	"oninput='DoTestRegExp(\"edSignallingTargetCalled"+signalling_idx+"\",this.id,\"inexp_result_"+signalling_idx+"\");' "+
	"></td>"+
	"</tr>"+
	"<tr>"+
	"<td>result</td>"+
	"<td span=2><input type='text' id='inexp_result_"+signalling_idx+"' maxlength='256' size='16' class='selectw' style='width:242px;'></td>"+
	"</tr>"+
	"</table>";

	AddTableRow(tbody, "called",
		"<input name=\"edSignallingTargetCalled"+signalling_idx+"\" " +
		"id=\"edSignallingTargetCalled"+signalling_idx+"\" " +
		"type=\"text\" value=\""+signalling_called+"\" " +
		"maxlength=\"256\" size=\"16\" class=\"selectw\" "+
		"oninput='DoTestRegExp(this.id,\"inexp_"+signalling_idx+"\",\"inexp_result_"+signalling_idx+"\"); doChangeEvent();' "+
		">"+
		"<img id='btn_check_"+signalling_idx+"' src=\"/images/arrow_down.png\" title='called testing' style='margin:0 2px 2px 2px; padding:0; width:17px; height:17px;vertical-align:bottom;' onclick=\"toggle_info_block(this,'called_check_"+signalling_idx+"');\">\n"+
		"<div id='called_check_"+signalling_idx+"' class='info_block_hide' >"+tmpstr+"</div>"
	);

/*
	AddTableRow(tbody, "caller",
		"<input name=\"edSignallingTargetCaller"+signalling_idx+"\" " +
		"id=\"edSignallingTargetCaller"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_caller+"\" " +
		"maxlength=\"256\" size=\"16\" class=\"selectw\" "+
		">");
*/

	var tmpstr = "<table>"+
	"<tr>"+
	"<td>inexp</td>"+
	"<td><input type='text' id='caller_inexp_"+signalling_idx+"' maxlength='256' size='16' class='selectw' style='width:242px;' "+
	"oninput='DoTestRegExp(\"edSignallingTargetCaller"+signalling_idx+"\",this.id,\"caller_inexp_result_"+signalling_idx+"\");' "+
	"></td>"+
	"</tr>"+
	"<tr>"+
	"<td>result</td>"+
	"<td span=2><input type='text' id='caller_inexp_result_"+signalling_idx+"' maxlength='256' size='16' class='selectw' style='width:242px;'></td>"+
	"</tr>"+
	"</table>";

	AddTableRow(tbody, "caller",
		"<input name=\"edSignallingTargetCaller"+signalling_idx+"\" " +
		"id=\"edSignallingTargetCaller"+signalling_idx+"\" " +
		"type=\"text\" value=\""+signalling_caller+"\" " +
		"maxlength=\"256\" size=\"16\" class=\"selectw\" "+
		"oninput='DoTestRegExp(this.id,\"caller_inexp_"+signalling_idx+"\",\"caller_inexp_result_"+signalling_idx+"\"); doChangeEvent();' "+
		">"+
		"<img id='btn_check_"+signalling_idx+"' src=\"/images/arrow_down.png\" title='caller testing' style='margin:0 2px 2px 2px; padding:0; width:17px; height:17px;vertical-align:bottom;' onclick=\"toggle_info_block(this,'caller_check_"+signalling_idx+"');\">\n"+
		"<div id='caller_check_"+signalling_idx+"' class='info_block_hide' >"+tmpstr+"</div>"
	);




	/*AddTableRow(tbody, "codec set",
		"<input name=\"edSignallingTargetCodecSet"+signalling_idx+"\" " +
		"id=\"edSignallingTargetCodecSet"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_codec_set+"\" " +
		"maxlength=\"50\" size=\"20\" class=\"selectw\">");*/

	AddTableRow(tbody,
		"codec set<br>\n"+
		"<div style=\"margin-top:10px;padding:0px;text-align:right\">\n"+
		"<img class=\"imglink\" onClick=\"MoveListItem('up', 'SignallingTargetCodecSet"+signalling_idx+"')\" src=\"/images/up.gif\" alt=\"Move selected items up\">\n"+
		"</div>\n"+
		"<div style=\"margin-top:0px;padding:0px;text-align:right\">\n"+
		"<img class=\"imglink\" onClick=\"MoveListItem('down', 'SignallingTargetCodecSet"+signalling_idx+"')\" src=\"/images/dn.gif\" alt=\"Move selected items down\">\n"+
		"</div>\n",

		"<select name=\"SignallingTargetCodecSet"+signalling_idx+"\" " +
		"id=\"SignallingTargetCodecSet"+signalling_idx+"\" " +
		"multiple size=\"4\" class=\"selectw\">"+
		GetCodecOptionsString(signalling_codec_set)+
		"</select>\n"+
		"<input name=\"edSignallingTargetCodecSet"+signalling_idx+"\" " +
		"id=\"edSignallingTargetCodecSet"+signalling_idx+"\" " +
		"type=\"hidden\" " +
		"value=\""+signalling_codec_set+"\">",

		true);

	AddTableRow(tbody, "type",
		"<select name=\"edSignallingTargetType"+signalling_idx+"\" class=\"selectw\" onchange=\"ShowSignallingBlock(this.value,"+signalling_idx+");\">"+
		"id=\"edSignallingTargetType"+signalling_idx+"\" " +
		"<option value=\"sip\""+GetSelectedString(signalling_type, 'sip')+">sip</option>"+
		"<option value=\"isdn\""+GetSelectedString(signalling_type, 'isdn')+">isdn</option>\n"+
		"<option value=\"ss7\""+GetSelectedString(signalling_type, 'ss7')+">ss7</option>\n"+
		"<option value=\"cas-hdlc\""+GetSelectedString(signalling_type, 'cas-hdlc')+">cas-hdlc</option>\n"+
		"</select>\n");

	AddTableRow(tbody, "ss7.cg.category",
		"<input name=\"edSignallingTargetSS7_cg_category"+signalling_idx+"\" " +
		"id=\"edSignallingTargetSS7_cg_category"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_ss7_cg_category+"\" class=\"selectw\">");

	AddTableRow(tbody, "ss7.cg.nature",
		"<input name=\"edSignallingTargetSS7_cg_nature"+signalling_idx+"\" " +
		"id=\"edSignallingTargetSS7_cg_nature"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_ss7_cg_nature+"\" class=\"selectw\">");
		
	AddTableRow(tbody, "ss7.cg.inetwork",
		"<input name=\"edSignallingTargetSS7_cg_inetwork"+signalling_idx+"\" " +
		"id=\"edSignallingTargetSS7_cg_inetwork"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_ss7_cg_inetwork+"\" class=\"selectw\">");
		
	AddTableRow(tbody, "ss7.cg.plan",
		"<input name=\"edSignallingTargetSS7_cg_plan"+signalling_idx+"\" " +
		"id=\"edSignallingTargetSS7_cg_plan"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_ss7_cg_plan+"\" class=\"selectw\">");
		
	AddTableRow(tbody, "ss7.cd.nature",
		"<input name=\"edSignallingTargetSS7_cd_nature"+signalling_idx+"\" " +
		"id=\"edSignallingTargetSS7_cd_nature"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_ss7_cd_nature+"\" class=\"selectw\">");
		
	AddTableRow(tbody, "ss7.cd.plan",
		"<input name=\"edSignallingTargetSS7_cd_plan"+signalling_idx+"\" " +
		"id=\"edSignallingTargetSS7_cd_plan"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_ss7_cd_plan+"\" class=\"selectw\">");
	
	AddTableRow(tbody, "isdn.cg.typeofnumber",
		"<input name=\"edSignallingTargetISDN_cg_typeofnumber"+signalling_idx+"\" " +
		"id=\"edSignallingTargetISDN_cg_typeofnumber"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_isdn_cg_typeofnumber+"\" class=\"selectw\">");

	AddTableRow(tbody, "isdn.cg.plan",
		"<input name=\"edSignallingTargetISDN_cg_plan"+signalling_idx+"\" " +
		"id=\"edSignallingTargetISDN_cg_plan"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_isdn_cg_plan+"\" class=\"selectw\">");

	AddTableRow(tbody, "isdn.cg.screeningind",
		"<input name=\"edSignallingTargetISDN_cg_screeningind"+signalling_idx+"\" " +
		"id=\"edSignallingTargetISDN_cg_screeningind"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_isdn_cg_screeningind+"\" class=\"selectw\">");

	AddTableRow(tbody, "isdn.cd.typeofnumber",
		"<input name=\"edSignallingTargetISDN_cd_typeofnumber"+signalling_idx+"\" " +
		"id=\"edSignallingTargetISDN_cd_typeofnumber"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_isdn_cd_typeofnumber+"\" class=\"selectw\">");

	AddTableRow(tbody, "isdn.cd.plan",
		"<input name=\"edSignallingTargetISDN_cd_plan"+signalling_idx+"\" " +
		"id=\"edSignallingTargetISDN_cd_plan"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_isdn_cd_plan+"\" class=\"selectw\">");

	AddTableRow(tbody, "isdn.cd.screeningind",
		"<input name=\"edSignallingTargetISDN_cd_screeningind"+signalling_idx+"\" " +
		"id=\"edSignallingTargetISDN_cd_screeningind"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_isdn_cd_screeningind+"\" class=\"selectw\">");

	AddTableRow(tbody, "group",
		"<input name=\"edSignallingTargetGroup"+signalling_idx+"\" " +
		"type=\"text\" " +
		"value=\""+signalling_group+"\" " +
		"itemtype=\"edSignallingTargetGroup\" " +
		"maxlength=\"5\" size=\"5\" class=\"selectw\">"+
		"<input name=\"edSignallingTargetComments"+signalling_idx+"\" type=\"hidden\" value=\""+signalling_comments+"\">"+
		"<input name=\"edSignallingTargetUnknowns"+signalling_idx+"\" type=\"hidden\" value=\""+signalling_unknowns+"\">");

	aTable.appendChild(tbody);

	//finally insert
	//hid.parentNode.insertBefore(aTable, hid);
	if( insert_side == 0 ){
		var obj = document.getElementById("UniqueSignallingTargetPlus");
		if(obj){
			obj.parentNode.insertBefore(aTable, obj);
			if(hid.value>1) Signaling_ChangePosition(hid.value,1);
			signalling_idx = 1;
		} else {
			hid.parentNode.insertBefore(aTable, hid);
			OnAddSignalling_Plus();
		}
	} else {
		hid.parentNode.insertBefore(aTable, hid);
	}

	UpdateSignallingTargetControls();
	
	ShowSignallingBlock(signalling_type,signalling_idx);
	doSectionCountCheck('SignallingTargetsContainerHeader','SignallingTargetsContainer','Signalling',0);
}

// Signalling Plus-block
function OnAddSignalling_Plus() {
	var hid = document.getElementById("hidSignallingTargetCount");
	var aTable = document.createElement("table");
	aTable.id = "UniqueSignallingTargetPlus";
	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	aTable.className = "nb";
	aTable.setAttribute("style", "float:left;background:" + GetAltColor("Plus", 4, true));
	aTable.style.cssText = "float:left;background:" + GetAltColor("Plus", 4, true);
	var tbody = document.createElement("tbody");

	AddTableRow(tbody, "",
		"<img  class=\"imglink\" style=\"display:inline;float:left;margin:40px 30px 20px 30px; width:100px;height:100px; text-align:center;\" onClick=\"Signalling_Plus_Delete();\" title=\"Add Signalling targets\" src=\"/images/add_block.gif\" >");
	
	aTable.appendChild(tbody);
	hid.parentNode.insertBefore(aTable, hid);
}
function Signalling_Plus_Delete() {
	var aObj = document.getElementById("UniqueSignallingTargetPlus");
	aObj.parentNode.removeChild(aObj);
	OnAddTargetSignalling();
	Signaling_List();
	OnAddSignalling_Plus();

	var hid = document.getElementById("hidSignallingTargetCount");
	var tablock = document.getElementById("UniqueSignallingTarget"+hid.value);
	tablock.onclick();
	document.getElementById("edSignallingTargetName"+hid.value).focus();
	
}






function UpdateSignallingTargetControls() {
	UpdatePatternControls();
}

function OnAddTargetAK(idx,
						name,
						slot,
						channel,
						income_caller_id,
						outcome_caller_id,
						called,
						insert_side, // 0 - left, 1 - right
						comments,
						unknowns) {
	var hid = document.getElementById("hidAKTargetCount");

	hid.value++;
	if (!idx || (idx < 0))
		idx = hid.value;
	if (!name)
		name = idx;
	if (!slot)
		slot = "0";
	if (!channel)
		channel = "0";
	if (!income_caller_id)
		income_caller_id = "";
	if (!outcome_caller_id)
		outcome_caller_id = "";
	if (!called)
		called = "";
	if (insert_side != 0 )
		insert_side = 1;
	if (!comments)
		comments = "";
	if (!unknowns)
		unknowns = "";

	//table
	var aTable = document.createElement("table");
	aTable.id = "UniqueAKTarget" + idx;

	aTable.onclick = function() {
		var hid = document.getElementById("hidAKTargetCount").value;
		for(var i = 1; i <= hid; i++){
			var tablock = document.getElementById("UniqueAKTarget"+i);
			tablock.setAttribute("style", "float:left;background:" + GetAltColor(idx, 1, true));
		}
		this.setAttribute("style", "float:left;background:" + GetAltColor(idx, 2, true));
	};
	
	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	aTable.className = "nb";
	aTable.setAttribute("style", "float:left;background:" + GetAltColor(idx, 1, true));
	aTable.style.cssText = "float:left;background:" + GetAltColor(idx, 1, true);
	aTable.setAttribute("block_type","AKTarget");
	var tbody = document.createElement("tbody");

	AddTableCaption(tbody,
		"<div style=\"display:inline;float:left\">&nbsp; #"+idx+"&nbsp;</div>"+

		"<img class=\"imglink\" style=\"display:inline;float:left;margin-right:2px;margin-top:2px;\" OnClick=\"doClearClick(event); TargetAK_Rotation('left',"+idx+");\" title=\"Move forward\" alt=\"<\" src=\"/images/lf.gif\">"+
		"<img class=\"imglink\" style=\"display:inline;float:left;margin-right:2px;margin-top:2px;\" OnClick=\"doClearClick(event); TargetAK_Rotation('right',"+idx+");\" title=\"Move back\" alt=\">\" src=\"/images/rt.gif\">"+
		
		"<select name=\"edAKTargetPosition"+idx+"\" id=\"edAKTargetPosition"+idx+"\" OnClick=\"doClearClick(event);\" OnChange=\"TargetAK_Move("+idx+");\" class=\"blockheader_select\" "+
		"style=\"display:inline;float:left;margin-right:2px;\" >" +
		"</select>\n"+
		
		"<img class=\"imglink\" style=\"display:inline;float:right;margin-right:2px;\" OnClick=\"TargetAK_Delete("+idx+");\" title=\"Delete AK target\" src=\"/images/del.gif\">");
		
	AddTableRow(tbody, "name",
		"<input name=\"edAKTargetName"+idx+"\" " +
		"id=\"edAKTargetName"+idx+"\" " +
		"type=\"text\" " +
		"value=\""+name+"\" " +
		"OnChange=\"UpdateAKTargetControls();\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw280\">");
		
	var slots = "";
	for(var i=0; i<=31; i++) {
		slots += "<option value=\""+i+"\""+GetSelectedString(slot, i)+">"+i+"</option>\n";
	}
	AddTableRow(tbody, "slot",
		/*"<input name=\"edAKTargetSlot"+idx+"\" " +
		"id=\"edAKTargetSlot"+idx+"\" " +
		"type=\"text\" " +
		"value=\""+slot+"\" " +
		"maxlength=\"5\" size=\"5\" class=\"selectw\">");*/
		"<select name=\"edAKTargetSlot"+idx+"\" class=\"selectw\">" +
		slots +
		"</select>\n");

	/*AddTableRow(tbody, "channel",
		"<input name=\"edAKTargetChannel"+idx+"\" " +
		"id=\"edAKTargetChannel"+idx+"\" " +
		"type=\"text\" " +
		"value=\""+channel+"\" " +
		"maxlength=\"5\" size=\"5\" class=\"selectw\">");*/
	var ak_targets = "";
	for(var i=0; i<=15; i++) {
		ak_targets += "<option value=\""+i+"\""+GetSelectedString(channel, i)+">"+i+"</option>\n";
	}
	AddTableRow(tbody, "channel",
		"<select name=\"edAKTargetChannel"+idx+"\" class=\"selectw\">" +
		ak_targets +
		"</select>\n");
		
		
	AddTableRow(tbody, "incoming caller id",
		"<input name=\"edAKTargetIncomeCallerId"+idx+"\" " +
		"type=\"text\" " +
		"value=\""+income_caller_id+"\" " +
		"maxlength=\"256\" size=\"10\" class=\"selectw280\">");

	AddTableRow(tbody, "outcoming caller id",
		"<input name=\"edAKTargetOutcomeCallerId"+idx+"\" " +
		"type=\"text\" " +
		"value=\""+outcome_caller_id+"\" " +
		"maxlength=\"256\" size=\"10\" class=\"selectw280\">");
		
	AddTableRow(tbody, "called",
		"<input name=\"edAKTargetCalled"+idx+"\" " +
		"type=\"text\" " +
		"value=\""+called+"\" " +
		"maxlength=\"256\" size=\"10\" class=\"selectw280\">"+
		"<input name=\"edAKTargetComments"+idx+"\" type=\"hidden\" value=\""+comments+"\">"+
		"<input name=\"edAKTargetUnknowns"+idx+"\" type=\"hidden\" value=\""+unknowns+"\">");

	aTable.appendChild(tbody);

	//finally insert
	if( insert_side == 0 ){
		var obj = document.getElementById("UniqueAKTargetPlus");
		if(obj){
			obj.parentNode.insertBefore(aTable, obj);
			if(hid.value>1) TargetAK_ChangePosition(hid.value,1);
		} else {
			hid.parentNode.insertBefore(aTable, hid);
		}
	} else {
		hid.parentNode.insertBefore(aTable, hid);
	}
	
	UpdateAKTargetControls();
	doSectionCountCheck('AKTargetsContainerHeader','AKTargetsContainer','AKTarget',0);
}

// AK Target Plus-block
function OnAddTargetAK_Plus() {
	var hid = document.getElementById("hidAKTargetCount");
	var aTable = document.createElement("table");
	aTable.id = "UniqueAKTargetPlus";
	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	aTable.className = "nb";
	aTable.setAttribute("style", "float:left;background:" + GetAltColor("Plus", 4, true));
	aTable.style.cssText = "float:left;background:" + GetAltColor("Plus", 4, true);
	var tbody = document.createElement("tbody");

	AddTableRow(tbody, "",
		"<img  class=\"imglink\" style=\"display:inline;float:left;margin:24px 50px 24px 150px; width:100px;height:100px; text-align:center;\" onClick=\"TargetAK_Plus_Delete();\" title=\"Add AK target\" src=\"/images/add_block.gif\" >");
	
	aTable.appendChild(tbody);
	hid.parentNode.insertBefore(aTable, hid);
}
function TargetAK_Plus_Delete() {
	var aObj = document.getElementById("UniqueAKTargetPlus");
	aObj.parentNode.removeChild(aObj);
	OnAddTargetAK();
	TargetAK_List();
	OnAddTargetAK_Plus();

	var hid = document.getElementById("hidAKTargetCount");
	var tablock = document.getElementById("UniqueAKTarget"+hid.value);
	tablock.onclick();
	document.getElementById("edAKTargetName"+hid.value).focus();
	
}


function UpdateAKTargetControls() {
	UpdatePatternControls();
}

function OnAddTargetModem(modem_idx,
						  modem_name,
						  modem_originate,
						  modem_fax,
						  modem_comments,
						  modem_unknowns) {
	var hid = document.getElementById("hidModemTargetCount");

	hid.value++;
	if (!modem_idx || (modem_idx < 0))
		modem_idx = hid.value;
	if (!modem_name)
		modem_name = "modem" + modem_idx;
	if (!modem_originate)
		modem_originate = "no";
	if (!modem_fax)
		modem_fax = "no";
	if (!modem_comments)
		modem_comments = "";
	if (!modem_unknowns)
		modem_unknowns = "";

	//table
	var aTable = document.createElement("table");
	aTable.id = "UniqueModemTarget" + modem_idx;
	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	aTable.className = "nb";
	aTable.setAttribute("style", "float:left;background:" + GetAltColor(modem_idx, 1, true));
	aTable.style.cssText = "float:left;background:" + GetAltColor(modem_idx, 1, true);
	aTable.setAttribute("block_type","ModemTarget");
	var tbody = document.createElement("tbody");

	AddTableCaption(tbody,
		"<div style=\"display:inline;float:left\">&nbsp; #"+modem_idx+"&nbsp;</div>"+
		"<img class=\"imglink\" style=\"display:inline;float:right;margin-right:2px;\" OnClick=\"OnDelTargetModem("+modem_idx+")\" title=\"Delete Modem target\" src=\"/images/del.gif\">");

	AddTableRow(tbody, "name",
		"<input name=\"edModemTargetName"+modem_idx+"\" " +
		"id=\"edModemTargetName"+modem_idx+"\" " +
		"type=\"text\" value=\""+modem_name+"\" " +
		"OnChange=\"UpdateModemTargetControls();\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");

	AddTableRow(tbody, "originate",
		"<select name=\"edModemTargetOriginate"+modem_idx+"\" class=\"selectw\">"+
		"<option value=\"yes\""+GetSelectedString(modem_originate, 'yes')+">yes</option>"+
		"<option value=\"no\""+GetSelectedString(modem_originate, 'no')+">no</option>\n"+
		"</select>\n");

	AddTableRow(tbody, "fax",
		"<select name=\"edModemTargetFax"+modem_idx+"\" class=\"selectw\">"+
		"<option value=\"yes\""+GetSelectedString(modem_fax, 'yes')+">yes</option>"+
		"<option value=\"no\""+GetSelectedString(modem_fax, 'no')+">no</option>\n"+
		"</select>\n"+
		"<input name=\"edModemTargetComments"+modem_idx+"\" type=\"hidden\" value=\""+modem_comments+"\">"+
		"<input name=\"edModemTargetUnknowns"+modem_idx+"\" type=\"hidden\" value=\""+modem_unknowns+"\">");

	aTable.appendChild(tbody);

	//finally insert
	hid.parentNode.insertBefore(aTable, hid);

	UpdateModemTargetControls();
	doSectionCountCheck('ModemTargetsContainerHeader','ModemTargetsContainer','ModemTarget',0);
}

function OnDelTargetModem(idx) {
	var aObj = document.getElementById("UniqueModemTarget"+idx);
	if (aObj == null) {
		alert("Modem target delete error!\nidx="+idx);
	} else {
		aObj.style.display = "none";
		document.body.appendChild(aObj);
		document.body.removeChild(aObj);
	}

	UpdateModemTargetControls();
	doSectionCountCheck('ModemTargetsContainerHeader','ModemTargetsContainer','ModemTarget',0);
}

function UpdateModemTargetControls() {
	UpdatePatternControls();
}

// show signalling parameters according the type
function ShowSignallingBlock(obj_value,signalling_idx){

	if(obj_value == 'isdn'){
	document.getElementById('edSignallingTargetISDN_cg_typeofnumber'+signalling_idx).parentNode.parentNode.style.display = '';
	document.getElementById('edSignallingTargetISDN_cg_plan'+signalling_idx).parentNode.parentNode.style.display = '';
	document.getElementById('edSignallingTargetISDN_cg_screeningind'+signalling_idx).parentNode.parentNode.style.display = '';
	document.getElementById('edSignallingTargetISDN_cd_typeofnumber'+signalling_idx).parentNode.parentNode.style.display = '';
	document.getElementById('edSignallingTargetISDN_cd_plan'+signalling_idx).parentNode.parentNode.style.display = '';
	document.getElementById('edSignallingTargetISDN_cd_screeningind'+signalling_idx).parentNode.parentNode.style.display = '';
	} else {
	document.getElementById('edSignallingTargetISDN_cg_typeofnumber'+signalling_idx).parentNode.parentNode.style.display = 'none';
	document.getElementById('edSignallingTargetISDN_cg_plan'+signalling_idx).parentNode.parentNode.style.display = 'none';
	document.getElementById('edSignallingTargetISDN_cg_screeningind'+signalling_idx).parentNode.parentNode.style.display = 'none';
	document.getElementById('edSignallingTargetISDN_cd_typeofnumber'+signalling_idx).parentNode.parentNode.style.display = 'none';
	document.getElementById('edSignallingTargetISDN_cd_plan'+signalling_idx).parentNode.parentNode.style.display = 'none';
	document.getElementById('edSignallingTargetISDN_cd_screeningind'+signalling_idx).parentNode.parentNode.style.display = 'none';
	}

	if(obj_value == 'ss7'){
	document.getElementById('edSignallingTargetSS7_cg_category'+signalling_idx).parentNode.parentNode.style.display = '';
	document.getElementById('edSignallingTargetSS7_cg_nature'+signalling_idx).parentNode.parentNode.style.display = '';
	document.getElementById('edSignallingTargetSS7_cg_inetwork'+signalling_idx).parentNode.parentNode.style.display = '';
	document.getElementById('edSignallingTargetSS7_cg_plan'+signalling_idx).parentNode.parentNode.style.display = '';
	document.getElementById('edSignallingTargetSS7_cd_nature'+signalling_idx).parentNode.parentNode.style.display = '';
	document.getElementById('edSignallingTargetSS7_cd_plan'+signalling_idx).parentNode.parentNode.style.display = '';
	} else {
	document.getElementById('edSignallingTargetSS7_cg_category'+signalling_idx).parentNode.parentNode.style.display = 'none';
	document.getElementById('edSignallingTargetSS7_cg_nature'+signalling_idx).parentNode.parentNode.style.display = 'none';
	document.getElementById('edSignallingTargetSS7_cg_inetwork'+signalling_idx).parentNode.parentNode.style.display = 'none';
	document.getElementById('edSignallingTargetSS7_cg_plan'+signalling_idx).parentNode.parentNode.style.display = 'none';
	document.getElementById('edSignallingTargetSS7_cd_nature'+signalling_idx).parentNode.parentNode.style.display = 'none';
	document.getElementById('edSignallingTargetSS7_cd_plan'+signalling_idx).parentNode.parentNode.style.display = 'none';
	}
}


function OnAddConnection(connection_idx,
						connection_type, //CASRemoteLEMZRadio|CASRemoteED137Radio - тип постоянного радио соединения
						connection_radio_rx_addr, //192.168.12.1 - адрес приема звукового трафика из сети
						connection_radio_rx_port, //34000 - порт приема звукового трафика из сети
						connection_radio_tx_addr, //224.0.1.1 - адрес трансляции звукового трафика в сеть
						connection_radio_tx_port, //35000 - порт трансляции звукового трафика в сеть
						connection_radio_freq_no, //125.1 - частота радиостанции
						connection_radio_freq_chan, //1 - номер частоты радиостанции в сетке вещания
						connection_cas_trunk_no, //4 - номер транка
						connection_cas_trunk_timeslot, //1 - номер таймслота в транке
						  connection_comments,
						  connection_unknowns) {
	var hid = document.getElementById("hidConnectionCount");

	hid.value++;
	if (!connection_idx || (connection_idx < 0))
		connection_idx = hid.value;
	if (!connection_type)
		connection_type = "CASRemoteLEMZRadio" + connection_idx;
	if (!connection_radio_rx_addr)
		connection_radio_rx_addr = "";
	if (!connection_radio_rx_port)
		connection_radio_rx_port = "";
	if (!connection_radio_tx_addr)
		connection_radio_tx_addr = "";
	if (!connection_radio_tx_port)
		connection_radio_tx_port = "";
	if (!connection_radio_freq_no)
		connection_radio_freq_no = "";
	if (!connection_radio_freq_chan)
		connection_radio_freq_chan = "";
	if (!connection_cas_trunk_no)
		connection_cas_trunk_no = "";
	if (!connection_cas_trunk_timeslot)
		connection_cas_trunk_timeslot = "";
	if (!connection_comments)
		connection_comments = "";
	if (!connection_unknowns)
		connection_unknowns = "";

	//table
	var aTable = document.createElement("table");
	aTable.id = "UniqueConnection" + connection_idx;
	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	aTable.className = "nb UniqueConnection";
	aTable.setAttribute("style", "float:left;background:" + GetAltColor(connection_idx, 1, true));
	aTable.style.cssText = "float:left;background:" + GetAltColor(connection_idx, 1, true);
	aTable.setAttribute("block_type","Connection");
	var tbody = document.createElement("tbody");

	AddTableCaption(tbody,
		"<div style=\"display:inline;float:left\">&nbsp; Connection #"+connection_idx+"&nbsp;</div>"+
		"<img class=\"imglink\" style=\"display:inline;float:right;margin-right:2px;\" OnClick=\"OnDelConnection("+connection_idx+")\" title=\"Delete Connection\" src=\"/images/del.gif\">");

	AddTableRow(tbody, "type",
		"<select name=\"edConnectiontype"+connection_idx+"\" class=\"selectw\">"+
		"<option value=\"CASRemoteLEMZRadio\""+GetSelectedString(connection_type, 'CASRemoteLEMZRadio')+">CASRemoteLEMZRadio</option>"+
		"<option value=\"CASRemoteED137Radio\""+GetSelectedString(connection_type, 'CASRemoteED137Radio')+" disabled>CASRemoteED137Radio</option>\n"+
		"</select>\n");

	AddTableRow(tbody, "radio.rx.addr",
		"<input name=\"edConnection_radio_rx_addr"+connection_idx+"\" " +
		"id=\"edConnection_radio_rx_addr"+connection_idx+"\" " +
		"type=\"text\" value=\""+connection_radio_rx_addr+"\" " +
		"OnChange=\"UpdateConnectionControls();\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");
		
	AddTableRow(tbody, "radio.rx.port",
		"<input name=\"edConnection_radio_rx_port"+connection_idx+"\" " +
		"id=\"edConnection_radio_rx_port"+connection_idx+"\" " +
		"type=\"text\" value=\""+connection_radio_rx_port+"\" " +
		"OnChange=\"UpdateConnectionControls();\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");
		
	AddTableRow(tbody, "radio.tx.addr",
		"<input name=\"edConnection_radio_tx_addr"+connection_idx+"\" " +
		"id=\"edConnection_radio_tx_addr"+connection_idx+"\" " +
		"type=\"text\" value=\""+connection_radio_tx_addr+"\" " +
		"OnChange=\"UpdateConnectionControls();\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");
		
	AddTableRow(tbody, "radio.tx.port",
		"<input name=\"edConnection_radio_tx_port"+connection_idx+"\" " +
		"id=\"edConnection_radio_tx_port"+connection_idx+"\" " +
		"type=\"text\" value=\""+connection_radio_tx_port+"\" " +
		"OnChange=\"UpdateConnectionControls();\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");
		
	AddTableRow(tbody, "radio.freq.no",
		"<input name=\"edConnection_radio_freq_no"+connection_idx+"\" " +
		"id=\"edConnection_radio_freq_no"+connection_idx+"\" " +
		"type=\"text\" value=\""+connection_radio_freq_no+"\" " +
		"OnChange=\"UpdateConnectionControls();\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");
		
	AddTableRow(tbody, "radio.freq.chan",
		"<input name=\"edConnection_radio_freq_chan"+connection_idx+"\" " +
		"id=\"edConnection_radio_freq_chan"+connection_idx+"\" " +
		"type=\"text\" value=\""+connection_radio_freq_chan+"\" " +
		"OnChange=\"UpdateConnectionControls();\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");
		
	AddTableRow(tbody, "cas.trunk.no",
		"<input name=\"edConnection_cas_trunk_no"+connection_idx+"\" " +
		"id=\"edConnection_cas_trunk_no"+connection_idx+"\" " +
		"type=\"text\" value=\""+connection_cas_trunk_no+"\" " +
		"itemtype=\"edConnection_cas_trunk_no\" " +
		"OnChange=\"UpdateConnectionControls();\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");
		
	AddTableRow(tbody, "cas.trunk.timeslot",
		"<input name=\"edConnection_cas_trunk_timeslot"+connection_idx+"\" " +
		"id=\"edConnection_cas_trunk_timeslot"+connection_idx+"\" " +
		"type=\"text\" value=\""+connection_cas_trunk_timeslot+"\" " +
		"itemtype=\"edConnection_cas_trunk_timeslot\" " +
		"OnChange=\"UpdateConnectionControls();\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");

	aTable.appendChild(tbody);

	//finally insert
	hid.parentNode.insertBefore(aTable, hid);

	UpdateConnectionControls();
	doSectionCountCheck('ConnectionContainerHeader','ConnectionContainer','Connection',0);
}

function OnDelConnection(idx) {
	var aObj = document.getElementById("UniqueConnection"+idx);
	if (aObj == null) {
		alert("Connection delete error!\nidx="+idx);
	} else {
		aObj.style.display = "none";
		document.body.appendChild(aObj);
		document.body.removeChild(aObj);
	}

	UpdateConnectionControls();
	doSectionCountCheck('ConnectionContainerHeader','ConnectionContainer','Connection',0);
}

function UpdateConnectionControls() {
	UpdatePatternControls();
}

function toggle_info_block(btn,obj_id){
	var obj = document.getElementById(obj_id);
	if(obj.className == "info_block") {
		obj.className = "info_block_hide"; 
		btn.setAttribute('src','/images/arrow_down.png')
	} else {
		obj.className = "info_block";
		btn.setAttribute('src','/images/arrow_up.png')
	}
}


function DoTestRegExp(regexp_id,inexp_id,outexp_id){
	var inexp_obj = document.getElementById(inexp_id);
	var outexp_obj = document.getElementById(outexp_id);
	var regexp_obj = document.getElementById(regexp_id);

	//inexp_obj.value = "sip:98@192.168.1.1";
	//var cmd = '/usr/local/sbin/router --check --reg "'+regexp_obj.value+'" --exp "'+inexp_obj.value+'"';
	var cmd = '/usr/local/sbin/router --check --reg "'+regexp_obj.value+'" --exp "'+inexp_obj.value+'"';
//	var filter = ' | grep "result" | cut -d "\\" -f 2';
	var filter = ' | grep "result" | cut -d "[" -f 2 | cut -d "]" -f 1';
	
	var urlstr = 'process.cgi?request_name=execute_command&cmd='+encodeURIComponent(cmd)+'&filter='+encodeURIComponent(filter);

	var xhr = new XMLHttpRequest();
	//xhr.open('GET', 'process.cgi?request_name=execute_command&cmd='+cmd+'&filter='+filter, true);
	xhr.open('GET', urlstr, true);
	xhr.send(null);
	xhr.onreadystatechange = function(){
	  if (xhr.readyState != 4) return;
	  if (xhr.status != 200){
	    alert(xhr.status + ': ' + xhr.statusText);
	  }else{ 
		//alert(xhr.responseText);
		outexp_obj.value = xhr.responseText;
	  }
	}

}


function OnAddCheckPatterns(pcalled,pcaller,pgroup) {
	var obj = document.getElementById("CheckPatternsContainer");

	//table
	var aTable = document.createElement("table");
	aTable.id = "UniqueCheckPatterns";
	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	aTable.className = "nb";
	aTable.setAttribute("style", "float:left;background:" + GetAltColor(0, 1, true));
	aTable.style.cssText = "float:left;background:" + GetAltColor(0, 1, true);
	var tbody = document.createElement("tbody");

	//AddTableCaption(tbody,
	//	"<div style=\"display:inline;float:left\">check</div>");

	AddTableRow(tbody, "called",
		"<input name=\"edCheckPatterns_called\" " +
		"id=\"edCheckPatterns_called\" " +
		"type=\"text\" value=\""+pcalled+"\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");

	AddTableRow(tbody, "caller",
		"<input name=\"edCheckPatterns_caller\" " +
		"id=\"edCheckPatterns_caller\" " +
		"type=\"text\" value=\""+pcaller+"\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");

	AddTableRow(tbody, "group",
		"<input name=\"edCheckPatterns_group\" " +
		"id=\"edCheckPatterns_group\" " +
		"type=\"text\" value=\""+pgroup+"\" " +
		"maxlength=\"50\" size=\"10\" class=\"selectw\">");

	if(document.cookie.indexOf('HideAfterReject=') == -1) setCookie('HideAfterReject',true);
	var hidereject = "";
	if(getCookie('HideAfterReject')=="true") hidereject = "checked";
	//alert( document.cookie );
	AddTableRow(tbody, "hide after reject",
		"<input name=\"edCheckPatterns_hide\" " +
		"id=\"edCheckPatterns_hide\" " +
		"type=\"checkbox\" value=\"1\"  " + hidereject + " " +
		"onchange = \"setCookie('HideAfterReject', this.checked); \" " +
		"class=\"selectw\">");
		
		
	AddTableRow(tbody, "",
		"<table style=\"padding: 0px; width:100%\">"+
		"<tr><td colspan=6 style=\"cursor:pointer; font-weight:bold; background:#ddd; padding-left: 10px;\" onclick=\"doCheckPattern();\" title=\"Check pattern\">Check</td></tr>"+
		"</table>"
		);

		
	aTable.appendChild(tbody);

	//finally insert
	obj.appendChild(aTable);

}

function OnAddCheckPatternsResult() {
	var obj = document.getElementById("CheckPatternsResultContainer");
	
	//var cleartab = document.getElementById("UniqueCheckPatternsResult");
	//if(cleartab) cleartab.parentNode.removeChild(cleartab);

	//table
	var aTable = document.createElement("table");
	aTable.id = "UniqueCheckPatternsResult";
	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	aTable.className = "nb";
	aTable.setAttribute("style", "float:left;background:" + GetAltColor(0, 1, true));
	aTable.style.cssText = "float:left;background:" + GetAltColor(0, 1, true) +"; display:none; ";
	var tbody = document.createElement("tbody");

	AddTableCaption(tbody,
		"<div style=\"display:inline;float:left\">&nbsp; Result&nbsp;</div>"+
		"<img class=\"imglink\" style=\"display:inline;float:right;margin-right:2px;\" OnClick=\"OnDelCheckPatternsResult()\" title=\"Close result\" src=\"/images/del.gif\">");

	AddTableCaption(tbody,
		"<div name=\"divCheckingResultTab\" " +
		"id=\"divCheckingResultTab\" ></div>");

	aTable.appendChild(tbody);

	//finally insert
	obj.appendChild(aTable);

}

function OnAddCheckPatternsMessage() {
	var obj = document.getElementById("CheckPatternsResultContainer");

	//table
	var aTable = document.createElement("table");
	aTable.id = "UniqueCheckPatternsMessage";
	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	aTable.className = "nb";
	aTable.setAttribute("style", "float:left;background:" + GetAltColor(0, 1, true));
	aTable.style.cssText = "float:left;background:" + GetAltColor(0, 1, true) +"; display:none; ";
	var tbody = document.createElement("tbody");

	AddTableCaption(tbody,
		"<div style=\"display:inline;float:left\">&nbsp; Save changes or refresh page before checking!&nbsp;</div>"+
		"<img class=\"imglink\" style=\"display:inline;float:right;margin-right:2px;\" OnClick=\"OnDelCheckPatternsMessage()\" title=\"Close message\" src=\"/images/del.gif\">");

	aTable.appendChild(tbody);

	//finally insert
	obj.appendChild(aTable);

}


function OnDelCheckPatternsResult() {
	var aObj = document.getElementById("UniqueCheckPatternsResult");
	if (aObj != null) {
		aObj.style.display = "none";
	}
}

function OnDelCheckPatternsMessage() {
	var aObj = document.getElementById("UniqueCheckPatternsMessage");
	if (aObj != null) {
		aObj.style.display = "none";
	}
}


function doCheckPattern() {
	
	var obj = document.getElementById("hidChangeEvent");
	if(obj.value == 1){
		OnDelCheckPatternsResult();
		var obj_message = document.getElementById("UniqueCheckPatternsMessage");
		obj_message.style.display = "";
		return;
	}
	
	var obj = document.getElementById("UniqueCheckPatternsResult");
	var obj_called = document.getElementById("edCheckPatterns_called");
	var obj_caller = document.getElementById("edCheckPatterns_caller");
	var obj_group = document.getElementById("edCheckPatterns_group");

	var called_val = obj_called.value;
	var caller_val = obj_caller.value;
	var group_val = obj_group.value;
	var result_val = '';
	
	doRouterEmit(called_val,caller_val,group_val,result_val);
	
	if (obj != null) {
		obj.style.display = "";
	}
}

function doChangeEvent(){
	var obj = document.getElementById("hidChangeEvent");
	obj.value = 1;
}

function doRouterEmit(called_val,caller_val,group_val,result_val){

	if(called_val == '') { called_val = '""'; }
	if(caller_val == '') { caller_val = '""'; }
	if(group_val == '') { group_val = '-1'; }

	var cmd = '/usr/local/sbin/router --emit --called '+called_val+' --caller '+caller_val+' --group '+group_val;
	
	var filter = '';
	var urlstr = 'process.cgi?request_name=execute_command&cmd='+encodeURIComponent(cmd)+'&filter='+encodeURIComponent(filter);

	var xhr = new XMLHttpRequest();
	xhr.open('GET', urlstr, true);
	xhr.send(null);
	xhr.onreadystatechange = function(){
	  if (xhr.readyState != 4) return;
	  if (xhr.status != 200){
	    alert(xhr.status + ': ' + xhr.statusText);
	  }else{ 
		//alert(xhr.responseText);
		result_val = xhr.responseText;
	  }
	  onCheckPattern(result_val);
	}

}

// parse checking patterns result
function onCheckPattern(result_val){
	//alert(result_val);
	var res = "";
	if(result_val.trim() == 'EMPTY') {
		res = "<table><tr><td>EMPTY</td></tr></table>";
		document.getElementById("divCheckingResultTab").innerHTML = res;
		return;
	}
	var resline = result_val.split('\n');
	resline.pop();
	var header_key = 0;
	var res = "<table style='border-collapse:collapse;margin:4px;' cellspacing='0' cellpadding='0'>";
	var rownum = 0;
	var hidreject = document.getElementById('edCheckPatterns_hide').checked;
	resline.forEach(function loop(item, i, arr) {
		if( (hidreject==true) && (loop.stop) ) return;
		if( item.search("Pattern") == 0 ) {
			//alert();		
			var patternline = item.split('>,');
			var pattern_called = (patternline[0].split('='))[1];
			var pattern_caller = (patternline[1].split('='))[1];
			var pattern_group = (patternline[2].split('='))[1];
			pattern_called = pattern_called.replace("<","").replace(">","");
			pattern_caller = pattern_caller.replace("<","").replace(">","");
			pattern_group = pattern_group.replace(")","");
			var pattern_num = searchPatternByValue(pattern_called,pattern_caller,pattern_group);
			res += "<tr><td colspan=7 onclick='goToPattern("+pattern_num+")' style='cursor:pointer;'>"+item+"</td></tr>";
			//alert(res);
			header_key = 1;
		}else{
			rownum +=1;
			var action = "";
			if( item.search("call") != -1 ) action = "call" ;
			if( item.search("reject") != -1 ) action = "<span style='color: red;'>reject</span>";

			item = item.trim();

			var pos1 = item.indexOf('[');
			var pos2 = item.indexOf(']');
			var paramline = item.substring(pos1+1,pos2).split(',');
			
			var p_name_0 = paramline[0].split('=');
			p_name_0[1] = p_name_0[1].trim().replace(/(^[<])|([>]$)/g,"");
			var p_name_1 = paramline[1].split('=');
			p_name_1[1] = p_name_1[1].trim().replace(/(^[<])|([>]$)/g,"");
			var p_name_2 = paramline[2].split('=');
			p_name_2[1] = p_name_2[1].trim().replace(/(^[<])|([>]$)/g,"");
			var p_name_3 = paramline[3].split('=');
			p_name_3[1] = p_name_3[1].trim().replace(/(^[<])|([>]$)/g,"");
			var p_name_4 = paramline[4].split('=');
			p_name_4[1] = p_name_4[1].trim().replace(/(^[<])|([>]$)/g,"");
			var p_name_5 = paramline[5].split('=');
			p_name_5[1] = p_name_5[1].trim().replace(/(^[<])|([>]$)/g,"");
			
			if(header_key == 1) {
				res += "<tr>";
				res += "<td class='tborder sec'>N</td>";
				res += "<td class='tborder sec'>name</td>";
				res += "<td class='tborder sec'>dial timeout</td>";
				res += "<td class='tborder sec'>answer timeout</td>";
				res += "<td class='tborder sec'>routing timeout</td>";
				res += "<td class='tborder sec'>called</td>";
				res += "<td class='tborder sec'>caller</td>";
				res += "<td class='tborder sec'>action</td>";
				res += "</tr>";
				header_key = 0;
			}

			var target_num = searchTargetByName(p_name_0[1]);
	
			if(target_num!=-1){
				res += "<tr onclick='goToTarget("+target_num+");' style='cursor:pointer'>";
				res += "<td class='tborder sec'>"+rownum+"</td>";
				res += "<td class='tborder sec'>"+p_name_0[1]+"</td>";
				res += "<td class='tborder sec'>"+p_name_1[1]+"</td>";
				res += "<td class='tborder sec'>"+p_name_2[1]+"</td>";
				res += "<td class='tborder sec'>"+p_name_3[1]+"</td>";
				res += "<td class='tborder sec'>"+p_name_4[1]+"</td>";
				res += "<td class='tborder sec'>"+p_name_5[1]+"</td>";
				res += "<td class='tborder sec'>"+action+"</td>";
				res += "</tr>";
			} else {
				var signalling_num = searchSignalingByName(p_name_0[1]);
				res += "<tr onclick='goToSignalling("+signalling_num+");' style='cursor:pointer'>";
				res += "<td class='tborder sec'>"+rownum+"</td>";
				res += "<td class='tborder sec'>"+p_name_0[1]+"</td>";
				res += "<td class='tborder sec'>"+p_name_1[1]+"</td>";
				res += "<td class='tborder sec'>"+p_name_2[1]+"</td>";
				res += "<td class='tborder sec'>"+p_name_3[1]+"</td>";
				res += "<td class='tborder sec'>"+p_name_4[1]+"</td>";
				res += "<td class='tborder sec'>"+p_name_5[1]+"</td>";
				res += "<td class='tborder sec'>"+action+"</td>";
				res += "</tr>";
			}
			
			
			searchSignalingByName(name)

		}
		//alert( i + ": " + item);
		
		if( item.search("reject") != -1 ) { loop.stop = true; } 
		
	});
	res += "</table>";
	//alert(res);
	document.getElementById("divCheckingResultTab").innerHTML = res;
	
}


/*
function onCheckBeforeSave(){
	
	var errmsg = '';
	var msg = [];
	var elems = document.querySelectorAll( 'input[itemtype="edSignallingTargetGroup"]' );
	for (var i = 0; i < elems.length; i++) {
		if(elems[i].value=='') msg.push(['Signalling targets','The group field must not be empty']);
	}
	
	var obj1 = document.querySelectorAll( 'input[itemtype="edConnection_cas_trunk_no"]' );
	var obj2 = document.querySelectorAll( 'input[itemtype="edConnection_cas_trunk_timeslot"]' );
	if(obj1.length>0){
		var errtype1 = 0;
		var errtype2 = 0;
		for (var i = 0; i <= obj1.length-1; i++) {
			for (var j = i+1; j < obj1.length; j++) {
				if( obj1[i].value==obj1[j].value && obj2[i].value==obj2[j].value && errtype1==0 ){
					msg.push(['Connections','Trunk number and timeslot duplication']);
					errtype1 = 1;
				}
			}
			if( (obj1[i].value=='' || obj2[i].value=='') && errtype2==0 ){
				msg.push(['Connections','Trunk number and timeslot must not be empty']);
				errtype2 = 1;
			}
		}
	}
	// message assembly
	for (var i = 0; i < msg.length; i++) {
		if(i>0 && msg[i][0]==msg[i-1][0]){
			errmsg += '- '+msg[i][1]+'\n';
		} else {
			errmsg += msg[i][0]+':\n- '+msg[i][1]+'\n';
		}
	}
		
	return errmsg;
	
}
*/

//---------------------------------------------------------------------------------------------------
//									           AK Targets
//---------------------------------------------------------------------------------------------------

// change block position (with slide)
function TargetAK_ChangePosition(idx1,idx2){
	var idx1 = parseInt(idx1);
	var idx2 = parseInt(idx2);
	
	var direction = idx1 > idx2 ? 'left' : 'right';
	var slide_offset = Math.abs(idx1 - idx2);
	
	// save current block
	var parr1 = [];
	parr1[0]=document.getElementById("edAKTargetName"+idx1).value;
	parr1[1]=document.getElementsByName("edAKTargetSlot"+idx1)[0].value;
	//parr1[2]=document.getElementById("edAKTargetChannel"+idx1).value;
	parr1[2]=document.getElementsByName("edAKTargetChannel"+idx1)[0].value;
	parr1[3]=document.getElementsByName("edAKTargetIncomeCallerId"+idx1)[0].value;
	parr1[4]=document.getElementsByName("edAKTargetOutcomeCallerId"+idx1)[0].value;
	parr1[5]=document.getElementsByName("edAKTargetCalled"+idx1)[0].value;
	var pcount = parr1.length;
	
	// slide blocks
	for (var i = 1; i <= slide_offset; i++) {
			
		if(direction=='left'){ var idx3 = idx1 - i; var idx4 = idx3 + 1; } // move left
		if(direction=='right'){ var idx3 = idx1 + i; var idx4 = idx3 - 1; } // move right
		var parr3 = [];
		parr3[0]=document.getElementById("edAKTargetName"+idx3);
		parr3[1]=document.getElementsByName("edAKTargetSlot"+idx3)[0];
		//parr3[2]=document.getElementById("edAKTargetChannel"+idx3);
		parr3[2]=document.getElementsByName("edAKTargetChannel"+idx3)[0];
		parr3[3]=document.getElementsByName("edAKTargetIncomeCallerId"+idx3)[0];
		parr3[4]=document.getElementsByName("edAKTargetOutcomeCallerId"+idx3)[0];
		parr3[5]=document.getElementsByName("edAKTargetCalled"+idx3)[0];

		var parr4 = [];
		parr4[0]=document.getElementById("edAKTargetName"+idx4);
		parr4[1]=document.getElementsByName("edAKTargetSlot"+idx4)[0];
		//parr4[2]=document.getElementById("edAKTargetChannel"+idx4);
		parr4[2]=document.getElementsByName("edAKTargetChannel"+idx4)[0];
		parr4[3]=document.getElementsByName("edAKTargetIncomeCallerId"+idx4)[0];
		parr4[4]=document.getElementsByName("edAKTargetOutcomeCallerId"+idx4)[0];
		parr4[5]=document.getElementsByName("edAKTargetCalled"+idx4)[0];

		for (var j = 0; j < pcount; j++) { parr4[j].value = parr3[j].value; }
	}
	// insert current block
	for (var j = 0; j < pcount; j++) { parr3[j].value = parr1[j]; }
	
	TargetAK_List();
	setTimeout(function(){},200);
	var tablock = document.getElementById("UniqueAKTarget"+idx2);
	tablock.onclick();
	document.getElementById("edAKTargetName"+idx2).focus();
}

// block list filling (for all block)
function TargetAK_List(){
	var hid = document.getElementById("hidAKTargetCount").value;
	var optionstr = "";
	for(var j = 1; j <= hid; j++){ optionstr = optionstr + "<option>"+j+"</option>"; }
	for(var i = 1; i <= hid; i++){
		var AKTarPos = document.getElementById("edAKTargetPosition"+i);
		AKTarPos.innerHTML = optionstr;
		AKTarPos.value = i;
	}
}	

// block rotation
function TargetAK_Rotation(direction,idx){
	var idx1 = idx;
	var idx2;
	if(direction=='left') idx2=eval(parseInt(idx1) - 1).toString(10);
	if(direction=='right') idx2=eval(parseInt(idx1) + 1).toString(10);
	TargetAK_ChangePosition(idx1,idx2);
}

// move block (set block order)
function TargetAK_Move(idx){
	var idx1 = idx;
	var idx2 = document.getElementById("edAKTargetPosition"+idx1).value;
	TargetAK_ChangePosition(idx1,idx2);
}

// delete block
function TargetAK_Delete(idx) {
	var hid = document.getElementById("hidAKTargetCount");
	if( idx < hid.value ) TargetAK_ChangePosition(parseInt(idx),parseInt(hid.value));
	//TargetAK_Active(idx);
	var tablock = document.getElementById("UniqueAKTarget"+idx);
	tablock.onclick();
	document.getElementById("edAKTargetName"+idx).focus();
	
	var aObj = document.getElementById("UniqueAKTarget"+hid.value);
	aObj.parentNode.removeChild(aObj);
	hid.value--;
	TargetAK_List();

	UpdateAKTargetControls();
	doSectionCountCheck('AKTargetsContainerHeader','AKTargetsContainer','AKTarget',0);
}

// stop event (clear onclick)
function doClearClick(event){
		event = event || window.event; 
		event.stopPropagation ? event.stopPropagation() : (event.cancelBubble=true);
}


//---------------------------------------------------------------------------------------------------
//									           Patterns
//---------------------------------------------------------------------------------------------------

// change block position (with slide)
function Pattern_ChangePosition(idx1,idx2){
	var idx1 = parseInt(idx1);
	var idx2 = parseInt(idx2);
	
	var direction = idx1 > idx2 ? 'left' : 'right';
	var slide_offset = Math.abs(idx1 - idx2);
	
	// save current block
	var parr1 = [];
	parr1[0]=document.getElementById("edPatternCalled"+idx1).value;
	parr1[1]=document.getElementById("edPatternCaller"+idx1).value;
	parr1[2]=document.getElementById("edPatternGroup"+idx1).value;
	parr1[3] = ""; // convert table to string - "pstn:1:0:2 reject:0:3:4 called:7:6:0"
	parr1[4]=document.getElementById("edPatternName"+idx1).value;
	var rowcount1 = document.getElementById("edPatternTargetTable"+idx1).rows.length;
	for(var i=2;i<rowcount1;i++){
		if( document.getElementById("pattern_type_"+idx1+"_"+i).value == 'native' ){
			parr1[3] = parr1[3]+
			document.getElementById("pattern_target_"+idx1+"_"+i).value+':';
		} else {
			parr1[3] = parr1[3]+
			document.getElementById("pattern_type_"+idx1+"_"+i).value+':';
		}
		parr1[3] = parr1[3]+
		document.getElementById("pattern_target_tr_"+idx1+"_"+i).value+':'+
		document.getElementById("pattern_target_ta_"+idx1+"_"+i).value+':'+
		document.getElementById("pattern_target_td_"+idx1+"_"+i).value+':'+' ';
	}
	var pcount = parr1.length;
	
	// slide blocks
	for (var i = 1; i <= slide_offset; i++) {
		if(direction=='left'){ var idx3 = idx1 - i; var idx4 = idx3 + 1; } // move left
		if(direction=='right'){ var idx3 = idx1 + i; var idx4 = idx3 - 1; } // move right
		var parr3 = [];
		parr3[0]=document.getElementById("edPatternCalled"+idx3);
		parr3[1]=document.getElementById("edPatternCaller"+idx3);
		parr3[2]=document.getElementById("edPatternGroup"+idx3);
		parr3[4]=document.getElementById("edPatternName"+idx3);
		parr3[3] = {};
		parr3[3].value = "";
		var rowcount3 = document.getElementById("edPatternTargetTable"+idx3).rows.length;
		for(var j=2;j<rowcount3;j++){
			if( document.getElementById("pattern_type_"+idx3+"_"+j).value == 'native' ){
				parr3[3].value = parr3[3].value+
				document.getElementById("pattern_target_"+idx3+"_"+j).value+':';
			} else {
				parr3[3].value = parr3[3].value+
				document.getElementById("pattern_type_"+idx3+"_"+j).value+':';
			}
			parr3[3].value = parr3[3].value+
			document.getElementById("pattern_target_tr_"+idx3+"_"+j).value+':'+
			document.getElementById("pattern_target_ta_"+idx3+"_"+j).value+':'+
			document.getElementById("pattern_target_td_"+idx3+"_"+j).value+':'+' ';
		}
		
		var parr4 = [];
		parr4[0]=document.getElementById("edPatternCalled"+idx4);
		parr4[1]=document.getElementById("edPatternCaller"+idx4);
		parr4[2]=document.getElementById("edPatternGroup"+idx4);
		parr4[4]=document.getElementById("edPatternName"+idx4);
		parr4[3] = {};
		parr4[3].value = "";
		var rowcount4 = document.getElementById("edPatternTargetTable"+idx4).rows.length;
		for(var j=2;j<rowcount4;j++){
			if( document.getElementById("pattern_type_"+idx4+"_"+j).value == 'native' ){
				parr4[3].value = parr4[3].value+
				document.getElementById("pattern_target_"+idx4+"_"+j).value+':';
			} else {
				parr4[3].value = parr4[3].value+
				document.getElementById("pattern_type_"+idx4+"_"+j).value+':';
			}
			parr4[3].value = parr4[3].value+
			document.getElementById("pattern_target_tr_"+idx4+"_"+j).value+':'+
			document.getElementById("pattern_target_ta_"+idx4+"_"+j).value+':'+
			document.getElementById("pattern_target_td_"+idx4+"_"+j).value+':'+' ';
		}

		for (var j = 0; j < pcount; j++) { parr4[j].value = parr3[j].value; }
		// target table row replace
		for(var n=2;n<rowcount4;n++){
			var obj = document.getElementById("pattern_target_"+idx4+"_"+n);
			obj.parentNode.parentNode.parentNode.removeChild(obj.parentNode.parentNode);
		}
		var patarr = parr4[3].value.split(' ');
		for(var n=0; n<patarr.length-1; n++){
			var tagarr = patarr[n].split(':');
			addPatterntargetRow(idx4,tagarr[0],tagarr[1],tagarr[2],tagarr[3]);
		}

		for(var n=2;n<rowcount3;n++){
			var obj = document.getElementById("pattern_target_"+idx3+"_"+n);
			obj.parentNode.parentNode.parentNode.removeChild(obj.parentNode.parentNode);
		}
	}

	// insert current block
	for (var j = 0; j < pcount; j++) { parr3[j].value = parr1[j]; }

	var patarr = parr3[3].value.split(' ');
	for(var n=0; n<patarr.length-1; n++){
		var tagarr = patarr[n].split(':');
		addPatterntargetRow(idx3,tagarr[0],tagarr[1],tagarr[2],tagarr[3]);
	}


	Pattern_List();
	setTimeout(function(){},200);
	var tablock = document.getElementById("UniquePattern"+idx2);
	tablock.onclick();
	document.getElementById("edPatternCalled"+idx2).focus();
}

// block list filling (for all block)
function Pattern_List(){
	var hid = document.getElementById("hidPatternCount").value;
	var optionstr = "";
	for(var j = 1; j <= hid; j++){ optionstr = optionstr + "<option>"+j+"</option>"; }
	for(var i = 1; i <= hid; i++){
		var BlockPos = document.getElementById("edPatternPosition"+i);
		BlockPos.innerHTML = optionstr;
		BlockPos.value = i;
	}
}	

// block rotation
function Pattern_Rotation(direction,idx){
	var idx1 = idx;
	var idx2;
	if(direction=='left') idx2=eval(parseInt(idx1) - 1).toString(10);
	if(direction=='right') idx2=eval(parseInt(idx1) + 1).toString(10);
	Pattern_ChangePosition(idx1,idx2);
}

// move block (set block order)
function Pattern_Move(idx){
	var idx1 = idx;
	var idx2 = document.getElementById("edPatternPosition"+idx1).value;
	Pattern_ChangePosition(idx1,idx2);
}

// delete block
function Pattern_Delete(idx) {
	var hid = document.getElementById("hidPatternCount");
	if( idx < hid.value ) Pattern_ChangePosition(parseInt(idx),parseInt(hid.value));

	var tablock = document.getElementById("UniquePattern"+idx);
	tablock.onclick();
	document.getElementById("edPatternCalled"+idx).focus();

	var aObj = document.getElementById("UniquePattern"+hid.value);
	aObj.parentNode.removeChild(aObj);
	hid.value--;
	Pattern_List();
	//UpdatePatternControls();
	doSectionCountCheck('PatternsContainerHeader','PatternsContainer','Pattern',0);
}


//---------------------------------------------------------------------------------------------------
//									           Signaling Targets
//---------------------------------------------------------------------------------------------------

// change block position (with slide)
function Signaling_ChangePosition(idx1,idx2){
	var idx1 = parseInt(idx1);
	var idx2 = parseInt(idx2);
	
	var direction = idx1 > idx2 ? 'left' : 'right';
	var slide_offset = Math.abs(idx1 - idx2);
	
	// save current block
	var parr1 = [];
	parr1[0]=document.getElementById("edSignallingTargetName"+idx1).value;
	parr1[1]=document.getElementById("edSignallingTargetCalled"+idx1).value;
	parr1[2]=document.getElementById("inexp_"+idx1).value;
	parr1[3]=document.getElementById("inexp_result_"+idx1).value;
	parr1[4]=document.getElementById("edSignallingTargetCaller"+idx1).value;
	parr1[5]=document.getElementById("caller_inexp_"+idx1).value;
	parr1[6]=document.getElementById("caller_inexp_result_"+idx1).value;
	parr1[7]=document.getElementById("SignallingTargetCodecSet"+idx1).innerHTML;
	parr1[8]=document.getElementById("edSignallingTargetCodecSet"+idx1).value;
	parr1[9]=document.getElementsByName("edSignallingTargetType"+idx1)[0].value;
	parr1[10]=document.getElementById("edSignallingTargetSS7_cg_category"+idx1).value;
	parr1[11]=document.getElementById("edSignallingTargetSS7_cg_nature"+idx1).value;
	parr1[12]=document.getElementById("edSignallingTargetSS7_cg_inetwork"+idx1).value;
	parr1[13]=document.getElementById("edSignallingTargetSS7_cg_plan"+idx1).value;
	parr1[14]=document.getElementById("edSignallingTargetSS7_cd_nature"+idx1).value;
	parr1[15]=document.getElementById("edSignallingTargetSS7_cd_plan"+idx1).value;
	parr1[16]=document.getElementById("edSignallingTargetISDN_cg_typeofnumber"+idx1).value;
	parr1[17]=document.getElementById("edSignallingTargetISDN_cg_plan"+idx1).value;
	parr1[18]=document.getElementById("edSignallingTargetISDN_cg_screeningind"+idx1).value;
	parr1[19]=document.getElementById("edSignallingTargetISDN_cd_typeofnumber"+idx1).value;
	parr1[20]=document.getElementById("edSignallingTargetISDN_cd_plan"+idx1).value;
	parr1[21]=document.getElementById("edSignallingTargetISDN_cd_screeningind"+idx1).value;
	parr1[21]=document.getElementsByName("edSignallingTargetGroup"+idx1)[0].value;
	var pcount = parr1.length;
	
	// slide blocks
	for (var i = 1; i <= slide_offset; i++) {
			
		if(direction=='left'){ var idx3 = idx1 - i; var idx4 = idx3 + 1; } // move left
		if(direction=='right'){ var idx3 = idx1 + i; var idx4 = idx3 - 1; } // move right
		var parr3 = [];
		parr3[0]=document.getElementById("edSignallingTargetName"+idx3);
		parr3[1]=document.getElementById("edSignallingTargetCalled"+idx3);
		parr3[2]=document.getElementById("inexp_"+idx3);
		parr3[3]=document.getElementById("inexp_result_"+idx3);
		parr3[4]=document.getElementById("edSignallingTargetCaller"+idx3);
		parr3[5]=document.getElementById("caller_inexp_"+idx3);
		parr3[6]=document.getElementById("caller_inexp_result_"+idx3);
		parr3[7]=document.getElementById("SignallingTargetCodecSet"+idx3);
		parr3[8]=document.getElementById("edSignallingTargetCodecSet"+idx3);
		parr3[9]=document.getElementsByName("edSignallingTargetType"+idx3)[0];
		parr3[10]=document.getElementById("edSignallingTargetSS7_cg_category"+idx3);
		parr3[11]=document.getElementById("edSignallingTargetSS7_cg_nature"+idx3);
		parr3[12]=document.getElementById("edSignallingTargetSS7_cg_inetwork"+idx3);
		parr3[13]=document.getElementById("edSignallingTargetSS7_cg_plan"+idx3);
		parr3[14]=document.getElementById("edSignallingTargetSS7_cd_nature"+idx3);
		parr3[15]=document.getElementById("edSignallingTargetSS7_cd_plan"+idx3);
		parr3[16]=document.getElementById("edSignallingTargetISDN_cg_typeofnumber"+idx3);
		parr3[17]=document.getElementById("edSignallingTargetISDN_cg_plan"+idx3);
		parr3[18]=document.getElementById("edSignallingTargetISDN_cg_screeningind"+idx3);
		parr3[19]=document.getElementById("edSignallingTargetISDN_cd_typeofnumber"+idx3);
		parr3[20]=document.getElementById("edSignallingTargetISDN_cd_plan"+idx3);
		parr3[21]=document.getElementById("edSignallingTargetISDN_cd_screeningind"+idx3);
		parr3[21]=document.getElementsByName("edSignallingTargetGroup"+idx3)[0];

		var parr4 = [];
		parr4[0]=document.getElementById("edSignallingTargetName"+idx4);
		parr4[1]=document.getElementById("edSignallingTargetCalled"+idx4);
		parr4[2]=document.getElementById("inexp_"+idx4);
		parr4[3]=document.getElementById("inexp_result_"+idx4);
		parr4[4]=document.getElementById("edSignallingTargetCaller"+idx4);
		parr4[5]=document.getElementById("caller_inexp_"+idx4);
		parr4[6]=document.getElementById("caller_inexp_result_"+idx4);
		parr4[7]=document.getElementById("SignallingTargetCodecSet"+idx4);
		parr4[8]=document.getElementById("edSignallingTargetCodecSet"+idx4);
		parr4[9]=document.getElementsByName("edSignallingTargetType"+idx4)[0];
		parr4[10]=document.getElementById("edSignallingTargetSS7_cg_category"+idx4);
		parr4[11]=document.getElementById("edSignallingTargetSS7_cg_nature"+idx4);
		parr4[12]=document.getElementById("edSignallingTargetSS7_cg_inetwork"+idx4);
		parr4[13]=document.getElementById("edSignallingTargetSS7_cg_plan"+idx4);
		parr4[14]=document.getElementById("edSignallingTargetSS7_cd_nature"+idx4);
		parr4[15]=document.getElementById("edSignallingTargetSS7_cd_plan"+idx4);
		parr4[16]=document.getElementById("edSignallingTargetISDN_cg_typeofnumber"+idx4);
		parr4[17]=document.getElementById("edSignallingTargetISDN_cg_plan"+idx4);
		parr4[18]=document.getElementById("edSignallingTargetISDN_cg_screeningind"+idx4);
		parr4[19]=document.getElementById("edSignallingTargetISDN_cd_typeofnumber"+idx4);
		parr4[20]=document.getElementById("edSignallingTargetISDN_cd_plan"+idx4);
		parr4[21]=document.getElementById("edSignallingTargetISDN_cd_screeningind"+idx4);
		parr4[21]=document.getElementsByName("edSignallingTargetGroup"+idx4)[0];

		for (var j = 0; j < pcount; j++) { parr4[j].value = parr3[j].value; }
		parr4[7].innerHTML = parr3[7].innerHTML;
		parr4[9].onchange();
	}
	// insert current block
	for (var j = 0; j < pcount; j++) { parr3[j].value = parr1[j]; }
	parr3[7].innerHTML = parr1[7];
	parr3[9].onchange();
	
	Signaling_List();
	setTimeout(function(){},200);
	var tablock = document.getElementById("UniqueSignallingTarget"+idx2);
	tablock.onclick();
	document.getElementById("edSignallingTargetName"+idx2).focus();
}

// block list filling (for all block)
function Signaling_List(){
	var hid = document.getElementById("hidSignallingTargetCount").value;
	var optionstr = "";
	for(var j = 1; j <= hid; j++){ optionstr = optionstr + "<option>"+j+"</option>"; }
	for(var i = 1; i <= hid; i++){
		var BlockPos = document.getElementById("edSignalingPosition"+i);
		BlockPos.innerHTML = optionstr;
		BlockPos.value = i;
	}
}	

// block rotation
function Signaling_Rotation(direction,idx){
	var idx1 = idx;
	var idx2;
	if(direction=='left') idx2=eval(parseInt(idx1) - 1).toString(10);
	if(direction=='right') idx2=eval(parseInt(idx1) + 1).toString(10);
	Signaling_ChangePosition(idx1,idx2);
}

// move block (set block order)
function Signaling_Move(idx){
	var idx1 = idx;
	var idx2 = document.getElementById("edSignalingPosition"+idx1).value;
	Signaling_ChangePosition(idx1,idx2);
}

// delete block
function Signaling_Delete(idx) {
	var hid = document.getElementById("hidSignallingTargetCount");
	if( idx < hid.value ) Signaling_ChangePosition(parseInt(idx),parseInt(hid.value));
	var tablock = document.getElementById("UniqueSignallingTarget"+idx);
	tablock.onclick();
	document.getElementById("edSignallingTargetName"+idx).focus();
	
	var aObj = document.getElementById("UniqueSignallingTarget"+hid.value);
	aObj.parentNode.removeChild(aObj);
	hid.value--;
	Signaling_List();

	UpdateSignallingTargetControls();
	doSectionCountCheck('SignallingTargetsContainerHeader','SignallingTargetsContainer','Signalling',0);
}

// return number of pattern by called and caller values
function searchPatternByValue(called,caller,group){
	if(group==-1) group="";
	var hid = document.getElementById("hidPatternCount").value;
	for(var i = 1; i <= hid; i++){
		var called_val = document.getElementById("edPatternCalled"+i).value;
		var caller_val = document.getElementById("edPatternCaller"+i).value;
		var group_val = document.getElementById("edPatternGroup"+i).value;
		if(called_val==called && caller_val==caller && group_val==group) return i;
	}
}

// set focus on pattern
function goToPattern(pattern_num){
	var tablock = document.getElementById("UniquePattern"+pattern_num);
	tablock.onclick();
	document.getElementById("edPatternCalled"+pattern_num).focus();
}

// return number of target by name
function searchTargetByName(name){
	var hid = document.getElementById("hidAKTargetCount").value;
	for(var i = 1; i <= hid; i++){
		var target_name = document.getElementById("edAKTargetName"+i).value;
		if(target_name==name) return i;
	}
	return -1;
}
// return number of signalling by name
function searchSignalingByName(name){
	var hid = document.getElementById("hidSignallingTargetCount").value;
	for(var i = 1; i <= hid; i++){
		var signalling_name = document.getElementById("edSignallingTargetName"+i).value;
		if(signalling_name==name) return i;
	}
	return -1;
}

// set focus on target
function goToTarget(target_num){
	var tablock = document.getElementById("UniqueAKTarget"+target_num);
	tablock.onclick();
	document.getElementById("edAKTargetName"+target_num).focus();
}
// set focus on signalling
function goToSignalling(signalling_num){
	var tablock = document.getElementById("UniqueSignallingTarget"+signalling_num);
	tablock.onclick();
	document.getElementById("edSignallingTargetName"+signalling_num).focus();
}
