var LineTestRequestStep = 2000;		// такт общения основного процесса с сервером
var TestState = 0;					// состояние теста
var StndState = 0;					// состояние установки эталона 
var AutoState = 0;					// состояние авто
var ServerDate = '';				// серверная дата
var ServerTime = '';				// серверное время (часы:минуты)
var ServerTimestamp = '';			// серверное время (часы:минуты:секунды)

$(document).ready( function () {
	
	//var spinner = $( "input[id=edAutoTestInterval]" ).spinner({min: 0, max: 200});

	//$( "#edAutoDate" ).datepicker({changeMonth: true, changeYear: true, showOtherMonths: true, selectOtherMonths: true});
	//$( "#edAutoDate" ).datepicker( "option", "dateFormat", "dd.mm.yy" );
	
	$(".24h").inputmask({
	alias: "datetime",
	inputFormat: "HH:MM dd/mm/yy"
	});
	
	line_test_request_start();


	$('input[id=edAutoTime').keyup(function(event) {
		if (event.keyCode === 13) {	
			$('input[id=btnSetAutoTime').click();
		}
	});
	$('input[id=edAutoStep').keyup(function(event) {
		if (event.keyCode === 13) {	
			$('input[id=btnSetAutoTime').click();
		}
	});

	//$( "#f_ACC_created_D1" ).datepicker({changeMonth: true, changeYear: true, showOtherMonths: true, selectOtherMonths: true});
	//$( "#f_ACC_created_D1" ).datepicker( "option", "dateFormat", "dd.mm.yy" );
	
});

// ------------------------------------------------------------------------------
//							основной процесс опроса сервера
// ------------------------------------------------------------------------------
function line_test_request_start(){
	var res = line_test_request();
	line_control_show(res);
	const LineTestRequestID = setInterval(() => {
		res = line_test_request();
		line_control_show(res);
	}, LineTestRequestStep);	
}
function line_test_show_detail(){
	var res = line_test_request();
	//line_control_show(res);
	//alert(res);
	var test_time = (res['last_timetest']).substring(0,4);
	test_time = test_time.substring(0,2)+':'+test_time.substring(2,4);
	var test_date = (res['last_timetest']).substring(4,10);
	test_date = test_date.substring(0,2)+'/'+test_date.substring(2,4)+'/'+test_date.substring(4,6);
	put2console(ServerTimestamp + ' ' + ServerDate + ' Тестирование выполнено: '+' '+test_time+' '+test_date);
	put2console(ServerTimestamp + ' ' + ServerDate + ' Тест. Линия 1: ' + res['line1_result']);
	put2console(ServerTimestamp + ' ' + ServerDate + ' Тест. Линия 2: ' + res['line2_result']);
}
// запрос данных из line_control.cfg, возвращает массив
function line_test_request(){
	var result = [];

	$.ajax({
		type: 'POST',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'line_test_request'
		}),
		dataType: 'text',
		async: !1,
		timeout: 1000,
		success: function(data) {
			//console.log(data);
			var arr = data.split(',');
			arr.forEach(function(elem, idx) {
				par = elem.split('=');
				result[par[0]] = par[1];
			});
			ServerDate = result['date'];
			ServerTime = result['time'];
			ServerTimestamp = result['timestamp'];
			document.getElementById('ed_ServerTime').innerHTML = 'Системное время: ' + ServerTime + ' ' + ServerDate;
		},
		error:function(){
		}
	});

	return result;
}


// ------------------------------------------------------------------------------
//									вывод информации
// ------------------------------------------------------------------------------

// вывод текста на информационную консоль
function put2console(str){
	var obj = document.getElementById('edInfoView');
	obj.value += '\n'+str;
	obj.scrollTop = obj.scrollHeight;
}

// вывод информации на страницу
function line_control_show(arr){
	
	// результат тестирования
	if(arr['line_test']==0){
		line_test_show_result(arr);
		if(TestState == 1){
			put2console(ServerTimestamp + ' ' + ServerDate + ' Тестирование выполнено');
			put2console(ServerTimestamp + ' ' + ServerDate + ' Тест. Линия 1: ' + arr['line1_result']);
			put2console(ServerTimestamp + ' ' + ServerDate + ' Тест. Линия 2: ' + arr['line2_result']);
			TestState = 0;
		}
	}
	// идет тестирование
	if(arr['line_test']==1){
		line_test_show_process();
		if(TestState == 0){
			put2console(ServerTimestamp + ' ' + ServerDate + ' Запуск тестирования и сравнение с эталоном...');
			TestState = 1;
		}
	}
	
	// результат установки эталона
	if(arr['stnd_test']==0){
		line_stnd_show_result(arr);
		if(StndState == 1){
			put2console(ServerTimestamp + ' ' + ServerDate + ' Эталон установлен');
			StndState = 0;
		}
	}
	// идет установка эталона
	if(arr['stnd_test']==1){
		line_stnd_show_process();
		if(StndState == 0){
			put2console(ServerTimestamp + ' ' + ServerDate + ' Установка эталонных значений...');
			StndState = 1;
		}
	}

	// выкл. авто
	if(arr['auto_test']==0){
		line_auto_off_show(arr);
		if(AutoState == 1){
			put2console(ServerTimestamp + ' ' + ServerDate + ' Авто ВЫКЛ.');
			AutoState = 0;
		}
	}
	// вкл. авто
	if(arr['auto_test']==1){
		line_auto_on_show(arr);
		if(AutoState == 0){
			put2console(ServerTimestamp + ' ' + ServerDate + '  Авто ВКЛ.');
			AutoState = 1;
		}
	}

	if( !$('#setAutoTimeForm').is(':visible') ){
		var time_auto = (arr['time_autotest']).substring(0,4);
		time_auto = time_auto.substring(0,2)+':'+time_auto.substring(2,4);
		var date_auto = (arr['time_autotest']).substring(4,10);
		date_auto = date_auto.substring(0,2)+'/'+date_auto.substring(2,4)+'/'+date_auto.substring(4,6);
		document.getElementById('edAutoTime').value = time_auto + ' ' + date_auto;
		document.getElementById('edAutoStep').value = arr['int_autotest'];
	}

}

// результат тестирования
function line_test_show_result(arr){
	var test_time = (arr['last_timetest']).substring(0,4);
	test_time = test_time.substring(0,2)+':'+test_time.substring(2,4);
	var test_date = (arr['last_timetest']).substring(4,10);
	test_date = test_date.substring(0,2)+'/'+test_date.substring(2,4)+'/'+test_date.substring(4,6);
	//put2console('Тестирование завершено'+' '+test_time+' '+test_date);
	document.getElementById('edTestTime').innerHTML = test_time;
	document.getElementById('edTestDate').innerHTML = test_date;
	
	var restag1 = '<span style="color:#ff0000">';
	if(arr['result1_test']=='НОРМА') restag1 = '<span style="color:#009000">';
	var restag2 = '<span style="color:#ff0000">';
	if(arr['result2_test']=='НОРМА') restag2 = '<span style="color:#009000">';
	
	document.getElementById('edTestResult').innerHTML = 'Линия 1: ' + restag1 + arr['result1_test'] + '</span><br>' + 'Линия 2: ' + restag2 + arr['result2_test'] + '</span>';
	document.getElementById('edTestMsg').innerHTML = 'Тестирование<br>выполнено';
}
// идет тестирование
function line_test_show_process(){
	document.getElementById('edTestTime').innerHTML = '';
	document.getElementById('edTestResult').innerHTML = '&nbsp;<br>&nbsp;';
	document.getElementById('edTestMsg').innerHTML = '&nbsp;<br>&nbsp;';
	var obj = document.getElementById('edTestDate');
	obj.innerHTML = '<img src="/images/wait.gif" style="width:32px;height:32px;">'
}
// результат установки эталона
function line_stnd_show_result(arr){
	var sample_time = (arr['stnd_timetest']).substring(0,4);
	sample_time = sample_time.substring(0,2)+':'+sample_time.substring(2,4);
	var sample_date = (arr['stnd_timetest']).substring(4,10);
	sample_date = sample_date.substring(0,2)+'/'+sample_date.substring(2,4)+'/'+sample_date.substring(4,6);
	//put2console('Эталон установлен'+' '+sample_time+' '+sample_date);
	document.getElementById('edTestSampleTime').innerHTML = sample_time;
	document.getElementById('edTestSampleDate').innerHTML = sample_date;
	document.getElementById('edTestSampleMsg').innerHTML = 'Эталон<br>установлен';
}
// идет установка эталона
function line_stnd_show_process(){
	document.getElementById('edTestSampleTime').innerHTML = '';
	document.getElementById('edTestSampleMsg').innerHTML = '';
	var obj = document.getElementById('edTestSampleDate');
	obj.innerHTML = '<img src="/images/wait.gif" style="width:32px;height:32px;">'
}

// авто включено
function line_auto_on_show(arr){
	document.getElementById('edAutoTestOn').innerHTML = 'ВКЛЮЧЕНО';
	var time_autotest = (arr['time_autotest']).substring(0,4);
	time_autotest = time_autotest.substring(0,2)+':'+time_autotest.substring(2,4);
	var test_date = (arr['time_autotest']).substring(4,10);
	test_date = test_date.substring(0,2)+'/'+test_date.substring(2,4)+'/'+test_date.substring(4,6);
	document.getElementById('edAutoTestStart').innerHTML = time_autotest + '<br>' + test_date;
	document.getElementById('edAutoTestStart').style.color = '#009000';
}
// авто выключено
function line_auto_off_show(arr){
	document.getElementById('edAutoTestOn').innerHTML = '<div style="color:#aaa">ВЫКЛЮЧЕНО</div>';
	//document.getElementById('edAutoTestStart').innerHTML = '&nbsp;<br>&nbsp;';

	var time_autotest = (arr['time_autotest']).substring(0,4);
	time_autotest = time_autotest.substring(0,2)+':'+time_autotest.substring(2,4);
	var test_date = (arr['time_autotest']).substring(4,10);
	test_date = test_date.substring(0,2)+'/'+test_date.substring(2,4)+'/'+test_date.substring(4,6);
	document.getElementById('edAutoTestStart').innerHTML = time_autotest + '<br>' + test_date;
	document.getElementById('edAutoTestStart').style.color = '#aaa';
	//document.getElementById('edAutoTestStart').setAttribute('color','#aaa');
}




// ------------------------------------------------------------------------------
//								сообщения серверу
// ------------------------------------------------------------------------------

function doTestStart(){
	//if(TestState != 1) do_new_test_file(); 
	do_new_test_file(); // 17.10.25 было указание - создавать файл new_test вне зависимости от запущенности процесса
}

function doStndStart(){
	if(StndState != 1) do_new_stnd_file();
}

function doAutoStart(){
	do_new_auto_file();
}

function doAutoSetup(){
	openAutoTimeForm();
}

// создание файла активации теста (для arm-terminal)
function do_new_test_file(){
	var result = false;

	$.ajax({
		type: 'GET',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'do_new_test_file'
		}),
		dataType: 'text',
		async: 0,
		timeout: 1000,
		success: function(data) {
			result = data;
		},
		error:function(){
			alert('error: do_new_test_file');
		}
	});
	
	return result;
}
// создание файла активации установки эталона (для arm-terminal)
function do_new_stnd_file(){
	var result = false;

	$.ajax({
		type: 'GET',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'do_new_stnd_file'
		}),
		dataType: 'text',
		async: 0,
		timeout: 1000,
		success: function(data) {
			result = data;
		},
		error:function(){
			alert('error: do_new_stnd_file');
		}
	});
	
	return result;
}
// создание файла активации авто (для arm-terminal)
function do_new_auto_file(){
	var result = false;

	$.ajax({
		type: 'GET',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'do_new_auto_file'
		}),
		dataType: 'text',
		async: 0,
		timeout: 1000,
		success: function(data) {
			result = data;
		},
		error:function(){
			alert('error: do_new_auto_file');
		}
	});
	
	return result;
}









	/*var time_autotest = (arr['time_autotest']).substring(0,4);
	time_autotest = time_autotest.substring(0,2)+':'+time_autotest.substring(2,4);
	document.getElementById('edAutoTestTime').value = time_autotest;

	if(arr['auto_test']==1) {
		document.getElementById('edAutoTestOn').innerHTML = 'ВКЛЮЧЕНО';
		var time_autotest = (arr['time_autotest']).substring(0,4);
		time_autotest = time_autotest.substring(0,2)+':'+time_autotest.substring(2,4);
		var test_date = (arr['time_autotest']).substring(4,10);
		test_date = test_date.substring(0,2)+'/'+test_date.substring(2,4)+'/'+test_date.substring(4,6);
		//'Тестирование завершено'+' '+test_time+' '+test_date
		document.getElementById('edAutoTestStart').innerHTML = test_date;
	} else {
		document.getElementById('edAutoTestOn').innerHTML = '';
		document.getElementById('edAutoTestStart').innerHTML = '';
	}*/
	




/*
function get_servertime() {
	var result = [];

	$.ajax({
		type: 'POST',
		url: '/cgi-bin/getservertime.cgi',
		dataType: 'text',
		async: !1,
		timeout: 1000,
		success: function(data) {
			//console.log(data);
			result = data;
		},
		error:function(){
			//alert('error: get_servertime');
			result = '';
		}
	});

	return result;
}






var isRunning_TestTimer = true;
function doLineTestStart(){
	addStrToTextArea('edInfoView','Запуск тестирования и сравнение с эталоном...');
	do_new_test_file();
	const TestTimerID = setInterval(() => {
    if (isRunning_TestTimer) {
		do_line_test();
		//do_new_test_file();
		progress_last_timetest();
    } else {
        clearInterval(TestTimerID);
        console.log('Test Timer stopped');
		isRunning_TestTimer = true;
		do_line_test_empty();
		get_last_timetest(1);
    }
	}, 2000);
}
function do_line_test() {
	var result = [];

	$.ajax({
		type: 'POST',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'do_line_test'
		}),
		dataType: 'text',
		async: !1,
		timeout: 1000,
		success: function(data) {
			console.log(data);
			if(data){
				var res = [];
				var arr = data.split(',');
				arr.forEach(function(elem, idx) {
					//console.log(elem, idx);
					em = elem.split('=');
					res[em[0]] = em[1];
					result[em[0]] = em[1];
				});
				console.log(res);
				if(res['line_test']==1){
					isRunning_TestTimer = false;
				}
			}
		},
		error:function(){
			alert('error: do_line_test');
		}
	});

	return result;
}

function do_line_test_empty() {
	$.ajax({
		type: 'POST',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'do_line_test_empty'
		}),
		dataType: 'text',
		async: !1,
		timeout: 1000,
		success: function(data) {
		},
		error:function(){
			alert('error: do_line_test_empty');
		}
	});
}

function get_last_timetest(info_mode){
	var res = [];
	res = do_line_control_conf_read();
	var test_time = (res['last_timetest']).substring(0,4);
	test_time = test_time.substring(0,2)+':'+test_time.substring(2,4);
	var test_date = (res['last_timetest']).substring(4,10);
	test_date = test_date.substring(0,2)+'/'+test_date.substring(2,4)+'/'+test_date.substring(4,6);
	if(info_mode==1) addStrToTextArea('edInfoView','Тестирование завершено'+' '+test_time+' '+test_date);
	document.getElementById('edTestTime').innerHTML = test_time;
	document.getElementById('edTestDate').innerHTML = test_date;
	
	var restag1 = '<span style="color:#ff0000">';
	if(res['result1_test']=='НОРМА') restag1 = '<span style="color:#009000">';
	var restag2 = '<span style="color:#ff0000">';
	if(res['result2_test']=='НОРМА') restag2 = '<span style="color:#009000">';
	
	document.getElementById('edTestResult').innerHTML = 'Линия 1: ' + restag1 + res['result1_test'] + '</span><br>' + 'Линия 2: ' + restag2 + res['result2_test'] + '</span>';

	var time_autotest = (res['time_autotest']).substring(0,4);
	time_autotest = time_autotest.substring(0,2)+':'+time_autotest.substring(2,4);
	document.getElementById('edAutoTestTime').value = time_autotest;

	if(res['auto_test']==1) {
		document.getElementById('edAutoTestOn').innerHTML = 'ВКЛЮЧЕНО';
		var time_autotest = (res['time_autotest']).substring(0,4);
		time_autotest = time_autotest.substring(0,2)+':'+time_autotest.substring(2,4);
		var test_date = (res['time_autotest']).substring(4,10);
		test_date = test_date.substring(0,2)+'/'+test_date.substring(2,4)+'/'+test_date.substring(4,6);
		//'Тестирование завершено'+' '+test_time+' '+test_date
		document.getElementById('edAutoTestStart').innerHTML = test_date;
	} else {
		document.getElementById('edAutoTestOn').innerHTML = '';
		document.getElementById('edAutoTestStart').innerHTML = '';
	}
	
	document.getElementById('edTestMsg').innerHTML = 'Тестирование<br>выполнено';
}

function progress_last_timetest(){
	document.getElementById('edTestTime').innerHTML = '';
	document.getElementById('edTestResult').innerHTML = '';
	document.getElementById('edTestMsg').innerHTML = '';
	var obj = document.getElementById('edTestDate');
	//if(obj.innerHTML.length==8) obj.innerHTML = '.';
	//else obj.innerHTML +='.';
	obj.innerHTML = '<img src="/images/wait.gif" style="width:32px;height:32px;">'
}




var isRunning_SampleTimer = true;
function doLineTestSample(){
	addStrToTextArea('edInfoView','Установка эталонных значений...');
	//const SampleTimerID = setInterval(do_line_control_conf_read, 2000);
	do_new_stnd_file();
	const SampleTimerID = setInterval(() => {
    if (isRunning_SampleTimer) {
		do_line_control_conf_read();
		//do_new_stnd_file();
		progress_stnd_time();
    } else {
        clearInterval(SampleTimerID);
        console.log('Sample Timer stopped');
		isRunning_SampleTimer = true;
		//addStrToTextArea('edInfoView','Эталон установлен');
		do_line_control_stnd_test_empty();
		get_line_control_stnd_time(1);
    }
	}, 2000);
}
function do_line_control_conf_read() {
	var result = [];

	$.ajax({
		type: 'POST',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'do_line_control_conf_read'
		}),
		dataType: 'text',
		async: !1,
		timeout: 1000,
		success: function(data) {
			console.log(data);
			if(data){
				var res = [];
				var arr = data.split(',');
				arr.forEach(function(elem, idx) {
					//console.log(elem, idx);
					em = elem.split('=');
					res[em[0]] = em[1];
					result[em[0]] = em[1];
				});
				console.log(res);
				if(res['stnd_test']==1){
					isRunning_SampleTimer = false;
				}
			}
		},
		error:function(){
			alert('error: do_line_control_conf_read');
		}
	});

	return result;
}

function addStrToTextArea(areaid,str){
	var obj = document.getElementById(areaid);
	obj.value += '\n'+str;
}

function do_line_control_stnd_test_empty() {
	$.ajax({
		type: 'POST',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'do_line_control_stnd_test_empty'
		}),
		dataType: 'text',
		async: !1,
		timeout: 1000,
		success: function(data) {
		},
		error:function(){
			alert('error: do_line_control_stnd_test_empty');
		}
	});
}

function get_line_control_stnd_time(info_mode){
	var res = [];
	res = do_line_control_conf_read();
	var sample_time = (res['stnd_timetest']).substring(0,4);
	sample_time = sample_time.substring(0,2)+':'+sample_time.substring(2,4);
	var sample_date = (res['stnd_timetest']).substring(4,10);
	sample_date = sample_date.substring(0,2)+'/'+sample_date.substring(2,4)+'/'+sample_date.substring(4,6);
	if(info_mode==1) addStrToTextArea('edInfoView','Эталон установлен'+' '+sample_time+' '+sample_date);
	document.getElementById('edTestSampleTime').innerHTML = sample_time;
	document.getElementById('edTestSampleDate').innerHTML = sample_date;
	document.getElementById('edTestSampleMsg').innerHTML = 'Эталон<br>установлен';
}

function progress_stnd_time(){
	document.getElementById('edTestSampleTime').innerHTML = '';
	document.getElementById('edTestSampleMsg').innerHTML = '';
	var obj = document.getElementById('edTestSampleDate');
	//if(obj.innerHTML.length==8) obj.innerHTML = '.';
	//else obj.innerHTML +='.';
	obj.innerHTML = '<img src="/images/wait.gif" style="width:32px;height:32px;">'
}





var isRunning_TestAuto = true;
function doLineTestAuto(){
	var lconf = [];
	lconf = do_line_control_conf_read();
	var auto_test = lconf['auto_test'];
	do_new_auto_file();

	const AutoTimerID = setInterval(() => {
    if (isRunning_TestAuto) {
		lconf = do_line_control_conf_read();
		var current_auto_test = lconf['auto_test'];
		// авто-тест включен
		if(auto_test == 0 && current_auto_test == 1){
			isRunning_TestAuto = false;
			console.log('Auto ON');
			document.getElementById('edAutoTestOn').innerHTML = 'ВКЛЮЧЕНО';
			var time_autotest = (lconf['time_autotest']).substring(0,4);
			time_autotest = time_autotest.substring(0,2)+':'+time_autotest.substring(2,4);
			var test_date = (lconf['time_autotest']).substring(4,10);
			test_date = test_date.substring(0,2)+'/'+test_date.substring(2,4)+'/'+test_date.substring(4,6);
			document.getElementById('edAutoTestStart').innerHTML = time_autotest + ' ' + test_date;
		}
		// авто-тест выключен
		if(auto_test == 1 && current_auto_test == 0){
			isRunning_TestAuto = false;
			console.log('Auto OFF');
			document.getElementById('edAutoTestOn').innerHTML = '';
			document.getElementById('edAutoTestStart').innerHTML = '';
		}
    } else {
        clearInterval(AutoTimerID);
		isRunning_TestAuto = true;
    }
	}, 2000);

}
*/



// ------------------------------------------------------------------------------
//								Редактирование параметров
// ------------------------------------------------------------------------------

function openAutoTimeForm(){
	$('#setAutoTimeForm').arcticmodal();
	$('input[id=edAutoTime]').focus();
}

function setAutoTime(){
	var time_autotest = document.getElementById('edAutoTime').value;
	var int_autotest = document.getElementById('edAutoStep').value;
	if(int_autotest < 1) {alert('Интервал должен быть больше нуля!');return;}
	time_autotest = time_autotest.replace(':','').replace(' ','').replace(/\//g,'');
	set_auto_time(time_autotest,int_autotest);
	$('#setAutoTimeForm').arcticmodal('close');
}

function set_auto_time(time_autotest,int_autotest){
	var result = [];
	
	$.ajax({
		type: 'POST',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'set_auto_time',
			time_autotest: time_autotest,
			int_autotest: int_autotest
		}),
		dataType: 'text',
		async: !1,
		timeout: 1000,
		success: function(data) {
		},
		error:function(){
			alert('error: set_auto_time');
		}
	});

	return result;
}
