<?php
require_once(dirname(__FILE__).'/conf_types.inc');
define("CODECCONFFILE", '/usr/local/etc/codecs.cfg');


//-------------------------------------------------------------------------------------------- 

class Codec_conf extends CustomSection {
	//public $uid  = "";
	public $codec_func = "";
	public $codec_name  = "";
	public $codec_status  = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				//. "uid=" . $this->uid . "\n"
				. "codec_func=" . $this->codec_func . "\n"
				. "codec_name=" . $this->codec_name . "\n"
				. "codec_status=" . $this->codec_status . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				//if ($sName === "uid")
				//	$this->uid = $sValue;
				if ($sName === "codec_func")
					$this->codec_func = $sValue;
				elseif ($sName === "codec_name")
					$this->codec_name = $sValue;
				elseif ($sName === "codec_status")
					$this->codec_status = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Codec_confs  {
	public $arrCodecConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Codec_conf();
		$this->arrCodecConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrCodecConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrCodecConfs[$i++]) {
			$sRes = $sRes . "[codec]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrCodecConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

//-------------------------------------------------------------------------------------------- 

# ######################################
class CodecConfFile extends CustomConfFile {
	public $codecconf;
	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->codecconf = new Codec_confs();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "codec")
				$this->codecconf->AddAsSection($sSectionValues);
			//elseif ($sSectionName === "snmp")
			//	$this->snmpconf->AddAsSection($sSectionValues);
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for common.conf\n");

		$this->PutLine($this->codecconf->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};

		$this->copyBufferToConf();
	}
	
};


?>
