<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("COMMONCONFFILE", '/usr/local/etc/common.cfg');
define("HOSTNAME", '/etc/hostname');

class Common_conf extends CustomSection {
	public $keycount  = "";
	public $keyplus = "";
	public $ntp = "";
	public $ntpserver1 = "";
	public $ntpserver2 = "";
	
	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "ntp=" . $this->ntp . "\n"
				. "ntpserver1=" . $this->ntpserver1 . "\n"
				. "ntpserver2=" . $this->ntpserver2 . "\n"
				. "keycount=" . $this->keycount . "\n"
				. "keyplus=" . $this->keyplus . "\n"
				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "keycount")
					$this->keycount = $sValue;
				elseif ($sName === "keyplus")
					$this->keyplus = $sValue;
				elseif ($sName === "ntp")
					$this->ntp = $sValue;
				elseif ($sName === "ntpserver1")
					$this->ntpserver1 = $sValue;
				elseif ($sName === "ntpserver2")
					$this->ntpserver2 = $sValue;
				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Common_confs {
	public $arrCommonConfs = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Common_conf();
		$this->arrCommonConfs[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrCommonConfs[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrCommonConfs[$i++]) {
			$sRes = $sRes . "[common]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrCommonConfs))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

# ######################################
class CommonConfFile extends CustomConfFile {
	public $comconf;
	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->comconf = new Common_confs();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "common")
				$this->comconf->AddAsSection($sSectionValues);
			//elseif ($sSectionName === "user")
			//	$this->user->AddAsSection($sSectionValues);
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	function FixToFile() {
		
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		//$this->PutLine($this->ctrl->GetAsSections());
		$this->PutLine($this->comconf->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}
};
# ######################################
?>
