<?php
require_once(dirname(__FILE__).'/conf_types.inc');

define("LINECONFFILE", '/usr/local/etc/line_control.cfg');

class Line_list extends CustomSection {
	public $last_timetest = "";

	public $result1_test = "";
	public $result2_test = "";
	public $line1_result = "";
	public $line2_result = "";

	public $stnd_timetest = "";
	public $line1_stnd = "";
	public $line2_stnd = "";

	public $int_autotest = "";
	public $time_autotest = "";

	public $stnd_test = "";
	public $line_test  = "";
	public $auto_test  = "";
	

	public function GetAsFullCfgString() {
		$sRes = parent::GetCommentLines()
				. "last_timetest=" . $this->last_timetest . "\n"
				. "result1_test=" . $this->result1_test . "\n"
				. "result2_test=" . $this->result2_test . "\n"
				. "line1_result=" . $this->line1_result . "\n"
				. "line2_result=" . $this->line2_result . "\n"
				. "stnd_timetest=" . $this->stnd_timetest . "\n"
				. "line1_stnd=" . $this->line1_stnd . "\n"
				. "line2_stnd=" . $this->line2_stnd . "\n"
				. "int_autotest=" . $this->int_autotest . "\n"
				. "time_autotest=" . $this->time_autotest . "\n"
				. "stnd_test=" . $this->stnd_test . "\n"
				. "line_test=" . $this->line_test . "\n"
				. "auto_test=" . $this->auto_test . "\n"

				. parent::GetUnknownLines();
		return $sRes;
	}

	public function PutParam($sParamLine) {
		$iFormat = 0;
		$sName = "";
		$sValue = "";
		parent::CheckValue($sParamLine, $iFormat, $sName, $sValue);
		switch ($iFormat) {
			case 1:
				if ($sName === "last_timetest")
					$this->last_timetest = $sValue;
				elseif ($sName === "result1_test")
					$this->result1_test = $sValue;
				elseif ($sName === "result2_test")
					$this->result2_test = $sValue;
				elseif ($sName === "line1_result")
					$this->line1_result = $sValue;
				elseif ($sName === "line2_result")
					$this->line2_result = $sValue;
				elseif ($sName === "stnd_timetest")
					$this->stnd_timetest = $sValue;
				elseif ($sName === "line1_stnd")
					$this->line1_stnd = $sValue;
				elseif ($sName === "line2_stnd")
					$this->line2_stnd = $sValue;
				elseif ($sName === "int_autotest")
					$this->int_autotest = $sValue;
				elseif ($sName === "time_autotest")
					$this->time_autotest = $sValue;
				elseif ($sName === "stnd_test")
					$this->stnd_test = $sValue;
				elseif ($sName === "line_test")
					$this->line_test = $sValue;
				elseif ($sName === "auto_test")
					$this->auto_test = $sValue;

				else
					parent::AddUnknownLine($sParamLine);
				break;
			case 2:
				parent::AddCommentLine($sParamLine);
				break;
		};
	}
};

class Line_lists {
	public $arrLineLists = array();

	public function AddAsSection($sSection) {
		$tmpARR = explode("\n", trim($sSection));
		reset($tmpARR);
		$sTMP = current($tmpARR);
		$obj = new Line_list();
		$this->arrLineLists[] = $obj;
		$i = 0;
		while ($i++ < count($tmpARR)) {
			$obj->PutParam($sTMP);
			$sTMP = next($tmpARR);
		};
		return $obj;
	}

	public function GetByIndex($iIndex) {
		return $this->arrLineLists[(int)$iIndex];
	}

	public function GetAsSections() {
		$sRes = "";
		$i = 0;
		while ($obj = $this->arrLineLists[$i++]) {
			$sRes = $sRes . "[linetest]\n" . $obj->GetAsFullCfgString();
			if ($i < count($this->arrLineLists))
				$sRes = $sRes . "\n";
		};
		return $sRes;
	}
};

# ######################################
class LineConfFile extends CustomConfFile {
	public $linelist;
	public $unknownparams;

	public function __construct($aFileName) {
		parent::__construct($aFileName);
		$this->linelist = new Line_lists();
		$this->unknownparams = array();
		$this->DoReadSections();
	}

	function SaveUnknownSettings($sSectionName, $sSectionValues) {
		$this->unknownparams[] = "[" . $sSectionName . "]\n" . trim($sSectionValues);
	}

	function DoReadNextSection(&$sSectionName, &$sSectionValues) {
		$bInSection = false;
		$sSectionValues = "";
		$sSectionValue = "";
		$iPart = 0;
		$iPosAfter = 0;
		while (parent::getNextStr($sSectionName, $iPart, $iPosAfter)) {
			if ($iPart === 0) {
				$bInSection = true;
				break;
			};
		};
		if ($bInSection) {
			$iPosAfterBK = 0;
			while (parent::getNextStr($sSectionValue, $iPart, $iPosAfter)) {
				if ($iPart === 0) {
					if ($iPosAfter !== 0) {
						parent::SetAtPos($iPosAfterBK);
					};
					break;
				} else {
					$sSectionValues = $sSectionValues . "\n" . $sSectionValue;
					$iPosAfterBK = $iPosAfter;
				};
			};
		};
		return $bInSection;
	}

	function DoReadSections() {
		$sSectionName = "";
		$sSectionValues = "";

		parent::SetAtFirst();
		while ($this->DoReadNextSection($sSectionName, $sSectionValues)) {
			if ($sSectionName === "linetest")
				$this->linelist->AddAsSection($sSectionValues);
			//elseif ($sSectionName === "action")
			//	$this->key_action->AddAsSection($sSectionValues);
			else
				$this->SaveUnknownSettings($sSectionName, $sSectionValues);
		};
	}

	function FixToFile() {
		$this->Clear();
		//$this->PutIgnoreLine("Generated by Web Administration Processor for router.conf\n");

		//$this->PutLine($this->ctrl->GetAsSections());
		$this->PutLine($this->linelist->GetAsSections());

		if (count($this->unknownparams) > 0) {
			$this->PutIgnoreLine("Unknown parameters:\n");
			for ($i = 0;$i < count($this->unknownparams);$i++) {
				$this->PutLine($this->unknownparams[$i] . "\n");
			};
		};
	}
};
# ######################################
?>
