var DeviceGroup = null;				// тип устройства
var DeviceInfo = [];				// информация об устройстве
var LineTestRequestStep = 2000;		// такт общения основного процесса с сервером
var ServerDate = '';				// серверная дата
var ServerTime = '';				// серверное время (часы:минуты)
var ServerTimestamp = '';			// серверное время (часы:минуты:секунды)

$(document).ready( function () {
	
	line_test_request_start();

});
















function OnAddUACSubscriberRow(ch_id, reg_uid, reg_id, reg_ip, reg_presence, reg_timeout, memkey){
	
	var tab = document.getElementById('hidUACSubscriberTable');
    var rid = tab.rows.length - 1; //console.log(rid);

	if(!reg_presence) reg_presence = '';
	if(!reg_timeout) reg_timeout = '';

	tr = document.createElement("tr");
	tr.setAttribute('item_type','UACSubscriberRow'+ch_id);
	if(memkey!=1) tr.style.display = "none";

	td = document.createElement("td");
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACSubscriber_subs"+rid+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACSubscriber_subs"+rid+"\" " +
		"type=\"text\" value=\"\" disabled>";
	tr.appendChild(td);

	td = document.createElement("td");
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACSubscriber_pres"+rid+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACSubscriber_pres"+rid+"\" " +
		"type=\"text\" value=\""+reg_presence+"\" >";
	tr.appendChild(td);

	td = document.createElement("td");
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACSubscriber_time"+rid+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACSubscriber_time"+rid+"\" " +
		"type=\"text\" value=\""+reg_timeout+"\" >";
	tr.appendChild(td);

	td = document.createElement("td");
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACSubscriber_id"+rid+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACSubscriber_id"+rid+"\" " +
		"type=\"text\" value=\""+reg_id+"\" >";
	tr.appendChild(td);

	td = document.createElement("td");
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACSubscriber_ip"+rid+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACSubscriber_ip"+rid+"\" " +
		"type=\"text\" value=\""+reg_ip+"\" >";
	tr.appendChild(td);

	var td = document.createElement("td");
	td.hidden = true;
	if(memkey == 1) chkey = "checked"; else chkey = "";
	td.innerHTML =
		"<input type=\"checkbox\" class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACSubscriber_check"+rid+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACSubscriber_check"+rid+"\" " +

		"value=\""+memkey+"\" " +
		"onchange=\"onUACSubscriberCheck(this,"+ch_id+","+rid+");\"" +
		chkey+
		"/>";
	tr.appendChild(td);

	td = document.createElement("td");
	td.hidden = true;
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACSubscriber_uid"+rid+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACSubscriber_uid"+rid+"\" " +
		"type=\"text\" value=\""+reg_uid+"\" >";
	tr.appendChild(td);

	
	tab.appendChild(tr);
	
	if(memkey==1) onUACSubscriberNumberRefresh(ch_id);

}

function onUACSubscriberCheck(obj,ch_id,rid){
	if(obj.checked){
		$('input[id=ed_ch_'+ch_id+'_UACSubscriber_pres'+rid+']').val('presence');
		$('input[id=ed_ch_'+ch_id+'_UACSubscriber_time'+rid+']').val('3600');
	} else {
		$('input[id=ed_ch_'+ch_id+'_UACSubscriber_pres'+rid+']').val('');
		$('input[id=ed_ch_'+ch_id+'_UACSubscriber_time'+rid+']').val('');
	}
	onUACSubscriberNumberRefresh(ch_id);
	
}
// перенумерация подписок
function onUACSubscriberNumberRefresh(ch_id){
	var tab = document.getElementById('hidUACSubscriberTable');
    var rowcount = tab.rows.length-1;
	var subsnum = 0;
	for(var i=0; i<rowcount; i++){
		//if( $('input[id=ed_ch_'+ch_id+'_UACSubscriber_check'+i+']')[0].checked ){
			//alert('ed_ch_'+ch_id+'_UACSubscriber_check'+i);
		var check_obj = document.getElementById('ed_ch_'+ch_id+'_UACSubscriber_check'+i);
		//checkImage_ed_ch_4_UACSubscriber_check6
		//ed_ch_4_UACSubscriber_check0
		if( check_obj.checked ){
			$('input[id=ed_ch_'+ch_id+'_UACSubscriber_subs'+i+']').val('UACSubscriber'+subsnum);
			subsnum++;
		} else {
			$('input[id=ed_ch_'+ch_id+'_UACSubscriber_subs'+i+']').val('');
		}
	}
	document.getElementById('ed_ch_sip_'+ch_id+'_UACSubscriberCount').value = subsnum++;
}

// hide-show inactive subscribers
function toggleUACSubscriber(obj,ch_id){
	
	if(obj.getAttribute('mode')==0) obj.setAttribute('mode',1); else obj.setAttribute('mode',0);
	if(obj.getAttribute('mode')==1) document.getElementById('btnUACSubscriberEdit').value = "Свернуть"; 
	else document.getElementById('btnUACSubscriberEdit').value = "Настроить";

	var elems = document.querySelectorAll( 'tr[item_type=UACSubscriberRow'+ch_id+']' );
	for (var i = 0; i < elems.length; i++) {
		var ch_obj = document.getElementById('ed_ch_'+ch_id+'_UACSubscriber_check'+i);
		if(obj.getAttribute('mode')==1) {
			//ch_obj.parentElement.style.display = "";
			$(ch_obj.parentElement).show();
		}
		else {
			//ch_obj.parentElement.style.display = "none";
			$(ch_obj.parentElement).hide();
		}
		if(!ch_obj.checked){
			if(elems[i].style.display == "none" ) {
				elems[i].style.display = ""; 
			}
			else elems[i].style.display = "none"; 
		}
	}
}























function line_test_request_start(){
	var res = line_test_request();
	const LineTestRequestID = setInterval(() => {
		res = line_test_request();
	}, LineTestRequestStep);	
}

// запрос данных из line_control.cfg, возвращает массив
function line_test_request(){
	var result = [];

	$.ajax({
		type: 'POST',
		url: '/cgi-bin/process.cgi',
		data: ({
			request_name: 'line_test_request'
		}),
		dataType: 'text',
		async: !1,
		timeout: 1000,
		success: function(data) {
			//console.log(data);
			var arr = data.split(',');
			arr.forEach(function(elem, idx) {
				par = elem.split('=');
				result[par[0]] = par[1];
			});
			ServerDate = result['date'];
			ServerTime = result['time'];
			ServerTimestamp = result['timestamp'];
			var obj_time = document.getElementById('ed_ServerTime');
			if(obj_time) obj_time.innerHTML = 'Системное время: ' + ServerTime + ' ' + ServerDate;
		},
		error:function(){
		}
	});

	return result;
}


//-------------------------------------------------------------------------------------------------
//												UACRegister
//-------------------------------------------------------------------------------------------------

function createUACRegisterHeader(ch_id) {
	var ipoint = document.getElementById("hidUACRegisterCount");

	var aTable = document.createElement("table");
	aTable.id = "UniqueUACRegister" + ch_id;
	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	aTable.className = "nb";
	aTable.setAttribute("block_UACRegister","UACRegister");

	var tr,td;

	var tbody = document.createElement("tbody");
	tr = document.createElement("tr"); // next row will be inserted before this initial row

	tbody.insertBefore(tr, tbody.lastChild);
	aTable.appendChild(tbody);




	tr = document.createElement("tr");
	
	td = document.createElement("td");
	td.className = "infoTableHeader";
	td.width = "38px";
	td.innerHTML = "&nbsp";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoTableHeader";
	td.width = "140px";
	td.innerHTML = "login";
	tr.appendChild(td);
	
	td = document.createElement("td");
	td.className = "infoTableHeader";
	td.width = "120px";
	td.innerHTML = "password";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoTableHeader";
	td.style["white-space"] = "normal";
	td.width = "40px";
	td.innerHTML = "timeout in sec";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoTableHeader";
	td.style["padding-left"] = "40px";
	td.width = "120px";
	td.innerHTML = "IP register";
	tr.appendChild(td);

	tbody.insertBefore(tr, tbody.lastChild);




	var div = document.createElement("div");
	div.appendChild(aTable);

	ipoint.parentNode.insertBefore(div, ipoint);

	var hid = document.getElementById("hidUACRegisterCount");
	hid.value =  "0";

	return true;
}


function OnAddUACRegister(ch_id,
						rec_id,
						regval) {
	var hid = document.getElementById("hidUACRegisterCount");
	hid.value++;
	
	if (isNaN(rec_id) || rec_id < 0) rec_id = hid.value - 1;
	//alert(rec_id);
	if (!regval) regval = "";

	tbody = document.getElementById("UniqueUACRegister" + ch_id);
	tbody = tbody.lastChild;

	var tr = document.createElement("tr");
	tr.id = 'UACRegisterRow_'+rec_id;

	var td = document.createElement("td");
	td.paddingLeft = "38px";
	td.className = "infoLineParam";
	td.innerHTML =
		"UACRegister" + rec_id;
	tr.appendChild(td);

/*	
	td = document.createElement("td");
	td.className = "selectw280";
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACRegister"+rec_id+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACRegister"+rec_id+"\" " +
		"type=\"text\" value=\""+regval+"\" " +
		"class=\"selectw280\">";
	tr.appendChild(td);
*/

	if( regval == NaN || regval == "" ) regval = "::@";
	var regsplit = regval.split('@');
	var regarr_ip = regsplit[1];
	var regarr = (regsplit[0]).split(':');
	var reg_login = regarr[0];
	var reg_password = regarr[1];
	var reg_timeout = regarr[2];

	td = document.createElement("td");
	//td.className = "selectw280";
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACRegister_log"+rec_id+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACRegister_log"+rec_id+"\" " +
		"type=\"text\" value=\""+reg_login+"\" " +
		"class=\"selectw\">";
	tr.appendChild(td);
	
	td = document.createElement("td");
	//td.className = "selectw280";
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACRegister_pas"+rec_id+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACRegister_pas"+rec_id+"\" " +
		"type=\"text\" value=\""+reg_password+"\" " +
		"class=\"selectw\">";
	tr.appendChild(td);
	
	td = document.createElement("td");
	//td.className = "selectw280";
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACRegister_time"+rec_id+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACRegister_time"+rec_id+"\" " +
		"type=\"text\" value=\""+reg_timeout+"\" " +
		"class=\"selectw40\">";
	tr.appendChild(td);
	
	td = document.createElement("td");
	//td.className = "selectw280";
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACRegister_ip"+rec_id+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACRegister_ip"+rec_id+"\" " +
		"type=\"text\" value=\""+regarr_ip+"\" " +
		"class=\"selectw\">";
	tr.appendChild(td);
	
	

	td = document.createElement("td");
	td.innerHTML =
		"<img class=\"imglink\" src=\"/images/del.gif\" width=\"16\" height=\"16\" alt=\"Удалить регистрацию\" title=\"Удалить регистрацию\" " +
		"onclick=\"doUACRegisterDelete(this,"+ch_id+")\">\n";
	tr.appendChild(td);
	
	tbody.insertBefore(tr, tbody.lastChild);

	document.getElementById("ed_ch_sip_4_UACRegisterCount").value = hid.value;

}

/*
function doUACRegisterDelete(obj,ch_id){
	
	var prename = new RegExp("ed_ch_" + ch_id + "_UACRegister_log", "g");
	var rec_id = obj.parentElement.parentElement.children[1].children[0].name.replace(prename,"");
	
	var hid = document.getElementById("hidUACRegisterCount");
	var nextcount = eval(hid.value);

	// delete row with slide
	for(var i = rec_id; i < nextcount; i++){
		var preobj = document.getElementById("ed_ch_" + ch_id + "_UACRegister_log" + i);
		var next_id = eval(i) + 1;
		if(next_id == nextcount) next_id--; // for last row in table
		var nextobj = document.getElementById("ed_ch_" + ch_id + "_UACRegister_log" + next_id);
		if(nextobj) preobj.value = nextobj.value;
		
		if(next_id == nextcount - 1 ) {
			nextobj.parentElement.parentElement.remove();
			hid.value--;
			document.getElementById("ed_ch_sip_4_UACRegisterCount").value = hid.value;
		}
	}
	
}
*/
function doUACRegisterDelete(obj,ch_id){
	
	var prename = new RegExp("ed_ch_" + ch_id + "_UACRegister_log", "g");
	var rec_id = obj.parentElement.parentElement.children[1].children[0].name.replace(prename,"");
	
	var hid = document.getElementById("hidUACRegisterCount");
	var nextcount = eval(hid.value);

	// delete row with slide
	for(var i = rec_id; i < nextcount; i++){
		var preobj_log = document.getElementById("ed_ch_" + ch_id + "_UACRegister_log" + i);
		var preobj_pas = document.getElementById("ed_ch_" + ch_id + "_UACRegister_pas" + i);
		var preobj_time = document.getElementById("ed_ch_" + ch_id + "_UACRegister_time" + i);
		var preobj_ip = document.getElementById("ed_ch_" + ch_id + "_UACRegister_ip" + i);
		var next_id = eval(i) + 1;
		if(next_id == nextcount) next_id--; // for last row in table
		var nextobj_log = document.getElementById("ed_ch_" + ch_id + "_UACRegister_log" + next_id);
		var nextobj_pas = document.getElementById("ed_ch_" + ch_id + "_UACRegister_pas" + next_id);
		var nextobj_time = document.getElementById("ed_ch_" + ch_id + "_UACRegister_time" + next_id);
		var nextobj_ip = document.getElementById("ed_ch_" + ch_id + "_UACRegister_ip" + next_id);
		if(nextobj_log) preobj_log.value = nextobj_log.value;
		if(nextobj_pas) preobj_pas.value = nextobj_pas.value;
		if(nextobj_time) preobj_time.value = nextobj_time.value;
		if(nextobj_ip) preobj_ip.value = nextobj_ip.value;
		
		if(next_id == nextcount - 1 ) {
			nextobj_log.parentElement.parentElement.remove();
			hid.value--;
			document.getElementById("ed_ch_sip_4_UACRegisterCount").value = hid.value;
		}
	}
	
}


//-------------------------------------------------------------------------------------------------
//												UACSubscriber
//-------------------------------------------------------------------------------------------------

function createUACSubscriberHeader(ch_id) {
	var ipoint = document.getElementById("hidUACSubscriberCount");

	var aTable = document.createElement("table");
	aTable.id = "UniqueUACSubscriber" + ch_id;
	aTable.cellPadding = 0;
	aTable.cellSpacing = 0;
	aTable.className = "nb";
	aTable.setAttribute("block_UACSubscriber","UACSubscriber");

	var tbody = document.createElement("tbody");
	tbody.id = 'tbody_subscriber';
	var tr = document.createElement("tr"); // next row will be inserted before this initial row
	tbody.insertBefore(tr, tbody.lastChild);
	aTable.appendChild(tbody);



	tr = document.createElement("tr");
	tr.id = 'tab_subscriber_header';
	
	td = document.createElement("td");
	td.className = "infoTableHeader";
	td.width = "38px";
	td.innerHTML = "&nbsp";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoTableHeader";
	td.width = "120px";
	td.innerHTML = "Статус абонента<br>(presence)";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoTableHeader";
	td.style["white-space"] = "normal";
	td.width = "40px";
	//td.innerHTML = "таймаут<br>сек";
	td.innerHTML = "Время жизни<br>(сек)";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoTableHeader";
	td.style["padding-left"] = "10px";
	td.style["white-space"] = "normal";
	td.width = "80px";
	td.innerHTML = "Идентификатор<br>(&lt;resource&gt;@)";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoTableHeader";
	td.style["padding-left"] = "40px";
	td.width = "120px";
	td.innerHTML = "IP адрес";
	td.style.cursor = 'pointer';
	td.onclick = function() {tabRowSorter(this);}
	td.setAttribute('sortorder','');
	tr.appendChild(td);

	tbody.insertBefore(tr, tbody.lastChild);



	var div = document.createElement("div");
	div.appendChild(aTable);

	ipoint.parentNode.insertBefore(div, ipoint);

	var hid = document.getElementById("hidUACSubscriberCount");
	hid.value =  "0";

	return true;
}


function OnAddUACSubscriber(ch_id,
						rec_id,
						regval) {
	var hid = document.getElementById("hidUACSubscriberCount");
	hid.value++;
	
	if (isNaN(rec_id) || rec_id < 0) rec_id = hid.value - 1;
	//alert(rec_id);
	if (!regval) regval = "";

	tbody = document.getElementById("UniqueUACSubscriber" + ch_id);
	tbody = tbody.lastChild;

	var tr = document.createElement("tr");
	tr.id = 'UACSubscriberRow_'+rec_id;

	var td = document.createElement("td");
	td.paddingLeft = "38px";
	td.className = "infoLineParam";
	td.innerHTML =
		"UACSubscriber" + rec_id;
	tr.appendChild(td);


	// возможные форматы
	// presence : <timeout in sec> : <resource name> @ <IP resource>
	// presence: <timeout in sec> : <IP resource>

	/*
	if( regval == NaN || regval == "" ) regval = ":@";
	var regsplit = regval.split('@');
	var regarr_ip = regsplit[1];
	var regarr = (regsplit[0]).split(':');
	var reg_presence = regarr[0];
	var reg_timeout = regarr[1];
	var reg_name = "";*/


	//if( regval == NaN || regval == "" ) regval = ":@";
	
	var regsplit = regval.split('@');
	var regarr = (regsplit[0]).split(':');
	var reg_ip = "";
	var reg_presence = "presence";
	var reg_timeout = "3600";
	var reg_name = "";

	if( regsplit[1] != undefined || regsplit.length == 2 ){
		reg_ip = regsplit[1];
		reg_presence = regarr[0];
		reg_timeout = regarr[1];
		reg_name = regarr[2];
	} else {
		if( regarr[0] != undefined && regarr[0] != "" ) reg_presence = regarr[0];
		if( regarr[1] != undefined && regarr[1] != "" ) reg_timeout = regarr[1];
		reg_name = "";
		if( regarr[2] != undefined ) reg_ip = regarr[2];
		if( regarr[3] != undefined ) reg_ip += ":"+regarr[3];
	}
	



	
	td = document.createElement("td");
	//td.className = "selectw280";
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACSubscriber_pre"+rec_id+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACSubscriber_pre"+rec_id+"\" " +
		"type=\"text\" value=\""+reg_presence+"\" >";
	tr.appendChild(td);

	td = document.createElement("td");
	//td.className = "selectw280";
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACSubscriber_time"+rec_id+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACSubscriber_time"+rec_id+"\" " +
		"type=\"text\" value=\""+reg_timeout+"\" >";
	tr.appendChild(td);

	td = document.createElement("td");
	//td.className = "selectw280";
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACSubscriber_name"+rec_id+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACSubscriber_name"+rec_id+"\" " +
		"type=\"text\" value=\""+reg_name+"\" >";
	tr.appendChild(td);

	td = document.createElement("td");
	//td.className = "selectw280";
	td.innerHTML =
		"<input class=\"selectw\" style=\"width:100%;\" " +
		"name=\"ed_ch_" + ch_id + "_UACSubscriber_ip"+rec_id+"\" " +
		"id=\"ed_ch_" + ch_id + "_UACSubscriber_ip"+rec_id+"\" " +
		"type=\"text\" value=\""+reg_ip+"\" >";
	tr.appendChild(td);

	td = document.createElement("td");
	td.innerHTML =
		"<img class=\"imglink\" src=\"/images/del.gif\" width=\"16\" height=\"16\" alt=\"Удалить подписку\" title=\"Удалить подписку\" " +
		"onclick=\"doUACSubscriberDelete(this,"+ch_id+")\">\n";
	tr.appendChild(td);
	
	tbody.insertBefore(tr, tbody.lastChild);

	document.getElementById("ed_ch_sip_4_UACSubscriberCount").value = hid.value;

}

/*
function doUACSubscriberDelete(obj,ch_id){
	
	var prename = new RegExp("ed_ch_" + ch_id + "_UACSubscriber", "g");
	var rec_id = obj.parentElement.parentElement.children[1].children[0].name.replace(prename,"");
	
	var hid = document.getElementById("hidUACSubscriberCount");
	var nextcount = eval(hid.value);

	// delete row with slide
	for(var i = rec_id; i < nextcount; i++){
		var preobj = document.getElementById("ed_ch_" + ch_id + "_UACSubscriber" + i);
		var next_id = eval(i) + 1;
		if(next_id == nextcount) next_id--; // for last row in table
		var nextobj = document.getElementById("ed_ch_" + ch_id + "_UACSubscriber" + next_id);
		if(nextobj) preobj.value = nextobj.value;
		
		if(next_id == nextcount - 1 ) {
			nextobj.parentElement.parentElement.remove();
			hid.value--;
			document.getElementById("ed_ch_sip_4_UACSubscriberCount").value = hid.value;
		}
	}
	
}
*/
function doUACSubscriberDelete(obj,ch_id){
	
	var prename = new RegExp("ed_ch_" + ch_id + "_UACSubscriber_pre", "g");
	var rec_id = obj.parentElement.parentElement.children[1].children[0].name.replace(prename,"");
	
	var hid = document.getElementById("hidUACSubscriberCount");
	var nextcount = eval(hid.value);

	// delete row with slide
	for(var i = rec_id; i < nextcount; i++){
		var preobj_pre = document.getElementById("ed_ch_" + ch_id + "_UACSubscriber_pre" + i);
		var preobj_time = document.getElementById("ed_ch_" + ch_id + "_UACSubscriber_time" + i);
		var preobj_name = document.getElementById("ed_ch_" + ch_id + "_UACSubscriber_name" + i);
		var preobj_ip = document.getElementById("ed_ch_" + ch_id + "_UACSubscriber_ip" + i);
		var next_id = eval(i) + 1;
		if(next_id == nextcount) next_id--; // for last row in table
		var nextobj_pre = document.getElementById("ed_ch_" + ch_id + "_UACSubscriber_pre" + next_id);
		var nextobj_time = document.getElementById("ed_ch_" + ch_id + "_UACSubscriber_time" + next_id);
		var nextobj_name = document.getElementById("ed_ch_" + ch_id + "_UACSubscriber_name" + next_id);
		var nextobj_ip = document.getElementById("ed_ch_" + ch_id + "_UACSubscriber_ip" + next_id);
		if(nextobj_pre) preobj_pre.value = nextobj_pre.value;
		if(nextobj_time) preobj_time.value = nextobj_time.value;
		if(nextobj_name) preobj_name.value = nextobj_name.value;
		if(nextobj_ip) preobj_ip.value = nextobj_ip.value;
		
		if(next_id == nextcount - 1 ) {
			nextobj_pre.parentElement.parentElement.remove();
			hid.value--;
			document.getElementById("ed_ch_sip_4_UACSubscriberCount").value = hid.value;
		}
	}
	
}

////////////////////////////////////////////////////////////////////////////////////////////////////////





function OnAddLiraChannel(idx, channeltype, sectionname, localaddress, localport, remoteaddress, remoteport, locationtype, locationplace, call_name) {
	var hid = document.getElementById("hidLiraChannelCount");

	/*if (!idx || (idx < 0)){
		hid.value = 4 + $('table[block_type=LiraChannel]').length;
		hid.value++;
		idx = hid.value;
	}*/

	if (!idx || (idx < 0)){
		idx = 5;
		while( $("table[id=UniqueLiraChannel"+idx+"]").length > 0 ){
			idx++;
		}
	}
	
	if (!sectionname) sectionname = "RADIO-LIRA."+idx;
	
	if (!localaddress) localaddress = "";
	if (!localport) localport = "";
	if (!remoteaddress) remoteaddress = "";
	if (!remoteport) remoteport = "";
	if (!channeltype) channeltype = "радио";
	if (!locationtype) locationtype = "";
	if (!locationplace) locationplace = "";
	if (!call_name) call_name = "";
	

	//table
	var aTab = document.createElement("table");
	aTab.id = "UniqueLiraChannel" + idx;
	aTab.width = '100%';

	aTab.cellPadding = 0;
	aTab.cellSpacing = 0;
	//aTab.className = "nbb";
	aTab.setAttribute("style", "float:left;background:" + GetAltColor(idx, 1, true));
	//aTab.style.cssText = "float:left;background:" + GetAltColor(pattern_idx, 1, true);
	aTab.style.cssText = "background:" + GetAltColor(idx, 1, true);
	aTab.style.marginTop = "10px";
	aTab.setAttribute("block_type","LiraChannel");
	var tbody = document.createElement("tbody");


//	AddTableCaption(tbody,
//		"<div style=\"display:inline;float:left\">&nbsp;Канал "+idx+":&nbsp;</div>");


	var tr = document.createElement("tr");
	var td = document.createElement("td");
	td.colSpan = 1;
	td.className = "editTableHeader";
	td.innerHTML = "<div style=\"display:inline;float:left\">&nbsp;Канал "+idx+":&nbsp;</div>";
	tr.appendChild(td);
	var td = document.createElement("td");
	td.colSpan = 3;
	td.className = "editTableHeader";
	td.align = "right";
	td.innerHTML = "<img class=\"imglink\" src=\"/images/del.gif\" width=\"16\" height=\"16\" alt=\"Удалить канал\" title=\"Удалить канал\" " +
		"onclick=\"LiraChannelDelete("+idx+")\">\n";
		//"onclick=\"doUACSubscriberDelete(this,"+idx+")\">\n";
	tr.appendChild(td);
	tbody.appendChild(tr);


	tr = document.createElement("tr");
	td = document.createElement("td");
	td.className = "infoLineParamMiddle";
	td.colSpan = 1;
	td.style.width = "20%";
	td.innerHTML = "Тип";
	tr.appendChild(td);
	td = document.createElement("td");
	td.className = "infoLineValue";
	td.colSpan = 3;
	td.style.width = "80%";
	td.innerHTML = "<select name=ed_ch_radio_lira_"+idx+"_ChannelType id=ed_ch_radio_lira_"+idx+"_ChannelType class=\"selectw\" onchange=\"onChannelTypeChange(this,"+idx+")\" >"+
		"<option value=\"радио\""+GetSelectedString(channeltype, 'радио')+">радио</option>"+
		"<option value=\"РП\""+GetSelectedString(channeltype, 'РП')+">РП</option>\n"+
		"</select>\n";
	tr.appendChild(td);
	tbody.appendChild(tr);


	tr = document.createElement("tr");
	td = document.createElement("td");
	td.className = "infoLineParamMiddle";
	td.colSpan = 1;
	td.style.width = "20%";
	td.innerHTML = "Соединение";
	tr.appendChild(td);
	td = document.createElement("td");
	td.className = "infoLineValue";
	td.colSpan = 3;
	td.style.width = "80%";
	td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_SectionName name=ed_ch_radio_lira_" + idx + "_SectionName type=\"text\" class=\"selectw280\" value=\"" + sectionname + "\" disabled>";
	tr.appendChild(td);
	tbody.appendChild(tr);


	tr = document.createElement("tr");
	td = document.createElement("td");
	td.className = "infoLineParamMiddle";
	td.colSpan = 1;
	td.style.width = "20%";
	td.innerHTML = "Название канала";
	tr.appendChild(td);
	td = document.createElement("td");
	td.className = "infoLineValue";
	td.colSpan = 3;
	td.style.width = "80%";
	td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_CallName name=ed_ch_radio_lira_" + idx + "_CallName type=\"text\" class=\"selectw280\" value=\"" + call_name + "\" maxlength=\"18\" >";
	tr.appendChild(td);
	tbody.appendChild(tr);





	if(channeltype=="радио"){

	tr = document.createElement("tr");
	td = document.createElement("td");
	td.className = "infoLineParamMiddle";
	td.colspan = 1;
	td.style.width = "30%";
	//td.innerHTML = "LocalAddress";
	td.innerHTML = "Адрес приема RTP";
	tr.appendChild(td);
	
	td = document.createElement("td");
	//td.style.border = "solid black 1px";
	td.style.width = "36%";
	td.className = "infoLineValue";
	td.colspan = 1;
	td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_LocalAddress name=ed_ch_radio_lira_" + idx + "_LocalAddress type=\"text\" class=\"selectw140\" value='" + localaddress + "' type=\"text\" itemtype=\"ip_input\" data-inputmask=\"'alias': 'ip'\" >";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoLineParamMiddle";
	td.colspan = 1;
	td.style.width = "10%";
	td.innerHTML = "Port";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoLineValue";
	td.colspan = 1;
	td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_LocalAddressPort name=ed_ch_radio_lira_" + idx + "_LocalAddressPort type=\"text\" class=\"selectw70\" value='" + localport + "' type=\"text\" itemtype=\"port_input\" >";
	tr.appendChild(td);

	tbody.appendChild(tr);


	tr = document.createElement("tr");
	td = document.createElement("td");
	td.className = "infoLineParamMiddle";
	//td.innerHTML = "RemoteAddress";
	td.innerHTML = "Адрес передачи RTP";
	tr.appendChild(td);
	
	td = document.createElement("td");
	td.className = "infoLineValue";
	td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_RemoteAddress name=ed_ch_radio_lira_" + idx + "_RemoteAddress type=\"text\" class=\"selectw140\" value='" + remoteaddress + "' type=\"text\" itemtype=\"ip_input\" data-inputmask=\"'alias': 'ip'\" >";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoLineParamMiddle";
	td.innerHTML = "Port";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoLineValue";
	td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_RemoteAddressPort name=ed_ch_radio_lira_" + idx + "_RemoteAddressPort type=\"text\" class=\"selectw70\" value='" + remoteport + "' type=\"text\" itemtype=\"port_input\" >";
	tr.appendChild(td);

	tbody.appendChild(tr);
	
	} // if(channeltype=='радио'){


	if(channeltype=="РП"){

	tr = document.createElement("tr");
	td = document.createElement("td");
	td.className = "infoLineParamMiddle";
	td.colspan = 1;
	td.style.width = "30%";
	td.innerHTML = "Location";
	tr.appendChild(td);
	
	td = document.createElement("td");
	//td.style.border = "solid black 1px";
	td.style.width = "37%";
	td.className = "infoLineValue";
	td.colspan = 1;
	//td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_LocationType name=ed_ch_radio_lira_" + idx + "_LocationType type=\"text\" class=\"selectw140\" value='" + locationtype + "' type=\"text\">";
	/*
	td.innerHTML = "<select name=ed_ch_radio_lira_"+idx+"_LocationType id=ed_ch_radio_lira_"+idx+"_LocationType class=\"selectw140\" >"+
		"<option value=\"Handset\""+GetSelectedString(locationtype, 'Handset')+">Handset</option>"+
		"<option value=\"Headset\""+GetSelectedString(locationtype, 'Headset')+">Headset</option>"+
		"<option value=\"Speaker\""+GetSelectedString(locationtype, 'Speaker')+">Speaker</option>"+
		"<option value=\"Tangenta\""+GetSelectedString(locationtype, 'Tangenta')+">Tangenta</option>"+
		"<option value=\"Table_microphone\""+GetSelectedString(locationtype, 'Table_microphone')+">Table_microphone</option>"+
		"</select>\n";
	*/
	td.innerHTML = "<select name=ed_ch_radio_lira_"+idx+"_LocationType id=ed_ch_radio_lira_"+idx+"_LocationType class=\"selectw160\" >"+
		"<option value=\"Телефонная трубка\""+GetSelectedString(locationtype, 'Телефонная трубка')+">Телефонная трубка</option>"+
		"<option value=\"Головная гарнитура\""+GetSelectedString(locationtype, 'Головная гарнитура')+">Головная гарнитура</option>"+
		"<option value=\"Внешний динамик\""+GetSelectedString(locationtype, 'Внешний динамик')+">Внешний динамик</option>"+
		"<option value=\"Тангента\""+GetSelectedString(locationtype, 'Тангента')+">Тангента</option>"+
		"<option value=\"Настольный микрофон\""+GetSelectedString(locationtype, 'Настольный микрофон')+">Настольный микрофон</option>"+
		"</select>\n";

	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoLineParamMiddle";
	td.colspan = 1;
	td.style.width = "10.0%";
	td.innerHTML = "Place";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoLineValue";
	td.colspan = 1;
	//td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_LocationPlace name=ed_ch_radio_lira_" + idx + "_LocationPlace type=\"text\" class=\"selectw70\" value='" + locationplace + "' type=\"text\">";
	td.innerHTML = "<select name=ed_ch_radio_lira_"+idx+"_LocationPlace id=ed_ch_radio_lira_"+idx+"_LocationPlace class=\"selectw40\" >"+
		"<option value=\"1\""+GetSelectedString(locationplace, '1')+">1</option>"+
		"<option value=\"2\""+GetSelectedString(locationplace, '2')+">2</option>"+
		"<option value=\"3\""+GetSelectedString(locationplace, '3')+">3</option>"+
		"<option value=\"4\""+GetSelectedString(locationplace, '4')+">4</option>"+
		"<option value=\"5\""+GetSelectedString(locationplace, '5')+">5</option>"+
		"<option value=\"6\""+GetSelectedString(locationplace, '6')+">6</option>"+
		"<option value=\"7\""+GetSelectedString(locationplace, '7')+">7</option>"+
		"<option value=\"8\""+GetSelectedString(locationplace, '8')+">8</option>"+
		"</select>\n";
	tr.appendChild(td);

	tbody.appendChild(tr);
	
	} // if(channeltype=='РП'){
	


/*					<tr class="bgsel">
						<td colspan=2 class="infoLineParam">LocalAddress </td>
						<td colspan=2 class="infoLineValue">
							<table>
								<tr>
								<td><input id="<?php echo $channel_radio_lira[7]["postname"]."LocalAddress"; ?>" name="<?php echo $channel_radio_lira[7]["postname"]."LocalAddress"; ?>" type="text" class="selectw140" value="<?php echo $channel_radio_lira[7]["LocalAddress"]; ?>" itemtype="ip_input" data-inputmask="'alias': 'ip'"></td>
								<!-- td><input id="<?php echo $channel_radio_lira[7]["postname"]."LocalAddress"; ?>" name="<?php echo $channel_radio_lira[7]["postname"]."LocalAddress"; ?>" type="text" class="selectw140" value="<?php echo $channel_radio_lira[7]["LocalAddress"]; ?>"></td -->
								<!-- td><input id="<?php echo $channel_radio_lira[7]["postname"]."LocalAddress"; ?>" name="<?php echo $channel_radio_lira[7]["postname"]."LocalAddress"; ?>" type="text" class="selectw140" onkeydown="this.oldval = this.value" oninput="if(!checkIPinput(this)) return false;" value="<?php echo $channel_radio_lira[7]["LocalAddress"]; ?>"></td -->
								<td class="infoLineParam">Port</td>
								<td><input id="<?php echo $channel_radio_lira[7]["postname"]."LocalAddressPort"; ?>" name="<?php echo $channel_radio_lira[7]["postname"]."LocalAddressPort"; ?>" type="text" class="selectw70" value="<?php echo $channel_radio_lira[7]["LocalAddressPort"]; ?>" itemtype="port_input"></td>
								</tr>
							</table>
						</td>
					</tr>*/
	
	/*AddTableCaption(tbody,
		"<div style=\"display:inline;float:left\">&nbsp;Pattern #"+pattern_idx+"&nbsp;</div>"+

		"<img class=\"imglink\" style=\"display:inline;float:left;margin-right:2px;\" OnClick=\"doClearClick(event); Pattern_Rotation('left',"+pattern_idx+")\" title=\"Move forward\" alt=\"<\" src=\"/images/lf.gif\">"+
		"<img class=\"imglink\" style=\"display:inline;float:left;margin-right:2px;\" OnClick=\"doClearClick(event); Pattern_Rotation('right',"+pattern_idx+")\" title=\"Move back\" alt=\">\" src=\"/images/rt.gif\">"+
		
		"<select name=\"edPatternPosition"+pattern_idx+"\" id=\"edPatternPosition"+pattern_idx+"\" OnClick=\"doClearClick(event);\" OnChange=\"Pattern_Move("+pattern_idx+");\" class=\"blockheader_select\" "+
		"style=\"display:inline;float:left;margin-right:2px;\" >" +
		"</select>\n"+

		"<img class=\"imglink\" style=\"display:inline;float:right;margin-right:2px;\" OnClick=\"Pattern_Delete("+pattern_idx+"); doChangeEvent();\" title=\"Delete pattern\" src=\"/images/del.gif\">" +
		"<input type=\"hidden\" id=\"UniquePattern_TargetCount" + pattern_idx +"\" name=\"UniquePattern_TargetCount" + pattern_idx +"\" " + pattern_idx +" target_row_list=\"\" value=\"\" ></input>");
		//"<input type=\"hidden\" id=UniquePattern_TargetCount" + pattern_idx +" value=\"0\" ></span>");

		
	AddTableRow(tbody, "name",
		"<input name=\"edPatternName"+pattern_idx+"\" " +
		"id=\"edPatternName"+pattern_idx+"\" " +
		"type=\"text\" " +
		"value=\""+pattern_name+"\" " +
		"OnChange=\"UpdatePatternControls();doChangeEvent();\" " +
		"class=\"selectw280\">");

	AddTableRow(tbody, "called",
		"<input name=\"edPatternCalled"+pattern_idx+"\" " +
		"id=\"edPatternCalled"+pattern_idx+"\" " +
		"type=\"text\" " +
		"value=\""+pattern_called+"\" " +
		"OnChange=\"UpdatePatternControls();doChangeEvent();\" " +
		"maxlength=\"256\" size=\"10\" class=\"selectw280\">");

	AddTableRow(tbody, "caller",
		"<input name=\"edPatternCaller"+pattern_idx+"\" " +
		"id=\"edPatternCaller"+pattern_idx+"\" " +
		"type=\"text\" " +
		"value=\""+pattern_caller+"\" " +
		"OnChange=\"UpdatePatternControls();doChangeEvent();\" " +
		"maxlength=\"256\" size=\"10\" class=\"selectw280\">");

	AddTableRow(tbody, "group",
		"<input name=\"edPatternGroup"+pattern_idx+"\" " +
		"id=\"edPatternGroup"+pattern_idx+"\" " +
		"type=\"text\" " +
		"value=\""+pattern_group+"\" " +
		"OnChange=\"UpdatePatternControls();doChangeEvent();\" " +
		//"onKeyDown=\"setMask('this','99999');\" " +
		//"onKeyDown=\"var maskchar=[8,9,13,37,38,39,40,46,48,49,50,51,52,53,54,55,56,57]; if(maskchar.indexOf(event.keyCode)<0) return false;\" " +
		//"data-meiomask='integer' "+
		"maxlength=\"256\" size=\"10\" class=\"selectw280\">");

	AddTableRow(tbody, "targets",
		"<table class=\"editLineParam\" name=\"edPatternTargetTable"+pattern_idx+"\" id=\"edPatternTargetTable"+pattern_idx+"\" style=\"padding: 0px;\" target_row_list=\"\" >"+
		"<tr><td>target</td><td>type</td><td>routing<br>timeout</td><td>answer<br>timeout</td><td>dial<br>timeout</td><td>vad<br>timeout</td><td align='center'>del</td><tr>"+
		"</table>"+
//		"<table class=\"selectw\" >"+
//		"<tr><td colspan=6 style=\"cursor:pointer;\" onclick=\"addPatterntargetRow("+pattern_idx+");\" title=\"Add new target\">+Add</td><tr>"+
//		"</table>"
		"<table class=\"infoLineParam\" style=\"padding: 0px;\">"+
		"<tr><td colspan=6 style=\"cursor:pointer; font-weight:bold; background:#ddd; padding-left: 10px;\" onclick=\"addPatterntargetRow("+pattern_idx+");doChangeEvent();\" title=\"Add new target\">+ Add</td><tr>"+
		"</table>"
		);*/
		
		
	aTab.appendChild(tbody);
	hid.parentNode.insertBefore(aTab, hid);

/*
	//finally insert
	//hid.parentNode.insertBefore(aTab, hid);
	if( insert_side == 0 ){
		var obj = document.getElementById("UniquePatternPlus");
		if(obj){
			obj.parentNode.insertBefore(aTab, obj);
			if(hid.value>1) Pattern_ChangePosition(hid.value,1);
			pattern_idx = 1;
		} else {
			hid.parentNode.insertBefore(aTab, hid);
			OnAddPattern_Plus();
		}
	} else {
		hid.parentNode.insertBefore(aTab, hid);
	}

	// pattern targets table filling (file row example: target=SIP>>RINO:1:0:2 reject:0:3:4 called:7:6:0)
	var patarr = pattern_target.split(' ');
	for(var i=0; i<patarr.length; i++){
		var tagarr = patarr[i].split(':');
//alert(i);
		addPatterntargetRow(pattern_idx,tagarr[0],tagarr[3],tagarr[2],tagarr[1],tagarr[4]); // attention: rotation of "routing" [3] and "dial" [1] timeout
	}
	
	//UpdatePatternControls();
	doSectionCountCheck('PatternsContainerHeader','PatternsContainer','Pattern',0);*/
}

/*
function LiraChannelDelete(idx){
	//var obj = document.getElementById("UniqueLiraChannel" + idx);
	//obj.remove();
	//var hid = document.getElementById("hidLiraChannelCount");
	//hid.value--;

	var lirach = [];
	var ChannelType = "";	
	var SectionName = "";
	var LocalAddress = "";
	var LocalAddressPort = "";
	var RemoteAddress = "";
	var RemoteAddressPort = "";
	
	$channels = $("table[id*=UniqueLiraChannel]");
	if($channels){
		var hid = document.getElementById("hidLiraChannelCount");
		$channels.each(function(index, value) {
		var num = getNumFromName(this.id,["UniqueLiraChannel"]);
		// save all next channels into array
		if(num > idx){
			//alert(num);
			ChannelType = document.getElementById("ed_ch_radio_lira_" + num + "_ChannelType").value;
			SectionName = document.getElementById("ed_ch_radio_lira_" + num + "_SectionName").value;
			LocalAddress = document.getElementById("ed_ch_radio_lira_" + num + "_LocalAddress").value;
			LocalAddressPort = document.getElementById("ed_ch_radio_lira_" + num + "_LocalAddressPort").value;
			RemoteAddress = document.getElementById("ed_ch_radio_lira_" + num + "_RemoteAddress").value;
			RemoteAddressPort = document.getElementById("ed_ch_radio_lira_" + num + "_RemoteAddressPort").value;
			lirach.push([ChannelType,SectionName,LocalAddress,LocalAddressPort,RemoteAddress,RemoteAddressPort]);
		}
		// remove these channels
		if(num >= idx){
			var obj = document.getElementById("UniqueLiraChannel" + num);
			obj.remove();
			hid.value--;
		}
		});		

		// restore next channels from array
		lirach.forEach(function(item, i, arr) {
			//alert(item[0]+"  "+item[1]);
			//OnAddLiraChannel(idx + i, channeltype, sectionname, localaddress, localport, remoteaddress, remoteport) 
			item[1] = ((item[0] == "радио") ? "RADIO-LIRA." : "LIRA.") + (idx + i);
			OnAddLiraChannel(idx + i, item[0], item[1], item[2], item[3], item[4], item[5]);
		});
	}
	
}
*/

function LiraChannelDelete(idx){
	var obj = document.getElementById("UniqueLiraChannel" + idx);
	obj.remove();
	var hid = document.getElementById("hidLiraChannelCount");
	hid.value--;

/*
	var lirach = [];
	var ChannelType = "";	
	var SectionName = "";
	var LocalAddress = "";
	var LocalAddressPort = "";
	var RemoteAddress = "";
	var RemoteAddressPort = "";
	
	$channels = $("table[id*=UniqueLiraChannel]");
	if($channels){
		var hid = document.getElementById("hidLiraChannelCount");
		$channels.each(function(index, value) {
		var num = getNumFromName(this.id,["UniqueLiraChannel"]);
		// save all next channels into array
		if(num > idx){
			//alert(num);
			ChannelType = document.getElementById("ed_ch_radio_lira_" + num + "_ChannelType").value;
			SectionName = document.getElementById("ed_ch_radio_lira_" + num + "_SectionName").value;
			LocalAddress = document.getElementById("ed_ch_radio_lira_" + num + "_LocalAddress").value;
			LocalAddressPort = document.getElementById("ed_ch_radio_lira_" + num + "_LocalAddressPort").value;
			RemoteAddress = document.getElementById("ed_ch_radio_lira_" + num + "_RemoteAddress").value;
			RemoteAddressPort = document.getElementById("ed_ch_radio_lira_" + num + "_RemoteAddressPort").value;
			lirach.push([ChannelType,SectionName,LocalAddress,LocalAddressPort,RemoteAddress,RemoteAddressPort]);
		}
		// remove these channels
		if(num >= idx){
			var obj = document.getElementById("UniqueLiraChannel" + num);
			obj.remove();
			hid.value--;
		}
		});		

		// restore next channels from array
		lirach.forEach(function(item, i, arr) {
			//alert(item[0]+"  "+item[1]);
			//OnAddLiraChannel(idx + i, channeltype, sectionname, localaddress, localport, remoteaddress, remoteport) 
			item[1] = ((item[0] == "радио") ? "RADIO-LIRA." : "LIRA.") + (idx + i);
			OnAddLiraChannel(idx + i, item[0], item[1], item[2], item[3], item[4], item[5]);
		});
	}*/
	
}



function getNumFromName(name,str){
	// emamle: num = getNumFromName("ed_ch_radio_lira_5_SectionName",["ed_ch_radio_lira_","_SectionName"]);
	var num = name;
	for ( i = 0; i < str.length; i++) num = num.replace(str[i],"");
	return parseInt(num);
 }

function onChannelTypeChange(obj,idx){
	conname = "ed_ch_radio_lira_"+idx+"_SectionName";
	conobj = document.getElementById(conname);
	
	var localaddress = "";
	var localport = "";
	var remoteaddress = "";
	var remoteport = "";
	var locationtype = "";
	var locationplace = "";

	var aTab = document.getElementById("UniqueLiraChannel" + idx);
	var tbody = aTab.getElementsByTagName('tbody')[0];
	
	if(obj.value == "радио") {
		conobj.value = "RADIO-LIRA."+idx;

	var obj = document.getElementById("ed_ch_radio_lira_"+idx+"_LocationType");
	obj.parentNode.parentNode.parentNode.removeChild(obj.parentNode.parentNode);

	var tr = document.createElement("tr");
	var td = document.createElement("td");
	td.className = "infoLineParam";
	td.colspan = 1;
	td.style.width = "30%";
	td.innerHTML = "LocalAddress";
	tr.appendChild(td);
	
	td = document.createElement("td");
	//td.style.border = "solid black 1px";
	td.style.width = "36%";
	td.className = "infoLineValue";
	td.colspan = 1;
	td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_LocalAddress name=ed_ch_radio_lira_" + idx + "_LocalAddress type=\"text\" class=\"selectw140\" value='" + localaddress + "' type=\"text\" itemtype=\"ip_input\" data-inputmask=\"'alias': 'ip'\" >";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoLineParam";
	td.colspan = 1;
	td.style.width = "10%";
	td.innerHTML = "Port";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoLineValue";
	td.colspan = 1;
	td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_LocalAddressPort name=ed_ch_radio_lira_" + idx + "_LocalAddressPort type=\"text\" class=\"selectw70\" value='" + localport + "' type=\"text\" itemtype=\"port_input\" >";
	tr.appendChild(td);

	tbody.appendChild(tr);
	//tbody.append(tr);


	tr = document.createElement("tr");
	td = document.createElement("td");
	td.className = "infoLineParam";
	td.innerHTML = "RemoteAddress";
	tr.appendChild(td);
	
	td = document.createElement("td");
	td.className = "infoLineValue";
	td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_RemoteAddress name=ed_ch_radio_lira_" + idx + "_RemoteAddress type=\"text\" class=\"selectw140\" value='" + remoteaddress + "' type=\"text\" itemtype=\"ip_input\" data-inputmask=\"'alias': 'ip'\" >";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoLineParam";
	td.innerHTML = "Port";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoLineValue";
	td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_RemoteAddressPort name=ed_ch_radio_lira_" + idx + "_RemoteAddressPort type=\"text\" class=\"selectw70\" value='" + remoteport + "' type=\"text\" itemtype=\"port_input\" >";
	tr.appendChild(td);

	tbody.appendChild(tr);

	inputIpFormat();

	}
	if(obj.value == "РП") {
		conobj.value = "LIRA."+idx;

	var obj = document.getElementById("ed_ch_radio_lira_"+idx+"_LocalAddress");
	obj.parentNode.parentNode.parentNode.removeChild(obj.parentNode.parentNode);
	var obj = document.getElementById("ed_ch_radio_lira_"+idx+"_RemoteAddress");
	obj.parentNode.parentNode.parentNode.removeChild(obj.parentNode.parentNode);

	var tr = document.createElement("tr");
	var td = document.createElement("td");
	td.className = "infoLineParam";
	td.colspan = 1;
	td.style.width = "30%";
	td.innerHTML = "Location";
	tr.appendChild(td);
	
	td = document.createElement("td");
	//td.style.border = "solid black 1px";
	td.style.width = "36%";
	td.className = "infoLineValue";
	td.colspan = 1;
	//td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_LocationType name=ed_ch_radio_lira_" + idx + "_LocationType type=\"text\" class=\"selectw140\" value='" + locationtype + "' type=\"text\">";
/*
	td.innerHTML = "<select name=ed_ch_radio_lira_"+idx+"_LocationType id=ed_ch_radio_lira_"+idx+"_LocationType class=\"selectw140\" >"+
		"<option value=\"Handset\""+GetSelectedString(locationtype, 'Handset')+">Handset</option>"+
		"<option value=\"Headset\""+GetSelectedString(locationtype, 'Headset')+">Headset</option>"+
		"<option value=\"Speaker\""+GetSelectedString(locationtype, 'Speaker')+">Speaker</option>"+
		"<option value=\"Tangenta\""+GetSelectedString(locationtype, 'Tangenta')+">Tangenta</option>"+
		"<option value=\"Table_microphone\""+GetSelectedString(locationtype, 'Table_microphone')+">Table_microphone</option>"+
		"</select>\n";
*/
	td.innerHTML = "<select name=ed_ch_radio_lira_"+idx+"_LocationType id=ed_ch_radio_lira_"+idx+"_LocationType class=\"selectw140\" >"+
		"<option value=\"Телефонная трубка\""+GetSelectedString(locationtype, 'Телефонная трубка')+">Телефонная трубка</option>"+
		"<option value=\"Головная гарнитура\""+GetSelectedString(locationtype, 'Головная гарнитура')+">Головная гарнитура</option>"+
		"<option value=\"Внешний динамик\""+GetSelectedString(locationtype, 'Внешний динамик')+">Внешний динамик</option>"+
		"<option value=\"Тангента\""+GetSelectedString(locationtype, 'Тангента')+">Тангента</option>"+
		"<option value=\"Настольный микрофон\""+GetSelectedString(locationtype, 'Настольный микрофон')+">Настольный микрофон</option>"+
		"</select>\n";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoLineParam";
	td.colspan = 1;
	td.style.width = "11.5%";
	td.innerHTML = "Place";
	tr.appendChild(td);

	td = document.createElement("td");
	td.className = "infoLineValue";
	td.colspan = 1;
	//td.innerHTML = "<input id=ed_ch_radio_lira_" + idx + "_LocationPlace name=ed_ch_radio_lira_" + idx + "_LocationPlace type=\"text\" class=\"selectw70\" value='" + locationplace + "' type=\"text\">";
	td.innerHTML = "<select name=ed_ch_radio_lira_"+idx+"_LocationPlace id=ed_ch_radio_lira_"+idx+"_LocationPlace class=\"selectw70\" >"+
		"<option value=\"1\""+GetSelectedString(locationplace, '1')+">1</option>"+
		"<option value=\"2\""+GetSelectedString(locationplace, '2')+">2</option>"+
		"<option value=\"3\""+GetSelectedString(locationplace, '3')+">3</option>"+
		"<option value=\"4\""+GetSelectedString(locationplace, '4')+">4</option>"+
		"<option value=\"5\""+GetSelectedString(locationplace, '5')+">5</option>"+
		"<option value=\"6\""+GetSelectedString(locationplace, '6')+">6</option>"+
		"<option value=\"7\""+GetSelectedString(locationplace, '7')+">7</option>"+
		"<option value=\"8\""+GetSelectedString(locationplace, '8')+">8</option>"+
		"</select>\n";
	tr.appendChild(td);

	tbody.appendChild(tr);
	}
}




/*class User {

  constructor(name) {
    this.name = name;
  }

  sayHi() {
    alert(this.name);
  }

}*/


/*
function tabRowSorter(obj){

	// тип колонки, строковый/численный, определяется автоматически
	var column_type = 'numeric';

	// номер колонки таблицы
	var td_idx = $(obj).index();
	
	// направление сортировки убывание/возрастание
	var sortorder = obj.getAttribute('sortorder');
	sortorder = (sortorder == '') ? 'asc' : (sortorder == 'asc' ? 'desc' : 'asc');
	obj.setAttribute('sortorder',sortorder);
	
	var td_header = $('tr[id=tab_subscriber_header] td');
	$(td_header).each(function( key, value ) {
		if(this!=obj) this.setAttribute('sortorder','');
	});

	// значения колонки, по которой сортируем и строки таблицы собираем в массив
	// строки таблицы будут сортироваться автоматически при сортировке значений
	var tab=$('tr table[id*=UniqueUACSubscriber]')[0];
	var tbody =$('tbody[id=tbody_subscriber]')[0];
	var row = $("tr[id*=UACSubscriberRow_]",tab);
	var dTab = [];
	$(row).each(function( key, value ) {
		var cell = $("td:eq("+td_idx+") input", this);
		dTab.push( {cell:cell.val(), row:this} );
		if( !Number(cell.val()) ) column_type = 'string';
	});

	// сортировка массива в зависимости от направления
	if(column_type == 'string'){
		dTab.sort((a, b) => {
		  const aU = a.cell.toUpperCase();
		  const bU = b.cell.toUpperCase();
		  var sortdir = sortorder == 'asc' ? 1 : -1;
		  if (aU < bU) return 1*sortdir;
		  if (aU > bU) return -1*sortdir;
		  return 0;
		});
	}
	if(column_type == 'numeric'){
		dTab.sort((a, b) => {
		  const aU = a.cell*1.0000;
		  const bU = b.cell*1.0000;
		  var sortdir = sortorder == 'asc' ? 1 : -1;
		  if (aU < bU) return 1*sortdir;
		  if (aU > bU) return -1*sortdir;
		  return 0;
		});
	}

	// вставляем в таблицу отсортированные строки
	var tr_header = $('tr[id=tab_subscriber_header]')[0];
	$(dTab).each(function( key, value ) {
		$(value.row).insertAfter($(tr_header));
	});
	
}
*/
function tabRowSorter(obj){

	var tr_header = $(obj).parent();	// строка заголовков header
	var tbody = $(tr_header).parent();	// body таблицы
	var tab=  $(tbody).parent();		// сама таблица

	var column_type = 'numeric';		// тип сортировки - строки/числа

	// направление сортировки убывание/возрастание
	var sortorder = obj.getAttribute('sortorder');
	if(sortorder == null) { sortorder = 'asc'; obj.setAttribute('sortorder','asc'); }
	else sortorder = (sortorder == 'asc') ? 'desc' : 'asc';
	obj.setAttribute('sortorder',sortorder);
	
	// сбрасываем порядок сортировки во всех остальных колонках
	var td_header = $('td',tr_header);
	$(td_header).each(function( key, value ) {
		if(this!=obj) this.setAttribute('sortorder','');
	});

	// значения колонки, по которой сортируем и строки таблицы собираем в массив
	// строки таблицы будут сортироваться автоматически при сортировке значений
//	var row = $("tr[datarow=1]",tab); 
	var tab=$('tr table[id*=UniqueUACSubscriber]')[0];
	var tbody =$('tbody[id=tbody_subscriber]')[0];
	var row = $("tr[id*=UACSubscriberRow_]",tab);
	var dTab = [];
	// проверяем содержит ли колонка одни ip адреса
	var check_ip = true;
	$(row).each(function( key, value ) {
		var cell = $("td:eq(" + $(obj).index() + ") input", this);
		check_ip = filter_var(cell.val(),'FILTER_VALIDATE_IP');
		//alert([check_ip,cell.val()]);
		if(!check_ip && cell.val() !='' ) return false;
	});
	if(check_ip){ // если тип колонки ip, добавляем нули, преобразуем в numeric
		$(row).each(function( key, value ) {
			var cell = $("td:eq(" + $(obj).index() + ") input", this);
			var ipaddr = cell.val();
			var inum = ipaddr.split('.');
			var ip0 = inum[0]; if(ip0.length == 1) ip0 = '00'+ip0; if(ip0.length == 2) ip0 = '0'+ip0;
			var ip1 = inum[1]; if(ip1.length == 1) ip1 = '00'+ip1; if(ip1.length == 2) ip1 = '0'+ip1;
			var ip2 = inum[2]; if(ip2.length == 1) ip2 = '00'+ip2; if(ip2.length == 2) ip2 = '0'+ip2;
			var ip3 = inum[3]; if(ip3.length == 1) ip3 = '00'+ip3; if(ip3.length == 2) ip3 = '0'+ip3;
			var ip = ip0+ip1+ip2+ip3;
			dTab.push( {cell:ip, row:this} );
			if( !Number(ip) ) column_type = 'string';
			else column_type = 'numeric';
		});
	} else {
		$(row).each(function( key, value ) {
			var cell = $("td:eq(" + $(obj).index() + ") input", this);
			dTab.push( {cell:cell.val(), row:this} );
			if( !Number(cell.val()) ) column_type = 'string';
		});
	}
	/* формат массива
	var dTab = [ 
		{cell:"Банан", row:"html_object_row"}, 
		{cell:"Арбуз", row:"html_object_row"}, 
		{cell:"Яблоко", row:"html_object_row"}, 
		{cell:"Курага", row:"html_object_row"}, 
		{cell:"Фундук", row:"html_object_row"}, 
		{cell:"Финик", row:"html_object_row"} 
	];*/

	// сортировка массива в зависимости от направления и типа данных
	if(column_type == 'string'){
		dTab.sort((a, b) => {
		  const aU = a.cell.toUpperCase();
		  const bU = b.cell.toUpperCase();
		  var sortdir = sortorder == 'asc' ? 1 : -1;
		  if (aU < bU) return 1*sortdir;
		  if (aU > bU) return -1*sortdir;
		  return 0;
		});
	}
	if(column_type == 'numeric'){
		dTab.sort((a, b) => {
		  const aU = a.cell*1.0000;
		  const bU = b.cell*1.0000;
		  var sortdir = sortorder == 'asc' ? 1 : -1;
		  if (aU < bU) return 1*sortdir;
		  if (aU > bU) return -1*sortdir;
		  return 0;
		});
	}

	// вставляем в таблицу отсортированные строки
	$(dTab).each(function( key, value ) {
		$(value.row).insertAfter($(tr_header));
	});

}




function filter_var(strval,filtertype){ // аналог php
	var res = true;
	if(filtertype == 'FILTER_VALIDATE_IP'){
		var ipaddr = strval.split(':');
		var iport = ipaddr.length == 2 ? ipaddr[1] : NaN;
		if( iport != NaN && (0 > parseInt(Number(iport)) || parseInt(Number(iport)) > 65535) ) { res = false; return res; }
		var inum = ipaddr[0].split('.');
		//alert( [ inum.length, inum[0].length, inum[1].length, inum[2].length, inum[3].length ] );
		
		if( inum.length == 4 && 0 < inum[0].length && inum[0].length < 4 && 0 < inum[1].length && inum[1].length < 4 && 0 < inum[2].length && inum[2].length < 4 && 0 < inum[3].length && inum[3].length < 4  ){
			if( !(0 <= parseInt(Number(inum[0])) && parseInt(Number(inum[0])) <= 256 && 
				0 <= parseInt(Number(inum[1])) && parseInt(Number(inum[1])) <= 256 && 
				0 <= parseInt(Number(inum[2])) && parseInt(Number(inum[2])) <= 256 && 
				0 <= parseInt(Number(inum[3])) && parseInt(Number(inum[3])) <= 256)
			) res = false;
		} else res = false;
		
	}
	
	return res;
}






// -----------------------------------------------------------------------------------------------------------

function OnAddAudioChannel(idx, channeltype, sectionname, iddevice, outdevice) {
	var hid = document.getElementById("hidAudioChannelCount");

	/*if (!idx || (idx < 0)){
		idx = 0;
		while( $("table[id=UniqueAudioChannel"+idx+"]").length > 0 ){
			idx++;
		}
	}*/
	
	if (!sectionname) sectionname = "AUDIO."+idx;
	
	if (!iddevice) iddevice = "";
	if (!outdevice) outdevice = "";
	

	//table
	var aTab = document.createElement("table");
	aTab.id = "UniqueAudioChannel" + idx;
	aTab.width = '100%';

	aTab.cellPadding = 0;
	aTab.cellSpacing = 0;
	aTab.setAttribute("style", "float:left;background:" + GetAltColor(idx, 1, true));
	aTab.style.cssText = "background:" + GetAltColor(idx, 1, true);
	aTab.style.marginTop = "10px";
	aTab.setAttribute("block_type","AudioChannel");
	var tbody = document.createElement("tbody");


	var tr = document.createElement("tr");
	var td = document.createElement("td");
	td.colSpan = 1;
	td.className = "editTableHeader";
	td.innerHTML = "<div style=\"display:inline;float:left\">&nbsp;Канал "+idx+":&nbsp;</div>";
	tr.appendChild(td);
	var td = document.createElement("td");
	td.colSpan = 3;
	td.className = "editTableHeader";
	td.align = "right";
	tr.appendChild(td);
	tbody.appendChild(tr);


	tr = document.createElement("tr");
	td = document.createElement("td");
	td.className = "infoLineParamMiddle";
	td.colSpan = 1;
	td.style.width = "20%";
	td.innerHTML = "Соединение";
	tr.appendChild(td);
	td = document.createElement("td");
	td.className = "infoLineValue";
	td.colSpan = 3;
	td.style.width = "80%";
	td.innerHTML = "<input id=ed_ch_audio_" + idx + "_SectionName name=ed_ch_audio_" + idx + "_SectionName type=\"text\" class=\"selectw280\" value=\"" + sectionname + "\" disabled>";
	tr.appendChild(td);
	tbody.appendChild(tr);

	tr = document.createElement("tr");
	td = document.createElement("td");
	td.className = "infoLineParamMiddle";
	td.colSpan = 1;
	td.style.width = "20%";
	td.innerHTML = "InDevice";
	tr.appendChild(td);
	td = document.createElement("td");
	td.className = "infoLineValue";
	td.colSpan = 3;
	td.style.width = "80%";
	td.innerHTML = "<input id=ed_ch_audio_" + idx + "_InDevice name=ed_ch_audio_" + idx + "_InDevice type=\"text\" class=\"selectw280\" value=\"" + iddevice + "\" maxlength=\"18\" disabled>";
	tr.appendChild(td);
	tbody.appendChild(tr);

	tr = document.createElement("tr");
	td = document.createElement("td");
	td.className = "infoLineParamMiddle";
	td.colSpan = 1;
	td.style.width = "20%";
	td.innerHTML = "OutDevice";
	tr.appendChild(td);
	td = document.createElement("td");
	td.className = "infoLineValue";
	td.colSpan = 3;
	td.style.width = "80%";
	td.innerHTML = "<input id=ed_ch_audio_" + idx + "_OutDevice name=ed_ch_audio_" + idx + "_OutDevice type=\"text\" class=\"selectw280\" value=\"" + outdevice + "\" maxlength=\"18\" disabled>";
	tr.appendChild(td);
	tbody.appendChild(tr);

	
	aTab.appendChild(tbody);
	hid.parentNode.insertBefore(aTab, hid);

}

