#!/bin/bash

# This is install/upgrade script for ksrs technical software

MainKSRSDir=/opt/ksrs-tech
KSRSTechGUIDir=gui
KSRSTechGUIBin=KARSControl
KSRSTechGUISrc=../TechControl/SNMP/Linux/Fedora
KSRSCollectorDir=snmp
KSRSCollectorBin=snmp-collector
KSRSCollectorScr=..TechControl/Modules/Linux/Fedora
KSRSCollectorTrapFwd=..Dependencies/Common/process-trap-forward.php
KSRSDataBaseDir=base
TechKSRSUnits="../TechControl/Modules/Linux/Fedora"
TechKSRSSNMPUnits="../TechControl/SNMP/Linux/Fedora"
TechKSRSDBUnits="../TechControl/DB"
TechKSRSDBSrc="AERO.fbk"
TechKSRSDB="AERO.fdb"
TechKSRSDBPatches=patches
TechKSRSDBBackup=bk
TermKSRSLibs="/etc/ld.so.conf.d/ksrs-terminal.conf"
TechKSRSLibs="/etc/ld.so.conf.d/ksrs-tech.conf"

KSRSGUIUser=user0
KSRSAutoGUI=KARSTech.desktop
KSRSAutoGUIContent="[Desktop Entry]
Type=Application
Exec=/opt/ksrs-tech/gui/KARSControl
Hidden=false
NoDisplay=false
X-GNOME-Autostart-enabled=true
Name[ru_RU]=KSRS Technical Control
Name=KSRS Technical Control
Comment[ru_RU]=
Comment="

KSRSAutoLoginContent="[base]
autologin=user0
session=/usr/bin/openbox-session
greeter=/usr/libexec/lxdm-greeter-gtk

[server]
arg=/usr/bin/X -background none vt1

[display]
gtk_theme=Clearlooks
bg=/usr/share/backgrounds/default.png
bottom_pane=1
lang=1
keyboard=0
theme=Industrial

[input]

[userlist]
disable=0
white=
black=
"

# 0. Check for root access
printf "checking for user access.. "
if [ $(whoami) != "root" ]; then
  echo "fail [need root access]"
  exit 1
else
  echo "ok"
fi

# 1. Check dependencies
#look packages
printf "checking for rpm dependences.. "
rpmList=$(rpm -qa | grep -e qt-4.8 -e qt-x11 -e qt-ibase -e net-snmp -e php -e lxdm -e openbox -e firebird)
rpmQTMain=0
rpmQTX11=0
rpmQTIBase=0
rpmPHP=0
rpmSNMP=0
rpmSNMPUtils=0
rpmLXDM=0
rpmOPENBOX=0
rpmFIREBIRD=0
for aPacket in $rpmList; do
  if [ "$rpmQTMain" -eq 0 ]; then
    if [[ $aPacket == qt-4.8* ]]; then
      rpmQTMain=1
      continue
    fi
  fi
  if [ "$rpmQTX11" -eq 0 ]; then
    if [[ $aPacket == qt-x11* ]]; then
      rpmQTX11=1
      continue
    fi
  fi
  if [ "$rpmQTIBase" -eq 0 ]; then
    if [[ $aPacket == qt-ibase* ]]; then
      rpmQTIBase=1
      continue
    fi
  fi
  if [ "$rpmPHP" -eq 0 ]; then
    if [[ $aPacket == php* ]]; then
      rpmPHP=1
      continue
    fi
  fi
  if [ "$rpmSNMP" -eq 0 ]; then
    if [[ $aPacket == net-snmp-agent* ]]; then
      rpmSNMP=1
      continue
    fi
  fi
  if [ "$rpmSNMPUtils" -eq 0 ]; then
    if [[ $aPacket == net-snmp-utils* ]]; then
      rpmSNMPUtils=1
      continue
    fi
  fi
  if [ "$rpmLXDM" -eq 0 ]; then
    if [[ $aPacket == lxdm-* ]]; then
      rpmLXDM=1
      continue
    fi
  fi
  if [ "$rpmOPENBOX" -eq 0 ]; then
    if [[ $aPacket == openbox-* ]]; then
      rpmOPENBOX=1
      continue
    fi
  fi
  if [ "$rpmFIREBIRD" -eq 0 ]; then
    if [[ $aPacket == firebird-classic* ]]; then
      rpmFIREBIRD=1
      continue
    fi
  fi
  if [ "$rpmFIREBIRD" -eq 0 ]; then
    if [[ $aPacket == firebird-superclassic* ]]; then
      rpmFIREBIRD=1
      continue
    fi
  fi
  if [ "$rpmFIREBIRD" -eq 0 ]; then
    if [[ $aPacket == firebird-superserver* ]]; then
      rpmFIREBIRD=1
      continue
    fi
  fi
done
if [ "$rpmQTIBase" -eq 0 -o "$rpmQTMain" -eq 0 -o "$rpmQTX11" -eq 0 -o "$rpmPHP" -eq 0 -o "$rpmSNMP" -eq 0 -o "$rpmSNMPUtils" -eq 0 -o "$rpmLXDM" -eq 0 -o "$rpmOPENBOX" -eq 0 -o "$rpmFIREBIRD" -eq 0 ]; then
  echo "fail"
  if [ "$rpmQTMain" -eq 0 ]; then
    echo "package <qt> is not accessible"
  fi
  if [ "$rpmQTX11" -eq 0 ]; then
    echo "package <qt-x11> is not accessible"
  fi
  if [ "$rpmQTIBase" -eq 0 ]; then
    echo "package <qt-ibase> is not accessible"
  fi
  if [ "$rpmPHP" -eq 0 ]; then
    echo "package <php> is not accessible"
  fi
  if [ "$rpmSNMP" -eq 0 ]; then
    echo "package <net-snmp> is not accessible"
  fi
  if [ "$rpmSNMPUtils" -eq 0 ]; then
    echo "package <net-snmp-utils> is not accessible"
  fi
  if [ "$rpmLXDM" -eq 0 ]; then
    echo "package <lxdm> is not accessible"
  fi
  if [ "$rpmOPENBOX" -eq 0 ]; then
    echo "package <openbox> is not accessible"
  fi
  if [ "$rpmFIREBIRD" -eq 0 ]; then
    echo "package <firebird-{some server}> is not accessible"
  fi  
  exit 1
fi
echo "ok"

# 2. (re)Place binary files
#create main binary directory (if need)
if ! [ -d $MainKSRSDir ]; then
  printf "create main directory for binary ($MainKSRSDir).. "
  if [ $(mkdir -m755 $MainKSRSDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
#create gui directory (if need)
if ! [ -d "$MainKSRSDir/$KSRSTechGUIDir" ]; then
  printf "create gui directory for binary ($MainKSRSDir/$KSRSTechGUIDir).. "
  if [ $(mkdir -m777 $MainKSRSDir/$KSRSTechGUIDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
#create snmp directory (if need)
if ! [ -d "$MainKSRSDir/$KSRSCollectorDir" ]; then
  printf "create snmp collector directory for binary ($MainKSRSDir/$KSRSCollectorDir).. "
  if [ $(mkdir -m755 $MainKSRSDir/$KSRSCollectorDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
#create db directory (if need)
if ! [ -d "$MainKSRSDir/$KSRSDataBaseDir" ]; then
  printf "create database directory ($MainKSRSDir/$KSRSDataBaseDir).. "
  if [ $(mkdir -m744 $MainKSRSDir/$KSRSDataBaseDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chown database directory ($MainKSRSDir/$KSRSDataBaseDir) to firebird user.. "
    if [ $(chown firebird:firebird $MainKSRSDir/$KSRSDataBaseDir) ]; then
      echo "fail"
    else
      echo "ok"
    fi
  fi
fi
if ! [ -d "$MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBPatches" ]; then
  printf "create patch database directory ($MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBPatches).. "
  if [ $(mkdir -m666 $MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBPatches) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
if ! [ -d "$MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBBackup" ]; then
  printf "create backup database directory ($MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBBackup).. "
  if [ $(mkdir -m755 $MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBBackup) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
#copy files
#gui
ksrsFiles=$(ls $TechKSRSUnits)
for afile in $ksrsFiles; do
  printf "copy technical gui file ($afile).. "
  if [ $(cp -f $TechKSRSUnits/$afile $MainKSRSDir/$KSRSTechGUIDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chmod technical gui file ($afile) to 777.. "
    if [ $(chmod -f 777 $MainKSRSDir/$KSRSTechGUIDir/$afile) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  fi
done
#snmp-collector
ksrsFiles=$(ls $TechKSRSSNMPUnits)
for afile in $ksrsFiles; do
  printf "copy snmp-collector file ($afile).. "
  if [ $(cp -f $TechKSRSSNMPUnits/$afile $MainKSRSDir/$KSRSCollectorDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chmod snmp-collector file ($afile) to 755.. "
    if [ $(chmod -f 755 $MainKSRSDir/$KSRSCollectorDir/$afile) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  fi
done
printf "copy snmp-collector trap forward script ($KSRSCollectorTrapFwd) in /usr/bin.. "
if [ $(cp -f $KSRSCollectorTrapFwd "/usr/bin") ]; then
  echo "fail"
  exit 1
else
  echo "ok"
fi
#database
##prototype
printf "copy database prototype file ($TechKSRSDBUnits/$TechKSRSDBSrc).. "
if [ $(cp -f $TechKSRSDBUnits/$TechKSRSDBSrc $MainKSRSDir/$KSRSDataBaseDir) ]; then
  echo "fail"
  exit 1
else
  echo "ok"
  printf "chmod database prototype file ($MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBSrc) to 644.. "
  if [ $(chmod -f 644 $MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBSrc) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
##patches
ksrsFiles=$(ls $TechKSRSDBUnits/$TechKSRSDBPatches)
for afile in $ksrsFiles; do
  printf "copy patch database file ($afile).. "
  if [ $(cp -f $TechKSRSDBUnits/$TechKSRSDBPatches/$afile $MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBPatches) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chmod patch database file ($afile) to 644.. "
    if [ $(chmod -f 644 $MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBPatches/$afile) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  fi
done

# 3. (re)Register libs - terminal libs has priority!
if ! [ -f $TermKSRSLibs ]; then
  if ! [ -f $TechKSRSLibs ]; then
    printf "create ($TechKSRSLibs) with content ($MainKSRSDir/$KSRSTechGUIDir).. "
    if [ $(echo "$MainKSRSDir/$KSRSTechGUIDir" > $TechKSRSLibs) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  else
    tmpStr=$(cat $TechKSRSLibs)
    if [ "$tmpStr" != "$MainKSRSDir/$KSRSTechGUIDir" ]; then
      printf "rewrite library references($tmpStr) to ($MainKSRSDir/$KSRSTechGUIDir).. "
      if [ $(echo "$MainKSRSDir/$KSRSTechGUIDir" > $TechKSRSLibs) ]; then
        echo "fail"
        exit 1
      else
        echo "ok"
      fi
    fi
  fi
  printf "renew library references.. "
  if [ $(ldconfig) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
else
  echo "warning: found ($TermKSRSLibs) library - gui will use it"
fi
# 4-5 ToDo

# 6. autologin and autostart
printf "checking user <$KSRSGUIUser>.. "
if ! [ -d "/home/$KSRSGUIUser" ]; then
  echo "absent"
  printf "creating gui terminal user.. "
  if [ $(adduser $KSRSGUIUser --password 1234) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
else
  echo "exists"
fi
if ! [ -d "/home/$KSRSGUIUser/.config" ]; then
  printf "creating gui terminal user config directory.. "
  if [ $(mkdir /home/$KSRSGUIUser/.config) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
if ! [ -d "/home/$KSRSGUIUser/.config/autostart" ]; then
  printf "creating gui terminal user autostart directory.. "
  if [ $(mkdir /home/$KSRSGUIUser/.config/autostart) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
printf "renew gui terminal user autostart script.. "
if [ $(echo "$KSRSAutoGUIContent" > /home/$KSRSGUIUser/.config/autostart/$KSRSAutoGUI) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "renew gui terminal user autologin script.. "
if [ $(echo "$KSRSAutoLoginContent" > /etc/lxdm/lxdm.conf) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "renew systemd user level link.. "
if [ $(ln -sf /usr/lib/systemd/system/graphical.target /etc/systemd/system/default.target) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
echo "Setup terminal software completed successfully. Please reboot operationg system!"
# normal exit
exit 0

echo "Setup technical software completed successfully. Please reboot operationg system!"
# normal exit
exit 0
