#!/bin/bash

# Переменные для настройки

#из даты выделяет только время
curdate=`date +%X`

# берет только дату
bkdate=`date +%F`

#расположение саомй базы, ну и собственно ее полное название
dbpath=127.0.0.1:/var/ksrs/base/AERO.FDB

#здесь можно заменить на любое удобное название, оно будет подставляться в начало названия бэкапа
db=AERO.FDB
dbuser=SYSDBA
dbpassword=masterkey
lock=/var/ksrs/base/bk/dbbback.lock

#путь где будет располагаться бэкап
bkpath=/var/ksrs/base/bk/$bkdate
cdpath=/var/ksrs/base/bk

#бэкап будет находится в папке "bk", а в ней уже будут создаваться каталоги по датам, в которых быкапы по каждой дате соотвественно
bkfile=$bkpath/$db-$curdate.fbk

if [ -e $lock ]
then
  echo "Backup already running"
else
  touch $lock
  if [ -e $bkpath ]
  then
    /usr/local/firebird/bin/gbak -b -g $dbpath $bkfile -user $dbuser -pas $dbpassword
  else
    mkdir -p $bkpath
    /usr/local/firebird/bin/gbak -b -g $dbpath $bkfile -user $dbuser -pas $dbpassword
  fi

  #Удаляем старые каталоги старше N дней, здесь стоит +8, т.е. будут удалены каталоги с бэкапами старше 7 дней

  cd  $cdpath  && ls -t | tail -n+8 | xargs -i rm -rv '{}'

  # Упаковываем при помощи архиватора xz

  /usr/bin/xz -9 $bkfile

  #Полное имя файла после архивирования.
  scpfile=$bkfile.xz

  #Создаем каталог по дате + удаляем устаревшие бэкапы
  /usr/bin/sshpass -p "12345678" /usr/bin/ssh root@192.168.12.102 "mkdir -p $bkpath; cd $cdpath && ls -t | tail -n+8 | xargs -i rm -rv '{}'; exit"
  
  #Копируем на удаленную машину.
  /usr/bin/sshpass -p "12345678" /usr/bin/scp -r $scpfile root@192.168.12.102:$bkpath 

  rm -f $lock
fi
