#!/bin/bash

# bash -vx
curdate=`date +%X`
bkdate=`date +%F`
db=AERO.FDB
dbpath=/var/ksrs/base
dbuser=SYSDBA
dbpassword=masterkey

#Firebird path
fb_root=/usr/local/firebird
#fb_root=/opt/fb25ss
fb_bin=${fb_root}/bin

cdpath=/var/ksrs/base/bk
bkpath=/var/ksrs/base/bk/$bkdate

bkrestore=/var/ksrs/base/restore/$db.fbk

bkfile=$bkpath/$db-$curdate.fbk

logfile=$dbpath/backup.log
lock=$dbpath/backup.lock

tmp_db=0tmp$db

msg()
{
	echo "$1"
	echo "`date +%X`:  $1" >> $logfile
}

msg1()
{
	echo "$1"
	echo "$1" >> $logfile
}

packbackup()
{
	msg "removing old files..." 
	cd $cdpath && ls -t | tail -n+30 | xargs -i rm -rv '{}'
	msg "packing backup..." 
	/usr/bin/xz -9 $bkfile
	msg "packing backup...DONE" 
	msg "copying backup..." 
	scpfile=$bkfile.xz
	/usr/bin/sshpass -p "12345678" /usr/bin/ssh root@192.168.12.102 "mkdir -p $bkpath; cd $cdpath && ls -t | tail -n+8 | xargs -i rm -rv '{}'; exit"
	/usr/bin/sshpass -p "12345678" /usr/bin/scp -r $scpfile root@192.168.12.102:$bkpath
	msg "copying backup...DONE" 
}

if [ -e $lock ]; then
	msg "Backup already running"
else
	touch $lock

	msg1 ""
	msg1 "================================================"
	msg1 "$(date +'%d-%b-%Y %R')"

	msg "stopping collector..." 
	service lemz-snmp-collector stop
	#killall KARSControl
	msg "stopping collector...DONE" 

	msg "shutting down database..." 
	${fb_bin}/gfix -shut -force 10 -user $dbuser -password $dbpassword $dbpath/$db
	msg "shutting down database...DONE" 

	msg "gfix 1..."
	gfix1=$(${fb_bin}/gfix -v -full -user $dbuser -password $dbpassword $dbpath/$db) 
	msg "gfix1 result: $gfix1"

	if [ "$gfix1" ]; then
		msg "mending database..."
		${fb_bin}/gfix -mend -user $dbuser -password $dbpassword $dbpath/$db >> $logfile 2>&1
		msg "mending database...DONE"

		#echo "---gfix 2---"
		#echo "-------gfix 2-------" >> $logfile
		#${fb_bin}/gfix -v -full -user $dbuser -password $dbpassword $dbpath/$db >> $logfile 2>&1

		msg "gbak-after-mend..."
		rm -f $bkrestore
		${fb_bin}/gbak -b -g $dbpath/$db $bkrestore -user $dbuser -pas $dbpassword >> $logfile 2>&1
		msg "gbak-after-mend...DONE"
		#echo $?

		if [ $? == 0 ]; then
			msg "backup created. starting restore..."

			msg "stopping firebird server..."
			service firebird-superserver stop || service firebird stop 
			msg "stopping firebird server...DONE"

			mv -f -T $dbpath/$db $dbpath/$tmp_db && msg "file $tmp_db created"

			msg "starting firebird server..."
			service firebird-superserver start || service firebird start
			msg "starting firebird server...DONE"

			if [ -f $dbpath/$tmp_db ]; then
				msg "restoring to a temporary database..."
				${fb_bin}/gbak -r -v -rep $bkrestore 127.0.0.1:$dbpath/$db -user $dbuser -pas $dbpassword && msg "database created successfully!"
				msg "restoring to a temporary database...DONE"

				msg "gfix-after-restore..." 
				gfix2=$(${fb_bin}/gfix -v -full -user $dbuser -password $dbpassword $dbpath/$db)
				msg "gfix2 result: $gfix2"

				if [ "$gfix2" ]; then
					msg "errors are not corrected after database restore!" 
				else
					if [ ! -e $bkpath ]; then
						mkdir -p $bkpath
					fi	
					msg "gbak-after-restore..." 
					${fb_bin}/gbak -b -g $dbpath/$db $bkfile -user $dbuser -pas $dbpassword
					msg "gbak-after-restore...DONE" 
					msg "backup created after restore!" >> $logfile

					packbackup 
				fi
			else
				msg "database file is not saved. database is not restored!" 
			fi
		else
			msg "backup not created!"
		fi
	else
		if [ ! -e $bkpath ]; then
			mkdir -p $bkpath
		fi

		msg "gbak-normal..." 
		${fb_bin}/gbak -b -g $dbpath/$db $bkfile -user $dbuser -pas $dbpassword
		msg "gbak-normal...DONE" 
		msg "backup created successfully!" 

		packbackup  
	fi

	msg "setting database online..." 
	${fb_bin}/gfix -online normal -user $dbuser -password $dbpassword $dbpath/$db
	msg "setting database online...DONE" 

	msg "starting collector..." 
	service lemz-snmp-collector start
	msg "starting collector...DONE" 

	rm -f $bkrestore
	rm -f $lock
	msg "finished. you can go home now." 
fi

#scpfile=$bkfile.bz2
#sshpass -p "123456" ssh root@192.168.1.93 " mkdir -p /lemz/$bkdate; cd /lemz && ls -t | tail -n+5 | xargs -i rm -rv '{}'; exit"
#sshpass -p "123456" scp -r /$scpfile  root@192.168.1.93:/lemz/$bkdate
