#!/bin/bash

# This is install/upgrade script for ksrs terminal software

MainKSRSDir=/opt/ksrs-terminal
KSRSServerDir=server
KSRSServerBin=krs-terminal-server
KSRSAgentDir=agent
KSRSAgentBin=snmp-agent
KSRSGUIDir=gui
TermKSRSUnits="../Terminal/Modules/Linux/Fedora"
TermLIRADrv="../Terminal/Drv/Linux"
TermLIRAModules="$TermLIRADrv/modules"
TermKSRSLibs="/etc/ld.so.conf.d/ksrs-terminal.conf"
KSRSCollectorTrapFwdFile="process-trap-forward.php"
KSRSCollectorTrapFwd="../Dependencies/Common/$KSRSCollectorTrapFwdFile"
KSRSTermServiceName=lemz-ksrs-terminal
KSRSTermService="/usr/lib/systemd/system/$KSRSTermServiceName.service"
KSRSTermServiceContent="[Unit]
Description=System KSRS terminal Service
Requires=network.target
After=network.target network.service

[Service]
Type=simple
Environment=LOGNAME=root
ExecStart=$MainKSRSDir/$KSRSServerDir/$KSRSServerBin --run
ExecStop=/usr/bin/killall -w -SIGINT $KSRSServerBin
Restart=on-failure
StandardOutput=null

[Install]
WantedBy=multi-user.target"
KSRSTermAgentName=lemz-snmp-agent
KSRSTermAgent="/usr/lib/systemd/system/$KSRSTermAgentName.service"
KSRSTermAgentContent="[Unit]
Description=System SNMP KSRS Agent Service
Requires=network.target
After=network.target runlevel1.target

[Service]
Type=simple
ExecStart=$MainKSRSDir/$KSRSAgentDir/$KSRSAgentBin --run
ExecStop=/usr/bin/killall -w -SIGINT $KSRSAgentBin
Restart=on-failure
StandardOutput=null

[Install]
WantedBy=multi-user.target"

SNMPRegex="^net-snmp-[0-9]+"


SNMPTrapServiceName="snmptrapd"
KSRSsnmptrapdConfContent="ignoreAuthFailure yes
disableAuthorization yes
snmpTrapdAddr UDP:162
traphandle default /usr/bin/php /usr/bin/$KSRSCollectorTrapFwdFile"
SNMPTRAPDMAINPID='$MAINPID'
KSRSSNMPTRAPDSevice="/usr/lib/systemd/system/$SNMPTrapServiceName.service"
SNMPTRAPDServiceContent="[Unit]
Description=Simple Network Management Protocol (SNMP) Trap Daemon.
After=syslog.target network.target

[Service]
Type=notify
EnvironmentFile=-/etc/sysconfig/snmptrapd
ExecStart=/usr/sbin/snmptrapd -Ln -f -On -n
ExecReload=/bin/kill -HUP $SNMPTRAPDMAINPID

[Install]
WantedBy=multi-user.target"


SNMPServiceName="snmpd"
KSRSTermOID=".1.3.6.1.4.1.120312.3"
KSRSsnmpdConModule="process-terminal-agent.php"
KSRSsnmpdConModuleSRC="../Dependencies/Common/$KSRSsnmpdConModule"
KSRSsnmpdConfContent="trap2sink 192.168.12.101 public
trap2sink 192.168.12.102 public
rwcommunity public 192.168.12.101
rwcommunity public 192.168.12.102
disk /
disk /opt
createUser internal
rouser internal
agentSecName internal
iquerySecName internal
defaultMonitors yes
notificationEvent  linkUpTrap    linkUp   ifIndex ifAdminStatus ifOperStatus
notificationEvent  linkDownTrap  linkDown ifIndex ifAdminStatus ifOperStatus
monitor  -r 10 -e linkUpTrap   \"Generate linkUp\"   ifOperStatus != 2
monitor  -r 10 -e linkDownTrap \"Generate linkDown\" ifOperStatus == 2
pass_persist $KSRSTermOID /usr/bin/php /usr/bin/$KSRSsnmpdConModule"
SNMPDMAINPID='$MAINPID'
KSRSSNMPAgent="/usr/lib/systemd/system/$SNMPServiceName.service"
SNMPDServiceContent="[Unit]
Description=Simple Network Management Protocol (SNMP) Daemon.
After=syslog.target network.target

[Service]
Type=notify
EnvironmentFile=-/etc/sysconfig/snmpd
ExecStart=/usr/sbin/snmpd -Ln -f
ExecReload=/bin/kill -HUP $SNMPDMAINPID

[Install]
WantedBy=multi-user.target"

KSRSGUIUser=user0
KSRSAutoGUI=KARSTerminal.desktop
KSRSAutoGUIContent="[Desktop Entry]
Type=Application
Exec=/opt/ksrs-terminal/gui/KARSTerminal 2>/dev/null
Hidden=false
NoDisplay=false
X-GNOME-Autostart-enabled=true
Name[ru_RU]=KSRS Terminal
Name=KSRS Terminal
Comment[ru_RU]=
Comment="

KSRSAutoLoginContent="[base]
autologin=user0
session=/usr/bin/openbox-session
greeter=/usr/libexec/lxdm-greeter-gtk

[server]
arg=/usr/bin/X -background none vt1

[display]
gtk_theme=Clearlooks
bg=/usr/share/backgrounds/default.png
bottom_pane=1
lang=1
keyboard=0
theme=Industrial

[input]

[userlist]
disable=0
white=
black=
"

TermCronConf="/etc/cron.d/cron_ksrs_term"
TermKSRSScripts=scripts

KSRScronConfContent="
SHELL=/bin/bash
PATH=/sbin:/bin:/usr/sbin:/usr/bin
MAILTO=root
0 3 * * * root $MainKSRSDir/$TermKSRSScripts/remove_logs.sh"

# 0. Check for root access
printf "checking for user access.. "
if [ $(whoami) != "root" ]; then
  echo "fail [need root access]"
  exit 1
else
  echo "ok"
fi

hostip=$(ifconfig | grep -Eo 'inet (addr:)?([0-9]*\.){3}[0-9]*' | grep -Eo '([0-9]*\.){3}[0-9]*' | grep -v '127.0.0.1')
echo "host ip is $hostip"
for TechIP in "192.168.12.1" "192.168.12.2" "192.168.12.3" "192.168.12.4" "192.168.12.5"
do
if [[ $hostip == $TechIP ]]; then
echo "is tech host, terminal software cannot be installed"
sleep 5
exit 1
fi
done

# 1. Check dependencies
#look packages
printf "checking for rpm dependences.. "
rpmList=$(rpm -qa | grep -e qt-4.8 -e qt-x11 -e net-snmp -e php -e lxdm -e openbox)
rpmQTMain=0
rpmQTX11=0
rpmPHP=0
rpmSNMP=0
rpmSNMPAgent=0
rpmSNMPUtils=0
rpmLXDM=0
rpmOPENBOX=0
for aPacket in $rpmList; do
  if [ "$rpmQTMain" -eq 0 ]; then
    if [[ $aPacket == qt-4.8* ]]; then
      rpmQTMain=1
      continue
    fi
  fi
  if [ "$rpmQTX11" -eq 0 ]; then
    if [[ $aPacket == qt-x11* ]]; then
      rpmQTX11=1
      continue
    fi
  fi
  if [ "$rpmPHP" -eq 0 ]; then
    if [[ $aPacket == php* ]]; then
      rpmPHP=1
      continue
    fi
  fi
  if [ "$rpmSNMP" -eq 0 ]; then
    if [[ $aPacket =~ $SNMPRegex ]]; then
      rpmSNMP=1
      continue
    fi
  fi
  if [ "$rpmSNMPAgent" -eq 0 ]; then
    if [[ $aPacket == net-snmp-agent* ]]; then
      rpmSNMPAgent=1
      continue
    fi
  fi  
  if [ "$rpmSNMPUtils" -eq 0 ]; then
    if [[ $aPacket == net-snmp-utils* ]]; then
      rpmSNMPUtils=1
      continue
    fi
  fi
  if [ "$rpmLXDM" -eq 0 ]; then
    if [[ $aPacket == lxdm-* ]]; then
      rpmLXDM=1
      continue
    fi
  fi
  if [ "$rpmOPENBOX" -eq 0 ]; then
    if [[ $aPacket == openbox-* ]]; then
      rpmOPENBOX=1
      continue
    fi
  fi
done
if [ "$rpmQTMain" -eq 0 -o "$rpmQTX11" -eq 0 -o "$rpmPHP" -eq 0 -o "$rpmSNMP" -eq 0 -o "$rpmSNMPAgent" -eq 0 -o "$rpmSNMPUtils" -eq 0 -o "$rpmLXDM" -eq 0 -o "$rpmOPENBOX" -eq 0 ]; then
  echo "fail"
  if [ "$rpmQTMain" -eq 0 ]; then
    echo "package <qt> is not accessible"
  fi
  if [ "$rpmQTX11" -eq 0 ]; then
    echo "package <qt-x11> is not accessible"
  fi
  if [ "$rpmPHP" -eq 0 ]; then
    echo "package <php> is not accessible"
  fi
  if [ "$rpmSNMP" -eq 0 ]; then
    echo "package <net-snmp> is not accessible"
  fi
  if [ "$rpmSNMPAgent" -eq 0 ]; then
    echo "package <net-snmp-agent> is not accessible"
  fi  
  if [ "$rpmSNMPUtils" -eq 0 ]; then
    echo "package <net-snmp-utils> is not accessible"
  fi
  if [ "$rpmLXDM" -eq 0 ]; then
    echo "package <lxdm> is not accessible"
  fi
  if [ "$rpmOPENBOX" -eq 0 ]; then
    echo "package <openbox> is not accessible"
  fi
  exit 1
fi
echo "ok"
#look kernel module
ft245DeviceMod=$(lsmod | grep -o ft245)
printf "checking for ft245 prescence.. "
if [ "bm$ft245DeviceMod" == "bmft245" ]; then
  echo "yes"
else
  echo "no"
  kernelVersion=$(uname -r)
  printf "try find ft245 module for kernel ($kernelVersion).. "
  if [ -f "$TermLIRAModules/$kernelVersion/ft245.ko" ]; then
    echo "found"
    #install module to the system
    if ! [ -d "/usr/lib/modules/$kernelVersion/lira" ]; then
      printf "create lira module directory (/usr/lib/modules/$kernelVersion/lira).. "
      if [ $(mkdir /usr/lib/modules/$kernelVersion/lira) ]; then
        echo "fail"
        exit 1
      else
        echo "ok"
      fi
    fi
    printf "copy lira driver module.. "
    if [ $(cp -f "$TermLIRAModules/$kernelVersion/ft245.ko" /usr/lib/modules/$kernelVersion/lira) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
    printf "copy lira driver udev configuration.. "
    if [ $(cp -f "$TermLIRADrv/99-lira.rules" /etc/udev/rules.d) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
    printf "loading lira driver module.. "
    if [ $(insmod /usr/lib/modules/$kernelVersion/lira/ft245.ko) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
    printf "reloading driver module dependencies.. "
    if [ $(depmod -a) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  else
    echo "not found ($TermLIRAModules/$kernelVersion/ft245.ko)"
    exit 1
  fi
fi

# 2. (re)Place binary files
#create main binary directory (if need)
if ! [ -d $MainKSRSDir ]; then
  printf "create main directory for binary ($MainKSRSDir).. "
  if [ $(mkdir -m755 $MainKSRSDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
#create agent directory (if need)
if ! [ -d "$MainKSRSDir/$KSRSAgentDir" ]; then
  printf "create agent directory for binary ($MainKSRSDir/$KSRSAgentDir).. "
  if [ $(mkdir -m755 $MainKSRSDir/$KSRSAgentDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
#create server directory (if need)
if ! [ -d "$MainKSRSDir/$KSRSServerDir" ]; then
  printf "create server directory for binary ($MainKSRSDir/$KSRSServerDir).. "
  if [ $(mkdir -m755 $MainKSRSDir/$KSRSServerDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
#create gui directory (if need)
if ! [ -d "$MainKSRSDir/$KSRSGUIDir" ]; then
  printf "create gui directory for binary ($MainKSRSDir/$KSRSGUIDir).. "
  if [ $(mkdir -m777 $MainKSRSDir/$KSRSGUIDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
else
  printf "chmod gui directory ($MainKSRSDir/$KSRSGUIDir) to 777.. "
  if [ $(chmod -f 777 $MainKSRSDir/$KSRSGUIDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
#create scripts directory (if need)
if ! [ -d "$MainKSRSDir/$TermKSRSScripts" ]; then
  printf "create scripts database directory ($MainKSRSDir/$TermKSRSScripts).. "
  if [ $(mkdir -p -m666 $MainKSRSDir/$TermKSRSScripts) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi

#copy files
#server
ksrsFiles=$(ls $TermKSRSUnits/$KSRSServerDir)
for afile in $ksrsFiles; do
  printf "copy server file ($afile).. "
  if [ $(cp -fR $TermKSRSUnits/$KSRSServerDir/$afile $MainKSRSDir/$KSRSServerDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chmod server file ($afile) to 755.. "
    if [ $(chmod -f 755 $MainKSRSDir/$KSRSServerDir/$afile) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  fi
done
#agent
ksrsFiles=$(ls $TermKSRSUnits/$KSRSAgentDir)
for afile in $ksrsFiles; do
  printf "copy agent file ($afile).. "
  if [ $(cp -f $TermKSRSUnits/$KSRSAgentDir/$afile $MainKSRSDir/$KSRSAgentDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chmod agent file ($afile) to 755.. "
    if [ $(chmod -f 755 $MainKSRSDir/$KSRSAgentDir/$afile) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  fi
done
#gui
ksrsFiles=$(ls $TermKSRSUnits/$KSRSGUIDir)
for afile in $ksrsFiles; do
  rm -fR $MainKSRSDir/$KSRSGUIDir/$afile
  printf "copy gui file ($afile).. "
  if [ $(cp -fR $TermKSRSUnits/$KSRSGUIDir/$afile $MainKSRSDir/$KSRSGUIDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chmod gui file ($afile) to 755.. "
    if [ $(chmod -f 755 $MainKSRSDir/$KSRSGUIDir/$afile) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  fi
done

##scripts
scriptFiles=$(ls $TermKSRSUnits/$TermKSRSScripts)
for afile in $scriptFiles; do
  printf "copy scripts database file ($afile).. "
  if [ $(cp -f $TermKSRSUnits/$TermKSRSScripts/$afile $MainKSRSDir/$TermKSRSScripts) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chmod scripts database file ($afile) to 744.. "
    if [ $(chmod -f 744 $MainKSRSDir/$TermKSRSScripts/$afile) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  fi
done

# 3. (re)Register libs
if ! [ -f $TermKSRSLibs ]; then
   printf "create ($TermKSRSLibs) with content ($MainKSRSDir/$KSRSGUIDir).. "
   if [ $(echo "$MainKSRSDir/$KSRSGUIDir" > $TermKSRSLibs) ]; then
      echo "fail"
      exit 1
   else
      echo "ok"
   fi
else
  tmpStr=$(cat $TermKSRSLibs)
  if [ "$tmpStr" != "$MainKSRSDir/$KSRSGUIDir" ]; then
    printf "rewrite library references($tmpStr) to ($MainKSRSDir/$KSRSGUIDir).. "
    if [ $(echo "$MainKSRSDir/$KSRSGUIDir" > $TermKSRSLibs) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  fi
fi
printf "renew library references.. "
if [ $(ldconfig) ]; then
  echo "fail"
  exit 1
else
  echo "ok"
fi

# 4. (re)Configure SNMP daemon
printf "copying ksrs snmpd connection module.. "
if [ $(cp -f $KSRSsnmpdConModuleSRC /usr/bin) ]; then
  echo "fail"
  exit 1
else
  echo "ok"
fi


## cron configuration
printf "checking cron configuration.. "
cronConfContent=$(cat $TermCronConf)
if ! [ "bm$KSRScronConfContent" == "bm$cronConfContent" ]; then
  echo "incorrect"
  printf "rewrite cron configuration.. "
  if [ $(echo "$KSRScronConfContent" > $TermCronConf) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
else
  echo "correct"
fi


printf "checking snmptrapd configuration.. "
snmptrapdConfContent=$(cat /etc/snmp/snmptrapd.conf)
if ! [ "bm$KSRSsnmptrapdConfContent" == "bm$snmptrapdConfContent" ]; then
  echo "incorrect"
  printf "rewrite snmptrapd configuration.. "
  if [ $(echo "$KSRSsnmptrapdConfContent" > /etc/snmp/snmptrapd.conf) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
else
  echo "correct"
fi

printf "checking snmpd configuration.. "
snmpdConfContent=$(cat /etc/snmp/snmpd.conf)
if ! [ "bm$KSRSsnmpdConfContent" == "bm$snmpdConfContent" ]; then
  echo "incorrect"
  printf "rewrite snmpd configuration.. "
  if [ $(echo "$KSRSsnmpdConfContent" > /etc/snmp/snmpd.conf) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
else
  echo "correct"
fi
runStatus=$(systemctl is-active $SNMPServiceName)
if [ "$runStatus" == "active" ]; then
  printf "stop $SNMPServiceName service.. "
  if [ $(systemctl stop $SNMPServiceName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi
autoStatus=$(2>/dev/null systemctl is-enabled $SNMPServiceName)
if [ "$autoStatus" == "enabled" ]; then
  printf "disable $SNMPServiceName service.. "
  if [ $(systemctl -q disable $SNMPServiceName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi

runStatus=$(systemctl is-active $SNMPTrapServiceName)
if [ "$runStatus" == "active" ]; then
  printf "stop $SNMPTrapServiceName service.. "
  if [ $(systemctl stop $SNMPTrapServiceName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi
autoStatus=$(2>/dev/null systemctl is-enabled $SNMPTrapServiceName)
if [ "$autoStatus" == "enabled" ]; then
  printf "disable $SNMPTrapServiceName service.. "
  if [ $(systemctl -q disable $SNMPTrapServiceName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi

# 5. (re)Install services (if needed)
#stop if running and autorun
runStatus=$(systemctl is-active $KSRSTermServiceName)
if [ "$runStatus" == "active" ]; then
  printf "stop $KSRSTermServiceName service.. "
  if [ $(systemctl stop $KSRSTermServiceName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi
autoStatus=$(2>/dev/null systemctl is-enabled $KSRSTermServiceName)
if [ "$autoStatus" == "enabled" ]; then
  printf "disable $KSRSTermServiceName service.. "
  if [ $(systemctl -q disable $KSRSTermServiceName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi
runStatus=$(systemctl is-active $KSRSTermAgentName)
if [ "$runStatus" == "active" ]; then
  printf "stop $KSRSTermAgentName service.. "
  if [ $(systemctl stop $KSRSTermAgentName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi
autoStatus=$(2>/dev/null systemctl is-enabled $KSRSTermAgentName)
if [ "$autoStatus" == "enabled" ]; then
  printf "disable $KSRSTermAgentName service.. "
  if [ $(systemctl -q disable $KSRSTermAgentName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi
#make server service configuration
if ! [ -f $KSRSTermService ]; then
  printf "create ($KSRSTermService).. "
else
  printf "renew ($KSRSTermService).. "
fi
if [ $(echo "$KSRSTermServiceContent" > $KSRSTermService) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
#make agent service configuration
if ! [ -f $KSRSTermAgent ]; then
  printf "create ($KSRSTermAgent).. "
else
  printf "renew ($KSRSTermAgent).. "
fi
if [ $(echo "$KSRSTermAgentContent" > $KSRSTermAgent) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
#make snmpd-agent service configuration
if ! [ -f $KSRSSNMPAgent ]; then
  printf "create ($KSRSSNMPAgent).. "
else
  printf "renew ($KSRSSNMPAgent).. "
fi
if [ $(echo "$SNMPDServiceContent" > $KSRSSNMPAgent) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
#make snmptrapd service configuration
if ! [ -f $KSRSSNMPTRAPDSevice ]; then
  printf "create ($KSRSSNMPTRAPDSevice).. "
else
  printf "renew ($KSRSSNMPTRAPDSevice).. "
fi
if [ $(echo "$SNMPTRAPDServiceContent" > $KSRSSNMPTRAPDSevice) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

#apply changes
printf "reload systemd daemons configuration.. "
if [ $(systemctl daemon-reload) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
#setup autorun
printf "enable $KSRSTermServiceName service.. "
if [ $(systemctl -q enable $KSRSTermServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "enable $KSRSTermAgentName service.. "
if [ $(systemctl -q enable $KSRSTermAgentName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

printf "enable $SNMPTrapServiceName service.. "
if [ $(systemctl -q enable $SNMPTrapServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "enable $SNMPServiceName service.. "
if [ $(systemctl -q enable $SNMPServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
#start services
printf "starting $KSRSTermServiceName service.. "
if [ $(systemctl start $KSRSTermServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "starting $KSRSTermAgentName service.. "
if [ $(systemctl start $KSRSTermAgentName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "starting $SNMPTrapServiceName service.. "
if [ $(systemctl start $SNMPTrapServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "starting $SNMPServiceName service.. "
if [ $(systemctl start $SNMPServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

# 6. autologin and autostart
printf "checking user <$KSRSGUIUser>.. "
if ! [ -d "/home/$KSRSGUIUser" ]; then
  echo "absent"
  printf "creating gui terminal user.. "
  if [ $(adduser $KSRSGUIUser --password 1234) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
else
  echo "exists"
fi
if ! [ -d "/home/$KSRSGUIUser/.config" ]; then
  printf "creating gui terminal user config directory.. "
  if [ $(mkdir /home/$KSRSGUIUser/.config) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
if ! [ -d "/home/$KSRSGUIUser/.config/autostart" ]; then
  printf "creating gui terminal user autostart directory.. "
  if [ $(mkdir /home/$KSRSGUIUser/.config/autostart) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
printf "renew gui terminal user autostart script.. "
if [ $(echo "$KSRSAutoGUIContent" > /home/$KSRSGUIUser/.config/autostart/$KSRSAutoGUI) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "renew gui terminal user autologin script.. "
if [ $(echo "$KSRSAutoLoginContent" > /etc/lxdm/lxdm.conf) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "renew systemd user level link.. "
if [ $(ln -sf /usr/lib/systemd/system/graphical.target /etc/systemd/system/default.target) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

# 7. misc
printf "renew openbox theme decoration.. "
rcfile=/etc/xdg/openbox/rc.xml
bksuffix=_ksrs
if [ -e ${rcfile} ] && [ ! -e ${rcfile}${bksuffix} ]; then
  param=titleLayout
  value=L
  sed -i${bksuffix} "s|\(<${param}>\)[^<>]*\(</${param}>\)|\1${value}\2|g" $rcfile
  echo "ok"
else
  echo "not needed"
fi

echo "Terminal software setup completed successfully. Please reboot operating system!"
# normal exit
exit 0
