#!/bin/bash

# This is install/upgrade script for ksrs technical software

MainKSRSDir=/opt/ksrs-tech
KSRSTechGUIDir=gui
KSRSTechGUIBin=KARSControl

dep_path="../Dependencies/Linux"
KSRSTechGUISrc=../TechControl/SNMP/Linux/Fedora
KSRSCollectorDir=snmp
KSRSCollectorBin=snmp-collector
KSRSCollectorScr=..TechControl/Modules/Linux/Fedora
KSRSCollectorTrapFwdFile="process-trap-forward.php"
KSRSCollectorTrapFwd="../Dependencies/Common/$KSRSCollectorTrapFwdFile"
KSRSDataBaseDir=base
TechKSRSUnits="../TechControl/Modules/Linux/Fedora"
TechKSRSSNMPUnits="../TechControl/SNMP/Linux/Fedora"
TechKSRSDBUnits="../TechControl/DB"
TechKSRSDBSrc="AERO.fbk"
TechKSRSDB="AERO.FDB"
TechKSRSDBPatches=patches
TechKSRSDBBackup=bk
TechKSRSDBRestore=restore

KSRSSudoers=/etc/sudoers.d/ksrs
TechKSRSSudoers="$dep_path/ksrs_sudoers"

udev_rules_path=/etc/udev/rules.d
AMountUdevRulesFilename="99-ksrs-media-auto-mount.rules"
AMountUdevRulesSrc="$dep_path/$AMountUdevRulesFilename"

VarMainKSRSDir=/var/ksrs
TechKSRSDBScripts=scripts
TechCronConf="/etc/cron.d/cron_ksrs"

TermKSRSLibs="/etc/ld.so.conf.d/ksrs-terminal.conf"
TechKSRSLibs="/etc/ld.so.conf.d/ksrs-tech.conf"

KSRSGUIUser=user0
KSRSAutoGUI=KARSTech.desktop
KSRSAutoGUIContent="[Desktop Entry]
Type=Application
Exec=/opt/ksrs-tech/gui/KARSControl 2>/dev/null
Hidden=false
NoDisplay=false
X-GNOME-Autostart-enabled=true
Name[ru_RU]=KSRS Technical Control
Name=KSRS Technical Control
Comment[ru_RU]=
Comment="

KSRSGUI=KARSControl.desktop
KSRSGUIContent="[Desktop Entry]
Version=1.0
Terminal=false
Exec=/opt/ksrs-tech/gui/KARSControl 2>/dev/null
Name[ru_RU]=KSRS Technical Control
Name=KSRS Technical Control
Comment[ru_RU]=
Comment=
Categories=Application
"


KSRSAutoLoginContent="[base]
autologin=user0
session=/usr/bin/openbox-session
greeter=/usr/libexec/lxdm-greeter-gtk

[server]
arg=/usr/bin/X -background none vt1

[display]
gtk_theme=Clearlooks
bg=/usr/share/backgrounds/default.png
bottom_pane=1
lang=1
keyboard=0
theme=Industrial

[input]

[userlist]
disable=0
white=
black=
"

KSRSUdevPrinterRules="KERNEL==\"lp*\", ATTRS{idVendor}==\"04b8\", ATTRS{idProduct}==\"0046\", MODE:=\"0666\""

KSRSCollectorServiceBin=snmp-collector
KSRSCollectorServiceName=lemz-snmp-collector
KSRSCollectorService="/usr/lib/systemd/system/$KSRSCollectorServiceName.service"
KSRSCollectorServiceContent="[Unit]
Description=System SNMP collector Service.
Requires=network.target
After=network.target network.service snmptrapd.service firebird-superserver.service

[Service]
Type=simple
ExecStart=/opt/ksrs-tech/snmp/$KSRSCollectorServiceBin --run
ExecStop=/usr/bin/killall -w -SIGINT $KSRSCollectorServiceBin
Restart=on-failure
StandardOutput=null
TimeoutStopSec=120

[Install]
WantedBy=multi-user.target"

KSRSRsyncServiceName="rsyncd"

KSRSRsyncSecretsFile="/etc/rsyncd.secrets"
KSRSRsyncSecretsContent="collector:123456"

KSRSRsyncFile="/etc/rsyncd.conf"
KSRSRsyncContent="maxconnections = 6
timeout = 300

[bk]
path = /var/ksrs/base/backup
hosts allow = 192.168.0.0/16
list = true
uid = nobody
gid = nobody
auth users = collector
read only = true
secrets file = /etc/rsyncd.secrets"


SNMPTrapServiceName="snmptrapd"
KSRSsnmptrapdConfContent="ignoreAuthFailure yes
disableAuthorization yes
snmpTrapdAddr UDP:162
traphandle default /usr/bin/php /usr/bin/$KSRSCollectorTrapFwdFile"
SNMPTRAPDMAINPID='$MAINPID'
KSRSSNMPTRAPDSevice="/usr/lib/systemd/system/$SNMPTrapServiceName.service"
SNMPTRAPDServiceContent="[Unit]
Description=Simple Network Management Protocol (SNMP) Trap Daemon.
After=syslog.target network.target

[Service]
Type=notify
EnvironmentFile=-/etc/sysconfig/snmptrapd
ExecStart=/usr/sbin/snmptrapd -Ln -f -On -n
ExecReload=/bin/kill -HUP $SNMPTRAPDMAINPID

[Install]
WantedBy=multi-user.target"

SNMPRegex="^net-snmp-[0-9]+"


SNMPServiceName="snmpd"
KSRSTechOID=".1.3.6.1.4.1.120312.4"
KSRSCollectorAgentFile="process-collector-agent.php"
KSRSCollectorAgent="../Dependencies/Common/$KSRSCollectorAgentFile"
KSRSsnmpdConfContent="trap2sink 192.168.12.101 public
trap2sink 192.168.12.102 public
rwcommunity public 192.168.12.101
rwcommunity public 192.168.12.102
disk /
disk /opt
disk /var
createUser internal
rouser internal
agentSecName internal
iquerySecName internal
defaultMonitors yes
notificationEvent  linkUpTrap    linkUp   ifIndex ifAdminStatus ifOperStatus
notificationEvent  linkDownTrap  linkDown ifIndex ifAdminStatus ifOperStatus

monitor  -r 10 -e linkUpTrap   \"Generate linkUp\"   ifOperStatus != 2
monitor  -r 10 -e linkDownTrap \"Generate linkDown\" ifOperStatus == 2

pass_persist $KSRSTechOID /usr/bin/php /usr/bin/$KSRSCollectorAgentFile"

SNMPDMAINPID='$MAINPID'
KSRSSNMPAgent="/usr/lib/systemd/system/$SNMPServiceName.service"
SNMPDServiceContent="[Unit]
Description=Simple Network Management Protocol (SNMP) Daemon.
After=syslog.target network.target

[Service]
Type=notify
EnvironmentFile=-/etc/sysconfig/snmpd
ExecStart=/usr/sbin/snmpd -Ln -f
ExecReload=/bin/kill -HUP $SNMPDMAINPID

[Install]
WantedBy=multi-user.target"

#0 */2 * * * root $MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBScripts/fdb_backup.sh
KSRScronConfContent="
SHELL=/bin/bash
PATH=/sbin:/bin:/usr/sbin:/usr/bin
MAILTO=root
0 2 * * * root $VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBScripts/fdb_sweep.sh
0 3 * * 6 root $VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBScripts/SqlThreeMonths.sh
0 3 * * 7 root $VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBScripts/remove_logs.sh"

# 0. Check for root access
printf "checking for user access.. "
if [ $(whoami) != "root" ]; then
  echo "fail [need root access]"
  exit 1
else
  echo "ok"
fi

# 1. Check dependencies
#look packages
printf "checking for rpm dependences.. "
rpmList=$(rpm -qa | grep -e qt-4.8 -e qt-x11 -e qt-ibase -e qtwebkit -e net-snmp -e php -e lxdm -e openbox -e firebird -e rsync -e rsyncd)
rpmQTMain=0
rpmQTX11=0
rpmQTIBase=0
rpmQTWebKit=0
rpmPHP=0
rpmSNMP=0
rpmSNMPAgent=0
rpmSNMPUtils=0
rpmLXDM=0
rpmOPENBOX=0
rpmFIREBIRD=0
rpmRSYNC=0
rpmRSYNCD=0
for aPacket in $rpmList; do
  if [ "$rpmQTMain" -eq 0 ]; then
    if [[ $aPacket == qt-4.8* ]]; then
      rpmQTMain=1
      continue
    fi
  fi
  if [ "$rpmQTX11" -eq 0 ]; then
    if [[ $aPacket == qt-x11* ]]; then
      rpmQTX11=1
      continue
    fi
  fi
  if [ "$rpmQTIBase" -eq 0 ]; then
    if [[ $aPacket == qt-ibase*686 ]]; then
      rpmQTIBase=1
      continue
    fi
  fi
  if [ "$rpmQTWebKit" -eq 0 ]; then
    if [[ $aPacket == qtwebkit*686 ]]; then
      rpmQTWebKit=1
      continue
    fi
  fi
  if [ "$rpmPHP" -eq 0 ]; then
    if [[ $aPacket == php* ]]; then
      rpmPHP=1
      continue
    fi
  fi
  if [ "$rpmSNMP" -eq 0 ]; then
    if [[ $aPacket =~ $SNMPRegex ]]; then
      rpmSNMP=1
      continue
    fi
  fi
  if [ "$rpmSNMPAgent" -eq 0 ]; then
    if [[ $aPacket == net-snmp-agent* ]]; then
      rpmSNMPAgent=1
      continue
    fi
  fi
  if [ "$rpmSNMPUtils" -eq 0 ]; then
    if [[ $aPacket == net-snmp-utils* ]]; then
      rpmSNMPUtils=1
      continue
    fi
  fi
  if [ "$rpmLXDM" -eq 0 ]; then
    if [[ $aPacket == lxdm-* ]]; then
      rpmLXDM=1
      continue
    fi
  fi
  if [ "$rpmOPENBOX" -eq 0 ]; then
    if [[ $aPacket == openbox-* ]]; then
      rpmOPENBOX=1
      continue
    fi
  fi
  if [ "$rpmFIREBIRD" -eq 0 ]; then
    if [[ $aPacket == firebird-classic* ]]; then
      rpmFIREBIRD=1
      continue
    fi
  fi
  if [ "$rpmFIREBIRD" -eq 0 ]; then
    if [[ $aPacket == firebird-superclassic* ]]; then
      rpmFIREBIRD=1
      continue
    fi
  fi
  if [ "$rpmFIREBIRD" -eq 0 ]; then
    if [[ $aPacket == firebird-superserver* ]]; then
      rpmFIREBIRD=1
      continue
    fi
  fi
  
  if [ "$rpmRSYNC" -eq 0 ]; then
    if [[ $aPacket == rsync* ]]; then
      rpmRSYNC=1
      continue
    fi
  fi
  if [ "$rpmRSYNCD" -eq 0 ]; then
    if [[ $aPacket == rsync-daemon* ]]; then
      rpmRSYNCD=1
      continue
    fi
  fi
done
if [ "$rpmQTWebKit" -eq 0 -o "$rpmQTIBase" -eq 0 -o "$rpmQTMain" -eq 0 -o "$rpmQTX11" -eq 0 -o "$rpmPHP" -eq 0 -o "$rpmSNMP" -eq 0 -o "$rpmSNMPAgent" -eq 0 -o "$rpmSNMPUtils" -eq 0 -o "$rpmLXDM" -eq 0 -o "$rpmOPENBOX" -eq 0 -o "$rpmRSYNC" -eq 0 -o "$rpmRSYNCD" -eq 0 ]; then
  echo "fail"
  if [ "$rpmQTMain" -eq 0 ]; then
    echo "package <qt> is not accessible"
  fi
  if [ "$rpmQTX11" -eq 0 ]; then
    echo "package <qt-x11> is not accessible"
  fi
  if [ "$rpmQTIBase" -eq 0 ]; then
    echo "package <qt-ibase> is not accessible"
  fi
  if [ "$rpmQTWebKit" -eq 0 ]; then
    echo "package <qtwebkit> is not accessible"
  fi
  if [ "$rpmPHP" -eq 0 ]; then
    echo "package <php> is not accessible"
  fi
  if [ "$rpmSNMP" -eq 0 ]; then
    echo "package <net-snmp> is not accessible"
  fi
  if [ "$rpmSNMPAgent" -eq 0 ]; then
    echo "package <net-snmp-agent> is not accessible"
  fi  
  if [ "$rpmSNMPUtils" -eq 0 ]; then
    echo "package <net-snmp-utils> is not accessible"
  fi
  if [ "$rpmLXDM" -eq 0 ]; then
    echo "package <lxdm> is not accessible"
  fi
  if [ "$rpmOPENBOX" -eq 0 ]; then
    echo "package <openbox> is not accessible"
  fi
#  if [ "$rpmFIREBIRD" -eq 0 ]; then
#    echo "package <firebird-{some server}> is not accessible"
#  fi  
  if [ "$rpmRSYNC" -eq 0 ]; then
    echo "package <rsync> is not accessible"
  fi
  if [ "$rpmRSYNCD" -eq 0 ]; then
    echo "package <rsync-daemon> is not accessible"
  fi

  exit 1
fi
echo "ok"

# 2. (re)Place binary files
#create main binary directory (if need)
if ! [ -d $MainKSRSDir ]; then
  printf "create main directory for binary ($MainKSRSDir).. "
  if [ $(mkdir -m755 $MainKSRSDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
#create gui directory (if need)
if ! [ -d "$MainKSRSDir/$KSRSTechGUIDir" ]; then
  printf "create gui directory for binary ($MainKSRSDir/$KSRSTechGUIDir).. "
  if [ $(mkdir -m777 $MainKSRSDir/$KSRSTechGUIDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
#create snmp directory (if need)
if ! [ -d "$MainKSRSDir/$KSRSCollectorDir" ]; then
  printf "create snmp collector directory for binary ($MainKSRSDir/$KSRSCollectorDir).. "
  if [ $(mkdir -m755 $MainKSRSDir/$KSRSCollectorDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
#create db directory (if need)
if ! [ -d "$MainKSRSDir/$KSRSDataBaseDir" ]; then
  printf "create database directory ($MainKSRSDir/$KSRSDataBaseDir).. "
  if [ $(mkdir -m744 $MainKSRSDir/$KSRSDataBaseDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chown database directory ($MainKSRSDir/$KSRSDataBaseDir) to firebird user.. "
    if [ $(chown firebird:firebird $MainKSRSDir/$KSRSDataBaseDir) ]; then
      echo "fail"
    else
      echo "ok"
    fi
  fi
fi

if ! [ -d "$VarMainKSRSDir/$KSRSDataBaseDir" ]; then
  printf "create database directory ($VarMainKSRSDir/$KSRSDataBaseDir).. "
  if [ $(mkdir -m744 $VarMainKSRSDir/$KSRSDataBaseDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chown database directory ($VarMainKSRSDir/$KSRSDataBaseDir) to firebird user.. "
    if [ $(chown firebird:firebird $VarMainKSRSDir/$KSRSDataBaseDir) ]; then
      echo "fail"
    else
      echo "ok"
    fi
  fi
fi


if ! [ -d "$MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBPatches" ]; then
  printf "create patch database directory ($MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBPatches).. "
  if [ $(mkdir -m666 $MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBPatches) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi

if ! [ -d "$VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBScripts" ]; then
  printf "create scripts database directory ($VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBScripts).. "
  if [ $(mkdir -p -m666 $VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBScripts) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi

if ! [ -d "$VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBBackup" ]; then
  printf "create backup database directory ($VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBBackup).. "
  if [ $(mkdir -m755 $VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBBackup) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi

if ! [ -d "$VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBRestore" ]; then
  printf "create backup database directory ($VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBRestore).. "
  if [ $(mkdir -m777 $VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBRestore) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi

#copy files
#gui
ksrsFiles=$(ls $TechKSRSUnits)
for afile in $ksrsFiles; do
  if ! [ -d $MainKSRSDir/$KSRSTechGUIDir/$afile ]; then
    rm -r $MainKSRSDir/$KSRSTechGUIDir/$afile || rm -f $MainKSRSDir/$KSRSTechGUIDir/$afile
  fi
  printf "copy technical gui file ($afile).. "
  if [ $(cp -fr $TechKSRSUnits/$afile $MainKSRSDir/$KSRSTechGUIDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chmod technical gui file ($afile) to 777.. "
    if [ $(chmod -f 777 $MainKSRSDir/$KSRSTechGUIDir/$afile) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  fi
done
#snmp-collector
ksrsFiles=$(ls $TechKSRSSNMPUnits)
for afile in $ksrsFiles; do
  printf "copy snmp-collector file ($afile).. "
  if [ $(cp -f $TechKSRSSNMPUnits/$afile $MainKSRSDir/$KSRSCollectorDir) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chmod snmp-collector file ($afile) to 755.. "
    if [ $(chmod -f 755 $MainKSRSDir/$KSRSCollectorDir/$afile) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  fi
done
printf "copy snmp-collector trap forward script ($KSRSCollectorTrapFwd) in /usr/bin.. "
if [ $(cp -f $KSRSCollectorTrapFwd "/usr/bin") ]; then
  echo "fail"
  exit 1
else
  echo "ok"
fi

printf "copy snmp-collector agent script ($KSRSCollectorAgent) in /usr/bin.. "
if [ $(cp -f $KSRSCollectorAgent "/usr/bin") ]; then
  echo "fail"
  exit 1
else
  echo "ok"
fi

#database
##prototype
printf "copy database prototype file ($TechKSRSDBUnits/$TechKSRSDBSrc).. "
if [ $(cp -f $TechKSRSDBUnits/$TechKSRSDBSrc $MainKSRSDir/$KSRSDataBaseDir) ]; then
  echo "fail"
  exit 1
else
  echo "ok"
  printf "chmod database prototype file ($MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBSrc) to 644.. "
  if [ $(chmod -f 644 $MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBSrc) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
##patches
ksrsFiles=$(ls $TechKSRSDBUnits/$TechKSRSDBPatches)
for afile in $ksrsFiles; do
  printf "copy patch database file ($afile).. "
  if [ $(cp -f $TechKSRSDBUnits/$TechKSRSDBPatches/$afile $MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBPatches) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chmod patch database file ($afile) to 644.. "
    if [ $(chmod -f 644 $MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBPatches/$afile) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  fi
done

##scripts
scriptFiles=$(ls $TechKSRSDBUnits/$TechKSRSDBScripts)
for afile in $scriptFiles; do
  printf "copy scripts database file ($afile).. "
  if [ $(cp -n $TechKSRSDBUnits/$TechKSRSDBScripts/$afile $VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBScripts) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chmod scripts database file ($afile) to 744.. "
    if [ $(chmod -f 744 $VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBScripts/$afile) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  fi
done

# 3. (re)Register libs - terminal libs has priority!

if ! [ -f $TermKSRSLibs ]; then
  if ! [ -f $TechKSRSLibs ]; then
    printf "create ($TechKSRSLibs) with content ($MainKSRSDir/$KSRSTechGUIDir).. "
    if [ $(echo "$MainKSRSDir/$KSRSTechGUIDir" > $TechKSRSLibs) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
  else
    tmpStr=$(cat $TechKSRSLibs)
    if [ "$tmpStr" != "$MainKSRSDir/$KSRSTechGUIDir" ]; then
      printf "rewrite library references($tmpStr) to ($MainKSRSDir/$KSRSTechGUIDir).. "
      if [ $(echo "$MainKSRSDir/$KSRSTechGUIDir" > $TechKSRSLibs) ]; then
        echo "fail"
        exit 1
      else
        echo "ok"
      fi
    fi
  fi
  printf "renew library references.. "
  if [ $(ldconfig) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
else
  echo "warning: found ($TermKSRSLibs) library - gui will use it"
fi

# 4. (re)Configure SNMP(TRAP) daemon
printf "checking snmptrapd configuration.. "
snmptrapdConfContent=$(cat /etc/snmp/snmptrapd.conf)
if ! [ "bm$KSRSsnmptrapdConfContent" == "bm$snmptrapdConfContent" ]; then
  echo "incorrect"
  printf "rewrite snmptrapd configuration.. "
  if [ $(echo "$KSRSsnmptrapdConfContent" > /etc/snmp/snmptrapd.conf) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
else
  echo "correct"
fi
printf "checking snmpd configuration.. "
snmpdConfContent=$(cat /etc/snmp/snmpd.conf)
if ! [ "bm$KSRSsnmpdConfContent" == "bm$snmpdConfContent" ]; then
  echo "incorrect"
  printf "rewrite snmpd configuration.. "
  if [ $(echo "$KSRSsnmpdConfContent" > /etc/snmp/snmpd.conf) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
else
  echo "correct"
fi

## cron configuration
printf "checking cron configuration.. "
cronConfContent=$(cat $TechCronConf)
if ! [ "bm$KSRScronConfContent" == "bm$cronConfContent" ]; then
  echo "incorrect"
  printf "rewrite cron configuration.. "
  if [ $(echo "$KSRScronConfContent" > $TechCronConf) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
else
  echo "correct"
fi

runStatus=$(systemctl is-active $SNMPTrapServiceName)
if [ "$runStatus" == "active" ]; then
  printf "stop $SNMPTrapServiceName service.. "
  if [ $(systemctl stop $SNMPTrapServiceName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi
autoStatus=$(2>/dev/null systemctl is-enabled $SNMPTrapServiceName)
if [ "$autoStatus" == "enabled" ]; then
  printf "disable $SNMPTrapServiceName service.. "
  if [ $(systemctl -q disable $SNMPTrapServiceName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi
runStatus=$(systemctl is-active $SNMPServiceName)
if [ "$runStatus" == "active" ]; then
  printf "stop $SNMPServiceName service.. "
  if [ $(systemctl stop $SNMPServiceName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi
autoStatus=$(2>/dev/null systemctl is-enabled $SNMPServiceName)
if [ "$autoStatus" == "enabled" ]; then
  printf "disable $SNMPServiceName service.. "
  if [ $(systemctl -q disable $SNMPServiceName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi

## sudoers configuration
printf "copy sudoers configuration file.. "
if [ $(cp -f $TechKSRSSudoers $KSRSSudoers) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
    printf "chmod sudoers ksrs file to 755.. "
    if [ $(chmod -f 755 $KSRSSudoers) ]; then
      echo "fail"
      exit 1
    else
      echo "ok"
    fi
fi

## openbox theme
printf "renew openbox theme decoration.. "
rcfile=/etc/xdg/openbox/rc.xml
bksuffix=_ksrs
if [ -e ${rcfile} ] && [ ! -e ${rcfile}${bksuffix} ]; then
  param=titleLayout
  value=L
  sed -i${bksuffix} "s|\(<${param}>\)[^<>]*\(</${param}>\)|\1${value}\2|g" $rcfile
  echo "ok"
else
  echo "not needed"
fi

## udev for usb flash drives automount patch
printf "patching udev for usb flash drives automount.. "
svc=/usr/lib/systemd/system/systemd-udevd.service
bksuffix=_ksrs
#if [ -e ${svc} ] && [ ! -e ${svc}${bksuffix} ]; then
if [ -e ${svc} ] ; then
  param=MountFlags
  value=shared
  sed -i${bksuffix} "s|\(^${param}=\).*\($\)|\1${value}\2|g" $svc
  echo "ok"
else
  echo "not needed"
fi

## udev for usb flash drives automount rules
printf "creating udev rules for usb flash drives automount.. "
if [ $(cp -f -T $AMountUdevRulesSrc "$udev_rules_path/$AMountUdevRulesFilename") ]; then
    echo "fail" 
    exit 1
  else
    echo "ok"
    printf "chmod ksrs usb flash automount udev rules file to 644.. "
    if [ $(chmod -f 644 "$udev_rules_path/$AMountUdevRulesFilename") ]; then
	echo "fail"
	exit 1
    else
	echo "ok"
    fi
fi	           


##rsync configuration
printf "rewrite rsyncd configuration.. "
if [ $(echo "$KSRSRsyncContent" > "$KSRSRsyncFile") ]; then
    echo "fail"
    exit 1
else
    echo "ok"
    printf "chmod rsyncd configuration file to 644.. "
    if [ $(chmod -f 644 "$KSRSRsyncFile") ]; then
	echo "fail"
	exit 1
    else
	echo "ok"
    fi
fi
  
printf "rewrite rsyncd secrets configuration.. "
if [ $(echo "$KSRSRsyncSecretsContent" > "$KSRSRsyncSecretsFile") ]; then
    echo "fail"
    exit 1
else
  echo "ok"
  printf "chmod rsync secrets file to 600.. "
    if [ $(chmod -f 600 "$KSRSRsyncSecretsFile") ]; then
	echo "fail"
	exit 1
    else
	echo "ok"
    fi
fi



# 5. (re)Install services (if need)
#stop if running and autorun
runStatus=$(systemctl is-active $KSRSCollectorServiceName)
if [ "$runStatus" == "active" ]; then
  printf "stop $KSRSCollectorServiceName service.. "
  if [ $(systemctl stop $KSRSCollectorServiceName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi
autoStatus=$(2>/dev/null systemctl is-enabled $KSRSCollectorServiceName)
if [ "$autoStatus" == "enabled" ]; then
  printf "disable $KSRSCollectorServiceName service.. "
  if [ $(systemctl -q disable $KSRSCollectorServiceName) ]; then
    echo "fail"
    exit 1
  fi
  echo "ok"
fi

#database restore first
#printf "checking the database.. "
#if [ -e $VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDB ]; then
#  printf "database exists "
#else
#  KSRSDatabase=127.0.0.1:$VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDB
#  KSRSDatabaseBK=$MainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBSrc
#  printf "database is restoring (wait a few minutes).. "
#  $VarMainKSRSDir/$KSRSDataBaseDir/$TechKSRSDBScripts/fdb_restore_first.sh $KSRSDatabaseBK $KSRSDatabase || exit 1
#fi
#echo "ok"

#make collector service configuration
if ! [ -f $KSRSCollectorService ]; then
  printf "create ($KSRSCollectorService).. "
else
  printf "renew ($KSRSCollectorService).. "
fi
if [ $(echo "$KSRSCollectorServiceContent" > $KSRSCollectorService) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
#make snmptrapd service configuration
if ! [ -f $KSRSSNMPTRAPDSevice ]; then
  printf "create ($KSRSSNMPTRAPDSevice).. "
else
  printf "renew ($KSRSSNMPTRAPDSevice).. "
fi
if [ $(echo "$SNMPTRAPDServiceContent" > $KSRSSNMPTRAPDSevice) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
#make snmpd service configuration
if ! [ -f $KSRSSNMPAgent ]; then
  printf "create ($KSRSSNMPAgent).. "
else
  printf "renew ($KSRSSNMPAgent).. "
fi
if [ $(echo "$SNMPDServiceContent" > $KSRSSNMPAgent) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

#apply changes
printf "reload systemd daemons configuration.. "
if [ $(systemctl daemon-reload) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

printf "reload udev rules.. "
if [ $(udevadm control --reload) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

#setup autorun
printf "enable $KSRSCollectorServiceName service.. "
if [ $(systemctl -q enable $KSRSCollectorServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "enable $SNMPTrapServiceName service.. "
if [ $(systemctl -q enable $SNMPTrapServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "enable $SNMPServiceName service.. "
if [ $(systemctl -q enable $SNMPServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

printf "enable $KSRSRsyncServiceName service.. "
if [ $(systemctl -q enable $KSRSRsyncServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"



#start services
printf "starting $SNMPTrapServiceName service.. "
if [ $(systemctl start $SNMPTrapServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

printf "starting $KSRSCollectorServiceName service.. "
if [ $(systemctl start $KSRSCollectorServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "starting $SNMPServiceName service.. "
if [ $(systemctl start $SNMPServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

printf "starting $KSRSRsyncServiceName service.. "
if [ $(systemctl start $KSRSRsyncServiceName) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

# 6. autologin and autostart
printf "checking user <$KSRSGUIUser>.. "
if ! [ -d "/home/$KSRSGUIUser" ]; then
  echo "absent"
  printf "creating gui terminal user.. "
  if [ $(adduser $KSRSGUIUser --password 1234) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
else
  echo "exists"
fi
if ! [ -d "/home/$KSRSGUIUser/.config" ]; then
  printf "creating gui terminal user config directory.. "
  if [ $(mkdir /home/$KSRSGUIUser/.config) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
if ! [ -d "/home/$KSRSGUIUser/.config/autostart" ]; then
  printf "creating gui terminal user autostart directory.. "
  if [ $(mkdir /home/$KSRSGUIUser/.config/autostart) ]; then
    echo "fail"
    exit 1
  else
    echo "ok"
  fi
fi
printf "renew gui terminal user autostart script.. "
if [ $(echo "$KSRSAutoGUIContent" > /home/$KSRSGUIUser/.config/autostart/$KSRSAutoGUI) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

printf "renew gui terminal user desktop script.. "
if [ $(echo "$KSRSGUIContent" > /usr/share/applications/$KSRSGUI) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

printf "renew gui terminal user autologin script.. "
if [ $(echo "$KSRSAutoLoginContent" > /etc/lxdm/lxdm.conf) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "renew systemd user level link.. "
if [ $(ln -sf /usr/lib/systemd/system/graphical.target /etc/systemd/system/default.target) ]; then
  echo "fail"
  exit 1
fi
echo "ok"
printf "allow printer access to all users.. "
if [ $(echo "$KSRSUdevPrinterRules" > /etc/udev/rules.d/90-cups-usb.rules) ]; then
  echo "fail"
  exit 1
fi
echo "ok"

echo "Technical software setup completed successfully. Please reboot operating system!"
# normal exit
exit 0
