<?php

/*
 * rino-SNMP-agent - SNMP agent for LEMZ (http://www.rinotel.com) monitoring server hardware
 *
 * Copyright (C) 2018 Volnikov Ivan
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 220 Lenin Avenue 82, Obninsk, Kaluga region, Russia.
 *
 * Report bugs to:  ivan@rinotel.com
 */

$fh = fopen('php://stdin', 'r');
$fo = fopen('php://stdout', 'w');

error_reporting(E_ALL ^ E_WARNING);

function doAnswer($MSG)
{
    global $fo;
    fwrite($fo,$MSG."\n");
}

function getStatusStr($iStatus)
{
    switch ($iStatus)
    {
	case 0:
	return "Initializing";
	case 1:
	return "Standalone";
	case 2:
	return "Main";
	case 3:
	return "Syncronize";
	case 4:
	return "Standby";
	default:
	return "Unknown status with code".$iStatus;
    }
}

function getStatusFromCollector($address,$service_port,&$res)
{
    $socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
    if ($socket < 0) {
	return false;
    } else 

    $result = socket_connect($socket, $address, $service_port);
    if ($result == false) {
	socket_close($socket);
	return false;
    }

    /*make ping request*/
    $in  = "\0x03\0x00\0x00\0x0C\0x01\0x00\0x00\0x00\0x00\0x00\0x00";
    $out = '';

    socket_write($socket, $in, strlen($in));
    
    //"Reading response";
    $out = socket_read($socket, 14); 

    socket_close($socket);

    $res = intval(substr(bin2hex($out),-2));
    return true;
}

if (!isset($fh)) {
    exit(1);
}

//main cycle

$mode = "command";
$command = "WORK";
do {
	$buffer = rtrim(fgets($fh));
	switch ($mode) {
		case "command":
			switch ($buffer) {
				case "PING":
				case "ping":
					// this is for startup handshake
					doAnswer("PONG");
					break;
				case "QUIT":
				case "quit":
					// this is for telnet-tests ;-)
					$command = "QUIT";
					//echo "Terminating.\n";
					break;
				case "getnext":
				case "GETNEXT":
					$mode = "getnext";
					break;
				case "get":
				case "GET":
					$mode = "get";					
					break;
				case "set":
				case "SET":
					$mode = "set";
					break;
				default:
					$command = "QUIT";
					break;
			}
			break;
		case "getnext":
		case "get":
			$oid=$buffer;
			//only one value WE can return - collector status
			$res = array();
			if ($oid === ".1.3.6.1.4.1.120312.4.1.0")
			{
				$res["oid"]=$oid;
				$res["type"]="integer";
				$res["value"]=255;
				if (getStatusFromCollector("127.0.0.1",39001,$rslt)==true)
				{
					$res["value"]=$rslt;					
				}
				doAnswer($res["oid"]);
				doAnswer($res["type"]);
				doAnswer($res["value"]);
			}else
			{
				doAnswer("NONE");
			}
			$mode = "command";

			break;
		case "set":
			$mode = "set2";
			break;
		case "set2":
			$mode = "set3";
			break;
		case "set3":
			$mode = "command";
			doAnswer("not-writable");
			break;
		default:
			$mode = "command";
			doAnswer("NONE");
			break;
	}
} while ( $command != "QUIT" );

fclose($fh);

?>
