#!/bin/sh

fmt()
{
    string="$1"
    direction="$2"
    fillchar="$3"
    size="$4"
    if [[ "${direction}" == "l" ]] || [[ "${direction}" == "L" ]] ; then
        while [[ ${#string} -lt ${size} ]] ; do
            string="${fillchar}${string}"
        done
        #string="${string: -${size}}"
    else
        while [[ ${#string} -lt ${size} ]] ; do
            string="${string}${fillchar}"
        done
        #string="${string:0:${size}}"
    fi
    echo "${string}"
}

log()
{
	
	echo $(fmt "$1" r '.' 70)$(fmt "$2" l '.' 10)
}

FT245_DIR=$(pwd)
FT245_SRC_DIR=$FT245_DIR/3.6-12
FT245_DRIVER_FILE=$FT245_DIR/modules/$(uname -r)/ft245.ko
FT245_DRIVER_XZ_FILE=$FT245_DIR/modules/$(uname -r)/ft245.ko.xz
FT245_UDEV_RULE_FILE=$FT245_DIR/99-lira.rules
KERNEL_MODULES_PATH=/usr/lib/modules/$(uname -r)/kernel/lib
FT245_MODULES_PATH=/usr/lib/modules/$(uname -r)/lira

#
# check driver
#
if [ -e  $FT245_DRIVER_XZ_FILE ]; then

	log "$FT245_DRIVER_XZ_FILE" "ok"
else

	log "$FT245_DRIVER_XZ_FILE" "not exist"
    if [ -e  $FT245_DRIVER_FILE ]; then

	log "$FT245_DRIVER_FILE" "ok"
    else

	log "$FT245_DRIVER_FILE" "not exist"
	cd $FT245_SRC_DIR
	log "Compiling..."
	make
	RESULT_CODE=$?
	if [ $RESULT_CODE -ne 0 ]; then
	    log "compile failed"
	    exit 1
	else
	    log "compile ok"
	fi
	make clean
	cd $FT245_DIR
    fi
fi


#
# cp module
#
/bin/mkdir -p $FT245_MODULES_PATH

RESULT_CODE=$?
if [ $RESULT_CODE -ne 0 ]; then

	log "$FT245_MODULES_PATH" "create failed"
	exit 0
else
	log "$FT245_MODULES_PATH" "create ok"
fi

if ls $KERNEL_MODULES_PATH/*ko.xz 1> /dev/null 2>&1;
then
    /bin/cp -rf $FT245_DRIVER_XZ_FILE $FT245_MODULES_PATH

    RESULT_CODE=$?
    if [ $RESULT_CODE -ne 0 ]; then

	log "$FT245_DRIVER_XZ_FILE" "cp failed"
	exit 0
    else
	log "$FT245_DRIVER_XZ_FILE" "cp ok"
    fi
else
    /bin/cp -rf $FT245_DRIVER_FILE $NF_MODULES_PATH

    RESULT_CODE=$?
    if [ $RESULT_CODE -ne 0 ]; then

	log "$FT245_DRIVER_FILE" "cp failed"
	exit 0
    else
	log "$FT245_DRIVER_FILE" "cp ok"
    fi
fi

#
# update dependence
#

depmod -a > /dev/null 2>&1

RESULT_CODE=$?
if [ $RESULT_CODE -ne 0 ]; then

	log "$FT245_DRIVER_FILE" "depmod failed"
	exit 0
else
	log "$FT245_DRIVER_FILE" "depmod ok"
fi

#
# cp udev rule
#
/bin/cp -rf $FT245_UDEV_RULE_FILE /etc/udev/rules.d

RESULT_CODE=$?
if [ $RESULT_CODE -ne 0 ]; then

	log "$FT245_UDEV_RULE_FILE" "cp failed"
	exit 0
else
	log "$FT245_UDEV_RULE_FILE" "cp ok"
fi
