<?php

/*
 * collector-SNMP-agent - SNMP agent for LEMZ (https://lemz.ru/%d1%82%d0%be%d0%bf%d0%b0%d0%b7-10) monitoring server hardware
 *
 * Copyright (C) 2021 Volnikov Ivan
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 220 Lenin Avenue 82, Obninsk, Kaluga region, Russia.
 *
 * Report bugs to:  volnikov.i.s@topaz-atcs.com
 */

$fh = fopen('php://stdin', 'r');
$fo = fopen('php://stdout', 'w');

$last_connect = 0;
$version_str = "unknown";

error_reporting(E_ALL ^ E_WARNING);

function doAnswer($MSG)
{
    global $fo;
    fwrite($fo,$MSG."\n");
}

function getStatusStr($iStatus)
{
    switch ($iStatus)
    {
	case 0:
	return "Initializing";
	case 1:
	return "Standalone";
	case 2:
	return "Main";
	case 3:
	return "Syncronize";
	case 4:
	return "Standby";
	default:
	return "Unknown status with code".$iStatus;
    }
}

function getStatusFromCollector($address,$service_port,&$res)
{
	global $last_connect;
	global $version_str;
    $socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
    if ($socket < 0) {
	return false;
    } else 

    $result = socket_connect($socket, $address, $service_port);
    if ($result == false) {
	socket_close($socket);
	return false;
    }

    /*make ping request*/
    /*$in  = "\0x03\0x00\0x00\0x0C\0x01\0x00\0x00\0x00\0x00\0x00\0x00";*/
    /*socket_write($socket, $in, strlen($in));*/
    $out = '';

    
    //After connection collector will send:
	//1. MUST be "Pong" MSG with status - size=14: 4 bytes(TPKT header) + 1 byte (Pong MSG code=0) + 4 bytes (cmdID) + 4 bytes (msgID) + 1 byte (Status code)
    $out = socket_read($socket, 14);
    $res = intval(substr(bin2hex($out),-2));
	//2. MAY be Version MSG - size=dynamic: 4 bytes(TPKT header: 0x03 0x00 <Length> - 2 bytes) + 1 byte (Vesion MSG code=9)+ 4 bytes (cmdID) + 4 bytes (msgID) + version (<Length> - 13 bytes)
	$out = socket_read($socket, 4); //header
	$len = intval(substr(bin2hex($out),-4),16);
	$out = socket_read($socket, 1); //code
	$code = intval(substr(bin2hex($out),-2),16);
	if ($code==9) //!!!Version
	{
		$out = socket_read($socket, 10); //skip cmdID+msgID+string len
		$out = socket_read($socket, $len-15); //version
		$version_str = $out;
		$last_connect=time();
	}
	//

    socket_close($socket);

    return true;
}

if (!isset($fh)) {
    exit(1);
}

//main cycle

$mode = "command";
$command = "WORK";
do {
	$buffer = rtrim(fgets($fh));
	switch ($mode) {
		case "command":
			switch ($buffer) {
				case "PING":
				case "ping":
					// this is for startup handshake
					doAnswer("PONG");
					break;
				case "QUIT":
				case "quit":
					// this is for telnet-tests ;-)
					$command = "QUIT";
					//echo "Terminating.\n";
					break;
				case "getnext":
				case "GETNEXT":
					$mode = "getnext";
					break;
				case "get":
				case "GET":
					$mode = "get";					
					break;
				case "set":
				case "SET":
					$mode = "set";
					break;
				default:
					$command = "QUIT";
					break;
			}
			break;
		case "getnext":
		case "get":
			$oid=$buffer;
			//only one value WE can return - collector status
			$res = array();
			if ($oid === ".1.3.6.1.4.1.120312.4.1.0")
			{
				$res["oid"]=$oid;
				$res["type"]="integer";
				$res["value"]=255;
				if (getStatusFromCollector("127.0.0.1",39001,$rslt)==true)
				{
					$res["value"]=$rslt;					
				}
				doAnswer($res["oid"]);
				doAnswer($res["type"]);
				doAnswer($res["value"]);
			}else
			{
				if ($oid === ".1.3.6.1.4.1.120312.4.2.0")
				{
					$res["oid"]=$oid;
					$res["type"]="string";
					if ((time()-$last_connect)>5) getStatusFromCollector("127.0.0.1",39001,$rslt);
					$res["value"]=$version_str;
					doAnswer($res["oid"]);
					doAnswer($res["type"]);
					doAnswer($res["value"]);
				}else
				{
					doAnswer("NONE");
				}
			}
			$mode = "command";

			break;
		case "set":
			$mode = "set2";
			break;
		case "set2":
			$mode = "set3";
			break;
		case "set3":
			$mode = "command";
			doAnswer("not-writable");
			break;
		default:
			$mode = "command";
			doAnswer("NONE");
			break;
	}
} while ( $command != "QUIT" );

fclose($fh);

?>
