#!/bin/bash

# bash -vx
#Firebird path
fb_root=/usr
#fb_root=/opt/fb25ss
fb_bin=${fb_root}/bin

curdate=`date +%X`
bkdate=`date +%F`

dbpath=/var/ksrs/base
db=AERO.FDB
dbuser=SYSDBA
dbpassword=masterkey

logfile=$dbpath/backup.log
lock=/var/ksrs/base/bk/dbback.lock

bkpath=/var/ksrs/base/bk/${bkdate}
cdpath=/var/ksrs/base/bk

bkfile=${bkpath}/${db}-${curdate}.fbk

#load the ISC_USER and ISC_PASSWORD environment variables. works only for POSIX firebird
#source ${fb_root}/SYSDBA.password
#export ISC_USER
#export ISC_PASSWORD
fb_auth="-user ${dbuser} -password ${dbpassword}"

msg()
{
  echo "*** $1"
  echo "`date +%X`:  $1" >> $logfile
}

msg1()
{
  echo "$1"
  echo "$1" >> $logfile
}

packbackup()
{
  msg "removing old files..." 
  cd $cdpath && ls -t | tail -n+30 | xargs -i rm -rv '{}'
  msg "packing backup..." 
  /usr/bin/xz -9 $bkfile
  msg "packing backup...DONE" 
  msg "copying backup..." 
  scpfile=$bkfile.xz
  /usr/bin/sshpass -p "12345678" /usr/bin/ssh root@192.168.12.2 "mkdir -p $bkpath; cd $cdpath && ls -t | tail -n+8 | xargs -i rm -rv '{}'; exit"
  /usr/bin/sshpass -p "12345678" /usr/bin/scp -r $scpfile root@192.168.12.2:$bkpath
  msg "copying backup...DONE" 
}

dbvalidate()
{
  ${fb_bin}/gfix -validate -full ${fb_auth} $1
  echo $?
}

dbmend()
{
  ${fb_bin}/gfix -mend ${fb_auth} $1
  echo $?
}

testbackup()
{
  local result=1
  local testdbfile=${1%/*}_test.fdb
  if [ -e $testdbfile ]; then
    rm -f $testdbfile
  fi

  #restore backup to the test database
  msg "  restoring to a temporary database..."
  ${fb_bin}/gbak -c -p 16384 ${fb_auth} $1 127.0.0.1:$testdbfile
  
  if [ -e $testdbfile ]; then
    #validate test database
    msg "  validating temporary database..."
    if [ `dbvalidate $testdbfile` = 0 ]; then
      #db is valid
      msg "  temporary database is OK"
      result=0
    else
      #mend invalid db at least two times waiting for empty output from gfix
      msg "  temporary database is NOT OK. trying to fix..."
      if [ `dbmend $testdbfile` = 0 ] || [ `dbmend $testdbfile` = 0 ]; then
        #fixed!
        msg "  successfully fixed backup file"
        result=0
      else
        #cannot fix :'(
        msg "  cannot fix backup file"
      fi
    fi

    rm -f $testdbfile
  else
    msg "  restoring to a temporary database failed"
  fi

  return $result
}

msg "starting..."

if [ -e $lock ]; then
  msg "backup already running. exiting."
else
  touch $lock
  if [ ! -d $bkpath ]; then
    mkdir -p $bkpath
  fi

  msg1 ""
  msg1 "================================================"
  msg1 "$(date +'%d-%b-%Y %R')"

  #do backup
  msg "creating backup file..."
  ${fb_bin}/gbak -b -g ${fb_auth} 127.0.0.1:$dbpath/$db $bkfile
  msg "creating backup file...DONE"

  msg "checking backup file..."
  #check if backup is valid
  testbackup $bkfile
  if [ $? = 0 ]; then
    #backup is valid
    msg "checking backup file...backup file is valid"
  else
    #wtf?!
    msg "checking backup file...invalid backup file. exiting."
    rm -f $bkfile
    rm -f $lock  #FIXME
    exit 1
  fi

  packbackup

  rm -f $lock
fi

msg "finished. you can go home now." 

exit 0

#scpfile=$bkfile.bz2
#sshpass -p "123456" ssh root@192.168.1.93 " mkdir -p /lemz/$bkdate; cd /lemz && ls -t | tail -n+5 | xargs -i rm -rv '{}'; exit"
#sshpass -p "123456" scp -r /$scpfile  root@192.168.1.93:/lemz/$bkdate
