<?php

/*
 * control-SNMP-agent - SNMP agent for LEMZ (https://lemz.ru/%d1%82%d0%be%d0%bf%d0%b0%d0%b7-10) monitoring server hardware
 *
 * Copyright (C) 2024 Volnikov Ivan
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 220 Lenin Avenue 82, Obninsk, Kaluga region, Russia.
 *
 * Report bugs to:  ivan@rinotel.com
 */

//$fd = fopen('/tmp/control-agent.log', 'a');
$fh = fopen('php://stdin', 'r');
$fo = fopen('php://stdout', 'w');
$sock = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP);
$control_iface = '127.0.0.1';
$control_port = 39041;
socket_bind($sock, $control_iface, $control_port - 1);

/*
function logDUMP($MSG)
{
    global $fd;
    $now = @DateTime::createFromFormat('U.u', number_format(microtime(true), 6, '.', ''));
    $nowstr = $now->format("m-d-Y H:i:s.u");
    fwrite($fd, $nowstr . ' ' . $MSG);
}
*/

function doAnswer($MSG)
{
    global $fo;
    fwrite($fo, $MSG . "\n");
}

function getDataFromControl($oid, $method, &$res)
{
    global $sock, $control_iface, $control_port;
    //logDUMP("getDataFromControl <".$oid."> command [mode=".$method."] - Enter\n");
    $msg = $oid . '|' . $method;
    socket_sendto($sock, $msg, strlen($msg), 0, $control_iface, $control_port);
    $read = array($sock);
    $write = NULL;
    $except = NULL;
    $num_changed_sockets = socket_select($read, $write, $except, 0, 500000);

    if ($num_changed_sockets === false) {
        //Error handling
        //logDUMP("getDataFromControl - Leave [Fail to select answer]\n");
    } else if ($num_changed_sockets > 0) {
        //there is answer
        $from_addr = $control_iface;
        $from_port = $control_port;
        if (socket_recvfrom($sock, $buf, 4096, 0, $from_addr, $from_port) > 0) {
            //logDUMP("getDataFromControl - sockreadbuf buf: ". var_export($buf, true)  ."\n");
            list($oid_res, $oid_type, $oid_value) = explode("|", $buf);
            if ($oid_res === "NONE") {
                //logDUMP("getDataFromControl - Leave [Answer: No oid found]\n");
                return false;
            } else {
                $res['oid'] = $oid_res;
                $res['type'] = $oid_type;
                $res['value'] = $oid_value;
                //logDUMP("getDataFromControl - Leave [Answer: oid=<$oid_res>, type=<$oid_type>, value=<$oid_value>]\n");
            }
            return true;
        }
        //logDUMP("getDataFromControl - Leave [Fail to get data from agent]\n");
    }
    //logDUMP("getDataFromControl - Leave [Timeout getting data from agent]\n");
    return false;
}

if (isset($fh)) {
    //logDUMP("Stdin is open!\n");
} else {
    //logDUMP("Can not open stdin!"."\n");
    exit(1);
}

//main cycle

$mode = "command";
$command = "WORK";
do {
    //logDUMP("Try read data from stdin..."."\n");
    $buffer = rtrim(fgets($fh));
    //logDUMP("Data from stdin received [".$buffer."]\n");
    switch ($mode) {
        case "command":
            switch ($buffer) {
                case "PING":
                case "ping":
                    // this is for startup handshake
                    doAnswer("PONG");
                    break;
                case "QUIT":
                case "quit":
                    // this is for telnet-tests ;-)
                    $command = "QUIT";
                    //echo "Terminating.\n";
                    break;
                case "getnext":
                case "GETNEXT":
                    $mode = "getnext";
                    break;
                case "get":
                case "GET":
                    $mode = "get";
                    break;
                case "set":
                case "SET":
                    $mode = "set";
                    break;
                default:
                    $command = "QUIT";
                    break;
            }
            //logDUMP("Receive <".$buffer."> command [mode=".$mode."]\n");
            break;
        case "getnext":
        case "get":
            $oid = $buffer;
            //logDUMP("Process <".$mode."> command [oid=".$oid."]\n");
            $res = array();
            if (getDataFromControl($oid, $mode, $res)) {
                doAnswer($res["oid"]);
                doAnswer($res["type"]);
                doAnswer($res["value"]);
            } else if ($oid === ".1.3.6.1.4.1.120312.5.1.1.0" || $oid === ".1.3.6.1.4.1.120312.5.1.2.0") {
                doAnswer($oid);
                doAnswer("string");
                doAnswer("");  //unknown
            } else {
                doAnswer("NONE");
            }
            $mode = "command";
            break;
        case "set":
            $mode = "set2";
            break;
        case "set2":
            $mode = "set3";
            break;
        case "set3":
            $mode = "command";
            doAnswer("not-writable");
            break;
        default:
            //logDUMP("Process <".$mode."> command - IGNORE \n");
            $mode = "command";
            doAnswer("NONE");
            break;
    }
} while ($command != "QUIT");

fclose($fh);
//logDUMP("Stdin is close!\n");

//fclose($fd);

?>
