#! /bin/php
<?php
define("TERMINAL_ADDR", '127.0.0.1');
define("TERMINAL_PORT", 37000);

define("P1_L1_MSG_GUI_STATUS", 4);

define("P1_L1_CMD_REBOOT", 0x8003);  // 3 | 0x8000
define("P1_REBOOT_TYPE_GUI_RESTART", 2);

define("KARS_OPERATORSTATUS_ROLE_TAG", "rlt");
define("KARS_OPERATORSTATUS_ROLES_TAG", "rlst");
define("KARS_OPERATORSTATUS_OPER_TAG", "opt");

$terminal_socket = false;

function get_tag_contents($data, $tagname) {
    $tag = "<$tagname>";
    $tstart = strpos($data, $tag);
    if ($tstart !== false) {
        $cstart = $tstart + strlen($tag);
        $tend = strpos($data, "</$tagname>", $cstart);
        if ($tend > 0)
            return substr($data, $cstart, $tend - $cstart);
    }
    return '';
}

function terminal_connect()
{
    global $terminal_socket;

    $terminal_socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
    if ($terminal_socket === false) {
        return false;
    } else
        $result = socket_connect($terminal_socket, TERMINAL_ADDR, TERMINAL_PORT);
    if ($result === false) {
        socket_close($terminal_socket);
        return false;
    }

    /*make ping request*/
    /*$in  = "\0x03\0x00\0x00\0x0C\0x01\0x00\0x00\0x00\0x00\0x00\0x00";*/
    /*socket_write($socket, $in, strlen($in));*/
    $out = '';

    /*
    //After connection collector will send:
    //1. MUST be "Pong" MSG with status - size=14: 4 bytes(TPKT header) + 1 byte (Pong MSG code=0) + 4 bytes (cmdID) + 4 bytes (msgID) + 1 byte (Status code)
    $out = socket_read($terminal_socket, 14);
    $res = intval(substr(bin2hex($out), -2));
    //2. MAY be Version MSG - size=dynamic: 4 bytes(TPKT header: 0x03 0x00 <Length> - 2 bytes) + 1 byte (Vesion MSG code=9)+ 4 bytes (cmdID) + 4 bytes (msgID) + version (<Length> - 13 bytes)
    $out = socket_read($terminal_socket, 4); //header
    $len = intval(substr(bin2hex($out), -4), 16);
    $out = socket_read($terminal_socket, 1); //code
    $code = intval(substr(bin2hex($out), -2), 16);
    if ($code == 9) //!!!Version
    {
        $out = socket_read($terminal_socket, 10); //skip cmdID+msgID+string len
        $out = socket_read($terminal_socket, $len - 15); //version
        $version_str = $out;
        $last_connect = time();
    }*/

    return true;
}

function terminal_disconnect()
{
    global $terminal_socket;
    if ($terminal_socket === false)
        return false;

    socket_close($terminal_socket);
    return true;
}

function terminal_sendping($ping_timeout = 15000)
{
    global $terminal_socket;
    if ($terminal_socket === false)
        return false;

    //send ping, identify as Control
    //'0300001000800000000000000000983A'  //15000ms
    $pingcmd = pack("H*", '0300001000800000000000000000') . pack("v", $ping_timeout);
    if (socket_write($terminal_socket, $pingcmd, strlen($pingcmd)) === false)
        return false;

    return true;
}

function terminal_getroles(&$roles_list, &$role_current)
{
    if (terminal_sendping() === false)
        return false;

    global $terminal_socket;

    //read ping answer
    //P1Protocol::P1MSGGuiStatusIndicator (P1_L1_MSG_GUI_STATUS)
    //  4 bytes (TPKT header: 0x03 0x00 <Length 2 bytes>) + 1 byte (CODE) + 4 bytes (cmdID) + 4 bytes (msgID) + DATA
    $out = socket_read($terminal_socket, 4);  //header
    $len = intval(substr(bin2hex($out), -4), 16);
    $out = socket_read($terminal_socket, 1);  //code
    $code = intval(substr(bin2hex($out), -2), 16);
    //echo "code: $code\n";

    if ($code == P1_L1_MSG_GUI_STATUS) {
        //read P1Protocol::P1MSGGuiStatusIndicator
        socket_read($terminal_socket, 10);  //skip cmdID+msgID+string len
        $msg_gui_status = socket_read($terminal_socket, $len - 15);  //DATA
        //echo "hexmsg: " . bin2hex($msg_gui_status) . "\n";
        //echo "msg: $msg_gui_status\n";

        //gui status
        $gui_status = intval(substr(bin2hex($msg_gui_status), 0, 2), 16);
        //echo "gui_status: $gui_status\n";
        $msg_gui_status = substr($msg_gui_status, 1);

        //current role name
        $role_current = get_tag_contents($msg_gui_status, KARS_OPERATORSTATUS_ROLE_TAG);
        //var_dump($role_current);

        //role names
        $roles_list = get_tag_contents($msg_gui_status, KARS_OPERATORSTATUS_ROLES_TAG);
        //var_dump($roles_list);

        return true;
        //2. P1_L1_MSG_PING_REGISTER:
    }

    return false;
}

function terminal_setrole($role_name)
{
    if (terminal_sendping(30000) === false)
        return false;

    global $terminal_socket;

    //send P1Protocol::P1Reboot
    /*rebootCmd.header.cmdID = 0;
    rebootCmd.header.msgID = 0;
    rebootCmd.header.Operation = P1_L1_CMD_REBOOT;
    rebootCmd.a_type = P1_REBOOT_TYPE_GUI_RESTART;
    rebootCmd.data = 'role_name';*/
    $cmd = pack("vVV", P1_L1_CMD_REBOOT, 0, 0);
    $cmd .= pack("C", P1_REBOOT_TYPE_GUI_RESTART);
    $cmd .= pack("v", strlen($role_name)) . $role_name;
    $cmd = pack("H*", '0300') . pack("n*", strlen($cmd) + 4) . $cmd;
    //var_dump($cmd);
    //var_dump(bin2hex($cmd));

    $sockres = socket_write($terminal_socket, $cmd, strlen($cmd));
    if ($sockres === false)
        return false;

    return true;
}

$res = '';
if (terminal_connect()) {
    //echo "connected\n";

    if ($argc > 1)
        parse_str(implode('&', array_slice($argv, 1)), $_REQUEST);

    $role_name = isset($_REQUEST['name']) ? $_REQUEST['name'] : '';
    //var_dump($role_name);
    if (empty($role_name)) {
        $roles_list = '';
        $role_current = '';
        if (terminal_getroles($roles_list, $role_current)) {
            $res = empty($role_current) ? '' : "$role_current||";
            $res .= $roles_list;
        }
    } else {
        if (terminal_setrole($role_name))
            $res = $role_name;
    }

    terminal_disconnect();
}
echo $res;
?>
